/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.messages.impl;

import ai.grazie.utils.mpp.UUID;
import com.intellij.lang.Language;
import com.intellij.ml.llm.context.ContextEntity;
import com.intellij.ml.llm.core.chat.actions.MockUserMessage;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.messages.ChatMessageRating;
import com.intellij.ml.llm.core.chat.messages.ChatUserMessageFactory;
import com.intellij.ml.llm.core.chat.messages.TaskMessage;
import com.intellij.ml.llm.core.chat.messages.UserMessage;
import com.intellij.ml.llm.core.chat.messages.UserMessageRequest;
import com.intellij.ml.llm.core.chat.messages.impl.ChatUserMessageRequest;
import com.intellij.ml.llm.core.chat.messages.impl.TaskMessageRequest;
import com.intellij.ml.llm.core.chat.messages.impl.UserMessageImpl;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.models.api.AiChatMediaMessage;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.PrivacySafeTaskCall;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JX\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015JP\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\f2\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J.\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0010\u0010\u001e\u001a\f\u0012\u0004\u0012\u00020 0\u001fj\u0002`!\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/core/chat/messages/impl/UserMessageFactory;", "", "<init>", "()V", "createUserMessage", "Lcom/intellij/ml/llm/core/chat/messages/UserMessage;", "chat", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "formattedDisplayText", "Lcom/intellij/ml/llm/privacy/PSString;", "formattedInternalText", "attachments", "", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "uid", "", "rating", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessageRating;", "markupLanguage", "Lcom/intellij/lang/Language;", "messageInfo", "Lcom/intellij/openapi/util/UserDataHolder;", "createTaskMessage", "Lcom/intellij/ml/llm/core/chat/messages/TaskMessage;", "task", "Lcom/intellij/ml/llm/grazie/adapters/tasksFacade/PrivacySafeTaskCall;", "media", "Lcom/intellij/ml/llm/core/models/api/AiChatMediaMessage;", "copy", "userMessage", "context", "", "Lcom/intellij/ml/llm/context/ContextEntity;", "Lcom/intellij/ml/llm/context/ContextEntities;", "intellij.ml.llm.chat"})
public final class UserMessageFactory {
    @NotNull
    public static final UserMessageFactory INSTANCE = new UserMessageFactory();

    private UserMessageFactory() {
    }

    @NotNull
    public final UserMessage createUserMessage(@NotNull ChatSession chat, @NotNull PSString formattedDisplayText, @NotNull PSString formattedInternalText, @NotNull List<? extends ChatAttachment> attachments, @NotNull String uid, @NotNull ChatMessageRating rating, @Nullable Language markupLanguage, @NotNull UserDataHolder messageInfo) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)formattedDisplayText, (String)"formattedDisplayText");
        Intrinsics.checkNotNullParameter((Object)formattedInternalText, (String)"formattedInternalText");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
        Intrinsics.checkNotNullParameter((Object)((Object)rating), (String)"rating");
        Intrinsics.checkNotNullParameter((Object)messageInfo, (String)"messageInfo");
        return new UserMessageImpl(chat, formattedDisplayText, formattedInternalText, attachments, uid, rating, markupLanguage, null, CollectionsKt.emptyList(), CollectionsKt.emptyList(), messageInfo);
    }

    public static /* synthetic */ UserMessage createUserMessage$default(UserMessageFactory userMessageFactory, ChatSession chatSession2, PSString pSString, PSString pSString2, List list, String string, ChatMessageRating chatMessageRating, Language language, UserDataHolder userDataHolder, int n, Object object) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            string = UUID.Companion.random().toString();
        }
        if ((n & 0x20) != 0) {
            chatMessageRating = ChatMessageRating.None;
        }
        if ((n & 0x40) != 0) {
            language = null;
        }
        if ((n & 0x80) != 0) {
            userDataHolder = (UserDataHolder)new UserDataHolderBase();
        }
        return userMessageFactory.createUserMessage(chatSession2, pSString, pSString2, list, string, chatMessageRating, language, userDataHolder);
    }

    @ApiStatus.Experimental
    @NotNull
    public final TaskMessage createTaskMessage(@NotNull ChatSession chat, @NotNull PSString formattedDisplayText, @NotNull PrivacySafeTaskCall task, @NotNull String uid, @NotNull List<? extends ChatAttachment> attachments, @NotNull List<AiChatMediaMessage> media, @NotNull UserDataHolder messageInfo) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)formattedDisplayText, (String)"formattedDisplayText");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Intrinsics.checkNotNullParameter(media, (String)"media");
        Intrinsics.checkNotNullParameter((Object)messageInfo, (String)"messageInfo");
        UserMessage userMessage = ChatUserMessageFactory.Companion.createUserMessage((UserMessageRequest)new TaskMessageRequest(chat, formattedDisplayText, task, uid, attachments, media, messageInfo));
        Intrinsics.checkNotNull((Object)userMessage, (String)"null cannot be cast to non-null type com.intellij.ml.llm.core.chat.messages.TaskMessage");
        return (TaskMessage)userMessage;
    }

    public static /* synthetic */ TaskMessage createTaskMessage$default(UserMessageFactory userMessageFactory, ChatSession chatSession2, PSString pSString, PrivacySafeTaskCall privacySafeTaskCall, String string, List list, List list2, UserDataHolder userDataHolder, int n, Object object) {
        if ((n & 8) != 0) {
            string = UUID.Companion.random().toString();
        }
        if ((n & 0x40) != 0) {
            userDataHolder = (UserDataHolder)new UserDataHolderBase();
        }
        return userMessageFactory.createTaskMessage(chatSession2, pSString, privacySafeTaskCall, string, list, list2, userDataHolder);
    }

    @NotNull
    public final UserMessage copy(@NotNull UserMessage userMessage, @NotNull List<? extends ChatAttachment> attachments, @NotNull Iterable<? extends ContextEntity> context) {
        Intrinsics.checkNotNullParameter((Object)userMessage, (String)"userMessage");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        UserMessage userMessage2 = userMessage;
        return userMessage2 instanceof MockUserMessage ? userMessage : (userMessage2 instanceof TaskMessage ? (UserMessage)UserMessageFactory.createTaskMessage$default(this, userMessage.getChat(), userMessage.getDisplayText(), ((TaskMessage)userMessage).getTask(), userMessage.getUid(), attachments, userMessage.getMedia(), null, 64, null) : ChatUserMessageFactory.Companion.createUserMessage((UserMessageRequest)new ChatUserMessageRequest(userMessage.getChat(), userMessage.getDisplayText(), userMessage.getFormattedText(), context, attachments, userMessage.getMedia(), userMessage.getUid(), userMessage.getRating(), userMessage.getMarkupLanguage(), null, userMessage.getMessageInfo(), false, 2560, null)));
    }
}

