/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts;

import com.intellij.ml.llm.core.chat.promptLibrary.AICustomizablePrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AIAssistantCustomInstructionsStorage;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AIAssistantStoredInstruction;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPrompt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\rJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014J\u0014\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014J\u0016\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/core/chat/promptLibrary/core/systemPrompts/AISystemLibraryPromptService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "storage", "Lcom/intellij/ml/llm/core/chat/promptLibrary/core/systemPrompts/AIAssistantCustomInstructionsStorage;", "getStorage", "()Lcom/intellij/ml/llm/core/chat/promptLibrary/core/systemPrompts/AIAssistantCustomInstructionsStorage;", "findStoredPrompt", "Lcom/intellij/ml/llm/core/chat/promptLibrary/core/systemPrompts/AISystemLibraryPrompt;", "id", "", "findPrompt", "getDefaultInstruction", "Lcom/intellij/ml/llm/privacy/PSString;", "actionId", "getCustomInstruction", "getAllInstructions", "", "updateAllInstructions", "", "newInstructions", "updateInstructionContent", "newContent", "Companion", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAISystemLibraryPromptService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AISystemLibraryPromptService.kt\ncom/intellij/ml/llm/core/chat/promptLibrary/core/systemPrompts/AISystemLibraryPromptService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n30#2,2:106\n1#3:108\n1#3:119\n1617#4,9:109\n1869#4:118\n1870#4:120\n1626#4:121\n827#4:122\n855#4,2:123\n1563#4:125\n1634#4,3:126\n*S KotlinDebug\n*F\n+ 1 AISystemLibraryPromptService.kt\ncom/intellij/ml/llm/core/chat/promptLibrary/core/systemPrompts/AISystemLibraryPromptService\n*L\n33#1:106,2\n67#1:119\n67#1:109,9\n67#1:118\n67#1:120\n67#1:121\n82#1:122\n82#1:123,2\n83#1:125\n83#1:126,3\n*E\n"})
public final class AISystemLibraryPromptService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public AISystemLibraryPromptService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final AIAssistantCustomInstructionsStorage getStorage() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<AIAssistantCustomInstructionsStorage> serviceClass$iv = AIAssistantCustomInstructionsStorage.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (AIAssistantCustomInstructionsStorage)object;
    }

    private final AISystemLibraryPrompt findStoredPrompt(String id) {
        AIAssistantStoredInstruction aIAssistantStoredInstruction = this.getStorage().findById(id);
        if (aIAssistantStoredInstruction == null) {
            return null;
        }
        AIAssistantStoredInstruction storedPrompt = aIAssistantStoredInstruction;
        return new AISystemLibraryPrompt(storedPrompt.getActionId(), storedPrompt.getContent());
    }

    @Nullable
    public final AISystemLibraryPrompt findPrompt(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        AISystemLibraryPrompt aISystemLibraryPrompt = this.findStoredPrompt(id);
        if (aISystemLibraryPrompt == null) {
            aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.findDefaultPrompt(id);
        }
        return aISystemLibraryPrompt;
    }

    @NotNull
    public final PSString getDefaultInstruction(@NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        AICustomizablePrompt aICustomizablePrompt = AICustomizablePrompt.Companion.getCustomizablePrompt(actionId);
        if (aICustomizablePrompt == null || (aICustomizablePrompt = aICustomizablePrompt.getDefaultPrompt()) == null) {
            aICustomizablePrompt = ConstantsKt.getEMPTY();
        }
        return aICustomizablePrompt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final PSString getCustomInstruction(@NotNull String actionId) {
        AISystemLibraryPrompt aISystemLibraryPrompt;
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        AISystemLibraryPrompt aISystemLibraryPrompt2 = this.findPrompt(actionId);
        AISystemLibraryPrompt aISystemLibraryPrompt3 = aISystemLibraryPrompt2;
        if (aISystemLibraryPrompt2 == null) return null;
        AISystemLibraryPrompt prompt2 = aISystemLibraryPrompt = aISystemLibraryPrompt3;
        boolean bl = false;
        if (Companion.isDefault(prompt2)) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        AISystemLibraryPrompt aISystemLibraryPrompt4 = aISystemLibraryPrompt;
        aISystemLibraryPrompt3 = aISystemLibraryPrompt4;
        if (aISystemLibraryPrompt4 == null) return null;
        PSString pSString = aISystemLibraryPrompt3.getContent();
        return pSString;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AISystemLibraryPrompt> getAllInstructions() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = AICustomizablePrompt.Companion.getAllCustomizablePrompts();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AISystemLibraryPrompt it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            AICustomizablePrompt customization = (AICustomizablePrompt)element$iv$iv;
            boolean bl2 = false;
            if (this.findPrompt(customization.getID()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateAllInstructions(@NotNull List<AISystemLibraryPrompt> newInstructions) {
        void $this$mapTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(newInstructions, (String)"newInstructions");
        for (AISystemLibraryPrompt aISystemLibraryPrompt : newInstructions) {
            if (AICustomizablePrompt.Companion.getCustomizablePrompt(aISystemLibraryPrompt.getId()) != null) continue;
            throw new IllegalArgumentException("Invalid actionId: " + aISystemLibraryPrompt.getId());
        }
        Iterable iterable = newInstructions;
        Companion companion = Companion;
        boolean $i$f$filterNot232 = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            AISystemLibraryPrompt p0 = (AISystemLibraryPrompt)element$iv$iv;
            boolean bl = false;
            if (companion.isDefault(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable3 = (List)destination$iv$iv;
        boolean $i$f$map = false;
        Iterable $i$f$filterNot232 = iterable3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void prompt2;
            Object element$iv$iv;
            element$iv$iv = (AISystemLibraryPrompt)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new AIAssistantStoredInstruction(prompt2.getId(), prompt2.getContent()));
        }
        List storedInstructions = (List)destination$iv$iv2;
        this.getStorage().saveAll(storedInstructions);
    }

    public final void updateInstructionContent(@NotNull String actionId, @NotNull PSString newContent) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        AISystemLibraryPrompt aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.findDefaultPrompt(actionId);
        if (aISystemLibraryPrompt == null) {
            throw new IllegalArgumentException("Invalid actionId: " + actionId);
        }
        AISystemLibraryPrompt defaultPrompt = aISystemLibraryPrompt;
        this.getStorage().remove(actionId);
        if (!Intrinsics.areEqual((Object)newContent, (Object)defaultPrompt.getContent())) {
            this.getStorage().save(new AIAssistantStoredInstruction(actionId, newContent));
        }
    }

    @JvmStatic
    @NotNull
    public static final AISystemLibraryPromptService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/core/chat/promptLibrary/core/systemPrompts/AISystemLibraryPromptService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/core/chat/promptLibrary/core/systemPrompts/AISystemLibraryPromptService;", "project", "Lcom/intellij/openapi/project/Project;", "findDefaultPrompt", "Lcom/intellij/ml/llm/core/chat/promptLibrary/core/systemPrompts/AISystemLibraryPrompt;", "id", "", "isDefault", "", "prompt", "intellij.ml.llm.chat"})
    @SourceDebugExtension(value={"SMAP\nAISystemLibraryPromptService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AISystemLibraryPromptService.kt\ncom/intellij/ml/llm/core/chat/promptLibrary/core/systemPrompts/AISystemLibraryPromptService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,105:1\n30#2,2:106\n*S KotlinDebug\n*F\n+ 1 AISystemLibraryPromptService.kt\ncom/intellij/ml/llm/core/chat/promptLibrary/core/systemPrompts/AISystemLibraryPromptService$Companion\n*L\n19#1:106,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AISystemLibraryPromptService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<AISystemLibraryPromptService> serviceClass$iv = AISystemLibraryPromptService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (AISystemLibraryPromptService)object;
        }

        private final AISystemLibraryPrompt findDefaultPrompt(String id) {
            AICustomizablePrompt aICustomizablePrompt = AICustomizablePrompt.Companion.getCustomizablePrompt(id);
            if (aICustomizablePrompt == null) {
                return null;
            }
            AICustomizablePrompt extension = aICustomizablePrompt;
            return new AISystemLibraryPrompt(extension.getID(), extension.getDefaultPrompt());
        }

        public final boolean isDefault(@NotNull AISystemLibraryPrompt prompt2) {
            Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
            AISystemLibraryPrompt aISystemLibraryPrompt = this.findDefaultPrompt(prompt2.getId());
            if (aISystemLibraryPrompt == null) {
                return false;
            }
            AISystemLibraryPrompt defaultPrompt = aISystemLibraryPrompt;
            return Intrinsics.areEqual((Object)prompt2.getContent(), (Object)defaultPrompt.getContent());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

