/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.services.paste;

import com.intellij.ml.llm.core.chat.services.paste.CodeSnippetCopyPasteDocumentParserKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003\b\t\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser;", "", "<init>", "()V", "findCurrentState", "Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$TextSegmentType;", "text", "", "Token", "Tokenizer", "TextSegmentType", "intellij.ml.llm.chat"})
public final class CodeSnippetCopyPasteDocumentParser {
    @NotNull
    public static final CodeSnippetCopyPasteDocumentParser INSTANCE = new CodeSnippetCopyPasteDocumentParser();

    private CodeSnippetCopyPasteDocumentParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final TextSegmentType findCurrentState(@NotNull String text2) {
        Token token;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List<Token> tokens = Tokenizer.Companion.tokenize(text2);
        Token.Backtick currentBacktick = null;
        boolean isCurrentlyOpenInline = false;
        boolean isCurrentlyOpenBlock = false;
        Ref.IntRef position = new Ref.IntRef();
        int n = ((Collection)tokens).size();
        for (int position2 = 0; position2 < n; ++position2) {
            Token token2 = tokens.get(position2);
            token = token2;
            if (token instanceof Token.Backtick) {
                if (CodeSnippetCopyPasteDocumentParser.findCurrentState$isPreviousTokenNewLineOrStart(tokens, position) && ((Token.Backtick)token2).getCount() > 2 && (CodeSnippetCopyPasteDocumentParser.findCurrentState$isNextTokenTextAndNextIsNewLineOrEnd(tokens, position) || CodeSnippetCopyPasteDocumentParser.findCurrentState$isNextTokenNewLineOrEnd(tokens, position))) {
                    if (isCurrentlyOpenInline) {
                        CodeSnippetCopyPasteDocumentParserKt.access$getLOG$p().error("Unexpected state while parsing: found open inline while previous token is new line");
                    }
                    if (isCurrentlyOpenBlock) {
                        Token.Backtick backtick = currentBacktick;
                        Intrinsics.checkNotNull((Object)backtick);
                        if (backtick.getCount() <= ((Token.Backtick)token2).getCount()) {
                            isCurrentlyOpenBlock = false;
                            currentBacktick = null;
                            continue;
                        }
                    }
                    if (isCurrentlyOpenBlock) continue;
                    currentBacktick = (Token.Backtick)token2;
                    isCurrentlyOpenBlock = true;
                    continue;
                }
                if (isCurrentlyOpenBlock) continue;
                if (isCurrentlyOpenInline) {
                    Token.Backtick backtick = currentBacktick;
                    Intrinsics.checkNotNull(backtick);
                    if (backtick.getCount() == ((Token.Backtick)token2).getCount()) {
                        isCurrentlyOpenInline = false;
                        currentBacktick = null;
                        continue;
                    }
                }
                if (isCurrentlyOpenInline) continue;
                isCurrentlyOpenInline = true;
                currentBacktick = (Token.Backtick)token2;
                continue;
            }
            if (token instanceof Token.NewLine) {
                if (!isCurrentlyOpenInline) continue;
                isCurrentlyOpenInline = false;
                currentBacktick = null;
                continue;
            }
            if (token instanceof Token.Text) continue;
            throw new NoWhenBranchMatchedException();
        }
        if (isCurrentlyOpenInline) {
            return TextSegmentType.InlineCode.INSTANCE;
        }
        if (isCurrentlyOpenBlock) {
            TextSegmentType textSegmentType;
            Token nextToken;
            Token.Backtick backtick = currentBacktick;
            Intrinsics.checkNotNull(backtick);
            int positionOfToken = tokens.indexOf(backtick);
            Token token3 = nextToken = (Token)CollectionsKt.getOrNull(tokens, (int)(positionOfToken + 1));
            if (token3 instanceof Token.Backtick) {
                CodeSnippetCopyPasteDocumentParserKt.access$getLOG$p().error("Can't have code block with backtick in comment");
                textSegmentType = new TextSegmentType.PlainText(false);
                return textSegmentType;
            } else if (token3 instanceof Token.NewLine) {
                textSegmentType = new TextSegmentType.CodeBlock(currentBacktick.getStartOffset(), currentBacktick.getCount(), "", true);
                return textSegmentType;
            } else if (token3 instanceof Token.Text) {
                token = (Token)CollectionsKt.getOrNull(tokens, (int)(positionOfToken + 2));
                if (token instanceof Token.Backtick) {
                    CodeSnippetCopyPasteDocumentParserKt.access$getLOG$p().error("Can't have code block with backtick in comment");
                    textSegmentType = new TextSegmentType.PlainText(false);
                    return textSegmentType;
                } else if (Intrinsics.areEqual((Object)token, (Object)Token.NewLine.INSTANCE)) {
                    textSegmentType = new TextSegmentType.CodeBlock(currentBacktick.getStartOffset(), currentBacktick.getCount(), ((Token.Text)nextToken).getText(), true);
                    return textSegmentType;
                } else if (token instanceof Token.Text) {
                    CodeSnippetCopyPasteDocumentParserKt.access$getLOG$p().error("Can't have two texts in row");
                    textSegmentType = new TextSegmentType.PlainText(false);
                    return textSegmentType;
                } else {
                    if (token != null) throw new NoWhenBranchMatchedException();
                    textSegmentType = new TextSegmentType.CodeBlock(currentBacktick.getStartOffset(), currentBacktick.getCount(), ((Token.Text)nextToken).getText(), false);
                }
                return textSegmentType;
            } else {
                if (token3 != null) throw new NoWhenBranchMatchedException();
                textSegmentType = new TextSegmentType.CodeBlock(currentBacktick.getStartOffset(), currentBacktick.getCount(), null, false);
            }
            return textSegmentType;
        }
        Object object = CollectionsKt.lastOrNull(tokens);
        return new TextSegmentType.PlainText(object == null ? true : object instanceof Token.NewLine);
    }

    private static final boolean findCurrentState$isPreviousTokenNewLineOrStart(List<? extends Token> tokens, Ref.IntRef position) {
        Object object = CollectionsKt.getOrNull(tokens, (int)(position.element - 1));
        return object == null ? true : object instanceof Token.NewLine;
    }

    private static final boolean findCurrentState$isNextTokenNewLineOrEnd(List<? extends Token> tokens, Ref.IntRef position) {
        Object object = CollectionsKt.getOrNull(tokens, (int)(position.element + 1));
        return object == null ? true : object instanceof Token.NewLine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findCurrentState$isNextTokenTextAndNextIsNewLineOrEnd(List<? extends Token> tokens, Ref.IntRef position) {
        if (!(CollectionsKt.getOrNull(tokens, (int)(position.element + 1)) instanceof Token.Text)) return false;
        Object object = CollectionsKt.getOrNull(tokens, (int)(position.element + 2));
        if (object == null) {
            return true;
        }
        boolean bl = object instanceof Token.NewLine;
        if (!bl) return false;
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$TextSegmentType;", "", "<init>", "()V", "PlainText", "InlineCode", "CodeBlock", "Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$TextSegmentType$CodeBlock;", "Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$TextSegmentType$InlineCode;", "Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$TextSegmentType$PlainText;", "intellij.ml.llm.chat"})
    public static abstract sealed class TextSegmentType {
        private TextSegmentType() {
        }

        public /* synthetic */ TextSegmentType(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$TextSegmentType$CodeBlock;", "Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$TextSegmentType;", "startOffset", "", "ticks", "language", "", "isNewLineAfter", "", "<init>", "(IILjava/lang/String;Z)V", "getStartOffset", "()I", "getTicks", "getLanguage", "()Ljava/lang/String;", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "toString", "intellij.ml.llm.chat"})
        public static final class CodeBlock
        extends TextSegmentType {
            private final int startOffset;
            private final int ticks;
            @Nullable
            private final String language;
            private final boolean isNewLineAfter;

            public CodeBlock(int startOffset, int ticks, @Nullable String language, boolean isNewLineAfter) {
                super(null);
                this.startOffset = startOffset;
                this.ticks = ticks;
                this.language = language;
                this.isNewLineAfter = isNewLineAfter;
            }

            public final int getStartOffset() {
                return this.startOffset;
            }

            public final int getTicks() {
                return this.ticks;
            }

            @Nullable
            public final String getLanguage() {
                return this.language;
            }

            public final boolean isNewLineAfter() {
                return this.isNewLineAfter;
            }

            public final int component1() {
                return this.startOffset;
            }

            public final int component2() {
                return this.ticks;
            }

            @Nullable
            public final String component3() {
                return this.language;
            }

            public final boolean component4() {
                return this.isNewLineAfter;
            }

            @NotNull
            public final CodeBlock copy(int startOffset, int ticks, @Nullable String language, boolean isNewLineAfter) {
                return new CodeBlock(startOffset, ticks, language, isNewLineAfter);
            }

            public static /* synthetic */ CodeBlock copy$default(CodeBlock codeBlock, int n, int n2, String string, boolean bl, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = codeBlock.startOffset;
                }
                if ((n3 & 2) != 0) {
                    n2 = codeBlock.ticks;
                }
                if ((n3 & 4) != 0) {
                    string = codeBlock.language;
                }
                if ((n3 & 8) != 0) {
                    bl = codeBlock.isNewLineAfter;
                }
                return codeBlock.copy(n, n2, string, bl);
            }

            @NotNull
            public String toString() {
                return "CodeBlock(startOffset=" + this.startOffset + ", ticks=" + this.ticks + ", language=" + this.language + ", isNewLineAfter=" + this.isNewLineAfter + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.startOffset);
                result2 = result2 * 31 + Integer.hashCode(this.ticks);
                result2 = result2 * 31 + (this.language == null ? 0 : this.language.hashCode());
                result2 = result2 * 31 + Boolean.hashCode(this.isNewLineAfter);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CodeBlock)) {
                    return false;
                }
                CodeBlock codeBlock = (CodeBlock)other;
                if (this.startOffset != codeBlock.startOffset) {
                    return false;
                }
                if (this.ticks != codeBlock.ticks) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.language, (Object)codeBlock.language)) {
                    return false;
                }
                return this.isNewLineAfter == codeBlock.isNewLineAfter;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$TextSegmentType$InlineCode;", "Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$TextSegmentType;", "<init>", "()V", "intellij.ml.llm.chat"})
        public static final class InlineCode
        extends TextSegmentType {
            @NotNull
            public static final InlineCode INSTANCE = new InlineCode();

            private InlineCode() {
                super(null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$TextSegmentType$PlainText;", "Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$TextSegmentType;", "isNewLine", "", "<init>", "(Z)V", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.chat"})
        public static final class PlainText
        extends TextSegmentType {
            private final boolean isNewLine;

            public PlainText(boolean isNewLine) {
                super(null);
                this.isNewLine = isNewLine;
            }

            public final boolean isNewLine() {
                return this.isNewLine;
            }

            public final boolean component1() {
                return this.isNewLine;
            }

            @NotNull
            public final PlainText copy(boolean isNewLine) {
                return new PlainText(isNewLine);
            }

            public static /* synthetic */ PlainText copy$default(PlainText plainText, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = plainText.isNewLine;
                }
                return plainText.copy(bl);
            }

            @NotNull
            public String toString() {
                return "PlainText(isNewLine=" + this.isNewLine + ")";
            }

            public int hashCode() {
                return Boolean.hashCode(this.isNewLine);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PlainText)) {
                    return false;
                }
                PlainText plainText = (PlainText)other;
                return this.isNewLine == plainText.isNewLine;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$Token;", "", "<init>", "()V", "Backtick", "NewLine", "Text", "Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$Token$Backtick;", "Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$Token$NewLine;", "Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$Token$Text;", "intellij.ml.llm.chat"})
    public static abstract sealed class Token {
        private Token() {
        }

        public /* synthetic */ Token(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$Token$Backtick;", "Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$Token;", "startOffset", "", "count", "<init>", "(II)V", "getStartOffset", "()I", "getCount", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.ml.llm.chat"})
        public static final class Backtick
        extends Token {
            private final int startOffset;
            private final int count;

            public Backtick(int startOffset, int count) {
                super(null);
                this.startOffset = startOffset;
                this.count = count;
            }

            public final int getStartOffset() {
                return this.startOffset;
            }

            public final int getCount() {
                return this.count;
            }

            public final int component1() {
                return this.startOffset;
            }

            public final int component2() {
                return this.count;
            }

            @NotNull
            public final Backtick copy(int startOffset, int count) {
                return new Backtick(startOffset, count);
            }

            public static /* synthetic */ Backtick copy$default(Backtick backtick, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = backtick.startOffset;
                }
                if ((n3 & 2) != 0) {
                    n2 = backtick.count;
                }
                return backtick.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "Backtick(startOffset=" + this.startOffset + ", count=" + this.count + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.startOffset);
                result2 = result2 * 31 + Integer.hashCode(this.count);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Backtick)) {
                    return false;
                }
                Backtick backtick = (Backtick)other;
                if (this.startOffset != backtick.startOffset) {
                    return false;
                }
                return this.count == backtick.count;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$Token$NewLine;", "Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$Token;", "<init>", "()V", "intellij.ml.llm.chat"})
        public static final class NewLine
        extends Token {
            @NotNull
            public static final NewLine INSTANCE = new NewLine();

            private NewLine() {
                super(null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$Token$Text;", "Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$Token;", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.chat"})
        public static final class Text
        extends Token {
            @NotNull
            private final String text;

            public Text(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                super(null);
                this.text = text2;
            }

            @NotNull
            public final String getText() {
                return this.text;
            }

            @NotNull
            public final String component1() {
                return this.text;
            }

            @NotNull
            public final Text copy(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return new Text(text2);
            }

            public static /* synthetic */ Text copy$default(Text text2, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = text2.text;
                }
                return text2.copy(string);
            }

            @NotNull
            public String toString() {
                return "Text(text=" + this.text + ")";
            }

            public int hashCode() {
                return this.text.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Text)) {
                    return false;
                }
                Text text2 = (Text)other;
                return Intrinsics.areEqual((Object)this.text, (Object)text2.text);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\r\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$Tokenizer;", "", "text", "", "<init>", "(Ljava/lang/String;)V", "pos", "", "hasNext", "", "next", "Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$Token;", "peek", "", "()Ljava/lang/Character;", "Companion", "intellij.ml.llm.chat"})
    public static final class Tokenizer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String text;
        private int pos;

        public Tokenizer(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
        }

        public final boolean hasNext() {
            return this.pos < this.text.length();
        }

        @Nullable
        public final Token next() {
            Token token;
            if (!this.hasNext()) {
                return null;
            }
            Character c = this.peek();
            char c2 = '`';
            if (c != null && c.charValue() == c2) {
                count = 0;
                int startPosition = this.pos;
                while (true) {
                    Character c3 = this.peek();
                    char c4 = '`';
                    if (c3 == null || c3.charValue() != c4) break;
                    ++count;
                    ++this.pos;
                }
                token = new Token.Backtick(startPosition, count);
            } else {
                Character c5 = this.peek();
                count = 10;
                if (c5 != null && c5.charValue() == count) {
                    Token.NewLine token2 = Token.NewLine.INSTANCE;
                    ++this.pos;
                    token = token2;
                } else {
                    int startPosition = this.pos;
                    boolean isActiveEscapeSymbol = false;
                    while (this.hasNext()) {
                        Character c6 = this.peek();
                        char c7 = '`';
                        if (c6 != null && c6.charValue() == c7 && !isActiveEscapeSymbol) break;
                        Character c8 = this.peek();
                        c7 = '\n';
                        if (c8 != null && c8.charValue() == c7 && !isActiveEscapeSymbol) break;
                        Character c9 = this.peek();
                        c7 = '\\';
                        isActiveEscapeSymbol = c9 != null && c9.charValue() == c7 ? !isActiveEscapeSymbol : false;
                        ++this.pos;
                    }
                    String string = this.text.substring(startPosition, this.pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    token = new Token.Text(string);
                }
            }
            return token;
        }

        @Nullable
        public final Character peek() {
            return StringsKt.getOrNull((CharSequence)this.text, (int)this.pos);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$Tokenizer$Companion;", "", "<init>", "()V", "tokenize", "", "Lcom/intellij/ml/llm/core/chat/services/paste/CodeSnippetCopyPasteDocumentParser$Token;", "text", "", "intellij.ml.llm.chat"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<Token> tokenize(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Tokenizer tokenizer = new Tokenizer(text2);
                return SequencesKt.toList((Sequence)SequencesKt.generateSequence(() -> Companion.tokenize$lambda$0(tokenizer)));
            }

            private static final Token tokenize$lambda$0(Tokenizer $tokenizer) {
                return $tokenizer.next();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

