/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.snippets;

import com.intellij.lang.Language;
import com.intellij.ml.llm.core.chat.snippets.CodeSnippetProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\b\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/ml/llm/core/chat/snippets/CodeSnippetProvider;", "getEP", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createEditorForChatCodeSnippet", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "language", "Lcom/intellij/lang/Language;", "disposable", "Lcom/intellij/openapi/Disposable;", "finalizeEditorForChatCodeSnippet", "", "editor", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nCodeSnippetProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeSnippetProvider.kt\ncom/intellij/ml/llm/core/chat/snippets/CodeSnippetProviderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,59:1\n13#2:60\n*S KotlinDebug\n*F\n+ 1 CodeSnippetProvider.kt\ncom/intellij/ml/llm/core/chat/snippets/CodeSnippetProviderKt\n*L\n21#1:60\n*E\n"})
public final class CodeSnippetProviderKt {
    @NotNull
    private static final ExtensionPointName<CodeSnippetProvider> EP = new ExtensionPointName("com.intellij.chatCodeSnippetProvider");
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final ExtensionPointName<CodeSnippetProvider> getEP() {
        return EP;
    }

    @NotNull
    public static final Editor createEditorForChatCodeSnippet(@NotNull Project project, @NotNull Document document, @NotNull Language language, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        for (CodeSnippetProvider provider : EP.getExtensionList()) {
            try {
                Editor editor = provider.tryCreateEditor(project, document, language);
                if (editor == null) continue;
                return editor;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        Editor editor = editorFactory.createViewer(document, project);
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx result2 = (EditorEx)editor;
        DisposerUtilKt.whenDisposed((Disposable)disposable, () -> CodeSnippetProviderKt.createEditorForChatCodeSnippet$lambda$0(result2, editorFactory));
        return (Editor)result2;
    }

    public static final void finalizeEditorForChatCodeSnippet(@NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        for (CodeSnippetProvider provider : EP.getExtensionList()) {
            try {
                provider.tryFinalizeEditor(project, editor);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    private static final Unit createEditorForChatCodeSnippet$lambda$0(EditorEx $result, EditorFactory $editorFactory) {
        if (!$result.isDisposed()) {
            $editorFactory.releaseEditor((Editor)$result);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CodeSnippetProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

