/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat;

import ai.grazie.utils.TextKt;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantExternalLinksKt;
import com.intellij.ml.llm.core.settings.LLMSettings;
import com.intellij.ml.llm.qa.endpoint.DocumentationQAEndpointKt;
import com.intellij.openapi.util.NlsSafe;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\bJ\f\u0010\u0017\u001a\u00020\u000f*\u00020\bH\u0002J\f\u0010\u0018\u001a\u00020\u000f*\u00020\bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/SecureHtmlSanitizer;", "", "<init>", "()V", "allowedResources", "", "Lcom/intellij/ml/llm/core/chat/ui/chat/SecureHtmlSanitizer$AllowedResource;", "sanitize", "", "html", "sanitizeWithAllowList", "", "document", "Lorg/jsoup/nodes/Document;", "isAllowedAttributeValue", "", "attributeName", "attributeValue", "isAllowedUrlScheme", "url", "isAllowedTextContent", "content", "sanitizeInternalResources", "isLink", "containsPathOrQueryParam", "AllowedResource", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nSecureHtmlSanitizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecureHtmlSanitizer.kt\ncom/intellij/ml/llm/core/chat/ui/chat/SecureHtmlSanitizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1869#2:194\n1740#2,3:195\n1870#2:198\n1869#2,2:199\n1869#2,2:201\n1869#2:203\n1563#2:204\n1634#2,3:205\n774#2:208\n865#2,2:209\n1869#2,2:211\n1870#2:213\n774#2:214\n865#2,2:215\n1869#2:217\n1761#2,3:218\n1870#2:221\n1563#2:223\n1634#2,3:224\n1#3:222\n*S KotlinDebug\n*F\n+ 1 SecureHtmlSanitizer.kt\ncom/intellij/ml/llm/core/chat/ui/chat/SecureHtmlSanitizer\n*L\n31#1:194\n32#1:195,3\n31#1:198\n79#1:199,2\n91#1:201,2\n97#1:203\n103#1:204\n103#1:205,3\n103#1:208\n103#1:209,2\n107#1:211,2\n97#1:213\n166#1:214\n166#1:215,2\n167#1:217\n168#1:218,3\n167#1:221\n16#1:223\n16#1:224,3\n*E\n"})
public final class SecureHtmlSanitizer {
    @NotNull
    public static final SecureHtmlSanitizer INSTANCE;
    @NotNull
    private static final List<AllowedResource> allowedResources;

    private SecureHtmlSanitizer() {
    }

    @NotNull
    public final String sanitize(@NlsSafe @NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Document document = Jsoup.parse((String)html);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document document2 = document;
        this.sanitizeWithAllowList(document2);
        if (!AIAssistantExternalLinksKt.isExternalLinksEnabled()) {
            Elements elements = document2.select("a");
            Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
            Iterable $this$forEach$iv = (Iterable)elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                Element a;
                block5: {
                    a = (Element)element$iv;
                    boolean bl2 = false;
                    Iterable $this$all$iv = allowedResources;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            AllowedResource it = (AllowedResource)element$iv2;
                            boolean bl3 = false;
                            String string = a.attr("href");
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
                            if (!StringsKt.startsWith$default((String)string, (String)it.getHref(), (boolean)false, (int)2, null)) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                a.removeAttr("href");
                String string = a.text();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
                if (!INSTANCE.isLink(string)) continue;
                String string2 = a.text();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text(...)");
                if (!INSTANCE.containsPathOrQueryParam(string2)) continue;
                a.text(LLMBundle.message((String)"hyperlink.removed.for.security.reasons", (Object[])new Object[0]));
            }
        }
        String string = document2.html();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"html(...)");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private final void sanitizeWithAllowList(Document document) {
        var3_2 = new String[]{"html", "head", "body", "title", "meta", "base", "p", "h1", "h2", "h3", "h4", "h5", "h6", "br", "hr", "b", "i", "u", "em", "strong", "code", "pre", "tt", "strike", "big", "small", "sub", "sup", "dfn", "samp", "kbd", "var", "cite", "ul", "ol", "li", "dl", "dt", "dd", "table", "tr", "td", "th", "caption", "thead", "tbody", "tfoot", "div", "span", "a", "img"};
        allowedTags = SetsKt.setOf((Object[])var3_2);
        var4_4 = new String[]{"id", "class", "lang", "dir", "title"};
        globalAllowedAttributes = SetsKt.setOf((Object[])var4_4);
        var5_5 = new Pair[18];
        var5_5[0] = TuplesKt.to((Object)"code", (Object)SetsKt.setOf((Object)"codespanviewextension_processed"));
        var6_6 = new String[]{"href", "target", "rel"};
        var5_5[1] = TuplesKt.to((Object)"a", (Object)SetsKt.setOf((Object[])var6_6));
        var6_6 = new String[]{"alt", "width", "height", "align", "border", "hspace", "vspace"};
        var5_5[2] = TuplesKt.to((Object)"img", (Object)SetsKt.setOf((Object[])var6_6));
        var6_6 = new String[]{"border", "cellpadding", "cellspacing", "align", "width", "height"};
        var5_5[3] = TuplesKt.to((Object)"table", (Object)SetsKt.setOf((Object[])var6_6));
        var6_6 = new String[]{"align", "valign"};
        var5_5[4] = TuplesKt.to((Object)"tr", (Object)SetsKt.setOf((Object[])var6_6));
        var6_6 = new String[]{"align", "valign", "colspan", "rowspan", "width", "height"};
        var5_5[5] = TuplesKt.to((Object)"td", (Object)SetsKt.setOf((Object[])var6_6));
        var6_6 = new String[]{"align", "valign", "colspan", "rowspan", "width", "height"};
        var5_5[6] = TuplesKt.to((Object)"th", (Object)SetsKt.setOf((Object[])var6_6));
        var6_6 = new String[]{"type", "start"};
        var5_5[7] = TuplesKt.to((Object)"ol", (Object)SetsKt.setOf((Object[])var6_6));
        var6_6 = new String[]{"type", "value"};
        var5_5[8] = TuplesKt.to((Object)"li", (Object)SetsKt.setOf((Object[])var6_6));
        var5_5[9] = TuplesKt.to((Object)"h1", (Object)SetsKt.setOf((Object)"align"));
        var5_5[10] = TuplesKt.to((Object)"h2", (Object)SetsKt.setOf((Object)"align"));
        var5_5[11] = TuplesKt.to((Object)"h3", (Object)SetsKt.setOf((Object)"align"));
        var5_5[12] = TuplesKt.to((Object)"h4", (Object)SetsKt.setOf((Object)"align"));
        var5_5[13] = TuplesKt.to((Object)"h5", (Object)SetsKt.setOf((Object)"align"));
        var5_5[14] = TuplesKt.to((Object)"h6", (Object)SetsKt.setOf((Object)"align"));
        var5_5[15] = TuplesKt.to((Object)"p", (Object)SetsKt.setOf((Object)"align"));
        var5_5[16] = TuplesKt.to((Object)"div", (Object)SetsKt.setOf((Object)"align"));
        var6_6 = new String[]{"align", "width", "size", "noshade"};
        var5_5[17] = TuplesKt.to((Object)"hr", (Object)SetsKt.setOf((Object[])var6_6));
        allowedAttributes = MapsKt.mapOf((Pair[])var5_5);
        v0 = document.getAllElements();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getAllElements(...)");
        $this$forEach$iv = CollectionsKt.toList((Iterable)((Iterable)v0));
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            element = (Element)element$iv;
            $i$a$-forEach-SecureHtmlSanitizer$sanitizeWithAllowList$1 = false;
            if (allowedTags.contains(element.tagName())) continue;
            Intrinsics.checkNotNullExpressionValue((Object)element.text(), (String)"text(...)");
            if (((CharSequence)textContent).length() > 0 && element.parent() != null) {
                element.before(textContent);
            }
            element.remove();
        }
        v1 = document.select("img");
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"select(...)");
        $this$forEach$iv = (Iterable)v1;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            img = (Element)element$iv;
            $i$a$-forEach-SecureHtmlSanitizer$sanitizeWithAllowList$2 = false;
            img.removeAttr("src");
            img.attr("alt", LLMBundle.message((String)"image.fetching.blocked.for.security.reasons", (Object[])new Object[0]));
        }
        v2 = document.getAllElements();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getAllElements(...)");
        $this$forEach$iv = (Iterable)v2;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            element = (Element)element$iv;
            $i$a$-forEach-SecureHtmlSanitizer$sanitizeWithAllowList$3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)element.tagName(), (String)"tagName(...)");
            v3 = (Set)allowedAttributes.get(tagName);
            if (v3 == null) {
                v3 = SetsKt.emptySet();
            }
            tagSpecificAllowed = v3;
            allAllowed = SetsKt.plus((Set)globalAllowedAttributes, (Iterable)tagSpecificAllowed);
            v4 = element.attributes();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"attributes(...)");
            $this$map$iv = (Iterable)v4;
            $i$f$map = false;
            var16_17 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var21_24 = (Attribute)item$iv$iv;
                var22_25 = destination$iv$iv;
                $i$a$-map-SecureHtmlSanitizer$sanitizeWithAllowList$3$attributesToRemove$1 = false;
                var22_25.add(it.getKey());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                attrName = (String)element$iv$iv;
                $i$a$-filter-SecureHtmlSanitizer$sanitizeWithAllowList$3$attributesToRemove$2 = false;
                if (!allAllowed.contains(attrName)) ** GOTO lbl-1000
                Intrinsics.checkNotNull((Object)attrName);
                v5 = element.attr(attrName);
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"attr(...)");
                if (!SecureHtmlSanitizer.INSTANCE.isAllowedAttributeValue(attrName, v5)) lbl-1000:
                // 2 sources

                {
                    v6 = true;
                } else {
                    v6 = false;
                }
                if (!v6) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            attributesToRemove = (List)destination$iv$iv;
            $this$forEach$iv = attributesToRemove;
            $i$f$forEach = false;
            for (E element$iv : $this$forEach$iv) {
                attrName = (String)element$iv;
                $i$a$-forEach-SecureHtmlSanitizer$sanitizeWithAllowList$3$1 = false;
                element.removeAttr(attrName);
            }
        }
    }

    private final boolean isAllowedAttributeValue(String attributeName, String attributeValue) {
        if (((CharSequence)attributeValue).length() == 0) {
            return true;
        }
        if (Intrinsics.areEqual((Object)attributeName, (Object)"href")) {
            return this.isAllowedUrlScheme(attributeValue);
        }
        return switch (attributeName) {
            case "id", "class" -> {
                CharSequence var4_4 = attributeValue;
                yield new Regex("^[a-zA-Z0-9_\\-\\s]*$").matches(var4_4);
            }
            case "border", "start", "colspan", "size", "cellpadding", "rowspan", "width", "cellspacing", "value", "height" -> {
                CharSequence var4_5 = attributeValue;
                yield new Regex("^\\d+(%|px|em|pt)?$").matches(var4_5);
            }
            case "valign", "align" -> {
                Object[] var4_6 = new String[]{"left", "right", "center", "justify", "top", "middle", "bottom", "baseline"};
                Set v1 = SetsKt.setOf((Object[])var4_6);
                String v2 = attributeValue.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toLowerCase(...)");
                yield v1.contains(v2);
            }
            case "type" -> {
                Object[] var4_7 = new String[]{"1", "a", "i", "disc", "circle", "square"};
                Set v3 = SetsKt.setOf((Object[])var4_7);
                String v4 = attributeValue.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"toLowerCase(...)");
                yield v3.contains(v4);
            }
            case "target" -> {
                Object[] var4_8 = new String[]{"_blank", "_self", "_parent", "_top"};
                yield SetsKt.setOf((Object[])var4_8).contains(attributeValue);
            }
            case "rel" -> {
                Object[] var4_9 = new String[]{"noopener", "noreferrer", "nofollow"};
                Set v5 = SetsKt.setOf((Object[])var4_9);
                String v6 = attributeValue.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"toLowerCase(...)");
                yield v5.contains(v6);
            }
            case "dir" -> {
                Object[] var4_10 = new String[]{"ltr", "rtl"};
                Set v7 = SetsKt.setOf((Object[])var4_10);
                String v8 = attributeValue.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"toLowerCase(...)");
                yield v7.contains(v8);
            }
            case "lang" -> {
                CharSequence var4_11 = attributeValue;
                yield new Regex("^[a-z]{2}(-[A-Z]{2})?$").matches(var4_11);
            }
            case "noshade" -> Intrinsics.areEqual((Object)attributeValue, (Object)"noshade");
            case "codespanviewextension_processed" -> {
                Object[] var4_12 = new String[]{"true", "false"};
                yield SetsKt.setOf((Object[])var4_12).contains(attributeValue);
            }
            case "alt", "title" -> this.isAllowedTextContent(attributeValue);
            default -> false;
        };
    }

    private final boolean isAllowedUrlScheme(String url) {
        if (((CharSequence)url).length() == 0) {
            return true;
        }
        String string = url.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String lowercaseUrl = ((Object)StringsKt.trim((CharSequence)string)).toString();
        return StringsKt.startsWith$default((String)lowercaseUrl, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)lowercaseUrl, (String)"https://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)lowercaseUrl, (String)"#", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)lowercaseUrl, (String)"/", (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)lowercaseUrl, (CharSequence)":", (boolean)false, (int)2, null);
    }

    private final boolean isAllowedTextContent(String content2) {
        if (((CharSequence)content2).length() == 0) {
            return true;
        }
        CharSequence charSequence = content2;
        return new Regex("^[a-zA-Z0-9\\s.,!?\\-_\\[\\]{}~@#$%^&*+=|\\\\]*$").matches(charSequence);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String sanitizeInternalResources(@NlsSafe @NotNull String html) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Document document = Jsoup.parse((String)html);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document document2 = document;
        Iterable $this$filter$iv = allowedResources;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AllowedResource it = (AllowedResource)element$iv$iv;
            boolean bl = false;
            if (!it.getInternal()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List internalResources = (List)destination$iv$iv;
        Elements elements = document2.select("a");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Iterable $this$forEach$iv = (Iterable)elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List children;
            Element parent;
            boolean bl;
            Element a;
            block5: {
                a = (Element)element$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = internalResources;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        AllowedResource it = (AllowedResource)element$iv2;
                        boolean bl3 = false;
                        String string = a.attr("href");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
                        if (!StringsKt.startsWith$default((String)string, (String)it.getHref(), (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl || a.parent() == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)a.childNodes(), (String)"childNodes(...)");
            a.children().remove();
            a.remove();
            parent.appendChildren((Collection)children);
        }
        String string = document2.html();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"html(...)");
        return string;
    }

    private final boolean isLink(String $this$isLink) {
        Object object;
        String string = $this$isLink;
        try {
            String $this$isLink_u24lambda_u240 = string;
            boolean bl = false;
            object = Result.constructor-impl((Object)new URL($this$isLink_u24lambda_u240));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return Result.isSuccess-impl((Object)object);
    }

    private final boolean containsPathOrQueryParam(String $this$containsPathOrQueryParam) {
        String linkWithoutPrefix = TextKt.dropPrefix((String)TextKt.dropPrefix((String)$this$containsPathOrQueryParam, (String)"http://"), (String)"https://");
        if (StringsKt.contains$default((CharSequence)linkWithoutPrefix, (char)'?', (boolean)false, (int)2, null)) {
            return true;
        }
        String textAfterSlash = StringsKt.substringAfter$default((String)linkWithoutPrefix, (char)'/', null, (int)2, null);
        return !Intrinsics.areEqual((Object)linkWithoutPrefix, (Object)textAfterSlash) && ((CharSequence)textAfterSlash).length() > 0;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        INSTANCE = new SecureHtmlSanitizer();
        Iterable $this$map$iv = LLMSettings.Companion.getDEFAULT_TRUSTED_DOMAINS();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            char[] cArray = new char[]{'*'};
            collection.add(new AllowedResource(StringsKt.trimEnd((String)it, (char[])cArray), false, 2, null));
        }
        Object[] objectArray = new AllowedResource[]{new AllowedResource("code_navigation_link", true), new AllowedResource((String)DocumentationQAEndpointKt.getDOCS_COMMAND_EXAMPLE_TAG().unwrap(), true)};
        allowedResources = CollectionsKt.plus((Collection)((List)var3_3), (Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/SecureHtmlSanitizer$AllowedResource;", "", "href", "", "internal", "", "<init>", "(Ljava/lang/String;Z)V", "getHref", "()Ljava/lang/String;", "getInternal", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    private static final class AllowedResource {
        @NotNull
        private final String href;
        private final boolean internal;

        public AllowedResource(@NotNull String href, boolean internal) {
            Intrinsics.checkNotNullParameter((Object)href, (String)"href");
            this.href = href;
            this.internal = internal;
        }

        public /* synthetic */ AllowedResource(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(string, bl);
        }

        @NotNull
        public final String getHref() {
            return this.href;
        }

        public final boolean getInternal() {
            return this.internal;
        }

        @NotNull
        public final String component1() {
            return this.href;
        }

        public final boolean component2() {
            return this.internal;
        }

        @NotNull
        public final AllowedResource copy(@NotNull String href, boolean internal) {
            Intrinsics.checkNotNullParameter((Object)href, (String)"href");
            return new AllowedResource(href, internal);
        }

        public static /* synthetic */ AllowedResource copy$default(AllowedResource allowedResource, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = allowedResource.href;
            }
            if ((n & 2) != 0) {
                bl = allowedResource.internal;
            }
            return allowedResource.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "AllowedResource(href=" + this.href + ", internal=" + this.internal + ")";
        }

        public int hashCode() {
            int result2 = this.href.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.internal);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AllowedResource)) {
                return false;
            }
            AllowedResource allowedResource = (AllowedResource)other;
            if (!Intrinsics.areEqual((Object)this.href, (Object)allowedResource.href)) {
                return false;
            }
            return this.internal == allowedResource.internal;
        }
    }
}

