/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.attachments;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.CurrentFileChatAttachment;
import com.intellij.ml.llm.core.chat.context.ChatContextMigrationService;
import com.intellij.ml.llm.core.chat.context.ChatDefaultRetrievers;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.FileContextAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.UtilKt;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.ChatAttachmentKindsProvider;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import com.intellij.ml.llm.util.file.FileManagerUtils;
import com.intellij.ml.llm.util.validation.VirtualFileValidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0010\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010+\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u0004\u0018\u00010/H\u0096@\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020&H\u0016J\b\u00103\u001a\u00020\u0010H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0016R\u0014\u0010\u001e\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0012R(\u0010!\u001a\u0004\u0018\u00010\u00062\b\u0010 \u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\f\"\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0016R\u0016\u0010'\u001a\u0004\u0018\u00010(X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u00065"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/CurrentFileContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "currentSelectedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/ml/llm/context/ContextEntitySource;)V", "getCurrentSelectedFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "id", "", "getId", "()Ljava/lang/String;", "name", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "getName", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "hint", "getHint", "tooltipText", "getTooltipText", "icon", "Ljavax/swing/Icon;", "getIcon", "popupPresentationText", "getPopupPresentationText", "value", "chosenFile", "getChosenFile", "setChosenFile", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "isVisible", "", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "getConnection", "()Lcom/intellij/util/messages/MessageBusConnection;", "virtualFile", "dispose", "", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "isInMessage", "toString", "Companion", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nCurrentFileContextAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurrentFileContextAttachment.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/attachments/CurrentFileContextAttachment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
public class CurrentFileContextAttachment
extends FileContextAttachment
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFile currentSelectedFile;
    @NotNull
    private final ContextEntitySource attachedBy;
    @NotNull
    private final String id;
    @NotNull
    private final AtomicProperty<String> name;
    @NotNull
    private final AtomicProperty<String> hint;
    @NotNull
    private final AtomicProperty<Icon> icon;
    @NotNull
    private final String popupPresentationText;
    @Nullable
    private VirtualFile chosenFile;
    @NotNull
    private final AtomicProperty<Boolean> isVisible;
    @Nullable
    private final MessageBusConnection connection;
    @NotNull
    private static final String SUFFIX = "Current";
    @NotNull
    public static final String SOURCE_ID = "CURRENT_FILE";

    /*
     * WARNING - void declaration
     */
    public CurrentFileContextAttachment(@NotNull Project project, @NotNull VirtualFile currentSelectedFile, @NotNull ContextEntitySource attachedBy) {
        VirtualFile it;
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)currentSelectedFile, (String)"currentSelectedFile");
        Intrinsics.checkNotNullParameter((Object)attachedBy, (String)"attachedBy");
        super(project, currentSelectedFile, attachedBy, null);
        this.currentSelectedFile = currentSelectedFile;
        this.attachedBy = attachedBy;
        this.id = SOURCE_ID;
        this.name = new AtomicProperty((Object)"");
        this.hint = new AtomicProperty((Object)SUFFIX);
        this.icon = new AtomicProperty((Object)AllIcons.FileTypes.Unknown);
        this.popupPresentationText = "Current File";
        this.isVisible = new AtomicProperty((Object)true);
        VirtualFile virtualFile3 = virtualFile2 = this.currentSelectedFile;
        CurrentFileContextAttachment currentFileContextAttachment = this;
        boolean bl = false;
        boolean bl2 = !(this.getFile() instanceof LightVirtualFileBase) && VirtualFileValidator.INSTANCE.validate(it, ChatAttachmentKindsProvider.INSTANCE, VirtualFileValidator.Check.Companion.allButFileTooLong()) == null;
        currentFileContextAttachment.setChosenFile((VirtualFile)(bl2 ? virtualFile2 : null));
        if (!ChatContextMigrationService.Companion.isRetrieverDisabled(ChatDefaultRetrievers.CurrentFile.getId())) {
            this.connection = null;
        } else {
            void $this$_init__u24lambda_u241;
            it = virtualFile2 = project.getMessageBus().connect((Disposable)this);
            currentFileContextAttachment = this;
            boolean bl3 = false;
            Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
            $this$_init__u24lambda_u241.subscribe(topic, (Object)new FileEditorManagerListener(this){
                final /* synthetic */ CurrentFileContextAttachment this$0;
                {
                    this.this$0 = $receiver;
                }

                public void selectionChanged(FileEditorManagerEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    VirtualFile newFile = event.getNewFile();
                    if (newFile == null || !newFile.exists()) {
                        CurrentFileContextAttachment.access$setChosenFile(this.this$0, null);
                        return;
                    }
                    if (this.this$0.getFile() instanceof LightVirtualFileBase || VirtualFileValidator.INSTANCE.validate(newFile, ChatAttachmentKindsProvider.INSTANCE, VirtualFileValidator.Check.Companion.allButFileTooLong()) != null) {
                        CurrentFileContextAttachment.access$setChosenFile(this.this$0, null);
                        return;
                    }
                    CurrentFileContextAttachment.access$setChosenFile(this.this$0, newFile);
                }
            });
            currentFileContextAttachment.connection = virtualFile2;
        }
    }

    public /* synthetic */ CurrentFileContextAttachment(Project project, VirtualFile virtualFile2, ContextEntitySource contextEntitySource, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            contextEntitySource = ContextAttachmentSource.CurrentFileRetriever.INSTANCE;
        }
        this(project, virtualFile2, contextEntitySource);
    }

    @NotNull
    public final VirtualFile getCurrentSelectedFile() {
        return this.currentSelectedFile;
    }

    @Override
    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.attachedBy;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public AtomicProperty<String> getName() {
        return this.name;
    }

    @NotNull
    public AtomicProperty<String> getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return UtilKt.toProjectRelativePath(this.getProject(), this.chosenFile);
    }

    @Override
    @NotNull
    public AtomicProperty<Icon> getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @Nullable
    public final VirtualFile getChosenFile() {
        return this.chosenFile;
    }

    private final void setChosenFile(VirtualFile value) {
        this.isVisible().set((Object)(value != null ? 1 : 0));
        if (value != null) {
            AtomicProperty<String> atomicProperty = this.getName();
            String string = value.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            atomicProperty.set((Object)string);
            AtomicProperty<Icon> atomicProperty2 = this.getIcon();
            Icon icon = value.getFileType().getIcon();
            if (icon == null) {
                Icon icon2 = AllIcons.FileTypes.Unknown;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Unknown");
            }
            atomicProperty2.set((Object)icon);
        }
        this.chosenFile = value;
    }

    @Override
    @NotNull
    public AtomicProperty<Boolean> isVisible() {
        return this.isVisible;
    }

    @Nullable
    protected final MessageBusConnection getConnection() {
        return this.connection;
    }

    @Override
    @Nullable
    public VirtualFile virtualFile() {
        return this.chosenFile;
    }

    public void dispose() {
        block0: {
            MessageBusConnection messageBusConnection = this.connection;
            if (messageBusConnection == null) break block0;
            messageBusConnection.disconnect();
        }
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return CurrentFileContextAttachment.createChatAttachment$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object createChatAttachment$suspendImpl(CurrentFileContextAttachment $this, Continuation<? super ChatAttachment> $completion) {
        if ($this.isMedia()) {
            return $this.createMediaAttachment($completion);
        }
        VirtualFile virtualFile2 = $this.chosenFile;
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file = virtualFile2;
        Language language = LanguageUtil.getFileLanguage((VirtualFile)file);
        Project project = $this.getProject();
        Language language2 = language;
        if (language2 == null || (language2 = ExtensionsKtKt.getPrivacySafe((Language)language2)) == null || (language2 = language2.getDisplayName()) == null || (language2 = language2.lowercase()) == null) {
            language2 = ConstantsKt.getEMPTY();
        }
        return new CurrentFileChatAttachment(project, file, PSStringOperatorsKt.wrapCodeIntoMarkdownSnippet((PSString)language2, (PSString)$this.getText()), language, $this.getAttachedBy(), ChatAttachment.Kind.Visible);
    }

    @Override
    public void performAction(boolean isInMessage) {
        VirtualFile file;
        Object object;
        if (isInMessage) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = this.currentSelectedFile;
            boolean bl = false;
            object = FileManagerUtils.INSTANCE.isSupported(it) ? virtualFile2 : null;
        } else {
            object = this.virtualFile();
        }
        VirtualFile virtualFile3 = file = object;
        boolean bl = virtualFile3 != null ? virtualFile3.isValid() : false;
        if (bl) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(file, true);
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "Current File (" + this.currentSelectedFile.getPath() + ")";
    }

    public static final /* synthetic */ void access$setChosenFile(CurrentFileContextAttachment $this, VirtualFile value) {
        $this.setChosenFile(value);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/CurrentFileContextAttachment$Companion;", "", "<init>", "()V", "SUFFIX", "", "SOURCE_ID", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

