/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.popup;

import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.popup.Bucket;
import com.intellij.ml.llm.core.chat.ui.chat.context.popup.ContextAttachmentDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u001e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tJ\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000fJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\u0006\u0010\f\u001a\u00020\u0006J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aJ\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\u001c\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\u001d\u001a\u00020\u000bJ\u000e\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\u001e\u001a\u00020\u000bR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/popup/ContextNotSelectedStorage;", "", "<init>", "()V", "buckets", "", "", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/popup/Bucket;", "MAX_ELEMS_PER_SESSION", "", "createBucket", "", "parentId", "addNotSelectedContext", "value", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachment;", "idx", "changeIsSelectedStatusForContext", "contextAttachment", "isAttachmentSelected", "", "markContextAsSelected", "markContextAsNotSelected", "getItems", "", "getAllParentIds", "", "getSelectedItemCount", "makeCurrentItemsPermanent", "clearNonPermanentSessionItems", "clear", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nContextAttachmentStorageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextAttachmentStorageManager.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/popup/ContextNotSelectedStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,152:1\n1788#2,4:153\n1761#2,3:160\n1869#2:167\n1870#2:169\n774#2:170\n865#2,2:171\n1563#2:173\n1634#2,3:174\n774#2:177\n865#2,2:178\n1869#2,2:181\n774#2:184\n865#2,2:185\n1869#2,2:187\n1869#2,2:189\n536#3:157\n521#3,2:158\n523#3,4:163\n1#4:168\n216#5:180\n217#5:183\n*S KotlinDebug\n*F\n+ 1 ContextAttachmentStorageManager.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/popup/ContextNotSelectedStorage\n*L\n74#1:153,4\n93#1:160,3\n98#1:167\n98#1:169\n117#1:170\n117#1:171,2\n118#1:173\n118#1:174,3\n126#1:177\n126#1:178,2\n131#1:181,2\n136#1:184\n136#1:185,2\n141#1:187,2\n149#1:189,2\n92#1:157\n92#1:158,2\n92#1:163,4\n131#1:180\n131#1:183\n*E\n"})
public final class ContextNotSelectedStorage {
    @NotNull
    private final Map<String, Bucket> buckets = new ConcurrentHashMap();
    private int MAX_ELEMS_PER_SESSION = 10;

    public final void createBucket(@NotNull String parentId) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        this.buckets.computeIfAbsent(parentId, arg_0 -> ContextNotSelectedStorage.createBucket$lambda$1(ContextNotSelectedStorage::createBucket$lambda$0, arg_0));
    }

    public final void addNotSelectedContext(@NotNull String parentId, @NotNull ContextAttachment value, int idx) {
        Object v2;
        Bucket bucket;
        block7: {
            int n;
            Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.createBucket(parentId);
            Bucket bucket2 = this.buckets.get(parentId);
            Intrinsics.checkNotNull((Object)bucket2);
            bucket = bucket2;
            Iterable $this$count$iv = bucket.getItems();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    ContextAttachmentDetails it = (ContextAttachmentDetails)element$iv;
                    boolean bl = false;
                    if (!(!it.getPermanent()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (n >= this.MAX_ELEMS_PER_SESSION + 1) {
                return;
            }
            Iterable iterable = bucket.getItems();
            for (Object t : iterable) {
                ContextAttachmentDetails contextAttachmentDetails = (ContextAttachmentDetails)t;
                boolean bl = false;
                ContextAttachment existing = contextAttachmentDetails.component1();
                if (!(Intrinsics.areEqual((Object)existing.getId(), (Object)value.getId()) && Intrinsics.areEqual((Object)existing.getText(), (Object)value.getText()))) continue;
                v2 = t;
                break block7;
            }
            v2 = null;
        }
        ContextAttachmentDetails existingItem = v2;
        if (existingItem != null) {
            existingItem.setIdx(Math.min(existingItem.getIdx(), idx));
        } else {
            bucket.getItems().add(new ContextAttachmentDetails(value, idx, false, false, 8, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void changeIsSelectedStatusForContext(ContextAttachment contextAttachment, boolean isAttachmentSelected) {
        Map.Entry entry;
        void $this$filterTo$iv$iv;
        Map<String, Bucket> $this$filter$iv = this.buckets;
        boolean $i$f$filter = false;
        Map<String, Bucket> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            boolean bl;
            block7: {
                entry = element$iv$iv;
                boolean bl2 = false;
                Bucket value = (Bucket)entry.getValue();
                Iterable $this$any$iv = value.getItems();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ContextAttachmentDetails it = (ContextAttachmentDetails)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getAttachment().getId(), (Object)contextAttachment.getId())) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set parentIds = destination$iv$iv.keySet();
        Iterable $this$forEach$iv = parentIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v3;
            block8: {
                boolean bl;
                String id = (String)element$iv;
                boolean bl4 = false;
                boolean bl5 = bl = this.buckets.get(id) != null;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl6 = false;
                    String string = "Bucket in ContextNotSelectedStorage must be created on opening tab";
                    throw new AssertionError((Object)string);
                }
                Bucket bucket = this.buckets.get(id);
                Intrinsics.checkNotNull((Object)bucket);
                Iterable bl2 = bucket.getItems();
                for (Object t : bl2) {
                    ContextAttachmentDetails it = (ContextAttachmentDetails)t;
                    boolean bl7 = false;
                    if (!Intrinsics.areEqual((Object)it.getAttachment().getId(), (Object)contextAttachment.getId())) continue;
                    v3 = t;
                    break block8;
                }
                v3 = null;
            }
            if ((ContextAttachmentDetails)v3 == null) continue;
            Object $this$changeIsSelectedStatusForContext_u24lambda_u241_u242 = entry;
            boolean bl = false;
            ((ContextAttachmentDetails)$this$changeIsSelectedStatusForContext_u24lambda_u241_u242).setSelected(isAttachmentSelected);
        }
    }

    public final void markContextAsSelected(@NotNull ContextAttachment contextAttachment) {
        Intrinsics.checkNotNullParameter((Object)contextAttachment, (String)"contextAttachment");
        this.changeIsSelectedStatusForContext(contextAttachment, true);
    }

    public final void markContextAsNotSelected(@NotNull ContextAttachment contextAttachment) {
        Intrinsics.checkNotNullParameter((Object)contextAttachment, (String)"contextAttachment");
        this.changeIsSelectedStatusForContext(contextAttachment, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ContextAttachment> getItems(@NotNull String parentId) {
        List list;
        Set<ContextAttachmentDetails> set;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Bucket bucket = this.buckets.get(parentId);
        if (bucket != null && (set = bucket.getItems()) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = set;
            boolean $i$f$filter22 = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ContextAttachmentDetails it = (ContextAttachmentDetails)element$iv$iv;
                boolean bl = false;
                if (!(!it.isSelected())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ContextAttachmentDetails bl = (ContextAttachmentDetails)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getAttachment());
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Set<String> getAllParentIds() {
        return CollectionsKt.toSet((Iterable)this.buckets.keySet());
    }

    /*
     * WARNING - void declaration
     */
    public final int getSelectedItemCount(@NotNull String parentId) {
        int n;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Bucket bucket = this.buckets.get(parentId);
        Object object = bucket;
        if (object != null && (object = ((Bucket)object).getItems()) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ContextAttachmentDetails it = (ContextAttachmentDetails)element$iv$iv;
                boolean bl = false;
                if (!it.isSelected()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            n = ((List)destination$iv$iv).size();
        } else {
            n = 0;
        }
        return n;
    }

    public final void makeCurrentItemsPermanent() {
        Map<String, Bucket> $this$forEach$iv = this.buckets;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Bucket>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Bucket> element$iv;
            Map.Entry<String, Bucket> entry = element$iv = iterator.next();
            boolean bl = false;
            Bucket value = entry.getValue();
            Iterable $this$forEach$iv2 = value.getItems();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ContextAttachmentDetails it = (ContextAttachmentDetails)element$iv2;
                boolean bl2 = false;
                it.setPermanent(true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void clearNonPermanentSessionItems(@NotNull String parentId) {
        block1: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
            Bucket bucket = this.buckets.get(parentId);
            if (bucket == null) break block1;
            Bucket bucket2 = bucket;
            boolean bl = false;
            Iterable iterable = bucket2.getItems();
            Bucket bucket3 = bucket2;
            boolean $i$f$filter = false;
            void var7_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ContextAttachmentDetails it = (ContextAttachmentDetails)element$iv$iv;
                boolean bl2 = false;
                if (!it.getPermanent()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            bucket3.setItems(CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv)));
        }
    }

    public final void clearNonPermanentSessionItems() {
        Iterable $this$forEach$iv = this.getAllParentIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.clearNonPermanentSessionItems(it);
        }
    }

    public final void clear(@NotNull String parentId) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        this.buckets.remove(parentId);
    }

    public final void clear() {
        Iterable $this$forEach$iv = this.getAllParentIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.clear(it);
        }
    }

    private static final Bucket createBucket$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Bucket(null, 1, null);
    }

    private static final Bucket createBucket$lambda$1(Function1 $tmp0, Object p0) {
        return (Bucket)$tmp0.invoke(p0);
    }
}

