/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.input;

import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.FocusedChatSessionHost;
import com.intellij.ml.llm.core.chat.ui.chat.input.AIAssistantInputDropHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0002\u0010\tJ\"\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/input/FilesToContextInputDropHandler;", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInputDropHandler;", "<init>", "()V", "canHandleDrop", "", "transferFlavors", "", "Ljava/awt/datatransfer/DataFlavor;", "([Ljava/awt/datatransfer/DataFlavor;)Z", "handleDrop", "transferable", "Ljava/awt/datatransfer/Transferable;", "project", "Lcom/intellij/openapi/project/Project;", "inputEditor", "Lcom/intellij/openapi/editor/Editor;", "extractData", "", "Ljava/io/File;", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAssistantInputDropHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantInputDropHandler.kt\ncom/intellij/ml/llm/core/chat/ui/chat/input/FilesToContextInputDropHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1#2:46\n808#3,11:47\n*S KotlinDebug\n*F\n+ 1 AIAssistantInputDropHandler.kt\ncom/intellij/ml/llm/core/chat/ui/chat/input/FilesToContextInputDropHandler\n*L\n43#1:47,11\n*E\n"})
public final class FilesToContextInputDropHandler
implements AIAssistantInputDropHandler {
    @Override
    public boolean canHandleDrop(@NotNull DataFlavor[] transferFlavors) {
        DataFlavor dataFlavor;
        block2: {
            Intrinsics.checkNotNullParameter((Object)transferFlavors, (String)"transferFlavors");
            if (!Registry.Companion.is("llm.chat.input.drop.files.as.attachments.enabled")) {
                return false;
            }
            DataFlavor[] dataFlavorArray = transferFlavors;
            int n = dataFlavorArray.length;
            for (int i = 0; i < n; ++i) {
                DataFlavor dataFlavor2;
                DataFlavor it = dataFlavor2 = dataFlavorArray[i];
                boolean bl = false;
                if (!it.isFlavorJavaFileListType()) continue;
                dataFlavor = dataFlavor2;
                break block2;
            }
            dataFlavor = null;
        }
        return dataFlavor != null;
    }

    @Override
    public boolean handleDrop(@NotNull Transferable transferable, @Nullable Project project, @NotNull Editor inputEditor) {
        Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
        Intrinsics.checkNotNullParameter((Object)inputEditor, (String)"inputEditor");
        if (!Registry.Companion.is("llm.chat.input.drop.files.as.attachments.enabled")) {
            return false;
        }
        if (project == null) {
            return false;
        }
        List<File> files = this.extractData(transferable);
        if (files.isEmpty()) {
            return false;
        }
        ChatSession chatSession2 = FocusedChatSessionHost.Companion.getInstance(project).getFocusedChatSession();
        if (chatSession2 == null) {
            return false;
        }
        ChatSession chatSession3 = chatSession2;
        chatSession3.getContextViewModel().handleFilesDrop(files);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> extractData(Transferable transferable) {
        List list;
        Object object;
        block5: {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            Intrinsics.checkNotNullExpressionValue((Object)dataFlavorArray, (String)"getTransferDataFlavors(...)");
            for (Object object2 : (Object[])dataFlavorArray) {
                DataFlavor it = (DataFlavor)object2;
                boolean bl = false;
                if (!it.isFlavorJavaFileListType()) continue;
                object = object2;
                break block5;
            }
            object = null;
        }
        DataFlavor dataFlavor = (DataFlavor)object;
        if (dataFlavor == null) {
            return CollectionsKt.emptyList();
        }
        DataFlavor fileFlavor = dataFlavor;
        Object object3 = transferable.getTransferData(fileFlavor);
        List list2 = object3 instanceof List ? (List)object3 : null;
        if (list2 != null) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = list2;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof File)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

