/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.input;

import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.CurrentChatSessionMode;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.NewChatMode;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/input/SwitchChatModesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Companion", "intellij.ml.llm.chat"})
public final class SwitchChatModesAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "AIAssistant.Chat.Toggle.Chat.Mode";

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setVisible(false);
        e.getPresentation().setEnabled(e.getDataContext().getData(ChatSession.Companion.getCurrentSession()) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ChatSession chatSession2 = (ChatSession)e.getDataContext().getData(ChatSession.Companion.getCurrentSession());
        if (chatSession2 == null) {
            return;
        }
        ChatSession chat = chatSession2;
        CurrentChatSessionMode modeChooser = chat.getChatMode();
        NewChatMode currentMode = (NewChatMode)modeChooser.getCurrentChatMode().getValue();
        NewChatMode lastAgentMode = modeChooser.getPreviousNonChatMode();
        if (lastAgentMode != null) {
            if (Intrinsics.areEqual((Object)currentMode, (Object)NewChatMode.Chat.INSTANCE)) {
                modeChooser.setChatMode(lastAgentMode);
            } else {
                modeChooser.setChatMode(NewChatMode.Chat.INSTANCE);
            }
            AIAssistantChatEventLogger.logAgentSelected(chat, AIAssistantChatEventLogger.AgentSelectionSource.SwitchChatModeAction);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/input/SwitchChatModesAction$Companion;", "", "<init>", "()V", "ID", "", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

