/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.MLLlmIcons;
import com.intellij.ml.llm.core.chat.proxy.AIAAgentAndModeSelectorSessionProxy;
import com.intellij.ml.llm.core.chat.services.AIAssistantServiceScope;
import com.intellij.ml.llm.core.chat.session.ChatSessionMode;
import com.intellij.ml.llm.core.chat.ui.AgentModel;
import com.intellij.ml.llm.core.chat.ui.AttachmentKindsProvider;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.AIAssistantChatModeSelectorUI;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.ChatAttachmentKindsProvider;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.InlineAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.popup.ActionPopupOptions;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.WizardPopup;
import java.awt.Component;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JList;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004&'()B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\b\u0010$\u001a\u00020%H\u0007R\u0017\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0014\u0010\u0015\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\bR\u0012\u0010\u001d\u001a\u00020\u001eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u0082\u0001\u0004*+,-\u00a8\u0006."}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode;", "", "<init>", "()V", "displayName", "", "Lorg/jetbrains/annotations/Nls;", "getDisplayName", "()Ljava/lang/String;", "id", "getId", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "supportModelSwitching", "", "getSupportModelSwitching", "()Z", "fullName", "getFullName", "shouldAppearAsAgent", "getShouldAppearAsAgent", "order", "", "getOrder", "()I", "description", "getDescription", "attachmentKindsProvider", "Lcom/intellij/ml/llm/core/chat/ui/AttachmentKindsProvider;", "getAttachmentKindsProvider", "()Lcom/intellij/ml/llm/core/chat/ui/AttachmentKindsProvider;", "getInlineActions", "", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/InlineAction;", "toLegacyChatMode", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionMode;", "CodeGeneration", "Chat", "AskAi", "Agent", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode$Agent;", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode$AskAi;", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode$Chat;", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode$CodeGeneration;", "intellij.ml.llm.chat"})
public abstract sealed class NewChatMode {
    private final boolean shouldAppearAsAgent;
    private final int order = Integer.MAX_VALUE;
    @Nullable
    private final String description;

    private NewChatMode() {
    }

    @NotNull
    public abstract String getDisplayName();

    @NotNull
    public abstract String getId();

    @Nullable
    public abstract Icon getIcon();

    public abstract boolean getSupportModelSwitching();

    @NotNull
    public String getFullName() {
        return this.getDisplayName();
    }

    public boolean getShouldAppearAsAgent() {
        return this.shouldAppearAsAgent;
    }

    public int getOrder() {
        return this.order;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public abstract AttachmentKindsProvider getAttachmentKindsProvider();

    @NotNull
    public List<InlineAction> getInlineActions() {
        return CollectionsKt.emptyList();
    }

    @Deprecated(message="Don't use legacy chat modes")
    @NotNull
    public final ChatSessionMode toLegacyChatMode() {
        ChatSessionMode chatSessionMode;
        NewChatMode newChatMode = this;
        if (newChatMode instanceof Chat) {
            chatSessionMode = ChatSessionMode.CHAT;
        } else if (newChatMode instanceof Agent) {
            chatSessionMode = ChatSessionMode.AGENT;
        } else if (newChatMode instanceof AskAi) {
            chatSessionMode = ChatSessionMode.ASK_AI;
        } else if (newChatMode instanceof CodeGeneration) {
            chatSessionMode = ChatSessionMode.CODE_GENERATION;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return chatSessionMode;
    }

    public /* synthetic */ NewChatMode(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\u00070\t\u00a2\u0006\u0002\b\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\fR\u0014\u0010\u0019\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u001b\u0010\u001b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode$Agent;", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode;", "agentModel", "Lcom/intellij/ml/llm/core/chat/ui/AgentModel;", "<init>", "(Lcom/intellij/ml/llm/core/chat/ui/AgentModel;)V", "getAgentModel", "()Lcom/intellij/ml/llm/core/chat/ui/AgentModel;", "displayName", "", "Lorg/jetbrains/annotations/Nls;", "getDisplayName", "()Ljava/lang/String;", "fullName", "getFullName", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "supportModelSwitching", "", "getSupportModelSwitching", "()Z", "id", "getId", "shouldAppearAsAgent", "getShouldAppearAsAgent", "description", "getDescription", "order", "", "getOrder", "()I", "attachmentKindsProvider", "Lcom/intellij/ml/llm/core/chat/ui/AttachmentKindsProvider;", "getAttachmentKindsProvider", "()Lcom/intellij/ml/llm/core/chat/ui/AttachmentKindsProvider;", "intellij.ml.llm.chat"})
    public static final class Agent
    extends NewChatMode {
        @NotNull
        private final AgentModel agentModel;
        private final boolean shouldAppearAsAgent;
        @Nullable
        private final String description;

        public Agent(@NotNull AgentModel agentModel) {
            Intrinsics.checkNotNullParameter((Object)agentModel, (String)"agentModel");
            super(null);
            this.agentModel = agentModel;
            this.shouldAppearAsAgent = true;
            this.description = this.agentModel.getDescription();
        }

        @NotNull
        public final AgentModel getAgentModel() {
            return this.agentModel;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.agentModel.getDisplayName();
        }

        @Override
        @NotNull
        public String getFullName() {
            return this.agentModel.getFullName();
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.agentModel.getIcon();
        }

        @Override
        public boolean getSupportModelSwitching() {
            return this.agentModel.getSupportModelSwitching();
        }

        @Override
        @NotNull
        public String getId() {
            return "agent_" + this.agentModel.getId();
        }

        @Override
        public boolean getShouldAppearAsAgent() {
            return this.shouldAppearAsAgent;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Override
        public int getOrder() {
            return this.agentModel.getOrder();
        }

        @Override
        @NotNull
        public AttachmentKindsProvider getAttachmentKindsProvider() {
            return this.agentModel.getAttachmentKindsProvider();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode$AskAi;", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode;", "<init>", "()V", "displayName", "", "Lorg/jetbrains/annotations/Nls;", "getDisplayName", "()Ljava/lang/String;", "id", "getId", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "supportModelSwitching", "", "getSupportModelSwitching", "()Z", "attachmentKindsProvider", "Lcom/intellij/ml/llm/core/chat/ui/AttachmentKindsProvider;", "getAttachmentKindsProvider", "()Lcom/intellij/ml/llm/core/chat/ui/AttachmentKindsProvider;", "intellij.ml.llm.chat"})
    public static final class AskAi
    extends NewChatMode {
        @NotNull
        public static final AskAi INSTANCE = new AskAi();

        private AskAi() {
            super(null);
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return LLMBundle.message((String)"chat.mode.chooser.askai.mode.short.name", (Object[])new Object[0]);
        }

        @Override
        @NotNull
        public String getId() {
            return "ask_ai_mode";
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = MLLlmIcons.Chat.ChatMode;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ChatMode");
            return icon;
        }

        @Override
        public boolean getSupportModelSwitching() {
            return true;
        }

        @Override
        @NotNull
        public AttachmentKindsProvider getAttachmentKindsProvider() {
            return ChatAttachmentKindsProvider.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0019\u0010\u0013\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode$Chat;", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode;", "<init>", "()V", "displayName", "", "Lorg/jetbrains/annotations/Nls;", "getDisplayName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "supportModelSwitching", "", "getSupportModelSwitching", "()Z", "id", "getId", "description", "getDescription", "attachmentKindsProvider", "Lcom/intellij/ml/llm/core/chat/ui/AttachmentKindsProvider;", "getAttachmentKindsProvider", "()Lcom/intellij/ml/llm/core/chat/ui/AttachmentKindsProvider;", "getInlineActions", "", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/InlineAction;", "intellij.ml.llm.chat"})
    public static final class Chat
    extends NewChatMode {
        @NotNull
        public static final Chat INSTANCE = new Chat();

        private Chat() {
            super(null);
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return LLMBundle.message((String)"chat.mode.chooser.chat.mode.short.name", (Object[])new Object[0]);
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = MLLlmIcons.Chat.ChatMode;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ChatMode");
            return icon;
        }

        @Override
        public boolean getSupportModelSwitching() {
            return true;
        }

        @Override
        @NotNull
        public String getId() {
            return "chat_mode";
        }

        @Override
        @NotNull
        public String getDescription() {
            return LLMBundle.message((String)"chat.mode.chooser.tooltip.chat.description", (Object[])new Object[0]);
        }

        @Override
        @NotNull
        public AttachmentKindsProvider getAttachmentKindsProvider() {
            return ChatAttachmentKindsProvider.INSTANCE;
        }

        @Override
        @NotNull
        public List<InlineAction> getInlineActions() {
            if (!Registry.Companion.is("llm.chat.context.codebase.switcher.in.popup.enabled")) {
                return CollectionsKt.emptyList();
            }
            String string = LLMBundle.message((String)"chat.mode.chooser.chat.inline.action.name", (Object[])new Object[0]);
            Icon icon = AllIcons.General.Settings;
            return CollectionsKt.listOf((Object)((Object)new InlineAction(string, icon){
                {
                    Intrinsics.checkNotNull((Object)$super_call_param$2);
                    super($super_call_param$1, $super_call_param$2);
                }

                public JBPopup getPopup(WizardPopup parentPopup, AIAssistantChatModeSelectorUI selectorUI, AIAAgentAndModeSelectorSessionProxy proxy) {
                    PopupFactoryImpl.ActionGroupPopup popup2;
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)parentPopup, (String)"parentPopup");
                        Intrinsics.checkNotNullParameter((Object)((Object)selectorUI), (String)"selectorUI");
                        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
                        String string = LLMBundle.message((String)"chat.mode.chooser.chat.enable.codebase", (Object[])new Object[0]);
                        ToggleAction codebaseToggle2 = new ToggleAction(proxy, string){
                            final /* synthetic */ AIAAgentAndModeSelectorSessionProxy $proxy;
                            {
                                this.$proxy = $proxy;
                                super($super_call_param$1);
                            }

                            public ActionUpdateThread getActionUpdateThread() {
                                return ActionUpdateThread.EDT;
                            }

                            public boolean isDumbAware() {
                                return true;
                            }

                            public boolean isSelected(AnActionEvent e) {
                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                return (Boolean)this.$proxy.getCodebaseModeVm().getEnabled().getValue();
                            }

                            public void setSelected(AnActionEvent e, boolean state) {
                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                BuildersKt.launch$default((CoroutineScope)AIAssistantServiceScope.Companion.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$proxy, state, null){
                                    int label;
                                    final /* synthetic */ AIAAgentAndModeSelectorSessionProxy $proxy;
                                    final /* synthetic */ boolean $state;
                                    {
                                        this.$proxy = $proxy;
                                        this.$state = $state;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.label = 1;
                                                Object object2 = this.$proxy.getCodebaseModeVm().toggleState(!this.$state, (Continuation<? super Unit>)((Continuation)this));
                                                if (object2 != object) return Unit.INSTANCE;
                                                return object;
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object2 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                            }
                        };
                        AnAction[] anActionArray = new AnAction[]{codebaseToggle2};
                        popup2 = new PopupFactoryImpl.ActionGroupPopup(parentPopup, null, (ActionGroup)new DefaultActionGroup(anActionArray), DataManager.getInstance().getDataContext((Component)((Object)selectorUI)), ActionPlaces.getPopupPlace((String)"ChatModeSubmenu"), new PresentationFactory(), ActionPopupOptions.Companion.create(false, false, true, false, 30, false, null), null);
                        popup2.setAdText(LLMBundle.message((String)"chat.mode.chooser.chat.popup.hint", (Object[])new Object[0]));
                        Object object = popup2.getList();
                        if (object == null || (object = ((JList)object).getAccessibleContext()) == null) break block0;
                        ((AccessibleContext)object).setAccessibleName(LLMBundle.message((String)"chat.mode.chooser.chat.settings.accessible.name", (Object[])new Object[0]));
                    }
                    return (JBPopup)popup2;
                }
            }));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0019\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\u0019\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode$CodeGeneration;", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode;", "<init>", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "supportModelSwitching", "", "getSupportModelSwitching", "()Z", "shouldAppearAsAgent", "getShouldAppearAsAgent", "displayName", "", "Lorg/jetbrains/annotations/Nls;", "getDisplayName", "()Ljava/lang/String;", "id", "getId", "order", "", "getOrder", "()I", "description", "getDescription", "attachmentKindsProvider", "Lcom/intellij/ml/llm/core/chat/ui/AttachmentKindsProvider;", "getAttachmentKindsProvider", "()Lcom/intellij/ml/llm/core/chat/ui/AttachmentKindsProvider;", "intellij.ml.llm.chat"})
    public static final class CodeGeneration
    extends NewChatMode {
        @NotNull
        public static final CodeGeneration INSTANCE = new CodeGeneration();

        private CodeGeneration() {
            super(null);
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = MLLlmIcons.Chat.Mode.CodeGeneration;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"CodeGeneration");
            return icon;
        }

        @Override
        public boolean getSupportModelSwitching() {
            return true;
        }

        @Override
        public boolean getShouldAppearAsAgent() {
            return true;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return LLMBundle.message((String)"chat.mode.chooser.agent.quick.edit.mode.name", (Object[])new Object[0]);
        }

        @Override
        @NotNull
        public String getId() {
            return "quick_edit_mode";
        }

        @Override
        public int getOrder() {
            return 3;
        }

        @Override
        @NotNull
        public String getDescription() {
            return LLMBundle.message((String)"chat.mode.chooser.tooltip.quick.edit.description", (Object[])new Object[0]);
        }

        @Override
        @NotNull
        public AttachmentKindsProvider getAttachmentKindsProvider() {
            return ChatAttachmentKindsProvider.INSTANCE;
        }
    }
}

