/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.modelSelector;

import com.intellij.collaboration.ui.CollaborationToolsUIUtilKt;
import com.intellij.ml.llm.MLLlmIcons;
import com.intellij.ml.llm.core.chat.ui.ChatModelPopupElement;
import com.intellij.ml.llm.core.chat.ui.chat.modelSelector.AIAssistantChatModelSelectorKt;
import com.intellij.ml.llm.core.chat.ui.chat.modelSelector.ModelDetailsComponent;
import com.intellij.ml.llm.core.chat.ui.chat.modelSelector.ModelSelectorPopupStep;
import com.intellij.ml.llm.core.models.api.AiaLlmProfileIDUtils;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalBox;
import com.intellij.ui.popup.BackendRenderedPopup;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ,\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/modelSelector/ModelSelectorListPopup;", "Lcom/intellij/ui/popup/list/ListPopupImpl;", "Lcom/intellij/ui/popup/BackendRenderedPopup;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Lcom/intellij/ui/popup/WizardPopup;", "step", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "Lcom/intellij/ml/llm/core/chat/ui/ChatModelPopupElement;", "parentValue", "", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ui/popup/WizardPopup;Lcom/intellij/openapi/ui/popup/ListPopupStep;Ljava/lang/Object;Lcom/intellij/openapi/Disposable;)V", "moreSubMenu", "Ljava/util/concurrent/atomic/AtomicReference;", "createPopup", "Lcom/intellij/openapi/ui/popup/PopupStep;", "getListElementRenderer", "Ljavax/swing/ListCellRenderer;", "installDetailsTooltip", "", "intellij.ml.llm.chat"})
@ApiStatus.Internal
public final class ModelSelectorListPopup
extends ListPopupImpl
implements BackendRenderedPopup {
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final AtomicReference<WizardPopup> moreSubMenu;

    public ModelSelectorListPopup(@NotNull Project project, @Nullable WizardPopup parent, @NotNull ListPopupStep<ChatModelPopupElement> step, @Nullable Object parentValue, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(step, (String)"step");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super(project, parent, step, parentValue);
        this.disposable = disposable;
        this.moreSubMenu = new AtomicReference<Object>(null);
        this.installDetailsTooltip();
        this.setMinimumSize(new Dimension(JBUIScale.scale((int)260), this.getMinimumSize().height));
        this.getList().addMouseMotionListener(new MouseMotionAdapter(){
            private Point prevPoint;

            public final Point getPrevPoint() {
                return this.prevPoint;
            }

            public final void setPrevPoint(Point point) {
                this.prevPoint = point;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (moreSubMenu.get() != null) {
                    Point point = e.getPoint();
                    if (point == null) {
                        return;
                    }
                    int index = this.getList().locationToIndex(point);
                    if (index >= 0) {
                        Object object = (WizardPopup)moreSubMenu.get();
                        if (object == null || (object = object.getComponent()) == null) {
                            return;
                        }
                        Object it = object;
                        boolean bl = false;
                        Rectangle subMenuRect = new Rectangle(((Component)it).getLocationOnScreen(), ((Component)it).getSize());
                        Object e2 = this.getList().getModel().getElementAt(index);
                        if (e2 != null) {
                            Object e3 = e2;
                            ModelSelectorListPopup modelSelectorListPopup = this;
                            Object it2 = e3;
                            boolean bl2 = false;
                            if (it2 instanceof ChatModelPopupElement.Model) {
                                Point point2 = e.getLocationOnScreen();
                                Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getLocationOnScreen(...)");
                                if (!this.isMovingTowardSubmenu(this.prevPoint, point2, subMenuRect)) {
                                    WizardPopup wizardPopup = modelSelectorListPopup.moreSubMenu.getAndSet(null);
                                    if (wizardPopup != null) {
                                        wizardPopup.cancel();
                                    }
                                }
                            }
                        }
                    }
                    this.prevPoint = e.getLocationOnScreen();
                }
            }

            private final boolean isMovingTowardSubmenu(Point prevPoint, Point currentPoint, Rectangle subMenuRect) {
                if (prevPoint == null) {
                    return true;
                }
                int deltaX = currentPoint.x - prevPoint.x;
                int deltaY = currentPoint.y - prevPoint.y;
                if (deltaX == 0 && deltaY == 0) {
                    return true;
                }
                int nearestX = Math.max(subMenuRect.x, Math.min(prevPoint.x, subMenuRect.x + subMenuRect.width));
                int submenuDirX = nearestX - prevPoint.x;
                int nearestY = Math.max(subMenuRect.y, Math.min(prevPoint.y, subMenuRect.y + subMenuRect.height));
                int submenuDirY = nearestY - prevPoint.y;
                int dotProduct = deltaX * submenuDirX + deltaY * submenuDirY;
                return dotProduct > 0;
            }
        });
        if (parent == null) {
            this.addListener(new JBPopupListener(){

                public void onClosed(LightweightWindowEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (!event.isOk()) {
                        AIAssistantChatEventLogger.logChatModelSelectorClosed();
                    }
                }
            });
        }
    }

    @Nullable
    protected WizardPopup createPopup(@Nullable WizardPopup parent, @Nullable PopupStep<?> step, @Nullable Object parentValue) {
        if (step instanceof ModelSelectorPopupStep) {
            ModelSelectorListPopup modelSelectorListPopup;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ModelSelectorListPopup it = modelSelectorListPopup = new ModelSelectorListPopup(project, parent, (ListPopupStep<ChatModelPopupElement>)((ListPopupStep)step), parentValue, this.disposable);
            boolean bl = false;
            if (parentValue instanceof ChatModelPopupElement.MoreModelsElement) {
                Disposer.register((Disposable)((Disposable)it), () -> ModelSelectorListPopup.createPopup$lambda$0$0(this));
                WizardPopup wizardPopup = this.moreSubMenu.getAndSet((WizardPopup)it);
                if (wizardPopup != null) {
                    wizardPopup.cancel();
                }
            }
            return (WizardPopup)modelSelectorListPopup;
        }
        return super.createPopup(parent, step, parentValue);
    }

    @NotNull
    protected ListCellRenderer<ChatModelPopupElement> getListElementRenderer() {
        return (ListCellRenderer)new PopupListElementRenderer<ChatModelPopupElement>(this){
            private JBLabel freeIcon;
            private JBLabel newIcon;
            private JBLabel betaIcon;
            private JBLabel rubyIcon;
            private JBLabel brainIcon;
            private JBLabel imageIcon;
            private JBLabel greyText;
            private JComponent extraSpace;

            protected JComponent createItemComponent() {
                JBLabel newFreeIcon = new JBLabel(MLLlmIcons.Chat.Model.Free);
                JBLabel newNewIcon = new JBLabel(MLLlmIcons.Chat.Model.New);
                JBLabel newBetaIcon = new JBLabel(MLLlmIcons.Chat.Model.Beta);
                JBLabel newRubyIcon = new JBLabel(MLLlmIcons.Chat.Model.Ruby);
                JBLabel newBrainIcon = new JBLabel(MLLlmIcons.Chat.Model.Brain);
                JBLabel newImageIcon = new JBLabel(MLLlmIcons.Chat.Model.Image_grey);
                JBLabel newGreyTextLabel = new JBLabel();
                Color color = UIManager.getColor("MenuItem.acceleratorForeground");
                if (color == null) {
                    color = (Color)JBColor.GRAY;
                }
                newGreyTextLabel.setForeground(color);
                JComponent finalPanel = super.createItemComponent();
                HorizontalBox newExtraSpace2 = new HorizontalBox(){
                    {
                        this.setVisible(false);
                    }

                    public Dimension getPreferredSize() {
                        return new Dimension(JBUIScale.scale((int)0), super.getPreferredSize().height);
                    }
                };
                JPanel iconsPanel = CollaborationToolsUIUtilKt.HorizontalListPanel((int)8);
                iconsPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)15, (int)0, (int)5));
                iconsPanel.add((Component)newBetaIcon);
                iconsPanel.add((Component)newRubyIcon);
                iconsPanel.add((Component)newBrainIcon);
                iconsPanel.add((Component)newImageIcon);
                iconsPanel.add((Component)newExtraSpace2);
                this.myTextLabel.getParent().add((Component)iconsPanel, "East");
                JPanel labelWrapper = CollaborationToolsUIUtilKt.HorizontalListPanel((int)8);
                Container labelParent = this.myTextLabel.getParent();
                ErrorLabel label = this.myTextLabel;
                labelParent.remove((Component)label);
                labelWrapper.add((Component)label);
                labelWrapper.add((Component)newGreyTextLabel);
                labelWrapper.add((Component)newFreeIcon);
                labelWrapper.add((Component)newNewIcon);
                labelParent.add((Component)labelWrapper, "Center");
                this.freeIcon = newFreeIcon;
                this.newIcon = newNewIcon;
                this.betaIcon = newBetaIcon;
                this.rubyIcon = newRubyIcon;
                this.brainIcon = newBrainIcon;
                this.imageIcon = newImageIcon;
                this.greyText = newGreyTextLabel;
                this.extraSpace = (JComponent)newExtraSpace2;
                return finalPanel;
            }

            protected void customizeComponent(JList<? extends ChatModelPopupElement> list, ChatModelPopupElement value, boolean isSelected) {
                block31: {
                    super.customizeComponent(list, (Object)value, isSelected);
                    JBLabel jBLabel = this.freeIcon;
                    if (jBLabel != null) {
                        jBLabel.setVisible(false);
                    }
                    JBLabel jBLabel2 = this.betaIcon;
                    if (jBLabel2 != null) {
                        jBLabel2.setVisible(false);
                    }
                    JBLabel jBLabel3 = this.newIcon;
                    if (jBLabel3 != null) {
                        jBLabel3.setVisible(false);
                    }
                    JBLabel jBLabel4 = this.rubyIcon;
                    if (jBLabel4 != null) {
                        jBLabel4.setVisible(false);
                    }
                    JBLabel jBLabel5 = this.brainIcon;
                    if (jBLabel5 != null) {
                        jBLabel5.setVisible(false);
                    }
                    JBLabel jBLabel6 = this.greyText;
                    if (jBLabel6 != null) {
                        jBLabel6.setVisible(false);
                    }
                    JComponent jComponent = this.extraSpace;
                    if (jComponent != null) {
                        jComponent.setVisible(false);
                    }
                    JBLabel jBLabel7 = this.imageIcon;
                    if (jBLabel7 != null) {
                        jBLabel7.setVisible(false);
                    }
                    if (value instanceof ChatModelPopupElement.NoModelsMessageElement) {
                        JComponent jComponent2 = this.extraSpace;
                        if (jComponent2 != null) {
                            jComponent2.setVisible(true);
                        }
                    }
                    if (value != null && value instanceof ChatModelPopupElement.AutoModel) {
                        JBLabel jBLabel8 = this.greyText;
                        if (jBLabel8 != null) {
                            jBLabel8.setText(((ChatModelPopupElement.AutoModel)value).getModel().getDisplayName());
                        }
                        JBLabel jBLabel9 = this.greyText;
                        if (jBLabel9 != null) {
                            jBLabel9.setVisible(true);
                        }
                        if (AIAssistantChatModelSelectorKt.isFree(((ChatModelPopupElement.AutoModel)value).getModel())) {
                            JBLabel jBLabel10 = this.freeIcon;
                            if (jBLabel10 != null) {
                                jBLabel10.setVisible(true);
                            }
                        }
                        if (AIAssistantChatModelSelectorKt.isNew(((ChatModelPopupElement.AutoModel)value).getModel())) {
                            JBLabel jBLabel11 = this.newIcon;
                            if (jBLabel11 != null) {
                                jBLabel11.setVisible(true);
                            }
                        }
                        if (AIAssistantChatModelSelectorKt.isBeta(((ChatModelPopupElement.AutoModel)value).getModel())) {
                            JBLabel jBLabel12 = this.betaIcon;
                            if (jBLabel12 != null) {
                                jBLabel12.setVisible(true);
                            }
                        }
                    }
                    if (value == null || !(value instanceof ChatModelPopupElement.Model)) break block31;
                    if (AIAssistantChatModelSelectorKt.isExpensive(((ChatModelPopupElement.Model)value).getModel())) {
                        JBLabel jBLabel13 = this.rubyIcon;
                        if (jBLabel13 != null) {
                            jBLabel13.setVisible(true);
                        }
                    }
                    if (AIAssistantChatModelSelectorKt.isThinking(((ChatModelPopupElement.Model)value).getModel())) {
                        JBLabel jBLabel14 = this.brainIcon;
                        if (jBLabel14 != null) {
                            jBLabel14.setVisible(true);
                        }
                    }
                    if (AIAssistantChatModelSelectorKt.isBeta(((ChatModelPopupElement.Model)value).getModel())) {
                        JBLabel jBLabel15 = this.betaIcon;
                        if (jBLabel15 != null) {
                            jBLabel15.setVisible(true);
                        }
                    }
                    if (AIAssistantChatModelSelectorKt.isNew(((ChatModelPopupElement.Model)value).getModel())) {
                        JBLabel jBLabel16 = this.newIcon;
                        if (jBLabel16 != null) {
                            jBLabel16.setVisible(true);
                        }
                    }
                    if (AIAssistantChatModelSelectorKt.isFree(((ChatModelPopupElement.Model)value).getModel())) {
                        JBLabel jBLabel17 = this.freeIcon;
                        if (jBLabel17 != null) {
                            jBLabel17.setVisible(true);
                        }
                    }
                    if (Registry.Companion.is("llm.chat.context.images.show.icon.in.selector") && AiaLlmProfileIDUtils.INSTANCE.supportsImages(AiaLlmProfileIDUtils.INSTANCE.fromString(((ChatModelPopupElement.Model)value).getModel().getId()))) {
                        JBLabel jBLabel18 = this.imageIcon;
                        if (jBLabel18 != null) {
                            jBLabel18.setVisible(true);
                        }
                    }
                }
            }
        };
    }

    private final void installDetailsTooltip() {
        JList jList = this.getList();
        JList jList2 = jList instanceof JList ? jList : null;
        if (jList2 == null) {
            return;
        }
        JList listComponent = jList2;
        ModelDetailsComponent detailsPopup = new ModelDetailsComponent(listComponent, this.moreSubMenu);
        Disposer.register((Disposable)((Disposable)this), (Disposable)detailsPopup);
    }

    private static final void createPopup$lambda$0$0(ModelSelectorListPopup this$0) {
        this$0.moreSubMenu.set(null);
    }
}

