/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.codeSnippet;

import com.intellij.lang.Language;
import com.intellij.ml.llm.core.chat.messages.MarkdownChatMessage;
import com.intellij.ml.llm.core.chat.snippets.CodeSnippetProviderKt;
import com.intellij.ml.llm.core.chat.ui.chat.AIAEditorSettingsListener;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantDimensions;
import com.intellij.ml.llm.core.chat.ui.chat.CodePartEditorInfo;
import com.intellij.ml.llm.core.chat.ui.chat.CodePartView;
import com.intellij.ml.llm.core.chat.ui.chat.selection.AIMessageSelectUtilsKt;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.CodeSnippetLanguage;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.CodeToolbarWrapper;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.CodeViewerKt;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.EditorFooterComponentWrapper;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.EditorFragment;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.EditorHeaderComponentWrapper;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.ExpandCollapseLabelWrapper;
import com.intellij.ml.llm.core.settings.LLMSettingsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SingleAlarm;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a,\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0003\u001aT\u0010\u001a\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0001\u001a4\u0010\"\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c\u001a \u0010#\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u0005H\u0002\u001a(\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002\u001a\u0010\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u000200H\u0000\u00a8\u00061"}, d2={"createCodeViewerFile", "Lcom/intellij/testFramework/LightVirtualFile;", "codeSnippetLanguage", "Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/CodeSnippetLanguage;", "content", "", "createCodeViewerEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "project", "Lcom/intellij/openapi/project/Project;", "file", "document", "Lcom/intellij/openapi/editor/Document;", "disposable", "Lcom/intellij/openapi/Disposable;", "applyEditorSettings", "", "editorSettings", "Lcom/intellij/openapi/editor/EditorSettings;", "llmSettings", "Lcom/intellij/ml/llm/core/settings/LLMSettingsManager;", "createStrippedCodeViewer", "Lcom/intellij/ml/llm/core/chat/ui/chat/CodePartEditorInfo;", "code", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "language", "createCodeViewerWithComponents", "message", "Lcom/intellij/ml/llm/core/chat/messages/MarkdownChatMessage;", "headerComponentWrapper", "Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/EditorHeaderComponentWrapper;", "footerComponentWrapper", "Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/EditorFooterComponentWrapper;", "editor", "createCodeViewer", "updateDocument", "newDocText", "paintTheRoundBorderWithBackground", "g", "Ljava/awt/Graphics;", "panel", "Ljavax/swing/JComponent;", "borderColor", "Ljava/awt/Color;", "frameThickness", "", "scrollToTopWhenNeeded", "scrollPane", "Ljavax/swing/JScrollPane;", "intellij.ml.llm.chat"})
public final class CodeViewerKt {
    @NotNull
    public static final LightVirtualFile createCodeViewerFile(@NotNull CodeSnippetLanguage codeSnippetLanguage, @NotNull String content2) {
        Intrinsics.checkNotNullParameter((Object)codeSnippetLanguage, (String)"codeSnippetLanguage");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Language intellijLanguage = codeSnippetLanguage.getIntellijLanguage();
        String fileBaseName = "AIAssistantSnippet";
        String fileExtension = codeSnippetLanguage.getFileExtension();
        String fileName = fileBaseName + "." + fileExtension;
        LightVirtualFile file = new LightVirtualFile(fileName, intellijLanguage, (CharSequence)content2);
        if (Intrinsics.areEqual((Object)file.getFileType(), (Object)UnknownFileType.INSTANCE)) {
            file.setFileType((FileType)PlainTextFileType.INSTANCE);
        }
        return file;
    }

    @NotNull
    public static final EditorEx createCodeViewerEditor(@NotNull Project project, @NotNull LightVirtualFile file, @NotNull Document document, @NotNull Disposable disposable) {
        EditorSettings editorSettings;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Editor editor = CodeSnippetProviderKt.createEditorForChatCodeSnippet(project, document, language, disposable);
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editor2 = (EditorEx)editor;
        editor2.setFile((VirtualFile)file);
        EditorHighlighter highlighter = EditorHighlighterFactory.Companion.getInstance().createEditorHighlighter(project, (VirtualFile)file);
        editor2.setHighlighter(highlighter);
        MarkupModelEx markupModelEx = editor2.getMarkupModel();
        Intrinsics.checkNotNull((Object)markupModelEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorMarkupModel");
        ((EditorMarkupModel)markupModelEx).setErrorStripeVisible(false);
        editor2.installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler(){

            public ActionGroup getActionGroup(EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return ActionUtil.getActionGroup((String)AIMessageSelectUtilsKt.messagePartPopupGroupId());
            }
        });
        int additionalLines = Registry.Companion.intValue("llm.ai.assistant.code.view.extraLines");
        LLMSettingsManager settings = LLMSettingsManager.Companion.getInstance();
        EditorSettings $this$createCodeViewerEditor_u24lambda_u240 = editorSettings = editor2.getSettings();
        boolean bl = false;
        $this$createCodeViewerEditor_u24lambda_u240.setDndEnabled(false);
        $this$createCodeViewerEditor_u24lambda_u240.setAdditionalLinesCount(additionalLines);
        $this$createCodeViewerEditor_u24lambda_u240.setLineMarkerAreaShown(false);
        $this$createCodeViewerEditor_u24lambda_u240.setFoldingOutlineShown(false);
        $this$createCodeViewerEditor_u24lambda_u240.setRightMarginShown(false);
        $this$createCodeViewerEditor_u24lambda_u240.setShowIntentionBulb(false);
        $this$createCodeViewerEditor_u24lambda_u240.setPaintSoftWraps(false);
        $this$createCodeViewerEditor_u24lambda_u240.setRefrainFromScrolling(true);
        $this$createCodeViewerEditor_u24lambda_u240.setAdditionalPageAtBottom(false);
        $this$createCodeViewerEditor_u24lambda_u240.setCaretRowShown(false);
        Intrinsics.checkNotNull((Object)$this$createCodeViewerEditor_u24lambda_u240);
        CodeViewerKt.applyEditorSettings($this$createCodeViewerEditor_u24lambda_u240, settings);
        editor2.addFocusListener(new FocusChangeListener(editor2){
            final /* synthetic */ EditorEx $editor;
            {
                this.$editor = $editor;
            }

            public void focusGained(Editor focusEditor) {
                Intrinsics.checkNotNullParameter((Object)focusEditor, (String)"focusEditor");
                this.$editor.getSettings().setCaretRowShown(true);
            }

            public void focusLost(Editor focusEditor) {
                Intrinsics.checkNotNullParameter((Object)focusEditor, (String)"focusEditor");
                this.$editor.getSettings().setCaretRowShown(false);
            }
        });
        MessageBus messageBus = project.getMessageBus();
        EditorImpl editorImpl = editor2 instanceof EditorImpl ? (EditorImpl)editor2 : null;
        if (editorImpl == null || (editorImpl = editorImpl.getDisposable()) == null) {
            editorImpl = disposable;
        }
        MessageBusConnection connection = messageBus.connect((Disposable)editorImpl);
        connection.subscribe(AIAEditorSettingsListener.Companion.getTOPIC(), () -> CodeViewerKt.createCodeViewerEditor$lambda$1(editor2, settings));
        return editor2;
    }

    private static final void applyEditorSettings(EditorSettings editorSettings, LLMSettingsManager llmSettings) {
        editorSettings.setUseSoftWraps(llmSettings.useSoftWrapsInChat());
        editorSettings.setLineNumbersShown(llmSettings.useLineNumbersInChat());
        editorSettings.setIndentGuidesShown(llmSettings.useIndentGuidesInChat());
    }

    @NotNull
    public static final CodePartEditorInfo createStrippedCodeViewer(@NotNull Project project, @NotNull GraphProperty<String> code, @NotNull Disposable disposable, @NotNull CodeSnippetLanguage language) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        String content2 = (String)code.get();
        LightVirtualFile file = CodeViewerKt.createCodeViewerFile(language, content2);
        Document document = VirtualFileUtil.findDocument((VirtualFile)((VirtualFile)file));
        if (document == null) {
            throw new IllegalStateException("Can't create inmemory document".toString());
        }
        Document document2 = document;
        EditorEx editor = CodeViewerKt.createCodeViewerEditor(project, file, document2, disposable);
        code.afterChange(arg_0 -> CodeViewerKt.createStrippedCodeViewer$lambda$0(project, document2, arg_0));
        JComponent jComponent = editor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent component = UiDataProvider.Companion.wrapComponent(jComponent, arg_0 -> CodeViewerKt.createStrippedCodeViewer$lambda$1(editor, arg_0));
        return new CodePartEditorInfo(code, component, editor, file, (ObservableMutableProperty<String>)((ObservableMutableProperty)new AtomicProperty((Object)language.getDisplayName())));
    }

    @NotNull
    public static final CodePartEditorInfo createCodeViewerWithComponents(@NotNull Project project, @NotNull GraphProperty<String> code, @NotNull Disposable disposable, @NotNull CodeSnippetLanguage codeSnippetLanguage, @NotNull MarkdownChatMessage message, @NotNull EditorHeaderComponentWrapper headerComponentWrapper, @NotNull EditorFooterComponentWrapper footerComponentWrapper, @NotNull EditorEx editor, @NotNull LightVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)codeSnippetLanguage, (String)"codeSnippetLanguage");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)headerComponentWrapper, (String)"headerComponentWrapper");
        Intrinsics.checkNotNullParameter((Object)footerComponentWrapper, (String)"footerComponentWrapper");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Document document = (Document)ReadAction.compute(() -> CodeViewerKt.createCodeViewerWithComponents$lambda$0(file));
        EditorFragment editorFragment = new EditorFragment(project, editor, message, disposable, headerComponentWrapper, footerComponentWrapper);
        editor.putUserData(CodePartView.Companion.getEditorFragmentKey$intellij_ml_llm_chat(), (Object)editorFragment);
        SingleAlarm.Companion companion = SingleAlarm.Companion;
        Runnable runnable = () -> CodeViewerKt.createCodeViewerWithComponents$lambda$1(footerComponentWrapper);
        SingleAlarm updateAlarm = companion.singleEdtAlarm(500, disposable, runnable);
        code.afterChange(arg_0 -> CodeViewerKt.createCodeViewerWithComponents$lambda$2(project, document, updateAlarm, arg_0));
        JComponent component = UiDataProvider.Companion.wrapComponent(editorFragment.getComponent(), arg_0 -> CodeViewerKt.createCodeViewerWithComponents$lambda$3(editor, headerComponentWrapper, footerComponentWrapper, arg_0));
        AtomicProperty languageDisplayProperty = new AtomicProperty((Object)codeSnippetLanguage.getDisplayName());
        return new CodePartEditorInfo(code, component, editor, file, (ObservableMutableProperty<String>)((ObservableMutableProperty)languageDisplayProperty));
    }

    @NotNull
    public static final CodePartEditorInfo createCodeViewer(@NotNull Project project, @NotNull GraphProperty<String> code, @NotNull Disposable disposable, @NotNull CodeSnippetLanguage codeSnippetLanguage, @NotNull MarkdownChatMessage message) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)codeSnippetLanguage, (String)"codeSnippetLanguage");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String content2 = (String)code.get();
        LightVirtualFile file = CodeViewerKt.createCodeViewerFile(codeSnippetLanguage, content2);
        Document document = (Document)ReadAction.compute(() -> CodeViewerKt.createCodeViewer$lambda$0(file));
        Intrinsics.checkNotNull((Object)document);
        EditorEx editor = CodeViewerKt.createCodeViewerEditor(project, file, document, disposable);
        AtomicProperty languageDisplayProperty = new AtomicProperty((Object)codeSnippetLanguage.getDisplayName());
        CodeToolbarWrapper headerComponentWrapper = new CodeToolbarWrapper((AtomicProperty<String>)languageDisplayProperty, editor);
        ExpandCollapseLabelWrapper footerComponentWrapper = new ExpandCollapseLabelWrapper(project, editor, message, 0, null, 24, null);
        return CodeViewerKt.createCodeViewerWithComponents(project, code, disposable, codeSnippetLanguage, message, headerComponentWrapper, footerComponentWrapper, editor, file);
    }

    private static final void updateDocument(Project project, Document document, String newDocText) {
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String oldDocText = string;
        if (StringsKt.startsWith$default((String)newDocText, (String)oldDocText, (boolean)false, (int)2, null)) {
            String newPart = StringsKt.substringAfter$default((String)newDocText, (String)oldDocText, null, (int)2, null);
            ApplicationKt.getApplication().runWriteAction(() -> CodeViewerKt.updateDocument$lambda$0(project, document, newPart));
        } else {
            ApplicationKt.getApplication().runWriteAction(() -> CodeViewerKt.updateDocument$lambda$1(document, newDocText));
        }
    }

    private static final void paintTheRoundBorderWithBackground(Graphics g, JComponent panel2, Color borderColor, int frameThickness) {
        Graphics2D graphics2D = g instanceof Graphics2D ? (Graphics2D)g : null;
        if (graphics2D == null) {
            return;
        }
        Graphics2D g2d = graphics2D;
        Insets ins = panel2.getInsets();
        Rectangle2D.Double clientArea = new Rectangle2D.Double(ins.left, ins.top, panel2.getWidth() - ins.left - ins.right, panel2.getHeight() - ins.top - ins.bottom);
        double arcDiameter = JBUI.scale((int)(AIAssistantDimensions.INSTANCE.borderRadius() * 2));
        Area fillArea = new Area(clientArea);
        fillArea.subtract(new Area(new RoundRectangle2D.Double(clientArea.x, clientArea.y, clientArea.width, clientArea.height, arcDiameter, arcDiameter)));
        g2d.setColor(UIUtil.getBgFillColor((Component)panel2));
        g2d.fill(fillArea);
        g2d.setColor(borderColor);
        RectanglePainter2D.DRAW.paint(g2d, clientArea.x, clientArea.y, clientArea.width, clientArea.height, Double.valueOf(arcDiameter), LinePainter2D.StrokeType.CENTERED, (double)JBUI.scale((int)frameThickness), RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public static final void scrollToTopWhenNeeded(@NotNull JScrollPane scrollPane) {
        Intrinsics.checkNotNullParameter((Object)scrollPane, (String)"scrollPane");
        int initScrollPos = scrollPane.getVerticalScrollBar().getValue();
        if (initScrollPos != 0) {
            scrollPane.getVerticalScrollBar().setValue(0);
            return;
        }
        scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(initScrollPos, scrollPane){
            final /* synthetic */ int $initScrollPos;
            final /* synthetic */ JScrollPane $scrollPane;
            {
                this.$initScrollPos = $initScrollPos;
                this.$scrollPane = $scrollPane;
            }

            public void adjustmentValueChanged(AdjustmentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                scrollToTopWhenNeeded.1 l = this;
                if (this.$initScrollPos != e.getValue()) {
                    JScrollBar jScrollBar;
                    JScrollBar $this$adjustmentValueChanged_u24lambda_u240 = jScrollBar = this.$scrollPane.getVerticalScrollBar();
                    boolean bl = false;
                    $this$adjustmentValueChanged_u24lambda_u240.setValue(0);
                    $this$adjustmentValueChanged_u24lambda_u240.removeAdjustmentListener(l);
                }
            }
        });
    }

    private static final void createCodeViewerEditor$lambda$1(EditorEx $editor, LLMSettingsManager $settings) {
        EditorSettings editorSettings = $editor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"getSettings(...)");
        CodeViewerKt.applyEditorSettings(editorSettings, $settings);
    }

    private static final Unit createStrippedCodeViewer$lambda$0(Project $project, Document $document, String newDocText) {
        Intrinsics.checkNotNullParameter((Object)newDocText, (String)"newDocText");
        CodeViewerKt.updateDocument($project, $document, newDocText);
        return Unit.INSTANCE;
    }

    private static final void createStrippedCodeViewer$lambda$1(EditorEx $editor, DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = OpenFileDescriptor.NAVIGATE_IN_EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"NAVIGATE_IN_EDITOR");
        sink.set(dataKey, (Object)$editor);
    }

    private static final Document createCodeViewerWithComponents$lambda$0(LightVirtualFile $file) {
        Document document = VirtualFileUtil.findDocument((VirtualFile)((VirtualFile)$file));
        if (document == null) {
            throw new IllegalStateException("Can't create inmemory document".toString());
        }
        return document;
    }

    private static final void createCodeViewerWithComponents$lambda$1(EditorFooterComponentWrapper $footerComponentWrapper) {
        block0: {
            ExpandCollapseLabelWrapper expandCollapseLabelWrapper = $footerComponentWrapper instanceof ExpandCollapseLabelWrapper ? (ExpandCollapseLabelWrapper)$footerComponentWrapper : null;
            if (expandCollapseLabelWrapper == null) break block0;
            expandCollapseLabelWrapper.updateExpandCollapseLabel();
        }
    }

    private static final Unit createCodeViewerWithComponents$lambda$2(Project $project, Document $document, SingleAlarm $updateAlarm, String newDocText) {
        Intrinsics.checkNotNullParameter((Object)newDocText, (String)"newDocText");
        Intrinsics.checkNotNull((Object)$document);
        CodeViewerKt.updateDocument($project, $document, newDocText);
        SingleAlarm.cancelAndRequest$default((SingleAlarm)$updateAlarm, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void createCodeViewerWithComponents$lambda$3(EditorEx $editor, EditorHeaderComponentWrapper $headerComponentWrapper, EditorFooterComponentWrapper $footerComponentWrapper, DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = OpenFileDescriptor.NAVIGATE_IN_EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"NAVIGATE_IN_EDITOR");
        sink.set(dataKey, (Object)$editor);
        $headerComponentWrapper.provideData(sink);
        $footerComponentWrapper.provideData(sink);
    }

    private static final Document createCodeViewer$lambda$0(LightVirtualFile $file) {
        Document document = VirtualFileUtil.findDocument((VirtualFile)((VirtualFile)$file));
        if (document == null) {
            throw new IllegalStateException("Can't create inmemory document".toString());
        }
        return document;
    }

    private static final void updateDocument$lambda$0(Project $project, Document $document, String $newPart) {
        WriteCommandAction.writeCommandAction((Project)$project).run(() -> CodeViewerKt.updateDocument$lambda$0$0($document, $newPart));
    }

    private static final void updateDocument$lambda$0$0(Document $document, String $newPart) {
        $document.insertString($document.getTextLength(), (CharSequence)$newPart);
    }

    private static final void updateDocument$lambda$1(Document $document, String $newDocText) {
        $document.setText((CharSequence)$newDocText);
    }

    public static final /* synthetic */ void access$paintTheRoundBorderWithBackground(Graphics g, JComponent panel2, Color borderColor, int frameThickness) {
        CodeViewerKt.paintTheRoundBorderWithBackground(g, panel2, borderColor, frameThickness);
    }
}

