/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.codeSnippet;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ml.llm.core.chat.messages.MarkdownChatMessage;
import com.intellij.ml.llm.core.chat.ui.AIAssistantColors;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.CodeViewerKt;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.EditorFooterComponentWrapper;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.hover.HoverStateListener;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001e\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0006\u0010!\u001a\u00020\rJ\u0010\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006&"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/ExpandCollapseLabelWrapper;", "Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/EditorFooterComponentWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "message", "Lcom/intellij/ml/llm/core/chat/messages/MarkdownChatMessage;", "editorLineThreshold", "", "onCollapsedStateChanged", "Lkotlin/Function1;", "", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/ml/llm/core/chat/messages/MarkdownChatMessage;ILkotlin/jvm/functions/Function1;)V", "value", "collapsed", "getCollapsed", "()Z", "setCollapsed", "(Z)V", "expandCollapseTextLabel", "Lcom/intellij/ui/components/JBLabel;", "contentRepaint", "Lkotlin/Function0;", "getContentRepaint$intellij_ml_llm_chat", "()Lkotlin/jvm/functions/Function0;", "setContentRepaint$intellij_ml_llm_chat", "(Lkotlin/jvm/functions/Function0;)V", "createExpandCollapseTextLabel", "getComponent", "Ljavax/swing/JComponent;", "updateExpandCollapseLabel", "updateBackgroundColor", "editorBackgroundColor", "Ljava/awt/Color;", "createStickyVersion", "intellij.ml.llm.chat"})
public final class ExpandCollapseLabelWrapper
implements EditorFooterComponentWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final MarkdownChatMessage message;
    private final int editorLineThreshold;
    @Nullable
    private Function1<? super Boolean, Unit> onCollapsedStateChanged;
    private boolean collapsed;
    @NotNull
    private final JBLabel expandCollapseTextLabel;
    @Nullable
    private Function0<Unit> contentRepaint;

    public ExpandCollapseLabelWrapper(@NotNull Project project, @NotNull EditorEx editor, @NotNull MarkdownChatMessage message, int editorLineThreshold, @Nullable Function1<? super Boolean, Unit> onCollapsedStateChanged) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.project = project;
        this.editor = editor;
        this.message = message;
        this.editorLineThreshold = editorLineThreshold;
        this.onCollapsedStateChanged = onCollapsedStateChanged;
        this.collapsed = this.message.getAuthor() == ChatMessageAuthor.User;
        this.expandCollapseTextLabel = this.createExpandCollapseTextLabel();
    }

    public /* synthetic */ ExpandCollapseLabelWrapper(Project project, EditorEx editorEx, MarkdownChatMessage markdownChatMessage, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 6;
        }
        if ((n2 & 0x10) != 0) {
            function1 = null;
        }
        this(project, editorEx, markdownChatMessage, n, (Function1<? super Boolean, Unit>)function1);
    }

    public final boolean getCollapsed() {
        return this.collapsed;
    }

    public final void setCollapsed(boolean value) {
        block1: {
            if (this.collapsed == value) {
                return;
            }
            this.collapsed = value;
            this.updateExpandCollapseLabel();
            Function1<? super Boolean, Unit> function1 = this.onCollapsedStateChanged;
            if (function1 == null) break block1;
            function1.invoke((Object)value);
        }
    }

    @Nullable
    public final Function0<Unit> getContentRepaint$intellij_ml_llm_chat() {
        return this.contentRepaint;
    }

    public final void setContentRepaint$intellij_ml_llm_chat(@Nullable Function0<Unit> function0) {
        this.contentRepaint = function0;
    }

    private final JBLabel createExpandCollapseTextLabel() {
        JBLabel jBLabel;
        JBLabel $this$createExpandCollapseTextLabel_u24lambda_u240 = jBLabel = new JBLabel("", 0);
        boolean bl = false;
        $this$createExpandCollapseTextLabel_u24lambda_u240.setForeground(AIAssistantColors.INSTANCE.getSnippetMoreLinesForeground(this.message.getAuthor(), false));
        $this$createExpandCollapseTextLabel_u24lambda_u240.setFont((Font)JBFont.medium());
        $this$createExpandCollapseTextLabel_u24lambda_u240.setOpaque(true);
        $this$createExpandCollapseTextLabel_u24lambda_u240.setVisible(false);
        $this$createExpandCollapseTextLabel_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        $this$createExpandCollapseTextLabel_u24lambda_u240.setComponentOrientation(Intrinsics.areEqual((Object)$this$createExpandCollapseTextLabel_u24lambda_u240.getComponentOrientation(), (Object)ComponentOrientation.RIGHT_TO_LEFT) ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT);
        HoverStateListener hoverListener2 = new HoverStateListener($this$createExpandCollapseTextLabel_u24lambda_u240, this){
            final /* synthetic */ JBLabel $this_apply;
            final /* synthetic */ ExpandCollapseLabelWrapper this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
            }

            protected void hoverChanged(Component component, boolean hovered) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                    this.$this_apply.setForeground(AIAssistantColors.INSTANCE.getSnippetMoreLinesForeground(ExpandCollapseLabelWrapper.access$getMessage$p(this.this$0).getAuthor(), hovered));
                    this.$this_apply.setBackground(!hovered ? ExpandCollapseLabelWrapper.access$getEditor$p(this.this$0).getBackgroundColor() : AIAssistantColors.INSTANCE.getSnippetMoreLinesBackground(ExpandCollapseLabelWrapper.access$getMessage$p(this.this$0).getAuthor(), hovered));
                    Function0<Unit> function0 = this.this$0.getContentRepaint$intellij_ml_llm_chat();
                    if (function0 == null) break block0;
                    function0.invoke();
                }
            }
        };
        hoverListener2.addTo((JComponent)$this$createExpandCollapseTextLabel_u24lambda_u240);
        $this$createExpandCollapseTextLabel_u24lambda_u240.addMouseListener((MouseListener)new MouseAdapter(this){
            final /* synthetic */ ExpandCollapseLabelWrapper this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                block0: {
                    this.this$0.setCollapsed(!this.this$0.getCollapsed());
                    AIAssistantChatEventLogger.logCodeSnippetPresentationChanged(ExpandCollapseLabelWrapper.access$getProject$p(this.this$0), ExpandCollapseLabelWrapper.access$getMessage$p(this.this$0).getChat(), ExpandCollapseLabelWrapper.access$getMessage$p(this.this$0), ExpandCollapseLabelWrapper.access$getEditor$p(this.this$0).getDocument().getLineCount(), this.this$0.getCollapsed());
                    Function0<Unit> function0 = this.this$0.getContentRepaint$intellij_ml_llm_chat();
                    if (function0 == null) break block0;
                    function0.invoke();
                }
            }
        });
        return jBLabel;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.expandCollapseTextLabel;
    }

    public final void updateExpandCollapseLabel() {
        block3: {
            int linesCount = this.editor.getDocument().getLineCount();
            if (this.collapsed) {
                JScrollPane jScrollPane = this.editor.getScrollPane();
                Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"getScrollPane(...)");
                CodeViewerKt.scrollToTopWhenNeeded(jScrollPane);
            }
            this.expandCollapseTextLabel.setVisible(linesCount > this.editorLineThreshold);
            if (this.collapsed) {
                Object[] objectArray = new Object[]{linesCount - this.editorLineThreshold};
                this.expandCollapseTextLabel.setText(LLMBundle.message((String)"label.more.lines.unfold", (Object[])objectArray));
                this.expandCollapseTextLabel.setIcon(AllIcons.General.ChevronDown);
            } else {
                this.expandCollapseTextLabel.setText(LLMBundle.message((String)"label.more.lines.fold", (Object[])new Object[0]));
                this.expandCollapseTextLabel.setIcon(AllIcons.General.ChevronUp);
            }
            Function0<Unit> function0 = this.contentRepaint;
            if (function0 == null) break block3;
            function0.invoke();
        }
    }

    @Override
    public void updateBackgroundColor(@NotNull Color editorBackgroundColor) {
        Intrinsics.checkNotNullParameter((Object)editorBackgroundColor, (String)"editorBackgroundColor");
        this.expandCollapseTextLabel.setBackground(editorBackgroundColor);
    }

    @Override
    @NotNull
    public EditorFooterComponentWrapper createStickyVersion() {
        ExpandCollapseLabelWrapper expandCollapseLabelWrapper;
        ExpandCollapseLabelWrapper it = expandCollapseLabelWrapper = new ExpandCollapseLabelWrapper(this.project, this.editor, this.message, this.editorLineThreshold, (Function1<? super Boolean, Unit>)((Function1)arg_0 -> ExpandCollapseLabelWrapper.createStickyVersion$lambda$0(this, arg_0)));
        boolean bl = false;
        this.onCollapsedStateChanged = arg_0 -> ExpandCollapseLabelWrapper.createStickyVersion$lambda$1$0(it, arg_0);
        return expandCollapseLabelWrapper;
    }

    private static final Unit createStickyVersion$lambda$0(ExpandCollapseLabelWrapper this$0, boolean newState) {
        this$0.setCollapsed(newState);
        return Unit.INSTANCE;
    }

    private static final Unit createStickyVersion$lambda$1$0(ExpandCollapseLabelWrapper $it, boolean newState) {
        $it.setCollapsed(newState);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MarkdownChatMessage access$getMessage$p(ExpandCollapseLabelWrapper $this) {
        return $this.message;
    }

    public static final /* synthetic */ EditorEx access$getEditor$p(ExpandCollapseLabelWrapper $this) {
        return $this.editor;
    }

    public static final /* synthetic */ Project access$getProject$p(ExpandCollapseLabelWrapper $this) {
        return $this.project;
    }
}

