/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.list;

import com.intellij.ide.DataManager;
import com.intellij.llmInstaller.ui.AIAssistantBasePanel;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.AIAContainerPanelFacade;
import com.intellij.ml.llm.core.AIAContentFacade;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.ChatSessionHost;
import com.intellij.ml.llm.core.chat.session.ChatSessionHostListener;
import com.intellij.ml.llm.core.chat.session.FocusedChatSessionHost;
import com.intellij.ml.llm.core.chat.ui.AIAssistantChatUtil;
import com.intellij.ml.llm.core.chat.ui.list.AIAssistantChatListPanelVm;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.dsl.listCellRenderer.LcrInitParams;
import com.intellij.ui.dsl.listCellRenderer.LcrRow;
import com.intellij.ui.dsl.listCellRenderer.LcrTextInitParams;
import com.intellij.ui.dsl.listCellRenderer.LcrTextSpeedSearchParams;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ\u0006\u0010\u0014\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0002J\b\u0010\u001a\u001a\u00020\u0012H\u0002J\b\u0010\u001b\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/list/AIAssistantChatListPanel;", "Lcom/intellij/llmInstaller/ui/AIAssistantBasePanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "vm", "Lcom/intellij/ml/llm/core/chat/ui/list/AIAssistantChatListPanelVm;", "<init>", "(Lcom/intellij/ml/llm/core/chat/ui/list/AIAssistantChatListPanelVm;)V", "list", "Lcom/intellij/ui/components/JBList;", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "kotlin.jvm.PlatformType", "listCellRenderer", "Ljavax/swing/ListCellRenderer;", "getModelCasted", "Ljavax/swing/DefaultListModel;", "getDefaultComponent", "Ljavax/swing/JComponent;", "removeChat", "", "chat", "updateModel", "createModel", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "openSelectedChat", "deleteSelectedChats", "dispose", "Companion", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAssistantChatListPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantChatListPanel.kt\ncom/intellij/ml/llm/core/chat/ui/list/AIAssistantChatListPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,218:1\n1068#2:219\n30#3,2:220\n*S KotlinDebug\n*F\n+ 1 AIAssistantChatListPanel.kt\ncom/intellij/ml/llm/core/chat/ui/list/AIAssistantChatListPanel\n*L\n158#1:219\n192#1:220,2\n*E\n"})
public final class AIAssistantChatListPanel
extends AIAssistantBasePanel
implements UiDataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AIAssistantChatListPanelVm vm;
    @NotNull
    private final JBList<ChatSession> list;
    @NotNull
    private final ListCellRenderer<ChatSession> listCellRenderer;
    @NotNull
    private static final DataKey<AIAssistantChatListPanel> ChatList = DataKey.Companion.create("ChatList");

    public AIAssistantChatListPanel(@NotNull AIAssistantChatListPanelVm vm) {
        JBList<ChatSession> jBList;
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        super(vm.getProject());
        this.vm = vm;
        this.list = new JBList((ListModel)this.createModel());
        this.listCellRenderer = BuilderKt.listCellRenderer(AIAssistantChatListPanel::listCellRenderer$lambda$0);
        AIAssistantChatUtil.INSTANCE.applyShortcuts((JComponent)((Object)this));
        JBList<ChatSession> $this$_init__u24lambda_u240 = jBList = this.list.getEmptyText();
        boolean bl = false;
        $this$_init__u24lambda_u240.clear();
        $this$_init__u24lambda_u240.appendLine(LLMBundle.message((String)"status.text.there.are.no.chats.yet", (Object[])new Object[0]));
        $this$_init__u24lambda_u240.appendLine(LLMBundle.message((String)"status.text.create.new.chat", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> AIAssistantChatListPanel.lambda$0$0(this, arg_0));
        JBList<ChatSession> $this$_init__u24lambda_u241 = jBList = this.list;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setCellRenderer(this.listCellRenderer);
        $this$_init__u24lambda_u241.addMouseListener((MouseListener)new PopupHandler(this){
            final /* synthetic */ AIAssistantChatListPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void invokePopup(Component comp, int x, int y) {
                Rectangle bounds;
                if (comp == null) {
                    return;
                }
                Point point = new Point(x, y);
                int index = AIAssistantChatListPanel.access$getList$p(this.this$0).locationToIndex(point);
                if (index >= 0 && index < AIAssistantChatListPanel.access$getList$p(this.this$0).getModel().getSize() && (bounds = AIAssistantChatListPanel.access$getList$p(this.this$0).getCellBounds(index, index)) != null && bounds.contains(point)) {
                    if (AIAssistantChatListPanel.access$getList$p(this.this$0).getSelectedValuesList().isEmpty()) {
                        AIAssistantChatListPanel.access$getList$p(this.this$0).setSelectedIndex(index);
                    }
                    ActionGroup actionGroup = ActionUtil.getActionGroup((String)"AIAssistant.ToolWindow.List.ContextActions");
                    if (actionGroup == null) {
                        return;
                    }
                    ActionGroup group = actionGroup;
                    DataContext dataContext = DataManager.getInstance().getDataContext(comp, x, y);
                    Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                    DataContext dataContext2 = dataContext;
                    ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, group, dataContext2, false, null, 10);
                    Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
                    ListPopup popup2 = listPopup;
                    popup2.show(new RelativePoint(comp, point));
                }
            }
        });
        $this$_init__u24lambda_u241.addMouseListener((MouseListener)new MouseAdapter(this){
            final /* synthetic */ AIAssistantChatListPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    AIAssistantChatListPanel.access$openSelectedChat(this.this$0);
                }
            }
        });
        $this$_init__u24lambda_u241.addKeyListener((KeyListener)new KeyAdapter(this){
            final /* synthetic */ AIAssistantChatListPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                switch (e.getKeyCode()) {
                    case 10: {
                        AIAssistantChatListPanel.access$openSelectedChat(this.this$0);
                        break;
                    }
                    case 127: {
                        AIAssistantChatListPanel.access$deleteSelectedChats(this.this$0);
                    }
                }
            }
        });
        JBScrollPane scrollPane = new JBScrollPane((Component)this.list, 20, 31);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        scrollPane.setOverlappingScrollBar(true);
        this.add((Component)scrollPane, "Center");
        TreeUIHelper.getInstance().installListSpeedSearch((JList)this.list, arg_0 -> AIAssistantChatListPanel._init_$lambda$3(AIAssistantChatListPanel::_init_$lambda$2, arg_0));
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable chatListenerDisposable = disposable;
        this.getProject().getMessageBus().connect(chatListenerDisposable).subscribe(ChatSessionHostListener.UPDATE_TOPIC, (Object)new ChatSessionHostListener(){

            @Override
            public void chatRenamed(ChatSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                this.repaint();
            }
        });
        DisposerUtilKt.whenDisposed((Disposable)((Disposable)this), () -> AIAssistantChatListPanel._init_$lambda$4(chatListenerDisposable));
    }

    private final DefaultListModel<ChatSession> getModelCasted() {
        ListModel listModel = this.list.getModel();
        Intrinsics.checkNotNull((Object)listModel, (String)"null cannot be cast to non-null type javax.swing.DefaultListModel<com.intellij.ml.llm.core.chat.session.ChatSession>");
        return (DefaultListModel)listModel;
    }

    @NotNull
    public JComponent getDefaultComponent() {
        return (JComponent)((Object)this);
    }

    public final void removeChat(@NotNull ChatSession chat) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        int index = this.getModelCasted().indexOf(chat);
        if (index >= 0) {
            this.getModelCasted().remove(index);
        }
    }

    public final void updateModel() {
        this.list.setModel((ListModel)this.createModel());
    }

    private final DefaultListModel<ChatSession> createModel() {
        Iterable $this$sortedByDescending$iv = ChatSessionHost.Companion.getInstance(this.getProject()).getAllChats();
        boolean $i$f$sortedByDescending = false;
        List sortedChats = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ChatSession it = (ChatSession)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTimestamp());
                it = (ChatSession)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
            }
        });
        DefaultListModel defaultListModel = JBList.createDefaultListModel((Iterable)sortedChats);
        Intrinsics.checkNotNullExpressionValue((Object)defaultListModel, (String)"createDefaultListModel(...)");
        return defaultListModel;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(ChatList, (Object)this);
    }

    private final void openSelectedChat() {
        block0: {
            ChatSession chatSession2 = (ChatSession)this.list.getSelectedValue();
            if (chatSession2 == null) break block0;
            ChatSession selectedItem = chatSession2;
            boolean bl = false;
            BuildersKt.launch$default((CoroutineScope)selectedItem.getRetrievalSession().getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, selectedItem, null){
                int label;
                final /* synthetic */ AIAssistantChatListPanel this$0;
                final /* synthetic */ ChatSession $selectedItem;
                {
                    this.this$0 = $receiver;
                    this.$selectedItem = $selectedItem;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = AIAssistantChatEventLogger.logChatOpened(AIAssistantChatListPanel.access$getProject(this.this$0), this.$selectedItem, (Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            FocusedChatSessionHost.Companion.getInstance(this.getProject()).focusChatSession(selectedItem);
        }
    }

    private final void deleteSelectedChats() {
        List selectedChats = this.list.getSelectedValuesList();
        switch (selectedChats.size()) {
            case 0: {
                return;
            }
            case 1: {
                if (MessageDialogBuilder.Companion.yesNo(LLMBundle.message((String)"dialog.title.delete.chat", (Object[])new Object[0]), LLMBundle.message((String)"dialog.message.do.you.want.to.delete.current.chat", (Object[])new Object[0])).ask(this.getProject())) break;
                return;
            }
            default: {
                Object[] objectArray = new Object[]{selectedChats.size()};
                if (MessageDialogBuilder.Companion.yesNo(LLMBundle.message((String)"dialog.title.delete.chats", (Object[])new Object[0]), LLMBundle.message((String)"dialog.message.do.you.want.to.delete.selected.chats", (Object[])objectArray)).ask(this.getProject())) break;
                return;
            }
        }
        for (ChatSession chat : selectedChats) {
            ComponentManager $this$service$iv = (ComponentManager)this.getProject();
            boolean $i$f$service = false;
            Class<ChatSessionHost> serviceClass$iv = ChatSessionHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ChatSessionHost chatSessionHost = (ChatSessionHost)object;
            Intrinsics.checkNotNull((Object)chat);
            chatSessionHost.removeChatSession(chat);
        }
        this.updateModel();
    }

    public void dispose() {
    }

    private static final Unit listCellRenderer$lambda$0(LcrRow $this$listCellRenderer) {
        Intrinsics.checkNotNullParameter((Object)$this$listCellRenderer, (String)"$this$listCellRenderer");
        $this$listCellRenderer.text(((ChatSession)$this$listCellRenderer.getValue()).getTitle().getText(), AIAssistantChatListPanel::listCellRenderer$lambda$0$0);
        String string = DateFormatUtil.formatPrettyDateTime((long)((ChatSession)$this$listCellRenderer.getValue()).getTimestamp());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatPrettyDateTime(...)");
        $this$listCellRenderer.text(string, AIAssistantChatListPanel::listCellRenderer$lambda$0$1);
        return Unit.INSTANCE;
    }

    private static final Unit listCellRenderer$lambda$0$0(LcrTextInitParams $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        $this$text.setAlign(LcrInitParams.Align.LEFT);
        $this$text.speedSearch(AIAssistantChatListPanel::listCellRenderer$lambda$0$0$0);
        return Unit.INSTANCE;
    }

    private static final Unit listCellRenderer$lambda$0$0$0(LcrTextSpeedSearchParams $this$speedSearch) {
        Intrinsics.checkNotNullParameter((Object)$this$speedSearch, (String)"$this$speedSearch");
        return Unit.INSTANCE;
    }

    private static final Unit listCellRenderer$lambda$0$1(LcrTextInitParams $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        $this$text.setForeground($this$text.getGreyForeground());
        return Unit.INSTANCE;
    }

    private static final void lambda$0$0(AIAssistantChatListPanel this$0, ActionEvent it) {
        DataContext dataContext = ActionToolbar.getDataContextFor((Component)((Component)((Object)this$0)));
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContextFor(...)");
        DataContext dataContext2 = dataContext;
        BuildersKt.launch$default((CoroutineScope)this$0.getPanelScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, dataContext2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AIAssistantChatListPanel this$0;
            final /* synthetic */ DataContext $dataContext;
            {
                this.this$0 = $receiver;
                this.$dataContext = $dataContext;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        AIAContainerPanelFacade aIAContainerPanelFacade = AIAContentFacade.Companion.getInstance(AIAssistantChatListPanel.access$getProject(this.this$0)).getPanel(this.$dataContext);
                        if (aIAContainerPanelFacade == null) {
                            void $this$launch;
                            void $this$invokeSuspend_u24lambda_u240 = $this$launch;
                            boolean bl = false;
                            void $this$thisLogger$iv = $this$invokeSuspend_u24lambda_u240;
                            boolean $i$f$thisLogger = false;
                            Logger logger = Logger.getInstance(CoroutineScope.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                            logger.warn("Container panel was not found when creating chat from empty state");
                            return Unit.INSTANCE;
                        }
                        AIAContainerPanelFacade containerPanel = aIAContainerPanelFacade;
                        containerPanel.openNewChat();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final String _init_$lambda$2(ChatSession chatSession2) {
        return chatSession2.getTitle().getText();
    }

    private static final String _init_$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit _init_$lambda$4(Disposable $chatListenerDisposable) {
        Disposer.dispose((Disposable)$chatListenerDisposable);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getProject(AIAssistantChatListPanel $this) {
        return $this.getProject();
    }

    public static final /* synthetic */ JBList access$getList$p(AIAssistantChatListPanel $this) {
        return $this.list;
    }

    public static final /* synthetic */ void access$openSelectedChat(AIAssistantChatListPanel $this) {
        $this.openSelectedChat();
    }

    public static final /* synthetic */ void access$deleteSelectedChats(AIAssistantChatListPanel $this) {
        $this.deleteSelectedChats();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/list/AIAssistantChatListPanel$Companion;", "", "<init>", "()V", "ChatList", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/ml/llm/core/chat/ui/list/AIAssistantChatListPanel;", "getChatList", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<AIAssistantChatListPanel> getChatList() {
            return ChatList;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

