/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.intentions.editor;

import com.intellij.ml.llm.core.AIFirstUseKt;
import com.intellij.ml.llm.core.LLMDocumentationSupport;
import com.intellij.ml.llm.core.LLMDocumentationSupportBean;
import com.intellij.ml.llm.core.LLMPromptsKt;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.intentions.editor.WriteDocumentationBackgroundTask;
import com.intellij.ml.llm.intentions.editor.WriteDocumentationInvokeState;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0006\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "runWriteDocumentationTasksOnSelection", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "isWriteDocumentationAvailable", "", "findSelectedElementToDocument", "", "Lcom/intellij/psi/PsiElement;", "selectionModel", "Lcom/intellij/openapi/editor/SelectionModel;", "getClosestToCaretNamedElement", "writeDocumentationActionGroupId", "", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nWriteDocumentationTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriteDocumentationTask.kt\ncom/intellij/ml/llm/intentions/editor/WriteDocumentationTaskKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,450:1\n1869#2,2:451\n1#3:453\n*S KotlinDebug\n*F\n+ 1 WriteDocumentationTask.kt\ncom/intellij/ml/llm/intentions/editor/WriteDocumentationTaskKt\n*L\n392#1:451,2\n*E\n"})
public final class WriteDocumentationTaskKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final String writeDocumentationActionGroupId = "write.documentation.intention.write.action";

    public static final void runWriteDocumentationTasksOnSelection(@NotNull Editor editor, @Nullable PsiFile file, @NotNull Project project) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                PsiFile psiFile = file;
                if (psiFile == null) {
                    return;
                }
                if (!WriteDocumentationTaskKt.isWriteDocumentationAvailable(editor, psiFile)) {
                    return;
                }
                if (!AIFirstUseKt.prepareAiForUse((Project)project)) {
                    return;
                }
                SelectionModel selectionModel = editor.getSelectionModel();
                Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
                SelectionModel selectionModel2 = selectionModel;
                String selectedText = selectionModel2.getSelectedText();
                if (selectedText == null) break block4;
                Iterable $this$forEach$iv = WriteDocumentationTaskKt.findSelectedElementToDocument(editor, project, selectionModel2);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    new WriteDocumentationBackgroundTask(project, editor, it, WriteDocumentationInvokeState.INTENTION).startGeneration();
                }
                break block5;
            }
            PsiElement psiElement = WriteDocumentationTaskKt.getClosestToCaretNamedElement(editor);
            if (psiElement == null) break block5;
            PsiElement it = psiElement;
            boolean bl = false;
            new WriteDocumentationBackgroundTask(project, editor, it, WriteDocumentationInvokeState.INTENTION).startGeneration();
        }
    }

    public static final boolean isWriteDocumentationAvailable(@NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            LLMDocumentationSupport lLMDocumentationSupport = (LLMDocumentationSupport)LLMDocumentationSupportBean.INSTANCE.forLanguage(file.getLanguage());
            if (lLMDocumentationSupport == null) {
                return false;
            }
            LLMDocumentationSupport documentationSupport = lLMDocumentationSupport;
            if (!documentationSupport.isIntentionEnabled()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        boolean hasAvailableLlmProfileId = AIAssistantUIUtil.INSTANCE.hasAvailableLlmProfileId(LLMPromptsKt.getDOCUMENTATION_GENERATION_PROMPT_ID());
        if (!hasAvailableLlmProfileId) {
            return false;
        }
        return file.isWritable() && !PrivacyPathCheckerKt.isAiIgnoreBlocked((PsiElement)((PsiElement)file));
    }

    private static final List<PsiElement> findSelectedElementToDocument(Editor editor, Project project, SelectionModel selectionModel) {
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (psiFile == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile rootPsiFile = psiFile;
        LLMDocumentationSupport lLMDocumentationSupport = (LLMDocumentationSupport)LLMDocumentationSupportBean.INSTANCE.forLanguage(rootPsiFile.getLanguage());
        if (lLMDocumentationSupport == null) {
            return CollectionsKt.emptyList();
        }
        LLMDocumentationSupport support = lLMDocumentationSupport;
        return support.findDocTargetsInSelection((PsiElement)rootPsiFile, selectionModel);
    }

    @Nullable
    public static final PsiElement getClosestToCaretNamedElement(@NotNull Editor editor) {
        Project project;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                project = editor.getProject();
                if (project == null) break block4;
                Project it = project;
                boolean bl = false;
                PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)it);
                project = psiFile;
                if (psiFile != null) break block5;
            }
            return null;
        }
        Project rootPsiFile = project;
        LLMDocumentationSupport lLMDocumentationSupport = (LLMDocumentationSupport)LLMDocumentationSupportBean.INSTANCE.forLanguage(rootPsiFile.getLanguage());
        if (lLMDocumentationSupport == null) {
            return null;
        }
        LLMDocumentationSupport support = lLMDocumentationSupport;
        return support.findNearestDocumentationTargetForCaret(editor);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.ml.llm");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        WriteDocumentationTaskKt.logger = logger;
    }
}

