/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.qa.endpoint;

import com.intellij.ml.llm.core.chat.messages.impl.FunctionCallResult;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.TextContextAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.functioncalls.FunctionCallContextAttachmentConverter;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import com.intellij.ml.llm.qa.endpoint.DocumentationQAEndpoint;
import com.intellij.ml.llm.qa.endpoint.DocumentationQAFunctionConverterKt;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/qa/endpoint/DocumentationQAFunctionConverter;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/functioncalls/FunctionCallContextAttachmentConverter;", "<init>", "()V", "convert", "", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachment;", "project", "Lcom/intellij/openapi/project/Project;", "functionCall", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "canHandle", "", "intellij.ml.llm.chat"})
public final class DocumentationQAFunctionConverter
implements FunctionCallContextAttachmentConverter {
    @Override
    @Nullable
    public Object convert(@NotNull Project project, @NotNull FunctionCallResult functionCall, @NotNull Continuation<? super List<? extends ContextAttachment>> $completion) {
        PSString pSString;
        PSString response = functionCall instanceof FunctionCallResult.TrimmedResult ? ((FunctionCallResult.TrimmedResult)functionCall).getTrimmedResponse() : functionCall.getResponse();
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        String vendorName = appInfo.getShortCompanyName();
        if (appInfo.isVendorJetBrains()) {
            pSString = DocumentationQAFunctionConverterKt.access$getINTELLIJ_DOCS_LABEL$p();
        } else if (Intrinsics.areEqual((Object)vendorName, (Object)DocumentationQAFunctionConverterKt.access$getVENDOR_GOOGLE$p().unwrap())) {
            pSString = DocumentationQAFunctionConverterKt.access$getANDROID_STUDIO_DOCS_LABEL$p();
        } else {
            PSString pSString2 = ConstantsKt.getPrivacyConst((String)"%s Docs");
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[1];
            Intrinsics.checkNotNull((Object)appInfo);
            pSStringConvertibleArray[0] = SharedExtensionsKtKt.getPrivacySafe((ApplicationInfo)((ApplicationInfo)appInfo)).getShortCompanyName();
            pSString = pSString2.format(pSStringConvertibleArray);
        }
        PSString sourceDisplayName = pSString;
        PSString formattedDisplayName = sourceDisplayName.replace(" ", (PrivacySafe)ConstantsKt.getPrivacyConst((String)"_"));
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{formattedDisplayName, PSStringOperatorsKt.toPSString((int)System.identityHashCode(response))};
        PSString attachmentId = ConstantsKt.getPrivacyConst((String)"%s_%s").format(pSStringConvertibleArray);
        return CollectionsKt.listOf((Object)new TextContextAttachment(project, attachmentId, response, ContextAttachmentSource.FunctionCall.INSTANCE));
    }

    @Override
    public boolean canHandle(@NotNull FunctionCallResult functionCall) {
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        String string = functionCall.getProvider();
        String string2 = Reflection.getOrCreateKotlinClass(DocumentationQAEndpoint.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string2);
        return Intrinsics.areEqual((Object)string, (Object)string2);
    }
}

