/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.util.validation;

import com.intellij.ml.llm.core.chat.messages.impl.FunctionCallError;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.util.validation.VirtualFileValidatorKt;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0007\u0006\u0007\b\t\n\u000b\fB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u0082\u0001\u0007\r\u000e\u000f\u0010\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/util/validation/ValidationError;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallError;", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "<init>", "(Lcom/intellij/ml/llm/privacy/PSString;)V", "DocumentNotExist", "FileIsBinaryError", "ImagesAreNotSupportedByTheModelError", "ImagesIsToLargeError", "PsiElementExpired", "FileTooLong", "FileExpired", "Lcom/intellij/ml/llm/util/validation/ValidationError$DocumentNotExist;", "Lcom/intellij/ml/llm/util/validation/ValidationError$FileExpired;", "Lcom/intellij/ml/llm/util/validation/ValidationError$FileIsBinaryError;", "Lcom/intellij/ml/llm/util/validation/ValidationError$FileTooLong;", "Lcom/intellij/ml/llm/util/validation/ValidationError$ImagesAreNotSupportedByTheModelError;", "Lcom/intellij/ml/llm/util/validation/ValidationError$ImagesIsToLargeError;", "Lcom/intellij/ml/llm/util/validation/ValidationError$PsiElementExpired;", "intellij.ml.llm.chat"})
public abstract sealed class ValidationError
extends FunctionCallError {
    private ValidationError(PSString text2) {
        super(text2);
    }

    public /* synthetic */ ValidationError(PSString text2, DefaultConstructorMarker $constructor_marker) {
        this(text2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/util/validation/ValidationError$DocumentNotExist;", "Lcom/intellij/ml/llm/util/validation/ValidationError;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "intellij.ml.llm.chat"})
    public static final class DocumentNotExist
    extends ValidationError {
        public DocumentNotExist(@NotNull VirtualFile virtualFile2) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            super(VirtualFileValidatorKt.access$format(ConstantsKt.getPrivacyConst((String)"Document for file: %s doesn't exist."), virtualFile2), null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/util/validation/ValidationError$FileExpired;", "Lcom/intellij/ml/llm/util/validation/ValidationError;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "intellij.ml.llm.chat"})
    public static final class FileExpired
    extends ValidationError {
        public FileExpired(@NotNull VirtualFile virtualFile2) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            super(VirtualFileValidatorKt.access$format(ConstantsKt.getPrivacyConst((String)"File: %s has expired already. Try again."), virtualFile2), null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/util/validation/ValidationError$FileIsBinaryError;", "Lcom/intellij/ml/llm/util/validation/ValidationError;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "intellij.ml.llm.chat"})
    public static final class FileIsBinaryError
    extends ValidationError {
        public FileIsBinaryError(@NotNull VirtualFile virtualFile2) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            super(VirtualFileValidatorKt.access$format(ConstantsKt.getPrivacyConst((String)"File: %s  is non-textual"), virtualFile2), null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/util/validation/ValidationError$FileTooLong;", "Lcom/intellij/ml/llm/util/validation/ValidationError;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "intellij.ml.llm.chat"})
    public static final class FileTooLong
    extends ValidationError {
        public FileTooLong(@NotNull VirtualFile virtualFile2) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            super(VirtualFileValidatorKt.access$format(ConstantsKt.getPrivacyConst((String)"File: %s size is too large."), virtualFile2), null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ml/llm/util/validation/ValidationError$ImagesAreNotSupportedByTheModelError;", "Lcom/intellij/ml/llm/util/validation/ValidationError;", "<init>", "()V", "intellij.ml.llm.chat"})
    public static final class ImagesAreNotSupportedByTheModelError
    extends ValidationError {
        public ImagesAreNotSupportedByTheModelError() {
            super(ConstantsKt.getPrivacyConst((String)"Current model doesn't support images."), null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/util/validation/ValidationError$ImagesIsToLargeError;", "Lcom/intellij/ml/llm/util/validation/ValidationError;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "limitMb", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;I)V", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getLimitMb", "()I", "intellij.ml.llm.chat"})
    public static final class ImagesIsToLargeError
    extends ValidationError {
        @NotNull
        private final VirtualFile virtualFile;
        private final int limitMb;

        public ImagesIsToLargeError(@NotNull VirtualFile virtualFile2, int limitMb) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            super(ConstantsKt.getPrivacyConst((String)"Image is to large."), null);
            this.virtualFile = virtualFile2;
            this.limitMb = limitMb;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        public final int getLimitMb() {
            return this.limitMb;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ml/llm/util/validation/ValidationError$PsiElementExpired;", "Lcom/intellij/ml/llm/util/validation/ValidationError;", "<init>", "()V", "intellij.ml.llm.chat"})
    public static final class PsiElementExpired
    extends ValidationError {
        public PsiElementExpired() {
            super(ConstantsKt.getPrivacyConst((String)"Psi element is not valid."), null);
        }
    }
}

