/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.askai;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.askai.DataContextStrategy;
import com.intellij.ml.llm.askai.toolRegistry.impl.AskAIDataContextUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/askai/FileDataContextStrategy;", "Lcom/intellij/ml/llm/askai/DataContextStrategy;", "<init>", "()V", "populateDataContext", "Lcom/intellij/ml/llm/askai/toolRegistry/impl/AskAIDataContextUtil$DataContextPopulationError;", "builder", "Lcom/intellij/openapi/actionSystem/impl/SimpleDataContext$Builder;", "paramValue", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/actionSystem/impl/SimpleDataContext$Builder;Ljava/lang/Object;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toAbsolutePath", "Ljava/nio/file/Path;", "filePath", "intellij.ml.llm.askai"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nAskAIDataContextStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AskAIDataContextStrategy.kt\ncom/intellij/ml/llm/askai/FileDataContextStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class FileDataContextStrategy
implements DataContextStrategy {
    @NotNull
    public static final FileDataContextStrategy INSTANCE = new FileDataContextStrategy();
    public static final int $stable;

    private FileDataContextStrategy() {
    }

    @Override
    @Nullable
    public Object populateDataContext(@NotNull SimpleDataContext.Builder builder, @Nullable Object paramValue, @NotNull Project project, @NotNull Continuation<? super AskAIDataContextUtil.DataContextPopulationError> $completion) {
        if (!(paramValue instanceof String)) {
            return new AskAIDataContextUtil.DataContextPopulationError("Expected string file path");
        }
        Path path = Paths.get((String)paramValue, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path absolutePath = this.toAbsolutePath(path, project);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(((Object)absolutePath).toString());
        if (virtualFile != null) {
            builder.add(CommonDataKeys.VIRTUAL_FILE, (Object)virtualFile);
            List list = FileEditorManager.getInstance((Project)project).getEditorList(virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEditorList(...)");
            FileEditor fileEditor = (FileEditor)CollectionsKt.firstOrNull((List)list);
            if (fileEditor != null) {
                FileEditor it = fileEditor;
                boolean bl = false;
                if (it instanceof TextEditor) {
                    builder.add(CommonDataKeys.EDITOR, (Object)((TextEditor)it).getEditor());
                }
            }
            return null;
        }
        return new AskAIDataContextUtil.DataContextPopulationError("File not found: " + paramValue);
    }

    private final Path toAbsolutePath(Path filePath, Project project) {
        Object object;
        block5: {
            block4: {
                if (filePath.isAbsolute()) {
                    return filePath;
                }
                object = project.getBasePath();
                if (object == null) break block4;
                String it = object;
                boolean bl = false;
                Path path = Paths.get(it, new String[0]).resolve(filePath);
                object = path;
                if (path != null) break block5;
            }
            object = filePath;
        }
        return object;
    }
}

