/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.askai.debug;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.askai.debug.AskAiEditorColorsSettingsExtractorKt;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001a\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ%\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u001d\u001a\u00020\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/ml/llm/askai/debug/AskAiEditorColorsSettingsExtractor;", "", "<init>", "()V", "getEditorColorsContent", "", "project", "Lcom/intellij/openapi/project/Project;", "getEditorColorsContentForPage", "pageName", "getAvailablePages", "", "getColorSchemePagesJson", "Lkotlinx/serialization/json/JsonObject;", "pages", "", "Lcom/intellij/openapi/options/colors/ColorSettingsPage;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "([Lcom/intellij/openapi/options/colors/ColorSettingsPage;Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)Lkotlinx/serialization/json/JsonObject;", "sanitizeCategoryName", "name", "extractPageSettings", "page", "extractAttributeDescriptor", "descriptor", "Lcom/intellij/openapi/options/colors/AttributesDescriptor;", "extractColorDescriptor", "Lcom/intellij/openapi/options/colors/ColorDescriptor;", "addColorIfPresent", "", "Lkotlinx/serialization/json/JsonObjectBuilder;", "key", "color", "Ljava/awt/Color;", "json", "Lkotlinx/serialization/json/Json;", "intellij.ml.llm.askai"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAskAiEditorColorsSettingsExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AskAiEditorColorsSettingsExtractor.kt\ncom/intellij/ml/llm/askai/debug/AskAiEditorColorsSettingsExtractor\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n29#2,2:182\n29#2,3:184\n31#2:187\n29#2,3:189\n29#2,2:210\n52#2,2:213\n54#2:217\n31#2:219\n29#2,2:220\n52#2,2:222\n54#2:226\n52#2,2:227\n54#2:231\n31#2:232\n29#2,2:233\n29#2,3:235\n31#2:238\n29#2,3:239\n29#2,3:242\n1#3:188\n11561#4:192\n11896#4,3:193\n11009#4:196\n11234#4,3:197\n11237#4,3:207\n13805#4,2:224\n13805#4,2:229\n382#5,7:200\n216#6:212\n217#6:218\n1869#7,2:215\n*S KotlinDebug\n*F\n+ 1 AskAiEditorColorsSettingsExtractor.kt\ncom/intellij/ml/llm/askai/debug/AskAiEditorColorsSettingsExtractor\n*L\n25#1:182,2\n29#1:184,3\n25#1:187\n48#1:189,3\n71#1:210,2\n74#1:213,2\n74#1:217\n71#1:219\n90#1:220,2\n96#1:222,2\n96#1:226\n111#1:227,2\n111#1:231\n90#1:232\n129#1:233,2\n134#1:235,3\n129#1:238\n155#1:239,3\n167#1:242,3\n61#1:192\n61#1:193,3\n66#1:196\n66#1:197,3\n66#1:207,3\n97#1:224,2\n112#1:229,2\n66#1:200,7\n72#1:212\n72#1:218\n75#1:215,2\n*E\n"})
public final class AskAiEditorColorsSettingsExtractor {
    @NotNull
    public static final AskAiEditorColorsSettingsExtractor INSTANCE = new AskAiEditorColorsSettingsExtractor();
    @NotNull
    private static final Json json = JsonKt.Json$default(null, AskAiEditorColorsSettingsExtractor::json$lambda$0, (int)1, null);
    public static final int $stable = 8;

    private AskAiEditorColorsSettingsExtractor() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getEditorColorsContent(@Nullable Project project) {
        void $this$getEditorColorsContent_u24lambda_u240_u240;
        JsonObjectBuilder builder$iv;
        JsonObjectBuilder builder$iv2;
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        ColorSettingsPage[] pages = ColorSettingsPages.getInstance().getRegisteredPages();
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$getEditorColorsContent_u24lambda_u240 = builder$iv2 = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$getEditorColorsContent_u24lambda_u240, (String)"schemeName", (String)scheme.getName());
        boolean $i$f$buildJsonObject2 = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        String string = "generalColors";
        JsonObjectBuilder jsonObjectBuilder2 = $this$getEditorColorsContent_u24lambda_u240;
        boolean bl2 = false;
        Color color = scheme.getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
        INSTANCE.addColorIfPresent((JsonObjectBuilder)$this$getEditorColorsContent_u24lambda_u240_u240, "defaultBackground", color);
        Color color2 = scheme.getDefaultForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultForeground(...)");
        INSTANCE.addColorIfPresent((JsonObjectBuilder)$this$getEditorColorsContent_u24lambda_u240_u240, "defaultForeground", color2);
        Unit unit = Unit.INSTANCE;
        jsonObjectBuilder2.put(string, (JsonElement)builder$iv.build());
        Intrinsics.checkNotNull((Object)pages);
        $this$getEditorColorsContent_u24lambda_u240.put("colorSchemePages", (JsonElement)INSTANCE.getColorSchemePagesJson(pages, scheme));
        JsonObject resultJson = builder$iv2.build();
        return json.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)resultJson);
    }

    public static /* synthetic */ String getEditorColorsContent$default(AskAiEditorColorsSettingsExtractor askAiEditorColorsSettingsExtractor, Project project, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        return askAiEditorColorsSettingsExtractor.getEditorColorsContent(project);
    }

    @NotNull
    public final String getEditorColorsContentForPage(@NotNull String pageName, @Nullable Project project) {
        JsonObjectBuilder builder$iv;
        Object object;
        EditorColorsScheme scheme;
        block2: {
            Intrinsics.checkNotNullParameter((Object)pageName, (String)"pageName");
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
            scheme = editorColorsScheme;
            ColorSettingsPage[] colorSettingsPageArray = ColorSettingsPages.getInstance().getRegisteredPages();
            Intrinsics.checkNotNullExpressionValue((Object)colorSettingsPageArray, (String)"getRegisteredPages(...)");
            for (Object object2 : (Object[])colorSettingsPageArray) {
                ColorSettingsPage it = (ColorSettingsPage)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)pageName)) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        ColorSettingsPage colorSettingsPage = (ColorSettingsPage)object;
        if (colorSettingsPage == null) {
            throw new IllegalArgumentException("Page with name '" + pageName + "' not found");
        }
        ColorSettingsPage page = colorSettingsPage;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$getEditorColorsContentForPage_u24lambda_u241 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$getEditorColorsContentForPage_u24lambda_u241, (String)"schemeName", (String)scheme.getName());
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$getEditorColorsContentForPage_u24lambda_u241, (String)"pageName", (String)pageName);
        $this$getEditorColorsContentForPage_u24lambda_u241.put("pageSettings", (JsonElement)INSTANCE.extractPageSettings(page, scheme));
        JsonObject resultJson = builder$iv.build();
        return json.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)resultJson);
    }

    public static /* synthetic */ String getEditorColorsContentForPage$default(AskAiEditorColorsSettingsExtractor askAiEditorColorsSettingsExtractor, String string, Project project, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        return askAiEditorColorsSettingsExtractor.getEditorColorsContentForPage(string, project);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAvailablePages() {
        void $this$mapTo$iv$iv;
        ColorSettingsPage[] colorSettingsPageArray = ColorSettingsPages.getInstance().getRegisteredPages();
        Intrinsics.checkNotNullExpressionValue((Object)colorSettingsPageArray, (String)"getRegisteredPages(...)");
        Object[] $this$map$iv = colorSettingsPageArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ColorSettingsPage colorSettingsPage = (ColorSettingsPage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDisplayName());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject getColorSchemePagesJson(ColorSettingsPage[] pages, EditorColorsScheme scheme) {
        JsonObjectBuilder builder$iv;
        List answer$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        ColorSettingsPage[] $this$groupBy$iv = pages;
        boolean $i$f$groupBy = false;
        ColorSettingsPage[] colorSettingsPageArray = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        int n = ((void)$this$groupByTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            void element$iv$iv;
            void page = element$iv$iv = $this$groupByTo$iv$iv[i];
            boolean bl = false;
            String string = page.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            String string2 = page.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
            String key$iv$iv = StringsKt.substringBefore((String)string, (String)" //", (String)string2);
            Map map = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map pagesByCategory = destination$iv$iv;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$getColorSchemePagesJson_u24lambda_u241 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        Map $this$forEach$iv = pagesByCategory;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl3 = false;
            String category = (String)entry.getKey();
            List pagesInCategory = (List)entry.getValue();
            String sanitizedCategory = INSTANCE.sanitizeCategoryName(category);
            boolean $i$f$buildJsonArray = false;
            JsonArrayBuilder builder$iv2 = new JsonArrayBuilder();
            answer$iv$iv$iv = builder$iv2;
            String string = sanitizedCategory;
            JsonObjectBuilder jsonObjectBuilder = $this$getColorSchemePagesJson_u24lambda_u241;
            boolean bl4 = false;
            Iterable $this$forEach$iv2 = pagesInCategory;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                void $this$getColorSchemePagesJson_u24lambda_u241_u240_u240;
                ColorSettingsPage page = (ColorSettingsPage)element$iv2;
                boolean bl5 = false;
                $this$getColorSchemePagesJson_u24lambda_u241_u240_u240.add((JsonElement)INSTANCE.extractPageSettings(page, scheme));
            }
            Unit unit = Unit.INSTANCE;
            jsonObjectBuilder.put(string, (JsonElement)builder$iv2.build());
        }
        return builder$iv.build();
    }

    private final String sanitizeCategoryName(String name) {
        CharSequence charSequence = name;
        Regex regex = new Regex("[^a-zA-Z0-9_\\s]");
        String string = "";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("\\s+");
        string = "_";
        CharSequence it = charSequence = regex.replace(charSequence, string);
        boolean bl = false;
        CharSequence charSequence2 = !StringsKt.isBlank((CharSequence)it) ? charSequence : null;
        if (charSequence2 == null) {
            charSequence2 = "General";
        }
        return charSequence2;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject extractPageSettings(ColorSettingsPage page, EditorColorsScheme scheme) {
        Unit unit;
        int n;
        JsonObjectBuilder jsonObjectBuilder;
        String string;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$extractPageSettings_u24lambda_u240 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$extractPageSettings_u24lambda_u240, (String)"pageName", (String)page.getDisplayName());
        AttributesDescriptor[] attributesDescriptorArray = page.getAttributeDescriptors();
        Intrinsics.checkNotNullExpressionValue((Object)attributesDescriptorArray, (String)"getAttributeDescriptors(...)");
        AttributesDescriptor[] attributeDescriptors = attributesDescriptorArray;
        if (!(attributeDescriptors.length == 0)) {
            JsonArrayBuilder builder$iv2;
            boolean $i$f$buildJsonArray = false;
            JsonArrayBuilder jsonArrayBuilder = builder$iv2 = new JsonArrayBuilder();
            string = "textAttributes";
            jsonObjectBuilder = $this$extractPageSettings_u24lambda_u240;
            boolean bl2 = false;
            AttributesDescriptor[] $this$forEach$iv = attributeDescriptors;
            boolean $i$f$forEach = false;
            n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                AttributesDescriptor element$iv;
                AttributesDescriptor descriptor = element$iv = $this$forEach$iv[i];
                boolean bl3 = false;
                try {
                    void $this$extractPageSettings_u24lambda_u240_u240;
                    Intrinsics.checkNotNull((Object)descriptor);
                    $this$extractPageSettings_u24lambda_u240_u240.add((JsonElement)INSTANCE.extractAttributeDescriptor(descriptor, scheme));
                    continue;
                }
                catch (Exception e) {
                    if (e instanceof CancellationException) {
                        throw e;
                    }
                    AskAiEditorColorsSettingsExtractorKt.access$getLOG$p().warn("Failed to extract attribute descriptor: " + descriptor.getDisplayName(), (Throwable)e);
                }
            }
            unit = Unit.INSTANCE;
            jsonObjectBuilder.put(string, (JsonElement)builder$iv2.build());
        }
        ColorDescriptor[] colorDescriptorArray = page.getColorDescriptors();
        Intrinsics.checkNotNullExpressionValue((Object)colorDescriptorArray, (String)"getColorDescriptors(...)");
        ColorDescriptor[] colorDescriptors = colorDescriptorArray;
        if (!(colorDescriptors.length == 0)) {
            JsonArrayBuilder builder$iv3;
            boolean $i$f$buildJsonArray = false;
            JsonArrayBuilder bl2 = builder$iv3 = new JsonArrayBuilder();
            string = "colors";
            jsonObjectBuilder = $this$extractPageSettings_u24lambda_u240;
            boolean bl4 = false;
            ColorDescriptor[] $this$forEach$iv = colorDescriptors;
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                ColorDescriptor element$iv;
                ColorDescriptor descriptor = element$iv = $this$forEach$iv[n];
                boolean bl5 = false;
                try {
                    void $this$extractPageSettings_u24lambda_u240_u241;
                    Intrinsics.checkNotNull((Object)descriptor);
                    $this$extractPageSettings_u24lambda_u240_u241.add((JsonElement)INSTANCE.extractColorDescriptor(descriptor, scheme));
                    continue;
                }
                catch (Exception e) {
                    if (e instanceof CancellationException) {
                        throw e;
                    }
                    AskAiEditorColorsSettingsExtractorKt.access$getLOG$p().warn("Failed to extract color descriptor: " + descriptor.getDisplayName(), (Throwable)e);
                }
            }
            unit = Unit.INSTANCE;
            jsonObjectBuilder.put(string, (JsonElement)builder$iv3.build());
        }
        return builder$iv.build();
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject extractAttributeDescriptor(AttributesDescriptor descriptor, EditorColorsScheme scheme) {
        JsonObjectBuilder builder$iv;
        TextAttributesKey textAttributesKey = descriptor.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"getKey(...)");
        TextAttributesKey key = textAttributesKey;
        TextAttributes attributes = scheme.getAttributes(key);
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$extractAttributeDescriptor_u24lambda_u240 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$extractAttributeDescriptor_u24lambda_u240, (String)"name", (String)descriptor.getDisplayName());
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$extractAttributeDescriptor_u24lambda_u240, (String)"key", (String)key.getExternalName());
        if (attributes != null) {
            void $this$extractAttributeDescriptor_u24lambda_u240_u240;
            Color it;
            JsonObjectBuilder builder$iv2;
            boolean $i$f$buildJsonObject2 = false;
            JsonObjectBuilder jsonObjectBuilder = builder$iv2 = new JsonObjectBuilder();
            String string = "attributes";
            JsonObjectBuilder jsonObjectBuilder2 = $this$extractAttributeDescriptor_u24lambda_u240;
            boolean bl2 = false;
            Color color = attributes.getForegroundColor();
            if (color != null) {
                it = color;
                boolean bl3 = false;
                INSTANCE.addColorIfPresent((JsonObjectBuilder)$this$extractAttributeDescriptor_u24lambda_u240_u240, "foregroundColor", it);
            }
            Color color2 = attributes.getBackgroundColor();
            if (color2 != null) {
                it = color2;
                boolean bl4 = false;
                INSTANCE.addColorIfPresent((JsonObjectBuilder)$this$extractAttributeDescriptor_u24lambda_u240_u240, "backgroundColor", it);
            }
            Color color3 = attributes.getEffectColor();
            if (color3 != null) {
                it = color3;
                boolean bl5 = false;
                INSTANCE.addColorIfPresent((JsonObjectBuilder)$this$extractAttributeDescriptor_u24lambda_u240_u240, "effectColor", it);
            }
            Color color4 = attributes.getErrorStripeColor();
            if (color4 != null) {
                it = color4;
                boolean bl6 = false;
                INSTANCE.addColorIfPresent((JsonObjectBuilder)$this$extractAttributeDescriptor_u24lambda_u240_u240, "errorStripeColor", it);
            }
            EffectType effectType = attributes.getEffectType();
            if (effectType != null) {
                it = effectType;
                boolean bl7 = false;
                JsonElementBuildersKt.put((JsonObjectBuilder)$this$extractAttributeDescriptor_u24lambda_u240_u240, (String)"effectType", (String)it.toString());
            }
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$extractAttributeDescriptor_u24lambda_u240_u240, (String)"fontType", (Number)attributes.getFontType());
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$extractAttributeDescriptor_u24lambda_u240_u240, (String)"isBold", (Boolean)((attributes.getFontType() & 1) != 0 ? 1 : 0));
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$extractAttributeDescriptor_u24lambda_u240_u240, (String)"isItalic", (Boolean)((attributes.getFontType() & 2) != 0 ? 1 : 0));
            Unit unit = Unit.INSTANCE;
            jsonObjectBuilder2.put(string, (JsonElement)builder$iv2.build());
        }
        return builder$iv.build();
    }

    private final JsonObject extractColorDescriptor(ColorDescriptor descriptor, EditorColorsScheme scheme) {
        JsonObjectBuilder builder$iv;
        ColorKey colorKey = descriptor.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)colorKey, (String)"getKey(...)");
        ColorKey key = colorKey;
        Color color = scheme.getColor(key);
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$extractColorDescriptor_u24lambda_u240 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$extractColorDescriptor_u24lambda_u240, (String)"name", (String)descriptor.getDisplayName());
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$extractColorDescriptor_u24lambda_u240, (String)"key", (String)key.getExternalName());
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$extractColorDescriptor_u24lambda_u240, (String)"kind", (String)descriptor.getKind().toString());
        if (color != null) {
            INSTANCE.addColorIfPresent($this$extractColorDescriptor_u24lambda_u240, "color", color);
        }
        return builder$iv.build();
    }

    /*
     * WARNING - void declaration
     */
    private final void addColorIfPresent(JsonObjectBuilder $this$addColorIfPresent, String key, Color color) {
        void $this$addColorIfPresent_u24lambda_u240;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        String string = key;
        JsonObjectBuilder jsonObjectBuilder2 = $this$addColorIfPresent;
        boolean bl = false;
        String string2 = "#%02x%02x%02x";
        Object[] objectArray = new Object[]{color.getRed(), color.getGreen(), color.getBlue()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$addColorIfPresent_u24lambda_u240, (String)"hex", (String)string3);
        Unit unit = Unit.INSTANCE;
        jsonObjectBuilder2.put(string, (JsonElement)builder$iv.build());
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }
}

