/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.embeddings.external.artifacts;

import com.intellij.ml.llm.embeddings.external.artifacts.DownloadableArtifact;
import com.intellij.ml.llm.embeddings.external.artifacts.LocalArtifactsManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0001\u0001\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/embeddings/external/artifacts/ModelArtifact;", "Lcom/intellij/ml/llm/embeddings/external/artifacts/DownloadableArtifact;", "name", "", "weightsPath", "vocabPath", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "archiveName", "getArchiveName", "downloadLink", "getDownloadLink", "destination", "Ljava/nio/file/Path;", "getDestination", "()Ljava/nio/file/Path;", "checkPresent", "", "getVocabPath", "getWeightsPath", "SmallModelArtifact", "Companion", "Lcom/intellij/ml/llm/embeddings/external/artifacts/ModelArtifact$SmallModelArtifact;", "intellij.ml.llm.embeddings"})
@SourceDebugExtension(value={"SMAP\nLocalArtifactsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalArtifactsManager.kt\ncom/intellij/ml/llm/embeddings/external/artifacts/ModelArtifact\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,250:1\n1740#2,3:251\n*S KotlinDebug\n*F\n+ 1 LocalArtifactsManager.kt\ncom/intellij/ml/llm/embeddings/external/artifacts/ModelArtifact\n*L\n221#1:251,3\n*E\n"})
public abstract sealed class ModelArtifact
implements DownloadableArtifact {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String weightsPath;
    @NotNull
    private final String vocabPath;
    @NotNull
    private final String archiveName;
    @NotNull
    private final String downloadLink;
    @NotNull
    private final Path destination;
    @NotNull
    private static final String CDN_LINK_BASE = "https://download.jetbrains.com/resources/ml/full-line/models/embeddings";

    private ModelArtifact(String name, String weightsPath, String vocabPath) {
        this.name = name;
        this.weightsPath = weightsPath;
        this.vocabPath = vocabPath;
        this.archiveName = this.name + ".zip";
        Object[] objectArray = new String[]{CDN_LINK_BASE, LocalArtifactsManager.Companion.getMODEL_VERSION$intellij_ml_llm_embeddings(), this.archiveName};
        this.downloadLink = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        Path path = LocalArtifactsManager.Companion.getModelsRoot$intellij_ml_llm_embeddings().resolve(this.name);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.destination = path;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public final String getArchiveName() {
        return this.archiveName;
    }

    @Override
    @NotNull
    public String getDownloadLink() {
        return this.downloadLink;
    }

    @Override
    @NotNull
    public Path getDestination() {
        return this.destination;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkPresent() {
        LinkOption[] linkOptionArray;
        Path path;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isDirectory(this.getDestination(), Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) return false;
        Object[] objectArray = new String[]{this.weightsPath, this.vocabPath};
        Iterable $this$all$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            String it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)this.getDestination().resolve(it), (String)"resolve(...)");
            linkOptionArray = new LinkOption[]{};
        } while (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)));
        return false;
    }

    @NotNull
    public final Path getVocabPath() {
        Path path = this.getDestination().resolve(this.vocabPath);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getWeightsPath() {
        Path path = this.getDestination().resolve(this.weightsPath);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    public /* synthetic */ ModelArtifact(String name, String weightsPath, String vocabPath, DefaultConstructorMarker $constructor_marker) {
        this(name, weightsPath, vocabPath);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/embeddings/external/artifacts/ModelArtifact$Companion;", "", "<init>", "()V", "CDN_LINK_BASE", "", "intellij.ml.llm.embeddings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/embeddings/external/artifacts/ModelArtifact$SmallModelArtifact;", "Lcom/intellij/ml/llm/embeddings/external/artifacts/ModelArtifact;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.embeddings"})
    public static final class SmallModelArtifact
    extends ModelArtifact {
        @NotNull
        public static final SmallModelArtifact INSTANCE = new SmallModelArtifact();

        private SmallModelArtifact() {
            super("small", "dan_100k_optimized.onnx", "bert-base-uncased.txt", null);
        }

        @NotNull
        public String toString() {
            return "SmallModelArtifact";
        }

        public int hashCode() {
            return -747789589;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SmallModelArtifact)) {
                return false;
            }
            SmallModelArtifact cfr_ignored_0 = (SmallModelArtifact)other;
            return true;
        }
    }
}

