/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.embeddings.retrievers;

import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.RelatedCodeWithFileContextAttachment;
import com.intellij.ml.llm.embeddings.retrievers.IndexableEntityPrivacyWrapper;
import com.intellij.ml.llm.embeddings.retrievers.TextChunkChatAttachment;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u001a\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001f\u0010\u0014\u001a\r\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\b\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/embeddings/retrievers/TextChunkAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/RelatedCodeWithFileContextAttachment;", "project", "Lcom/intellij/openapi/project/Project;", "entityPrivacyWrapper", "Lcom/intellij/ml/llm/embeddings/retrievers/IndexableEntityPrivacyWrapper;", "virtualFilePointer", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "textOffset", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/embeddings/retrievers/IndexableEntityPrivacyWrapper;Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;I)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getEntityPrivacyWrapper", "()Lcom/intellij/ml/llm/embeddings/retrievers/IndexableEntityPrivacyWrapper;", "getVirtualFilePointer", "()Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "getTextOffset", "()I", "name", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "intellij.ml.llm.embeddings"})
public final class TextChunkAttachment
extends RelatedCodeWithFileContextAttachment {
    @NotNull
    private final Project project;
    @NotNull
    private final IndexableEntityPrivacyWrapper entityPrivacyWrapper;
    @NotNull
    private final VirtualFilePointer virtualFilePointer;
    private final int textOffset;
    @NotNull
    private final ObservableProperty<String> name;

    public TextChunkAttachment(@NotNull Project project, @NotNull IndexableEntityPrivacyWrapper entityPrivacyWrapper, @NotNull VirtualFilePointer virtualFilePointer, int textOffset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)entityPrivacyWrapper), (String)"entityPrivacyWrapper");
        Intrinsics.checkNotNullParameter((Object)virtualFilePointer, (String)"virtualFilePointer");
        super(project, null, entityPrivacyWrapper.getName(), entityPrivacyWrapper.getContextRepresentation(), virtualFilePointer, (ContextAttachmentSource)ContextAttachmentSource.TextChunksRetriever.INSTANCE);
        this.project = project;
        this.entityPrivacyWrapper = entityPrivacyWrapper;
        this.virtualFilePointer = virtualFilePointer;
        this.textOffset = textOffset;
        this.name = (ObservableProperty)new AtomicProperty((Object)this.entityPrivacyWrapper.getName().unwrap());
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final IndexableEntityPrivacyWrapper getEntityPrivacyWrapper() {
        return this.entityPrivacyWrapper;
    }

    @NotNull
    public final VirtualFilePointer getVirtualFilePointer() {
        return this.virtualFilePointer;
    }

    public final int getTextOffset() {
        return this.textOffset;
    }

    @NotNull
    public ObservableProperty<String> getName() {
        return this.name;
    }

    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return new TextChunkChatAttachment(this.getProject(), this.entityPrivacyWrapper, this.virtualFilePointer, this.textOffset);
    }

    public void performAction(boolean isInMessage) {
        VirtualFile virtualFile = this.virtualFilePointer.getFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.getProject()).openFile(file, true);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
        Object object = ArraysKt.firstOrNull((Object[])fileEditorArray);
        TextEditor textEditor = object instanceof TextEditor ? (TextEditor)object : null;
        TextEditor textEditor2 = textEditor;
        if (textEditor2 == null || (textEditor2 = textEditor2.getEditor()) == null) {
            return;
        }
        TextEditor editor = textEditor2;
        editor.getCaretModel().moveToOffset(this.textOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
    }
}

