/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.ByteHeapKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0016\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u0017J\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\u001fJ\u0006\u0010 \u001a\u00020\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lio/kinference/ndarray/arrays/ByteMinHeap;", "", "size", "", "<init>", "(I)V", "data", "", "getData", "()[B", "indices", "", "getIndices", "()[I", "count", "maxValue", "", "getMaxValue", "()B", "maxIndex", "getMaxIndex", "()I", "siftUp", "", "idx", "siftDown", "insert", "key", "index", "removeMax", "sorted", "Lkotlin/Pair;", "clear", "ndarray-core"})
public final class ByteMinHeap {
    @NotNull
    private final byte[] data;
    @NotNull
    private final int[] indices;
    private int count;

    public ByteMinHeap(int size) {
        this.data = new byte[size];
        this.indices = new int[size];
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    @NotNull
    public final int[] getIndices() {
        return this.indices;
    }

    public final byte getMaxValue() {
        return this.data[0];
    }

    private final int getMaxIndex() {
        return this.indices[0];
    }

    private final void siftUp(int idx) {
        int internalIdx = idx;
        while (this.data[idx] > this.data[(idx - 1) / 2]) {
            UtilsKt.swap(this.indices, idx, (idx - 1) / 2);
            ByteHeapKt.swap(this.data, idx, (idx - 1) / 2);
            internalIdx = (internalIdx - 1) / 2;
        }
    }

    private final void siftDown(int idx) {
        int internalIdx = idx;
        while (2 * internalIdx + 1 < this.count) {
            int j;
            int left = 2 * internalIdx + 1;
            int right = left + 1;
            int n = j = right < this.count && this.data[right] > this.data[left] ? right : left;
            if (this.data[internalIdx] >= this.data[j]) break;
            ByteHeapKt.swap(this.data, internalIdx, j);
            UtilsKt.swap(this.indices, internalIdx, j);
            internalIdx = j;
        }
    }

    public final void insert(byte key, int index2) {
        int n = this.count;
        this.count = n + 1;
        this.data[this.count - 1] = key;
        this.indices[this.count - 1] = index2;
        this.siftUp(this.count - 1);
    }

    public final void removeMax() {
        this.data[0] = this.data[this.count - 1];
        this.indices[0] = this.indices[this.count - 1];
        int n = this.count;
        this.count = n + -1;
        this.siftDown(0);
    }

    @NotNull
    public final Pair<byte[], int[]> sorted() {
        byte[] sortedData = new byte[this.count];
        int[] sortedIndices = new int[this.count];
        for (int idx = this.count - 1; -1 < idx; --idx) {
            sortedData[idx] = this.getMaxValue();
            sortedIndices[idx] = this.getMaxIndex();
            this.removeMax();
        }
        return TuplesKt.to((Object)sortedData, (Object)sortedIndices);
    }

    public final void clear() {
        this.count = 0;
    }
}

