/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.memory.storage;

import io.kinference.ndarray.arrays.MutableNDArrayCore;
import io.kinference.ndarray.arrays.NDArrayCore;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.ndarray.arrays.memory.MemoryManager;
import io.kinference.ndarray.arrays.memory.storage.BooleanManualHandlingArrayStorage;
import io.kinference.ndarray.arrays.memory.storage.ByteManualHandlingArrayStorage;
import io.kinference.ndarray.arrays.memory.storage.DoubleManualHandlingArrayStorage;
import io.kinference.ndarray.arrays.memory.storage.FloatManualHandlingArrayStorage;
import io.kinference.ndarray.arrays.memory.storage.IntManualHandlingArrayStorage;
import io.kinference.ndarray.arrays.memory.storage.LongManualHandlingArrayStorage;
import io.kinference.ndarray.arrays.memory.storage.ManualStorage;
import io.kinference.ndarray.arrays.memory.storage.ShortManualHandlingArrayStorage;
import io.kinference.ndarray.arrays.memory.storage.TypedManualHandlingStorage;
import io.kinference.ndarray.arrays.memory.storage.UByteManualHandlingArrayStorage;
import io.kinference.ndarray.arrays.memory.storage.UIntManualHandlingArrayStorage;
import io.kinference.ndarray.arrays.memory.storage.ULongManualHandlingArrayStorage;
import io.kinference.ndarray.arrays.memory.storage.UShortManualHandlingArrayStorage;
import io.kinference.primitives.types.DataType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0017"}, d2={"Lio/kinference/ndarray/arrays/memory/storage/ManualArrayHandlingStorage;", "Lio/kinference/ndarray/arrays/memory/storage/ManualStorage;", "memoryManager", "Lio/kinference/ndarray/arrays/memory/MemoryManager;", "<init>", "(Lio/kinference/ndarray/arrays/memory/MemoryManager;)V", "storage", "", "Lio/kinference/ndarray/arrays/memory/storage/TypedManualHandlingStorage;", "[Lio/kinference/ndarray/arrays/memory/storage/TypedManualHandlingStorage;", "getNDArray", "Lio/kinference/ndarray/arrays/MutableNDArrayCore;", "dataType", "Lio/kinference/primitives/types/DataType;", "strides", "Lio/kinference/ndarray/arrays/Strides;", "fillZeros", "", "returnNDArray", "", "ndArray", "Lio/kinference/ndarray/arrays/NDArrayCore;", "resetState", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nManualArrayHandlingStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManualArrayHandlingStorage.kt\nio/kinference/ndarray/arrays/memory/storage/ManualArrayHandlingStorage\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,47:1\n13346#2,2:48\n*S KotlinDebug\n*F\n+ 1 ManualArrayHandlingStorage.kt\nio/kinference/ndarray/arrays/memory/storage/ManualArrayHandlingStorage\n*L\n43#1:48,2\n*E\n"})
public final class ManualArrayHandlingStorage
implements ManualStorage {
    @NotNull
    private final MemoryManager memoryManager;
    @NotNull
    private final TypedManualHandlingStorage[] storage;

    public ManualArrayHandlingStorage(@NotNull MemoryManager memoryManager) {
        Intrinsics.checkNotNullParameter((Object)memoryManager, (String)"memoryManager");
        this.memoryManager = memoryManager;
        TypedManualHandlingStorage[] typedManualHandlingStorageArray = new TypedManualHandlingStorage[]{new ByteManualHandlingArrayStorage(), new ShortManualHandlingArrayStorage(), new IntManualHandlingArrayStorage(), new LongManualHandlingArrayStorage(), new UByteManualHandlingArrayStorage(), new UShortManualHandlingArrayStorage(), new UIntManualHandlingArrayStorage(), new ULongManualHandlingArrayStorage(), new FloatManualHandlingArrayStorage(), new DoubleManualHandlingArrayStorage(), new BooleanManualHandlingArrayStorage()};
        this.storage = typedManualHandlingStorageArray;
    }

    @Override
    @NotNull
    public MutableNDArrayCore getNDArray(@NotNull DataType dataType, @NotNull Strides strides, boolean fillZeros) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        return this.storage[dataType.ordinal()].getNDArray(strides, fillZeros, this.memoryManager);
    }

    @Override
    public void returnNDArray(@NotNull NDArrayCore ndArray) {
        Intrinsics.checkNotNullParameter((Object)ndArray, (String)"ndArray");
        this.storage[ndArray.getType().ordinal()].returnNDArray(ndArray);
    }

    @Override
    public void resetState() {
        TypedManualHandlingStorage[] $this$forEach$iv = this.storage;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            TypedManualHandlingStorage element$iv;
            TypedManualHandlingStorage it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.clear();
        }
        this.memoryManager.resetLimit();
    }
}

