/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.memory.storage;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.MutableNDArrayCore;
import io.kinference.ndarray.arrays.MutableUByteNDArray;
import io.kinference.ndarray.arrays.NDArrayCore;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.ndarray.arrays.UByteNDArray;
import io.kinference.ndarray.arrays.memory.MemoryManager;
import io.kinference.ndarray.arrays.memory.storage.TypedManualHandlingStorage;
import io.kinference.ndarray.arrays.memory.storage.UByteGetBlockFunctionsExtensionKt;
import io.kinference.ndarray.arrays.tiled.UByteTiledArray;
import io.kinference.ndarray.extensions.constants.UByteConstants;
import io.kinference.primitives.types.DataType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UByteArray;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.unsigned.UArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/kinference/ndarray/arrays/memory/storage/UByteManualHandlingArrayStorage;", "Lio/kinference/ndarray/arrays/memory/storage/TypedManualHandlingStorage;", "<init>", "()V", "storage", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lkotlin/collections/ArrayDeque;", "Lkotlin/UByteArray;", "getNDArray", "Lio/kinference/ndarray/arrays/MutableNDArrayCore;", "strides", "Lio/kinference/ndarray/arrays/Strides;", "fillZeros", "", "limiter", "Lio/kinference/ndarray/arrays/memory/MemoryManager;", "returnNDArray", "", "ndarray", "Lio/kinference/ndarray/arrays/NDArrayCore;", "clear", "Companion", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nUByteManualHandlingArrayStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UByteManualHandlingArrayStorage.kt\nio/kinference/ndarray/arrays/memory/storage/UByteManualHandlingArrayStorage\n+ 2 Utils.kt\nio/kinference/ndarray/extensions/utils/UtilsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,56:1\n57#2,7:57\n57#2,7:64\n216#3,2:71\n*S KotlinDebug\n*F\n+ 1 UByteManualHandlingArrayStorage.kt\nio/kinference/ndarray/arrays/memory/storage/UByteManualHandlingArrayStorage\n*L\n26#1:57,7\n46#1:64,7\n52#1:71,2\n*E\n"})
public final class UByteManualHandlingArrayStorage
implements TypedManualHandlingStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Int2ObjectOpenHashMap<ArrayDeque<UByteArray>> storage = new Int2ObjectOpenHashMap(64);
    @NotNull
    private static final DataType type = DataType.UBYTE;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNDArrayCore getNDArray(@NotNull Strides strides, boolean fillZeros, @NotNull MemoryManager limiter2) {
        UByteArray[] uByteArrayArray;
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        Intrinsics.checkNotNullParameter((Object)limiter2, (String)"limiter");
        int blockSize = UtilsKt.blockSizeByStrides(strides);
        int blocksNum = strides.getLinearSize() / blockSize;
        if (limiter2.checkMemoryLimitAndAdd(UByteGetBlockFunctionsExtensionKt.getUByteArraySizeInBytes(blockSize * blocksNum))) {
            ArrayDeque arrayDeque;
            Int2ObjectOpenHashMap<ArrayDeque<UByteArray>> $this$getOrPut$iv = this.storage;
            boolean $i$f$getOrPut = false;
            ArrayDeque existingValue$iv = $this$getOrPut$iv.get(blockSize);
            if (existingValue$iv != null) {
                arrayDeque = existingValue$iv;
            } else {
                boolean bl = false;
                ArrayDeque value$iv = new ArrayDeque(blocksNum);
                $this$getOrPut$iv.put(blockSize, (ArrayDeque<UByteArray>)value$iv);
                arrayDeque = value$iv;
            }
            ArrayDeque queue = arrayDeque;
            UByteArray[] uByteArrayArray2 = new UByteArray[blocksNum];
            for (int i = 0; i < blocksNum; ++i) {
                byte[] byArray;
                int n = i;
                UByteArray[] uByteArrayArray3 = uByteArrayArray2;
                int n2 = n;
                UByteArray uByteArray = (UByteArray)queue.removeFirstOrNull();
                Object object = uByteArray != null ? uByteArray.unbox-impl() : null;
                if (object != null) {
                    void $this$getNDArray_u24lambda_u241;
                    byte[] byArray2;
                    byte[] byArray3 = byArray2 = object;
                    int n3 = n2;
                    UByteArray[] uByteArrayArray4 = uByteArrayArray3;
                    boolean bl = false;
                    UArraysKt.fill-WpHrYlw$default((byte[])$this$getNDArray_u24lambda_u241, (byte)UByteConstants.INSTANCE.getZERO-w2LRezQ(), (int)0, (int)0, (int)6, null);
                    Unit unit = Unit.INSTANCE;
                    uByteArrayArray3 = uByteArrayArray4;
                    n2 = n3;
                    byArray = byArray2;
                } else {
                    byArray = UByteArray.constructor-impl((int)blockSize);
                }
                uByteArrayArray3[n2] = UByteArray.box-impl((byte[])byArray);
            }
            uByteArrayArray = uByteArrayArray2;
        } else {
            int queue = 0;
            UByteArray[] uByteArrayArray5 = new UByteArray[blocksNum];
            while (queue < blocksNum) {
                int n = queue++;
                uByteArrayArray5[n] = UByteArray.box-impl((byte[])UByteArray.constructor-impl((int)blockSize));
            }
            uByteArrayArray = uByteArrayArray5;
        }
        UByteArray[] blocks = uByteArrayArray;
        UByteTiledArray tiled = new UByteTiledArray(blocks);
        return new MutableUByteNDArray(tiled, strides);
    }

    @Override
    public void returnNDArray(@NotNull NDArrayCore ndarray) {
        ArrayDeque arrayDeque;
        Intrinsics.checkNotNullParameter((Object)ndarray, (String)"ndarray");
        if (!(ndarray instanceof UByteNDArray)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int blockSize = ((UByteNDArray)ndarray).getArray().getBlockSize();
        int blocksNum = ((UByteNDArray)ndarray).getArray().getBlocksNum();
        Int2ObjectOpenHashMap<ArrayDeque<UByteArray>> $this$getOrPut$iv = this.storage;
        boolean $i$f$getOrPut = false;
        ArrayDeque existingValue$iv = $this$getOrPut$iv.get(blockSize);
        if (existingValue$iv != null) {
            arrayDeque = existingValue$iv;
        } else {
            boolean bl = false;
            ArrayDeque value$iv = new ArrayDeque(blocksNum);
            $this$getOrPut$iv.put(blockSize, (ArrayDeque<UByteArray>)value$iv);
            arrayDeque = value$iv;
        }
        ArrayDeque queue = arrayDeque;
        CollectionsKt.addAll((Collection)((Collection)queue), (Object[])((UByteNDArray)ndarray).getArray().getBlocks());
    }

    @Override
    public void clear() {
        Map $this$forEach$iv = this.storage;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            ArrayDeque queue = (ArrayDeque)entry.getValue();
            queue.clear();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/kinference/ndarray/arrays/memory/storage/UByteManualHandlingArrayStorage$Companion;", "", "<init>", "()V", "type", "Lio/kinference/primitives/types/DataType;", "ndarray-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

