/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.memory.storage;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.MutableNDArrayCore;
import io.kinference.ndarray.arrays.MutableUShortNDArray;
import io.kinference.ndarray.arrays.NDArrayCore;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.ndarray.arrays.UShortNDArray;
import io.kinference.ndarray.arrays.memory.MemoryManager;
import io.kinference.ndarray.arrays.memory.storage.TypedManualHandlingStorage;
import io.kinference.ndarray.arrays.memory.storage.UShortGetBlockFunctionsExtensionKt;
import io.kinference.ndarray.arrays.tiled.UShortTiledArray;
import io.kinference.ndarray.extensions.constants.UShortConstants;
import io.kinference.primitives.types.DataType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UShortArray;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.unsigned.UArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/kinference/ndarray/arrays/memory/storage/UShortManualHandlingArrayStorage;", "Lio/kinference/ndarray/arrays/memory/storage/TypedManualHandlingStorage;", "<init>", "()V", "storage", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lkotlin/collections/ArrayDeque;", "Lkotlin/UShortArray;", "getNDArray", "Lio/kinference/ndarray/arrays/MutableNDArrayCore;", "strides", "Lio/kinference/ndarray/arrays/Strides;", "fillZeros", "", "limiter", "Lio/kinference/ndarray/arrays/memory/MemoryManager;", "returnNDArray", "", "ndarray", "Lio/kinference/ndarray/arrays/NDArrayCore;", "clear", "Companion", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nUShortManualHandlingArrayStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UShortManualHandlingArrayStorage.kt\nio/kinference/ndarray/arrays/memory/storage/UShortManualHandlingArrayStorage\n+ 2 Utils.kt\nio/kinference/ndarray/extensions/utils/UtilsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,56:1\n57#2,7:57\n57#2,7:64\n216#3,2:71\n*S KotlinDebug\n*F\n+ 1 UShortManualHandlingArrayStorage.kt\nio/kinference/ndarray/arrays/memory/storage/UShortManualHandlingArrayStorage\n*L\n26#1:57,7\n46#1:64,7\n52#1:71,2\n*E\n"})
public final class UShortManualHandlingArrayStorage
implements TypedManualHandlingStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Int2ObjectOpenHashMap<ArrayDeque<UShortArray>> storage = new Int2ObjectOpenHashMap(64);
    @NotNull
    private static final DataType type = DataType.USHORT;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNDArrayCore getNDArray(@NotNull Strides strides, boolean fillZeros, @NotNull MemoryManager limiter2) {
        UShortArray[] uShortArrayArray;
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        Intrinsics.checkNotNullParameter((Object)limiter2, (String)"limiter");
        int blockSize = UtilsKt.blockSizeByStrides(strides);
        int blocksNum = strides.getLinearSize() / blockSize;
        if (limiter2.checkMemoryLimitAndAdd(UShortGetBlockFunctionsExtensionKt.getUShortArraySizeInBytes(blockSize * blocksNum))) {
            ArrayDeque arrayDeque;
            Int2ObjectOpenHashMap<ArrayDeque<UShortArray>> $this$getOrPut$iv = this.storage;
            boolean $i$f$getOrPut = false;
            ArrayDeque existingValue$iv = $this$getOrPut$iv.get(blockSize);
            if (existingValue$iv != null) {
                arrayDeque = existingValue$iv;
            } else {
                boolean bl = false;
                ArrayDeque value$iv = new ArrayDeque(blocksNum);
                $this$getOrPut$iv.put(blockSize, (ArrayDeque<UShortArray>)value$iv);
                arrayDeque = value$iv;
            }
            ArrayDeque queue = arrayDeque;
            UShortArray[] uShortArrayArray2 = new UShortArray[blocksNum];
            for (int i = 0; i < blocksNum; ++i) {
                short[] sArray;
                int n = i;
                UShortArray[] uShortArrayArray3 = uShortArrayArray2;
                int n2 = n;
                UShortArray uShortArray = (UShortArray)queue.removeFirstOrNull();
                Object object = uShortArray != null ? uShortArray.unbox-impl() : null;
                if (object != null) {
                    void $this$getNDArray_u24lambda_u241;
                    short[] sArray2;
                    short[] sArray3 = sArray2 = object;
                    int n3 = n2;
                    UShortArray[] uShortArrayArray4 = uShortArrayArray3;
                    boolean bl = false;
                    UArraysKt.fill-EtDCXyQ$default((short[])$this$getNDArray_u24lambda_u241, (short)UShortConstants.INSTANCE.getZERO-Mh2AYeg(), (int)0, (int)0, (int)6, null);
                    Unit unit = Unit.INSTANCE;
                    uShortArrayArray3 = uShortArrayArray4;
                    n2 = n3;
                    sArray = sArray2;
                } else {
                    sArray = UShortArray.constructor-impl((int)blockSize);
                }
                uShortArrayArray3[n2] = UShortArray.box-impl((short[])sArray);
            }
            uShortArrayArray = uShortArrayArray2;
        } else {
            int queue = 0;
            UShortArray[] uShortArrayArray5 = new UShortArray[blocksNum];
            while (queue < blocksNum) {
                int n = queue++;
                uShortArrayArray5[n] = UShortArray.box-impl((short[])UShortArray.constructor-impl((int)blockSize));
            }
            uShortArrayArray = uShortArrayArray5;
        }
        UShortArray[] blocks = uShortArrayArray;
        UShortTiledArray tiled = new UShortTiledArray(blocks);
        return new MutableUShortNDArray(tiled, strides);
    }

    @Override
    public void returnNDArray(@NotNull NDArrayCore ndarray) {
        ArrayDeque arrayDeque;
        Intrinsics.checkNotNullParameter((Object)ndarray, (String)"ndarray");
        if (!(ndarray instanceof UShortNDArray)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int blockSize = ((UShortNDArray)ndarray).getArray().getBlockSize();
        int blocksNum = ((UShortNDArray)ndarray).getArray().getBlocksNum();
        Int2ObjectOpenHashMap<ArrayDeque<UShortArray>> $this$getOrPut$iv = this.storage;
        boolean $i$f$getOrPut = false;
        ArrayDeque existingValue$iv = $this$getOrPut$iv.get(blockSize);
        if (existingValue$iv != null) {
            arrayDeque = existingValue$iv;
        } else {
            boolean bl = false;
            ArrayDeque value$iv = new ArrayDeque(blocksNum);
            $this$getOrPut$iv.put(blockSize, (ArrayDeque<UShortArray>)value$iv);
            arrayDeque = value$iv;
        }
        ArrayDeque queue = arrayDeque;
        CollectionsKt.addAll((Collection)((Collection)queue), (Object[])((UShortNDArray)ndarray).getArray().getBlocks());
    }

    @Override
    public void clear() {
        Map $this$forEach$iv = this.storage;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            ArrayDeque queue = (ArrayDeque)entry.getValue();
            queue.clear();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/kinference/ndarray/arrays/memory/storage/UShortManualHandlingArrayStorage$Companion;", "", "<init>", "()V", "type", "Lio/kinference/primitives/types/DataType;", "ndarray-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

