/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.tiled;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.ndarray.arrays.memory.contexts.AutoAllocatorContext;
import io.kinference.ndarray.arrays.memory.storage.ByteGetBlockFunctionsExtensionKt;
import io.kinference.ndarray.arrays.pointers.BytePointer;
import io.kinference.ndarray.arrays.pointers.BytePointerKt;
import io.kinference.ndarray.arrays.tiled.ByteTiledArray;
import io.kinference.primitives.types.DataType;
import io.kinference.utils.inlines.InlineInt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u000bJ\u0006\u0010\u0015\u001a\u00020\u0004J\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0018\u001a\u00020\u000bJ\u0011\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000bH\u0086\u0002J\u0019\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001aH\u0086\u0002J\u0006\u0010\u001e\u001a\u00020\u0000J,\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00002\b\b\u0002\u0010!\u001a\u00020\u000b2\b\b\u0002\u0010\"\u001a\u00020\u000b2\b\b\u0002\u0010#\u001a\u00020\u000bJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000J\u0016\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bJ\"\u0010)\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\b\b\u0002\u0010*\u001a\u00020\u000b2\b\b\u0002\u0010+\u001a\u00020\u000bR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006-"}, d2={"Lio/kinference/ndarray/arrays/tiled/ByteTiledArray;", "", "blocks", "", "", "<init>", "([[B)V", "getBlocks", "()[[B", "[[B", "size", "", "getSize", "()I", "blockSize", "getBlockSize", "blocksNum", "getBlocksNum", "pointer", "Lio/kinference/ndarray/arrays/pointers/BytePointer;", "startIndex", "toArray", "indexFor", "Lkotlin/Pair;", "i", "get", "", "set", "", "value", "copyOf", "copyInto", "dest", "destOffset", "srcStart", "srcEnd", "plus", "other", "copyOfRange", "fromIndex", "toIndex", "fill", "from", "to", "Companion", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nByteTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteTiledArray.kt\nio/kinference/ndarray/arrays/tiled/ByteTiledArray\n+ 2 BytePointer.kt\nio/kinference/ndarray/arrays/pointers/BytePointerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n953#2:189\n955#2,30:191\n953#2:221\n955#2,30:223\n1#3:190\n1#3:222\n*S KotlinDebug\n*F\n+ 1 ByteTiledArray.kt\nio/kinference/ndarray/arrays/tiled/ByteTiledArray\n*L\n147#1:189\n147#1:191,30\n153#1:221\n153#1:223,30\n147#1:190\n153#1:222\n*E\n"})
public final class ByteTiledArray {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[][] blocks;
    private final int size;
    private final int blockSize;
    private final int blocksNum;
    @NotNull
    private static final DataType type = DataType.BYTE;

    public ByteTiledArray(@NotNull byte[][] blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        this.blocks = blocks;
        this.blockSize = ((Object[])this.blocks).length == 0 ? 0 : ((byte[])ArraysKt.first((Object[])((Object[])this.blocks))).length;
        this.blocksNum = ((Object[])this.blocks).length;
        this.size = this.blocksNum * this.blockSize;
    }

    @NotNull
    public final byte[][] getBlocks() {
        return this.blocks;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final int getBlocksNum() {
        return this.blocksNum;
    }

    @NotNull
    public final BytePointer pointer(int startIndex) {
        return new BytePointer(this, startIndex);
    }

    public static /* synthetic */ BytePointer pointer$default(ByteTiledArray byteTiledArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return byteTiledArray.pointer(n);
    }

    @NotNull
    public final byte[] toArray() {
        if (this.size == 0) {
            return new byte[0];
        }
        byte[] array = new byte[this.size];
        int offset = 0;
        byte[][] byArray = this.blocks;
        int n = ((Object[])byArray).length;
        for (int i = 0; i < n; ++i) {
            byte[] block = byArray[i];
            ArraysKt.copyInto$default((byte[])block, (byte[])array, (int)offset, (int)0, (int)0, (int)12, null);
            offset += this.blockSize;
        }
        return array;
    }

    @NotNull
    public final Pair<Integer, Integer> indexFor(int i) {
        int blockIdx = i / this.blockSize;
        int blockOff = i % this.blockSize;
        return TuplesKt.to((Object)blockIdx, (Object)blockOff);
    }

    public final byte get(int i) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        return this.blocks[blockIdx][blockOff];
    }

    public final void set(int i, byte value) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        this.blocks[blockIdx][blockOff] = value;
    }

    @NotNull
    public final ByteTiledArray copyOf() {
        int n = 0;
        int n2 = this.blocksNum;
        byte[][] byArrayArray = new byte[n2][];
        while (n < n2) {
            int n3 = n++;
            byArrayArray[n3] = new byte[this.blockSize];
        }
        byte[][] copyBlocks = byArrayArray;
        n2 = this.blocksNum;
        for (int blockNum = 0; blockNum < n2; ++blockNum) {
            byte[] thisBlock = this.blocks[blockNum];
            byte[] destBlock = copyBlocks[blockNum];
            ArraysKt.copyInto$default((byte[])thisBlock, (byte[])destBlock, (int)0, (int)0, (int)0, (int)14, null);
        }
        return new ByteTiledArray(copyBlocks);
    }

    /*
     * WARNING - void declaration
     */
    public final void copyInto(@NotNull ByteTiledArray dest, int destOffset, int srcStart, int srcEnd) {
        void $this$accept$iv;
        BytePointer destPtr;
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (srcStart == srcEnd) {
            return;
        }
        BytePointer thisPtr = new BytePointer(this, srcStart);
        BytePointer bytePointer = destPtr = new BytePointer(dest, destOffset);
        int count$iv = srcEnd - srcStart;
        boolean $i$f$accept = false;
        if (!BytePointerKt.isCompatibleBySize((BytePointer)$this$accept$iv, thisPtr, count$iv)) {
            boolean $i$a$-require-BytePointerKt$accept$1$iv22 = false;
            String $i$a$-require-BytePointerKt$accept$1$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-BytePointerKt$accept$1$iv22.toString());
        }
        if (BytePointerKt.isCompatibleWith((BytePointer)$this$accept$iv, thisPtr)) {
            int dstOffset$iv;
            byte[] dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                byte[] srcBlock$iv = thisPtr.getCurrentBlock();
                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    thisPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    thisPtr.setIndexInBlock(thisPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void src;
                    byte cfr_ignored_0 = dstBlock$iv[index$iv];
                    byte by = srcBlock$iv[index$iv];
                    int n2 = index$iv++;
                    byte[] byArray = dstBlock$iv;
                    boolean bl = false;
                    void var20_26 = src;
                    byArray[n2] = var20_26;
                }
            }
        } else {
            while (end$iv > 0) {
                $this$accept$iv.get();
                byte src = thisPtr.getAndIncrement();
                void var18_23 = $this$accept$iv;
                boolean bl = false;
                byte by = src;
                var18_23.set(by);
                $this$accept$iv.increment();
                --end$iv;
            }
        }
    }

    public static /* synthetic */ void copyInto$default(ByteTiledArray byteTiledArray, ByteTiledArray byteTiledArray2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = byteTiledArray.size;
        }
        byteTiledArray.copyInto(byteTiledArray2, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteTiledArray plus(@NotNull ByteTiledArray other) {
        void $this$accept$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BytePointer thisPtr = new BytePointer(this, 0, 2, null);
        BytePointer destPtr = new BytePointer(other, 0, 2, null);
        BytePointer bytePointer = thisPtr;
        int count$iv = this.size;
        boolean $i$f$accept = false;
        if (!BytePointerKt.isCompatibleBySize((BytePointer)$this$accept$iv, destPtr, count$iv)) {
            boolean $i$a$-require-BytePointerKt$accept$1$iv22 = false;
            String $i$a$-require-BytePointerKt$accept$1$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-BytePointerKt$accept$1$iv22.toString());
        }
        if (BytePointerKt.isCompatibleWith((BytePointer)$this$accept$iv, destPtr)) {
            int dstOffset$iv;
            byte[] dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                byte[] srcBlock$iv = destPtr.getCurrentBlock();
                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    destPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    destPtr.setIndexInBlock(destPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void dst;
                    void src;
                    byte by;
                    byte by2 = srcBlock$iv[index$iv];
                    byte by3 = dstBlock$iv[index$iv];
                    int n2 = index$iv++;
                    byte[] byArray = dstBlock$iv;
                    boolean bl = false;
                    byArray[n2] = by = (byte)(src + dst);
                }
            }
        } else {
            while (end$iv > 0) {
                byte dst = destPtr.getAndIncrement();
                byte src = $this$accept$iv.get();
                void var16_22 = $this$accept$iv;
                boolean bl = false;
                byte by = (byte)(src + dst);
                var16_22.set(by);
                $this$accept$iv.increment();
                --end$iv;
            }
        }
        return this;
    }

    @NotNull
    public final byte[] copyOfRange(int fromIndex, int toIndex) {
        byte[] array = new byte[toIndex - fromIndex];
        BytePointer pointer = new BytePointer(this, fromIndex);
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = pointer.getAndIncrement();
        }
        return array;
    }

    public final void fill(byte value, int from, int to) {
        if (from == to) {
            return;
        }
        BytePointer pointer = new BytePointer(this, from);
        for (int count = to - from; count > 0; count -= this.blockSize) {
            byte[] block = pointer.getCurrentBlock();
            int offset = pointer.getIndexInBlock();
            pointer.blockIncrement();
            ArraysKt.fill((byte[])block, (byte)value, (int)offset, (int)Math.min(this.blockSize, count + offset));
        }
    }

    public static /* synthetic */ void fill$default(ByteTiledArray byteTiledArray, byte by, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byteTiledArray.size;
        }
        byteTiledArray.fill(by, n, n2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086B\u00a2\u0006\u0002\u0010\fJ*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0086B\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0086B\u00a2\u0006\u0002\u0010\u0014J*\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0086B\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0086B\u00a2\u0006\u0002\u0010\u001bJ2\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0086B\u00a2\u0006\u0002\u0010\u001cJ\"\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00100\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lio/kinference/ndarray/arrays/tiled/ByteTiledArray$Companion;", "", "<init>", "()V", "type", "Lio/kinference/primitives/types/DataType;", "getType", "()Lio/kinference/primitives/types/DataType;", "invoke", "Lio/kinference/ndarray/arrays/tiled/ByteTiledArray;", "strides", "Lio/kinference/ndarray/arrays/Strides;", "(Lio/kinference/ndarray/arrays/Strides;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "init", "Lkotlin/Function1;", "Lio/kinference/utils/inlines/InlineInt;", "", "(Lio/kinference/ndarray/arrays/Strides;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shape", "", "([ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "([ILkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "array", "", "size", "", "blockSize", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(IILkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "matrixLike", "ndarray-core"})
    @SourceDebugExtension(value={"SMAP\nByteTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteTiledArray.kt\nio/kinference/ndarray/arrays/tiled/ByteTiledArray$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataType getType() {
            return type;
        }

        @Nullable
        public final Object invoke(@NotNull Strides strides, @NotNull Continuation<? super ByteTiledArray> $completion) {
            int blockSize = UtilsKt.blockSizeByStrides(strides);
            return Companion.invoke(strides.getLinearSize(), blockSize, $completion);
        }

        @Nullable
        public final Object invoke(@NotNull Strides strides, @NotNull Function1<? super InlineInt, Byte> init, @NotNull Continuation<? super ByteTiledArray> $completion) {
            int blockSize = UtilsKt.blockSizeByStrides(strides);
            return Companion.invoke(strides.getLinearSize(), blockSize, init, $completion);
        }

        @Nullable
        public final Object invoke(@NotNull int[] shape, @NotNull Continuation<? super ByteTiledArray> $completion) {
            return this.invoke(new Strides(shape), $completion);
        }

        @Nullable
        public final Object invoke(@NotNull int[] shape, @NotNull Function1<? super InlineInt, Byte> init, @NotNull Continuation<? super ByteTiledArray> $completion) {
            return this.invoke(new Strides(shape), init, $completion);
        }

        @NotNull
        public final ByteTiledArray invoke(@NotNull Strides strides, @NotNull byte[] array) {
            Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int blockSize = UtilsKt.blockSizeByStrides(strides);
            int countBlocks = array.length / blockSize;
            int n = 0;
            byte[][] byArrayArray = new byte[countBlocks][];
            while (n < countBlocks) {
                int n2 = n++;
                byArrayArray[n2] = new byte[blockSize];
            }
            byte[][] blocksArray = byArrayArray;
            n = 0;
            while (n < countBlocks) {
                int blockNum = n++;
                boolean bl = false;
                ArraysKt.copyInto$default((byte[])array, (byte[])blocksArray[blockNum], (int)0, (int)(blockNum * blockSize), (int)((blockNum + 1) * blockSize), (int)2, null);
            }
            return new ByteTiledArray(blocksArray);
        }

        @Nullable
        public final Object invoke(int size, int blockSize, @NotNull Continuation<? super ByteTiledArray> $completion) {
            Object object;
            block6: {
                int blocksNum;
                block5: {
                    if (blockSize != 0 && !(size % blockSize == 0)) {
                        boolean $i$a$-require-ByteTiledArray$Companion$invoke$82 = false;
                        String $i$a$-require-ByteTiledArray$Companion$invoke$82 = "Size must divide blockSize";
                        throw new IllegalArgumentException($i$a$-require-ByteTiledArray$Companion$invoke$82.toString());
                    }
                    blocksNum = blockSize == 0 ? 0 : size / blockSize;
                    object = (AutoAllocatorContext)$completion.getContext().get((CoroutineContext.Key)AutoAllocatorContext.Key);
                    if (object == null) break block5;
                    byte[][] byArray = ByteGetBlockFunctionsExtensionKt.getByteBlock(object, blocksNum, blockSize);
                    object = byArray;
                    if (byArray != null) break block6;
                }
                int n = 0;
                byte[][] byArrayArray = new byte[blocksNum][];
                while (n < blocksNum) {
                    int n2 = n++;
                    byArrayArray[n2] = new byte[blockSize];
                }
                object = byArrayArray;
            }
            Object blocks = object;
            return new ByteTiledArray((byte[][])blocks);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object invoke(int var1_1, int var2_2, @NotNull Function1<? super InlineInt, Byte> var3_3, @NotNull Continuation<? super ByteTiledArray> $completion) {
            if (!($completion instanceof invoke.8)) ** GOTO lbl-1000
            var13_5 = $completion;
            if ((var13_5.label & -2147483648) != 0) {
                var13_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    int I$0;
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.invoke(0, 0, null, (Continuation<? super ByteTiledArray>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var14_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = init;
                    $continuation.I$0 = blockSize;
                    $continuation.label = 1;
                    v0 = ByteTiledArray.Companion.invoke((int)size, blockSize, (Continuation<? super ByteTiledArray>)$continuation);
                    if (v0 == var14_7) {
                        return var14_7;
                    }
                    ** GOTO lbl24
                }
                case 1: {
                    blockSize = $continuation.I$0;
                    init = (Function1)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    tiledArray = (ByteTiledArray)v0;
                    count = 0;
                    var7_10 = tiledArray.getBlocks();
                    var9_12 = ((Object[])var7_10).length;
                    for (var8_11 = 0; var8_11 < var9_12; ++var8_11) {
                        block = var7_10[var8_11];
                        for (idx = 0; idx < blockSize; ++idx) {
                            block[idx] = ((Number)init.invoke((Object)InlineInt.box-impl(InlineInt.constructor-impl(count++)))).byteValue();
                        }
                    }
                    return tiledArray;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @NotNull
        public final ByteTiledArray matrixLike(@NotNull int[] shape, @NotNull Function1<? super Integer, Byte> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            if (!(shape.length == 1 || shape.length == 2)) {
                boolean $i$a$-require-ByteTiledArray$Companion$matrixLike$22 = false;
                String $i$a$-require-ByteTiledArray$Companion$matrixLike$22 = "NDArray should be of rank <= 2. Got rank=" + shape.length;
                throw new IllegalArgumentException($i$a$-require-ByteTiledArray$Companion$matrixLike$22.toString());
            }
            int count = 0;
            int blockSize = ArraysKt.last((int[])shape);
            int blocksNum = shape.length == 1 ? 1 : shape[0];
            int n = 0;
            byte[][] byArrayArray = new byte[blocksNum][];
            while (n < blocksNum) {
                int n2 = n++;
                byArrayArray[n2] = new byte[blockSize];
            }
            byte[][] blocks = byArrayArray;
            int n3 = ((Object[])blocks).length;
            for (n = 0; n < n3; ++n) {
                byte[] block = blocks[n];
                for (int idx = 0; idx < blockSize; ++idx) {
                    block[idx] = ((Number)init.invoke((Object)count++)).byteValue();
                }
            }
            return new ByteTiledArray(blocks);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

