/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.extensions.broadcasting;

import io.kinference.ndarray.arrays.MutableUByteNDArray;
import io.kinference.ndarray.arrays.UByteBinaryOperation;
import io.kinference.ndarray.arrays.UByteNDArray;
import io.kinference.ndarray.extensions.broadcasting.BroadcastingInfo;
import io.kinference.ndarray.extensions.broadcasting.ReshapeViewKt;
import io.kinference.ndarray.extensions.broadcasting.ScalarBroadcastFun;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.UByteArray;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a(\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"broadcastTwoTensorsUByte", "Lio/kinference/ndarray/arrays/MutableUByteNDArray;", "left", "Lio/kinference/ndarray/arrays/UByteNDArray;", "right", "dest", "op", "Lio/kinference/ndarray/arrays/UByteBinaryOperation;", "executeWithoutBroadcasting", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nBroadcastTwoArgumentsUByte.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BroadcastTwoArgumentsUByte.kt\nio/kinference/ndarray/extensions/broadcasting/BroadcastTwoArgumentsUByteKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class BroadcastTwoArgumentsUByteKt {
    @NotNull
    public static final MutableUByteNDArray broadcastTwoTensorsUByte(@NotNull UByteNDArray left, @NotNull UByteNDArray right, @NotNull MutableUByteNDArray dest, @NotNull UByteBinaryOperation op) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Object[] objectArray = new UByteNDArray[]{left, right};
        BroadcastingInfo broadcastingInfo = BroadcastingInfo.Companion.create(CollectionsKt.listOf((Object[])objectArray));
        if (!Arrays.equals(dest.getShape(), broadcastingInfo.getDestShape())) {
            boolean bl = false;
            String string = "Destination has incorrect shape, expected: " + ArraysKt.joinToString$default((int[])broadcastingInfo.getDestShape(), null, null, null, (int)0, null, null, (int)63, null) + ", actual " + ArraysKt.joinToString$default((int[])dest.getShape(), null, null, null, (int)0, null, null, (int)63, null);
            throw new IllegalArgumentException(string.toString());
        }
        if (broadcastingInfo.getBroadcastingAxes().isEmpty()) {
            return BroadcastTwoArgumentsUByteKt.executeWithoutBroadcasting(left, right, dest, op);
        }
        int totalAxesToBroadcast = broadcastingInfo.getBroadcastAlongLastAxis() ? broadcastingInfo.getBroadcastingAxes().size() - 1 : broadcastingInfo.getBroadcastingAxes().size();
        int[][] nArray = broadcastingInfo.getBroadcastingShapes();
        int[] leftBroadcastingShape = (int[])((Object[])nArray)[0];
        int[] rightBroadcastingShape = (int[])((Object[])nArray)[1];
        int[] destBroadcastingShape = broadcastingInfo.getBroadcastingDestShape();
        int destBlocksInRow = ArraysKt.last((int[])destBroadcastingShape) / dest.getArray().getBlockSize();
        int[] leftOffsets = ReshapeViewKt.makeOffsets(leftBroadcastingShape, ArraysKt.last((int[])leftBroadcastingShape) / left.getArray().getBlockSize());
        int[] rightOffsets = ReshapeViewKt.makeOffsets(rightBroadcastingShape, ArraysKt.last((int[])rightBroadcastingShape) / right.getArray().getBlockSize());
        int[] destOffsets = ReshapeViewKt.makeOffsets(destBroadcastingShape, destBlocksInRow);
        boolean leftIsScalar = broadcastingInfo.getBroadcastAlongLastAxis() && ArraysKt.last((int[])leftBroadcastingShape) == 1;
        boolean rightIsScalar = broadcastingInfo.getBroadcastAlongLastAxis() && ArraysKt.last((int[])rightBroadcastingShape) == 1;
        UByteArray[] leftBlocks = left.getArray().getBlocks();
        UByteArray[] rightBlocks = right.getArray().getBlocks();
        UByteArray[] destBlocks = dest.getArray().getBlocks();
        ScalarBroadcastFun leftIsScalarFun = (arg_0, arg_1, arg_2, arg_3) -> BroadcastTwoArgumentsUByteKt.broadcastTwoTensorsUByte$lambda$1(destBroadcastingShape, leftOffsets, rightOffsets, destOffsets, leftBlocks, destBlocksInRow, destBlocks, rightBlocks, op, arg_0, arg_1, arg_2, arg_3);
        ScalarBroadcastFun rightIsScalarFun = (arg_0, arg_1, arg_2, arg_3) -> BroadcastTwoArgumentsUByteKt.broadcastTwoTensorsUByte$lambda$2(destBroadcastingShape, leftOffsets, rightOffsets, destOffsets, rightBlocks, destBlocksInRow, destBlocks, leftBlocks, op, arg_0, arg_1, arg_2, arg_3);
        ScalarBroadcastFun defaultFun = (arg_0, arg_1, arg_2, arg_3) -> BroadcastTwoArgumentsUByteKt.broadcastTwoTensorsUByte$lambda$3(destBlocksInRow, leftBlocks, rightBlocks, destBlocks, op, arg_0, arg_1, arg_2, arg_3);
        ScalarBroadcastFun broadcastingFun = leftIsScalar ? leftIsScalarFun : (rightIsScalar ? rightIsScalarFun : defaultFun);
        BroadcastTwoArgumentsUByteKt.broadcastTwoTensorsUByte$broadcast(totalAxesToBroadcast, broadcastingFun, destBroadcastingShape, leftOffsets, rightOffsets, destOffsets, leftBroadcastingShape, rightBroadcastingShape, 0, 0, 0, 0);
        return dest;
    }

    private static final MutableUByteNDArray executeWithoutBroadcasting(UByteNDArray left, UByteNDArray right, MutableUByteNDArray dest, UByteBinaryOperation op) {
        UByteArray[] leftBlocks = left.getArray().getBlocks();
        UByteArray[] rightBlocks = right.getArray().getBlocks();
        UByteArray[] destBlocks = dest.getArray().getBlocks();
        int n = destBlocks.length;
        for (int blockIdx = 0; blockIdx < n; ++blockIdx) {
            byte[] destBlock = destBlocks[blockIdx].unbox-impl();
            byte[] leftBlock = leftBlocks[blockIdx].unbox-impl();
            byte[] rightBlock = rightBlocks[blockIdx].unbox-impl();
            int n2 = UByteArray.getSize-impl((byte[])destBlock);
            for (int idx = 0; idx < n2; ++idx) {
                UByteArray.set-VurrAj0((byte[])destBlock, (int)idx, (byte)op.invoke-bFBRPgc(UByteArray.get-w2LRezQ((byte[])leftBlock, (int)idx), UByteArray.get-w2LRezQ((byte[])rightBlock, (int)idx)));
            }
        }
        return dest;
    }

    private static final void broadcastTwoTensorsUByte$lambda$1(int[] $destBroadcastingShape, int[] $leftOffsets, int[] $rightOffsets, int[] $destOffsets, UByteArray[] $leftBlocks, int $destBlocksInRow, UByteArray[] $destBlocks, UByteArray[] $rightBlocks, UByteBinaryOperation $op, int leftOffset, int rightOffset, int destOffset, int axisToBroadcastIdx) {
        Intrinsics.checkNotNullParameter((Object)$destBroadcastingShape, (String)"$destBroadcastingShape");
        Intrinsics.checkNotNullParameter((Object)$leftOffsets, (String)"$leftOffsets");
        Intrinsics.checkNotNullParameter((Object)$rightOffsets, (String)"$rightOffsets");
        Intrinsics.checkNotNullParameter((Object)$destOffsets, (String)"$destOffsets");
        Intrinsics.checkNotNullParameter((Object)$leftBlocks, (String)"$leftBlocks");
        Intrinsics.checkNotNullParameter((Object)$destBlocks, (String)"$destBlocks");
        Intrinsics.checkNotNullParameter((Object)$rightBlocks, (String)"$rightBlocks");
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        int shapeIdx = axisToBroadcastIdx * 2;
        int batchSize = $destBroadcastingShape[shapeIdx];
        for (int batchIdx = 0; batchIdx < batchSize; ++batchIdx) {
            int leftBatchOffset = leftOffset + $leftOffsets[shapeIdx] * batchIdx;
            int rightBatchOffset = rightOffset + $rightOffsets[shapeIdx] * batchIdx;
            int destBatchOffset = destOffset + $destOffsets[shapeIdx] * batchIdx;
            byte leftScalar = UByteArray.get-w2LRezQ((byte[])$leftBlocks[leftBatchOffset].unbox-impl(), (int)0);
            for (int blockIdx = 0; blockIdx < $destBlocksInRow; ++blockIdx) {
                byte[] destBlock = $destBlocks[destBatchOffset + blockIdx].unbox-impl();
                byte[] rightBlock = $rightBlocks[rightBatchOffset + blockIdx].unbox-impl();
                int n = UByteArray.getSize-impl((byte[])destBlock);
                for (int idx = 0; idx < n; ++idx) {
                    UByteArray.set-VurrAj0((byte[])destBlock, (int)idx, (byte)$op.invoke-bFBRPgc(leftScalar, UByteArray.get-w2LRezQ((byte[])rightBlock, (int)idx)));
                }
            }
        }
    }

    private static final void broadcastTwoTensorsUByte$lambda$2(int[] $destBroadcastingShape, int[] $leftOffsets, int[] $rightOffsets, int[] $destOffsets, UByteArray[] $rightBlocks, int $destBlocksInRow, UByteArray[] $destBlocks, UByteArray[] $leftBlocks, UByteBinaryOperation $op, int leftOffset, int rightOffset, int destOffset, int axisToBroadcastIdx) {
        Intrinsics.checkNotNullParameter((Object)$destBroadcastingShape, (String)"$destBroadcastingShape");
        Intrinsics.checkNotNullParameter((Object)$leftOffsets, (String)"$leftOffsets");
        Intrinsics.checkNotNullParameter((Object)$rightOffsets, (String)"$rightOffsets");
        Intrinsics.checkNotNullParameter((Object)$destOffsets, (String)"$destOffsets");
        Intrinsics.checkNotNullParameter((Object)$rightBlocks, (String)"$rightBlocks");
        Intrinsics.checkNotNullParameter((Object)$destBlocks, (String)"$destBlocks");
        Intrinsics.checkNotNullParameter((Object)$leftBlocks, (String)"$leftBlocks");
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        int shapeIdx = axisToBroadcastIdx * 2;
        int batchSize = $destBroadcastingShape[shapeIdx];
        for (int batchIdx = 0; batchIdx < batchSize; ++batchIdx) {
            int leftBatchOffset = leftOffset + $leftOffsets[shapeIdx] * batchIdx;
            int rightBatchOffset = rightOffset + $rightOffsets[shapeIdx] * batchIdx;
            int destBatchOffset = destOffset + $destOffsets[shapeIdx] * batchIdx;
            byte rightScalar = UByteArray.get-w2LRezQ((byte[])$rightBlocks[rightBatchOffset].unbox-impl(), (int)0);
            for (int blockIdx = 0; blockIdx < $destBlocksInRow; ++blockIdx) {
                byte[] destBlock = $destBlocks[destBatchOffset + blockIdx].unbox-impl();
                byte[] leftBlock = $leftBlocks[leftBatchOffset + blockIdx].unbox-impl();
                int n = UByteArray.getSize-impl((byte[])destBlock);
                for (int idx = 0; idx < n; ++idx) {
                    UByteArray.set-VurrAj0((byte[])destBlock, (int)idx, (byte)$op.invoke-bFBRPgc(UByteArray.get-w2LRezQ((byte[])leftBlock, (int)idx), rightScalar));
                }
            }
        }
    }

    private static final void broadcastTwoTensorsUByte$lambda$3(int $destBlocksInRow, UByteArray[] $leftBlocks, UByteArray[] $rightBlocks, UByteArray[] $destBlocks, UByteBinaryOperation $op, int leftOffset, int rightOffset, int destOffset, int n) {
        Intrinsics.checkNotNullParameter((Object)$leftBlocks, (String)"$leftBlocks");
        Intrinsics.checkNotNullParameter((Object)$rightBlocks, (String)"$rightBlocks");
        Intrinsics.checkNotNullParameter((Object)$destBlocks, (String)"$destBlocks");
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        for (int blockIdx = 0; blockIdx < $destBlocksInRow; ++blockIdx) {
            byte[] leftBlock = $leftBlocks[leftOffset + blockIdx].unbox-impl();
            byte[] rightBlock = $rightBlocks[rightOffset + blockIdx].unbox-impl();
            byte[] destBlock = $destBlocks[destOffset + blockIdx].unbox-impl();
            int n2 = UByteArray.getSize-impl((byte[])destBlock);
            for (int idx = 0; idx < n2; ++idx) {
                UByteArray.set-VurrAj0((byte[])destBlock, (int)idx, (byte)$op.invoke-bFBRPgc(UByteArray.get-w2LRezQ((byte[])leftBlock, (int)idx), UByteArray.get-w2LRezQ((byte[])rightBlock, (int)idx)));
            }
        }
    }

    private static final void broadcastTwoTensorsUByte$broadcast(int totalAxesToBroadcast, ScalarBroadcastFun broadcastingFun, int[] destBroadcastingShape, int[] leftOffsets, int[] rightOffsets, int[] destOffsets, int[] leftBroadcastingShape, int[] rightBroadcastingShape, int leftOffset, int rightOffset, int destOffset, int axisToBroadcastIdx) {
        if (axisToBroadcastIdx == totalAxesToBroadcast) {
            broadcastingFun.invoke(leftOffset, rightOffset, destOffset, axisToBroadcastIdx);
        } else {
            int shapeIdx = axisToBroadcastIdx * 2;
            int batchSize = destBroadcastingShape[shapeIdx];
            int dimSize = destBroadcastingShape[shapeIdx + 1];
            for (int batchIdx = 0; batchIdx < batchSize; ++batchIdx) {
                int leftBatchOffset = leftOffset + leftOffsets[shapeIdx] * batchIdx;
                int rightBatchOffset = rightOffset + rightOffsets[shapeIdx] * batchIdx;
                int destBatchOffset = destOffset + destOffsets[shapeIdx] * batchIdx;
                for (int dimIdx = 0; dimIdx < dimSize; ++dimIdx) {
                    int leftFullOffset = leftBatchOffset + dimIdx % leftBroadcastingShape[shapeIdx + 1] * leftOffsets[shapeIdx + 1];
                    int rightFullOffset = rightBatchOffset + dimIdx % rightBroadcastingShape[shapeIdx + 1] * rightOffsets[shapeIdx + 1];
                    int destFullOffset = destBatchOffset + dimIdx * destOffsets[shapeIdx + 1];
                    BroadcastTwoArgumentsUByteKt.broadcastTwoTensorsUByte$broadcast(totalAxesToBroadcast, broadcastingFun, destBroadcastingShape, leftOffsets, rightOffsets, destOffsets, leftBroadcastingShape, rightBroadcastingShape, leftFullOffset, rightFullOffset, destFullOffset, axisToBroadcastIdx + 1);
                }
            }
        }
    }
}

