/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.extensions.utils;

import io.kinference.ndarray.extensions.utils.UtilsKt;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b)\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u00018BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\tJ\u000e\u0010'\u001a\u00020\t2\u0006\u0010&\u001a\u00020\tJ\u000e\u0010(\u001a\u00020\t2\u0006\u0010&\u001a\u00020\tJ\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\tH\u00c6\u0003J\t\u0010/\u001a\u00020\tH\u00c6\u0003J\t\u00100\u001a\u00020\tH\u00c6\u0003JY\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\tH\u00c6\u0001J\u0013\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00105\u001a\u00020\tH\u00d6\u0001J\t\u00106\u001a\u000207H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u001b\u0010\u0018\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0019\u0010\u000fR\u001b\u0010\u001c\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001b\u001a\u0004\b\u001d\u0010\u0015R\u001b\u0010\u001f\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001b\u001a\u0004\b \u0010\u0015R\u001b\u0010\"\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u001b\u001a\u0004\b#\u0010\u0015\u00a8\u00069"}, d2={"Lio/kinference/ndarray/extensions/utils/InputInfo;", "", "inputShape", "", "kernelShape", "pads", "strides", "dilations", "groups", "", "rank", "ceilMode", "<init>", "([I[I[I[I[IIII)V", "getInputShape", "()[I", "getKernelShape", "getPads", "getStrides", "getDilations", "getGroups", "()I", "getRank", "getCeilMode", "outputShape", "getOutputShape", "outputShape$delegate", "Lkotlin/Lazy;", "inputSize", "getInputSize", "inputSize$delegate", "kernelSize", "getKernelSize", "kernelSize$delegate", "outputSize", "getOutputSize", "outputSize$delegate", "padBegin", "i", "padEnd", "padTotal", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "toString", "", "Builder", "ndarray-core"})
public final class InputInfo {
    @NotNull
    private final int[] inputShape;
    @NotNull
    private final int[] kernelShape;
    @NotNull
    private final int[] pads;
    @NotNull
    private final int[] strides;
    @NotNull
    private final int[] dilations;
    private final int groups;
    private final int rank;
    private final int ceilMode;
    @NotNull
    private final Lazy outputShape$delegate;
    @NotNull
    private final Lazy inputSize$delegate;
    @NotNull
    private final Lazy kernelSize$delegate;
    @NotNull
    private final Lazy outputSize$delegate;

    public InputInfo(@NotNull int[] inputShape, @NotNull int[] kernelShape, @NotNull int[] pads, @NotNull int[] strides, @NotNull int[] dilations, int groups, int rank, int ceilMode) {
        Intrinsics.checkNotNullParameter((Object)inputShape, (String)"inputShape");
        Intrinsics.checkNotNullParameter((Object)kernelShape, (String)"kernelShape");
        Intrinsics.checkNotNullParameter((Object)pads, (String)"pads");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        Intrinsics.checkNotNullParameter((Object)dilations, (String)"dilations");
        this.inputShape = inputShape;
        this.kernelShape = kernelShape;
        this.pads = pads;
        this.strides = strides;
        this.dilations = dilations;
        this.groups = groups;
        this.rank = rank;
        this.ceilMode = ceilMode;
        this.outputShape$delegate = LazyKt.lazy(() -> InputInfo.outputShape_delegate$lambda$0(this));
        this.inputSize$delegate = LazyKt.lazy(() -> InputInfo.inputSize_delegate$lambda$1(this));
        this.kernelSize$delegate = LazyKt.lazy(() -> InputInfo.kernelSize_delegate$lambda$2(this));
        this.outputSize$delegate = LazyKt.lazy(() -> InputInfo.outputSize_delegate$lambda$3(this));
    }

    @NotNull
    public final int[] getInputShape() {
        return this.inputShape;
    }

    @NotNull
    public final int[] getKernelShape() {
        return this.kernelShape;
    }

    @NotNull
    public final int[] getPads() {
        return this.pads;
    }

    @NotNull
    public final int[] getStrides() {
        return this.strides;
    }

    @NotNull
    public final int[] getDilations() {
        return this.dilations;
    }

    public final int getGroups() {
        return this.groups;
    }

    public final int getRank() {
        return this.rank;
    }

    public final int getCeilMode() {
        return this.ceilMode;
    }

    @NotNull
    public final int[] getOutputShape() {
        Lazy lazy = this.outputShape$delegate;
        return (int[])lazy.getValue();
    }

    public final int getInputSize() {
        Lazy lazy = this.inputSize$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getKernelSize() {
        Lazy lazy = this.kernelSize$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getOutputSize() {
        Lazy lazy = this.outputSize$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int padBegin(int i) {
        return this.pads[i];
    }

    public final int padEnd(int i) {
        return this.pads[i + this.rank];
    }

    public final int padTotal(int i) {
        return this.padBegin(i) + this.padEnd(i);
    }

    @NotNull
    public final int[] component1() {
        return this.inputShape;
    }

    @NotNull
    public final int[] component2() {
        return this.kernelShape;
    }

    @NotNull
    public final int[] component3() {
        return this.pads;
    }

    @NotNull
    public final int[] component4() {
        return this.strides;
    }

    @NotNull
    public final int[] component5() {
        return this.dilations;
    }

    public final int component6() {
        return this.groups;
    }

    public final int component7() {
        return this.rank;
    }

    public final int component8() {
        return this.ceilMode;
    }

    @NotNull
    public final InputInfo copy(@NotNull int[] inputShape, @NotNull int[] kernelShape, @NotNull int[] pads, @NotNull int[] strides, @NotNull int[] dilations, int groups, int rank, int ceilMode) {
        Intrinsics.checkNotNullParameter((Object)inputShape, (String)"inputShape");
        Intrinsics.checkNotNullParameter((Object)kernelShape, (String)"kernelShape");
        Intrinsics.checkNotNullParameter((Object)pads, (String)"pads");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        Intrinsics.checkNotNullParameter((Object)dilations, (String)"dilations");
        return new InputInfo(inputShape, kernelShape, pads, strides, dilations, groups, rank, ceilMode);
    }

    public static /* synthetic */ InputInfo copy$default(InputInfo inputInfo, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            nArray = inputInfo.inputShape;
        }
        if ((n4 & 2) != 0) {
            nArray2 = inputInfo.kernelShape;
        }
        if ((n4 & 4) != 0) {
            nArray3 = inputInfo.pads;
        }
        if ((n4 & 8) != 0) {
            nArray4 = inputInfo.strides;
        }
        if ((n4 & 0x10) != 0) {
            nArray5 = inputInfo.dilations;
        }
        if ((n4 & 0x20) != 0) {
            n = inputInfo.groups;
        }
        if ((n4 & 0x40) != 0) {
            n2 = inputInfo.rank;
        }
        if ((n4 & 0x80) != 0) {
            n3 = inputInfo.ceilMode;
        }
        return inputInfo.copy(nArray, nArray2, nArray3, nArray4, nArray5, n, n2, n3);
    }

    @NotNull
    public String toString() {
        return "InputInfo(inputShape=" + Arrays.toString(this.inputShape) + ", kernelShape=" + Arrays.toString(this.kernelShape) + ", pads=" + Arrays.toString(this.pads) + ", strides=" + Arrays.toString(this.strides) + ", dilations=" + Arrays.toString(this.dilations) + ", groups=" + this.groups + ", rank=" + this.rank + ", ceilMode=" + this.ceilMode + ")";
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.inputShape);
        result = result * 31 + Arrays.hashCode(this.kernelShape);
        result = result * 31 + Arrays.hashCode(this.pads);
        result = result * 31 + Arrays.hashCode(this.strides);
        result = result * 31 + Arrays.hashCode(this.dilations);
        result = result * 31 + Integer.hashCode(this.groups);
        result = result * 31 + Integer.hashCode(this.rank);
        result = result * 31 + Integer.hashCode(this.ceilMode);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InputInfo)) {
            return false;
        }
        InputInfo inputInfo = (InputInfo)other;
        if (!Intrinsics.areEqual((Object)this.inputShape, (Object)inputInfo.inputShape)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.kernelShape, (Object)inputInfo.kernelShape)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pads, (Object)inputInfo.pads)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.strides, (Object)inputInfo.strides)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dilations, (Object)inputInfo.dilations)) {
            return false;
        }
        if (this.groups != inputInfo.groups) {
            return false;
        }
        if (this.rank != inputInfo.rank) {
            return false;
        }
        return this.ceilMode == inputInfo.ceilMode;
    }

    private static final int[] outputShape_delegate$lambda$0(InputInfo this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int n = this$0.rank;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            int inputWithPad = this$0.inputShape[n2] + this$0.padTotal(n2);
            int kernelWithDilation = (this$0.kernelShape[n2] - 1) * this$0.dilations[n2] + 1;
            nArray[n2] = this$0.ceilMode == 1 ? UtilsKt.divCeil(inputWithPad - kernelWithDilation, this$0.strides[n2]) + 1 : (inputWithPad - kernelWithDilation) / this$0.strides[n2] + 1;
        }
        return nArray;
    }

    private static final int inputSize_delegate$lambda$1(InputInfo this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return UtilsKt.inferShapeSize(this$0.inputShape);
    }

    private static final int kernelSize_delegate$lambda$2(InputInfo this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return UtilsKt.inferShapeSize(this$0.kernelShape);
    }

    private static final int outputSize_delegate$lambda$3(InputInfo this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return UtilsKt.inferShapeSize(this$0.getOutputShape());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001:\u00014Bm\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\u0012\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\b\u0010\u001d\u001a\u00020\u0007H\u0002J\b\u0010\u001e\u001a\u00020\u0007H\u0002J\b\u0010\u001f\u001a\u00020\u0007H\u0002J\b\u0010 \u001a\u00020\u0007H\u0002J\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003\u00a2\u0006\u0002\u0010$J\t\u0010%\u001a\u00020\u0005H\u00c2\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0007H\u00c2\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0007H\u00c2\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0007H\u00c2\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0007H\u00c2\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\u0007H\u00c2\u0003J\t\u0010+\u001a\u00020\u0003H\u00c2\u0003J\t\u0010,\u001a\u00020\u0003H\u00c2\u0003Jt\u0010-\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010.J\u0013\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u00020\u0003H\u00d6\u0001J\t\u00103\u001a\u00020\u0016H\u00d6\u0001R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lio/kinference/ndarray/extensions/utils/InputInfo$Builder;", "", "dimensions", "", "autoPad", "Lio/kinference/ndarray/extensions/utils/InputInfo$Builder$AutoPad;", "pads", "", "strides", "dilations", "inputShape", "kernelShape", "groups", "ceilMode", "<init>", "(Ljava/lang/Integer;Lio/kinference/ndarray/extensions/utils/InputInfo$Builder$AutoPad;[I[I[I[I[III)V", "Ljava/lang/Integer;", "specifyDimensions", "specifyPads", "specifyInputShape", "specifyKernelShape", "specifyAutoPad", "", "specifyStrides", "specifyDilations", "specifyGroups", "specifyCeilMode", "ones", "size", "defaultStrides", "defaultDilations", "defaultPads", "inferPads", "build", "Lio/kinference/ndarray/extensions/utils/InputInfo;", "component1", "()Ljava/lang/Integer;", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/Integer;Lio/kinference/ndarray/extensions/utils/InputInfo$Builder$AutoPad;[I[I[I[I[III)Lio/kinference/ndarray/extensions/utils/InputInfo$Builder;", "equals", "", "other", "hashCode", "toString", "AutoPad", "ndarray-core"})
    @SourceDebugExtension(value={"SMAP\nInputInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputInfo.kt\nio/kinference/ndarray/extensions/utils/InputInfo$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
    public static final class Builder {
        @Nullable
        private Integer dimensions;
        @NotNull
        private AutoPad autoPad;
        @Nullable
        private int[] pads;
        @Nullable
        private int[] strides;
        @Nullable
        private int[] dilations;
        @Nullable
        private int[] inputShape;
        @Nullable
        private int[] kernelShape;
        private int groups;
        private int ceilMode;

        public Builder(@Nullable Integer dimensions, @NotNull AutoPad autoPad, @Nullable int[] pads, @Nullable int[] strides, @Nullable int[] dilations, @Nullable int[] inputShape, @Nullable int[] kernelShape, int groups, int ceilMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)autoPad), (String)"autoPad");
            this.dimensions = dimensions;
            this.autoPad = autoPad;
            this.pads = pads;
            this.strides = strides;
            this.dilations = dilations;
            this.inputShape = inputShape;
            this.kernelShape = kernelShape;
            this.groups = groups;
            this.ceilMode = ceilMode;
        }

        public /* synthetic */ Builder(Integer n, AutoPad autoPad, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = null;
            }
            if ((n4 & 2) != 0) {
                autoPad = AutoPad.NOTSET;
            }
            if ((n4 & 4) != 0) {
                nArray = null;
            }
            if ((n4 & 8) != 0) {
                nArray2 = null;
            }
            if ((n4 & 0x10) != 0) {
                nArray3 = null;
            }
            if ((n4 & 0x20) != 0) {
                nArray4 = null;
            }
            if ((n4 & 0x40) != 0) {
                nArray5 = null;
            }
            if ((n4 & 0x80) != 0) {
                n2 = 1;
            }
            if ((n4 & 0x100) != 0) {
                n3 = 0;
            }
            this(n, autoPad, nArray, nArray2, nArray3, nArray4, nArray5, n2, n3);
        }

        @NotNull
        public final Builder specifyDimensions(int dimensions) {
            Builder builder;
            Builder $this$specifyDimensions_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$specifyDimensions_u24lambda_u240.dimensions = dimensions;
            return builder;
        }

        @NotNull
        public final Builder specifyPads(@Nullable int[] pads) {
            Builder builder;
            Builder $this$specifyPads_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$specifyPads_u24lambda_u241.pads = pads;
            return builder;
        }

        @NotNull
        public final Builder specifyInputShape(@NotNull int[] inputShape) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)inputShape, (String)"inputShape");
            Builder $this$specifyInputShape_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$specifyInputShape_u24lambda_u242.inputShape = inputShape;
            return builder;
        }

        @NotNull
        public final Builder specifyKernelShape(@NotNull int[] kernelShape) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)kernelShape, (String)"kernelShape");
            Builder $this$specifyKernelShape_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$specifyKernelShape_u24lambda_u243.kernelShape = kernelShape;
            return builder;
        }

        @NotNull
        public final Builder specifyAutoPad(@NotNull String autoPad) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)autoPad, (String)"autoPad");
            Builder $this$specifyAutoPad_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$specifyAutoPad_u24lambda_u244.autoPad = AutoPad.valueOf(autoPad);
            return builder;
        }

        @NotNull
        public final Builder specifyStrides(@Nullable int[] strides) {
            Builder builder;
            Builder $this$specifyStrides_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$specifyStrides_u24lambda_u245.strides = strides;
            return builder;
        }

        @NotNull
        public final Builder specifyDilations(@Nullable int[] dilations) {
            Builder builder;
            Builder $this$specifyDilations_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$specifyDilations_u24lambda_u246.dilations = dilations;
            return builder;
        }

        @NotNull
        public final Builder specifyGroups(int groups) {
            Builder builder;
            Builder $this$specifyGroups_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$specifyGroups_u24lambda_u247.groups = groups;
            return builder;
        }

        @NotNull
        public final Builder specifyCeilMode(int ceilMode) {
            Builder builder;
            Builder $this$specifyCeilMode_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$specifyCeilMode_u24lambda_u248.ceilMode = ceilMode;
            return builder;
        }

        private final int[] ones(int size) {
            int n = 0;
            int[] nArray = new int[size];
            while (n < size) {
                int n2 = n++;
                nArray[n2] = 1;
            }
            return nArray;
        }

        private final int[] defaultStrides() {
            Integer n = this.dimensions;
            Intrinsics.checkNotNull((Object)n);
            return this.ones(n);
        }

        private final int[] defaultDilations() {
            Integer n = this.dimensions;
            Intrinsics.checkNotNull((Object)n);
            return this.ones(n);
        }

        private final int[] defaultPads() {
            int n = 0;
            Integer n2 = this.dimensions;
            Intrinsics.checkNotNull((Object)n2);
            int n3 = n2 * 2;
            int[] nArray = new int[n3];
            while (n < n3) {
                int n4 = n++;
                nArray[n4] = 0;
            }
            return nArray;
        }

        private final int[] inferPads() {
            int i;
            int n;
            if (!(this.autoPad == AutoPad.NOTSET || this.pads == null)) {
                boolean $i$a$-require-InputInfo$Builder$inferPads$32 = false;
                String $i$a$-require-InputInfo$Builder$inferPads$32 = "Explicit pads cannot be used simultaneously with auto_pad attribute.";
                throw new IllegalArgumentException($i$a$-require-InputInfo$Builder$inferPads$32.toString());
            }
            if (this.autoPad == AutoPad.VALID || this.autoPad == AutoPad.NOTSET) {
                return this.defaultPads();
            }
            if (!(this.inputShape != null && this.strides != null && this.kernelShape != null && this.dilations != null)) {
                boolean $i$a$-require-InputInfo$Builder$inferPads$42 = false;
                String $i$a$-require-InputInfo$Builder$inferPads$42 = "inputShape, strides, dilations and kernelShape must be specified, when auto_pad is SAME_UPPER or SAME_LOWER";
                throw new IllegalArgumentException($i$a$-require-InputInfo$Builder$inferPads$42.toString());
            }
            Integer n2 = this.dimensions;
            Intrinsics.checkNotNull((Object)n2);
            int n3 = n2 * 2;
            int[] nArray = new int[n3];
            for (int $i$a$-require-InputInfo$Builder$inferPads$42 = 0; $i$a$-require-InputInfo$Builder$inferPads$42 < n3; ++$i$a$-require-InputInfo$Builder$inferPads$42) {
                int n4;
                n = $i$a$-require-InputInfo$Builder$inferPads$42;
                Integer n5 = this.dimensions;
                Intrinsics.checkNotNull((Object)n5);
                if (n < n5) {
                    Intrinsics.checkNotNull((Object)this.inputShape);
                    int n6 = this.inputShape[n];
                    Intrinsics.checkNotNull((Object)this.strides);
                    int outputShape = UtilsKt.divCeil(n6, this.strides[n]);
                    Intrinsics.checkNotNull((Object)this.strides);
                    int n7 = (outputShape - 1) * this.strides[n];
                    Intrinsics.checkNotNull((Object)this.kernelShape);
                    int n8 = this.kernelShape[n] - 1;
                    Intrinsics.checkNotNull((Object)this.dilations);
                    int n9 = n7 + (n8 * this.dilations[n] + 1);
                    Intrinsics.checkNotNull((Object)this.inputShape);
                    n4 = n9 - this.inputShape[n];
                } else {
                    n4 = 0;
                }
                nArray[n] = n4;
            }
            int[] pads = nArray;
            if (this.autoPad == AutoPad.SAME_UPPER) {
                i = 0;
                Integer n10 = this.dimensions;
                Intrinsics.checkNotNull((Object)n10);
                n3 = n10;
                while (i < n3) {
                    int padEnd = UtilsKt.divCeil(pads[i], 2);
                    Integer n11 = this.dimensions;
                    Intrinsics.checkNotNull((Object)n11);
                    pads[i + n11.intValue()] = padEnd;
                    n = i++;
                    pads[n] = pads[n] - padEnd;
                }
                return pads;
            }
            if (this.autoPad == AutoPad.SAME_LOWER) {
                i = 0;
                Integer n12 = this.dimensions;
                Intrinsics.checkNotNull((Object)n12);
                n3 = n12;
                while (i < n3) {
                    int padEnd = pads[i] / 2;
                    Integer n13 = this.dimensions;
                    Intrinsics.checkNotNull((Object)n13);
                    pads[i + n13.intValue()] = padEnd;
                    n = i++;
                    pads[n] = pads[n] - padEnd;
                }
                return pads;
            }
            throw new IllegalStateException(("Invalid auto_pad argument: " + this.autoPad + ".").toString());
        }

        @NotNull
        public final InputInfo build() {
            if (!(this.dimensions != null && this.kernelShape != null && this.inputShape != null)) {
                boolean bl = false;
                String string = "Number of dimensions, kernelShape, inputShape must be specified before build.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.strides == null) {
                this.strides = this.defaultStrides();
            }
            if (this.dilations == null) {
                this.dilations = this.defaultDilations();
            }
            if (this.pads == null) {
                this.pads = this.inferPads();
            }
            Intrinsics.checkNotNull((Object)this.inputShape);
            Intrinsics.checkNotNull((Object)this.kernelShape);
            Intrinsics.checkNotNull((Object)this.pads);
            Intrinsics.checkNotNull((Object)this.strides);
            Intrinsics.checkNotNull((Object)this.dilations);
            Integer n = this.dimensions;
            Intrinsics.checkNotNull((Object)n);
            return new InputInfo(this.inputShape, this.kernelShape, this.pads, this.strides, this.dilations, this.groups, n, this.ceilMode);
        }

        private final Integer component1() {
            return this.dimensions;
        }

        private final AutoPad component2() {
            return this.autoPad;
        }

        private final int[] component3() {
            return this.pads;
        }

        private final int[] component4() {
            return this.strides;
        }

        private final int[] component5() {
            return this.dilations;
        }

        private final int[] component6() {
            return this.inputShape;
        }

        private final int[] component7() {
            return this.kernelShape;
        }

        private final int component8() {
            return this.groups;
        }

        private final int component9() {
            return this.ceilMode;
        }

        @NotNull
        public final Builder copy(@Nullable Integer dimensions, @NotNull AutoPad autoPad, @Nullable int[] pads, @Nullable int[] strides, @Nullable int[] dilations, @Nullable int[] inputShape, @Nullable int[] kernelShape, int groups, int ceilMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)autoPad), (String)"autoPad");
            return new Builder(dimensions, autoPad, pads, strides, dilations, inputShape, kernelShape, groups, ceilMode);
        }

        public static /* synthetic */ Builder copy$default(Builder builder, Integer n, AutoPad autoPad, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = builder.dimensions;
            }
            if ((n4 & 2) != 0) {
                autoPad = builder.autoPad;
            }
            if ((n4 & 4) != 0) {
                nArray = builder.pads;
            }
            if ((n4 & 8) != 0) {
                nArray2 = builder.strides;
            }
            if ((n4 & 0x10) != 0) {
                nArray3 = builder.dilations;
            }
            if ((n4 & 0x20) != 0) {
                nArray4 = builder.inputShape;
            }
            if ((n4 & 0x40) != 0) {
                nArray5 = builder.kernelShape;
            }
            if ((n4 & 0x80) != 0) {
                n2 = builder.groups;
            }
            if ((n4 & 0x100) != 0) {
                n3 = builder.ceilMode;
            }
            return builder.copy(n, autoPad, nArray, nArray2, nArray3, nArray4, nArray5, n2, n3);
        }

        @NotNull
        public String toString() {
            return "Builder(dimensions=" + this.dimensions + ", autoPad=" + this.autoPad + ", pads=" + Arrays.toString(this.pads) + ", strides=" + Arrays.toString(this.strides) + ", dilations=" + Arrays.toString(this.dilations) + ", inputShape=" + Arrays.toString(this.inputShape) + ", kernelShape=" + Arrays.toString(this.kernelShape) + ", groups=" + this.groups + ", ceilMode=" + this.ceilMode + ")";
        }

        public int hashCode() {
            int result = this.dimensions == null ? 0 : ((Object)this.dimensions).hashCode();
            result = result * 31 + this.autoPad.hashCode();
            result = result * 31 + (this.pads == null ? 0 : Arrays.hashCode(this.pads));
            result = result * 31 + (this.strides == null ? 0 : Arrays.hashCode(this.strides));
            result = result * 31 + (this.dilations == null ? 0 : Arrays.hashCode(this.dilations));
            result = result * 31 + (this.inputShape == null ? 0 : Arrays.hashCode(this.inputShape));
            result = result * 31 + (this.kernelShape == null ? 0 : Arrays.hashCode(this.kernelShape));
            result = result * 31 + Integer.hashCode(this.groups);
            result = result * 31 + Integer.hashCode(this.ceilMode);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Builder)) {
                return false;
            }
            Builder builder = (Builder)other;
            if (!Intrinsics.areEqual((Object)this.dimensions, (Object)builder.dimensions)) {
                return false;
            }
            if (this.autoPad != builder.autoPad) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pads, (Object)builder.pads)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.strides, (Object)builder.strides)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dilations, (Object)builder.dilations)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.inputShape, (Object)builder.inputShape)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.kernelShape, (Object)builder.kernelShape)) {
                return false;
            }
            if (this.groups != builder.groups) {
                return false;
            }
            return this.ceilMode == builder.ceilMode;
        }

        public Builder() {
            this(null, null, null, null, null, null, null, 0, 0, 511, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lio/kinference/ndarray/extensions/utils/InputInfo$Builder$AutoPad;", "", "<init>", "(Ljava/lang/String;I)V", "NOTSET", "VALID", "SAME_UPPER", "SAME_LOWER", "ndarray-core"})
        public static final class AutoPad
        extends Enum<AutoPad> {
            public static final /* enum */ AutoPad NOTSET = new AutoPad();
            public static final /* enum */ AutoPad VALID = new AutoPad();
            public static final /* enum */ AutoPad SAME_UPPER = new AutoPad();
            public static final /* enum */ AutoPad SAME_LOWER = new AutoPad();
            private static final /* synthetic */ AutoPad[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static AutoPad[] values() {
                return (AutoPad[])$VALUES.clone();
            }

            public static AutoPad valueOf(String value) {
                return Enum.valueOf(AutoPad.class, value);
            }

            @NotNull
            public static EnumEntries<AutoPad> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = autoPadArray = new AutoPad[]{AutoPad.NOTSET, AutoPad.VALID, AutoPad.SAME_UPPER, AutoPad.SAME_LOWER};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

