/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.trees;

import io.kinference.trees.TreeSplitType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00152\u00020\u0001:\u0005\u0011\u0012\u0013\u0014\u0015B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0004\u0016\u0017\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lio/kinference/trees/TreeSplitter;", "", "featureIds", "", "nodeSplitValues", "", "<init>", "([I[F)V", "getFeatureIds", "()[I", "getNodeSplitValues", "()[F", "split", "", "input", "srcIdx", "splitIdx", "GTTreeSplitter", "GTETreeSplitter", "LTTreeSplitter", "LEQTreeSplitter", "Companion", "Lio/kinference/trees/TreeSplitter$GTETreeSplitter;", "Lio/kinference/trees/TreeSplitter$GTTreeSplitter;", "Lio/kinference/trees/TreeSplitter$LEQTreeSplitter;", "Lio/kinference/trees/TreeSplitter$LTTreeSplitter;", "inference-ir-trees"})
public abstract class TreeSplitter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] featureIds;
    @NotNull
    private final float[] nodeSplitValues;

    private TreeSplitter(int[] featureIds, float[] nodeSplitValues) {
        this.featureIds = featureIds;
        this.nodeSplitValues = nodeSplitValues;
    }

    @NotNull
    public final int[] getFeatureIds() {
        return this.featureIds;
    }

    @NotNull
    public final float[] getNodeSplitValues() {
        return this.nodeSplitValues;
    }

    public abstract int split(@NotNull float[] var1, int var2, int var3);

    public /* synthetic */ TreeSplitter(int[] featureIds, float[] nodeSplitValues, DefaultConstructorMarker $constructor_marker) {
        this(featureIds, nodeSplitValues);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lio/kinference/trees/TreeSplitter$Companion;", "", "<init>", "()V", "get", "Lio/kinference/trees/TreeSplitter;", "splitType", "Lio/kinference/trees/TreeSplitType;", "featureIds", "", "nodeSplitValues", "", "inference-ir-trees"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TreeSplitter get(@NotNull TreeSplitType splitType, @NotNull int[] featureIds, @NotNull float[] nodeSplitValues) {
            Intrinsics.checkNotNullParameter((Object)((Object)splitType), (String)"splitType");
            Intrinsics.checkNotNullParameter((Object)featureIds, (String)"featureIds");
            Intrinsics.checkNotNullParameter((Object)nodeSplitValues, (String)"nodeSplitValues");
            return switch (WhenMappings.$EnumSwitchMapping$0[splitType.ordinal()]) {
                case 1 -> new GTTreeSplitter(featureIds, nodeSplitValues);
                case 2 -> new GTETreeSplitter(featureIds, nodeSplitValues);
                case 3 -> new LTTreeSplitter(featureIds, nodeSplitValues);
                case 4 -> new LEQTreeSplitter(featureIds, nodeSplitValues);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TreeSplitType.values().length];
                try {
                    nArray[TreeSplitType.BRANCH_GT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TreeSplitType.BRANCH_GTE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TreeSplitType.BRANCH_LT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TreeSplitType.BRANCH_LEQ.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lio/kinference/trees/TreeSplitter$GTETreeSplitter;", "Lio/kinference/trees/TreeSplitter;", "featureIds", "", "nodeSplitValues", "", "<init>", "([I[F)V", "split", "", "input", "srcIdx", "splitIdx", "inference-ir-trees"})
    public static final class GTETreeSplitter
    extends TreeSplitter {
        public GTETreeSplitter(@NotNull int[] featureIds, @NotNull float[] nodeSplitValues) {
            Intrinsics.checkNotNullParameter((Object)featureIds, (String)"featureIds");
            Intrinsics.checkNotNullParameter((Object)nodeSplitValues, (String)"nodeSplitValues");
            super(featureIds, nodeSplitValues, null);
        }

        @Override
        public int split(@NotNull float[] input, int srcIdx, int splitIdx) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return input[srcIdx + this.getFeatureIds()[splitIdx]] >= this.getNodeSplitValues()[splitIdx] ? 1 : 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lio/kinference/trees/TreeSplitter$GTTreeSplitter;", "Lio/kinference/trees/TreeSplitter;", "featureIds", "", "nodeSplitValues", "", "<init>", "([I[F)V", "split", "", "input", "srcIdx", "splitIdx", "inference-ir-trees"})
    public static final class GTTreeSplitter
    extends TreeSplitter {
        public GTTreeSplitter(@NotNull int[] featureIds, @NotNull float[] nodeSplitValues) {
            Intrinsics.checkNotNullParameter((Object)featureIds, (String)"featureIds");
            Intrinsics.checkNotNullParameter((Object)nodeSplitValues, (String)"nodeSplitValues");
            super(featureIds, nodeSplitValues, null);
        }

        @Override
        public int split(@NotNull float[] input, int srcIdx, int splitIdx) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return input[srcIdx + this.getFeatureIds()[splitIdx]] > this.getNodeSplitValues()[splitIdx] ? 1 : 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lio/kinference/trees/TreeSplitter$LEQTreeSplitter;", "Lio/kinference/trees/TreeSplitter;", "featureIds", "", "nodeSplitValues", "", "<init>", "([I[F)V", "split", "", "input", "srcIdx", "splitIdx", "inference-ir-trees"})
    public static final class LEQTreeSplitter
    extends TreeSplitter {
        public LEQTreeSplitter(@NotNull int[] featureIds, @NotNull float[] nodeSplitValues) {
            Intrinsics.checkNotNullParameter((Object)featureIds, (String)"featureIds");
            Intrinsics.checkNotNullParameter((Object)nodeSplitValues, (String)"nodeSplitValues");
            super(featureIds, nodeSplitValues, null);
        }

        @Override
        public int split(@NotNull float[] input, int srcIdx, int splitIdx) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return input[srcIdx + this.getFeatureIds()[splitIdx]] <= this.getNodeSplitValues()[splitIdx] ? 1 : 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lio/kinference/trees/TreeSplitter$LTTreeSplitter;", "Lio/kinference/trees/TreeSplitter;", "featureIds", "", "nodeSplitValues", "", "<init>", "([I[F)V", "split", "", "input", "srcIdx", "splitIdx", "inference-ir-trees"})
    public static final class LTTreeSplitter
    extends TreeSplitter {
        public LTTreeSplitter(@NotNull int[] featureIds, @NotNull float[] nodeSplitValues) {
            Intrinsics.checkNotNullParameter((Object)featureIds, (String)"featureIds");
            Intrinsics.checkNotNullParameter((Object)nodeSplitValues, (String)"nodeSplitValues");
            super(featureIds, nodeSplitValues, null);
        }

        @Override
        public int split(@NotNull float[] input, int srcIdx, int splitIdx) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return input[srcIdx + this.getFeatureIds()[splitIdx]] < this.getNodeSplitValues()[splitIdx] ? 1 : 0;
        }
    }
}

