/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn;

import com.intellij.ml.llm.matterhorn.ArtifactType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.text.StringKt;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0004H\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0000J \u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0000\"\u0004\b\u0001\u0010\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0000\"\u0004\b\u0001\u0010\u00012\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006J\"\u0010\u0014\u001a\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u0000\"\u0004\b\u0001\u0010\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006J \u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0000\"\u0004\b\u0001\u0010\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\r\u001a\u00020\u0004J\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0004J\t\u0010\u0019\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0003J)\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\n\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/matterhorn/ArtifactId;", "O", "", "path", "", "type", "Lcom/intellij/ml/llm/matterhorn/ArtifactType;", "<init>", "(Ljava/lang/String;Lcom/intellij/ml/llm/matterhorn/ArtifactType;)V", "getPath", "()Ljava/lang/String;", "getType", "()Lcom/intellij/ml/llm/matterhorn/ArtifactType;", "name", "getName", "toString", "isAncestorOf", "", "id", "childOfType", "parentOfType", "changeType", "changeName", "toFileName", "toChildDirectory", "component1", "component2", "copy", "equals", "other", "hashCode", "", "core"})
public final class ArtifactId<O> {
    @NotNull
    private final String path;
    @NotNull
    private final ArtifactType<O> type;

    public ArtifactId(@NotNull String path, @NotNull ArtifactType<O> type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this.path = path;
        this.type = type;
        boolean bl2 = bl = !StringsKt.contains$default((CharSequence)this.path, (CharSequence)"\n", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = !StringsKt.contains$default((CharSequence)this.path, (CharSequence)"\r", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final ArtifactType<O> getType() {
        return this.type;
    }

    @NotNull
    public final String getName() {
        String[] stringArray = new String[]{"///"};
        return (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)this.path, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    @NotNull
    public String toString() {
        return this.path + "." + this.type;
    }

    public final boolean isAncestorOf(@NotNull ArtifactId<?> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        return StringsKt.startsWith$default((String)id.path, (String)"///", (int)this.path.length(), (boolean)false, (int)4, null) && StringsKt.startsWith$default((String)id.path, (String)this.path, (boolean)false, (int)2, null);
    }

    @NotNull
    public final <O> ArtifactId<O> childOfType(@NotNull ArtifactType<O> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.childOfType(type.getName(), type);
    }

    @NotNull
    public final <O> ArtifactId<O> childOfType(@NotNull String name, @NotNull ArtifactType<O> type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return new ArtifactId<O>(this.path + "///" + name, type);
    }

    @Nullable
    public final <O> ArtifactId<O> parentOfType(@NotNull ArtifactType<O> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        String[] stringArray = new String[]{"///"};
        List parts = CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)this.path, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)1);
        return parts.isEmpty() ? null : new ArtifactId<O>(CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)"///", null, null, (int)0, null, null, (int)62, null), type);
    }

    @NotNull
    public final <O> ArtifactId<O> changeType(@NotNull ArtifactType<O> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return new ArtifactId<O>(this.path, type);
    }

    @NotNull
    public final ArtifactId<O> changeName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = new String[]{"///"};
        return new ArtifactId<O>(CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)this.path, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)1), (Object)name), (CharSequence)"///", null, null, (int)0, null, null, (int)62, null), this.type);
    }

    @NotNull
    public final String toFileName() {
        String sanitizedPath = this.toChildDirectory();
        return sanitizedPath + "." + this.type;
    }

    @NotNull
    public final String toChildDirectory() {
        String[] stringArray = new String[]{"///"};
        String sanitizedPath = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)this.path, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"/", null, null, (int)0, null, ArtifactId::toChildDirectory$lambda$0, (int)30, null);
        return sanitizedPath;
    }

    @NotNull
    public final String component1() {
        return this.path;
    }

    @NotNull
    public final ArtifactType<O> component2() {
        return this.type;
    }

    @NotNull
    public final ArtifactId<O> copy(@NotNull String path, @NotNull ArtifactType<O> type) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return new ArtifactId<O>(path, type);
    }

    public static /* synthetic */ ArtifactId copy$default(ArtifactId artifactId, String string, ArtifactType artifactType, int n, Object object) {
        if ((n & 1) != 0) {
            string = artifactId.path;
        }
        if ((n & 2) != 0) {
            artifactType = artifactId.type;
        }
        return artifactId.copy(string, artifactType);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = result * 31 + this.type.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArtifactId)) {
            return false;
        }
        ArtifactId artifactId = (ArtifactId)other;
        if (!Intrinsics.areEqual((Object)this.path, (Object)artifactId.path)) {
            return false;
        }
        return Intrinsics.areEqual(this.type, artifactId.type);
    }

    private static final CharSequence toChildDirectory$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = StringKt.trimMiddle$default((String)it, (int)50, (boolean)false, (int)2, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = FileUtil.sanitizeFileName((String)string, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sanitizeFileName(...)");
        return string2;
    }
}

