/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn;

import com.intellij.ml.llm.matterhorn.AgentContext;
import com.intellij.ml.llm.matterhorn.AgentSessionHistory;
import com.intellij.ml.llm.matterhorn.ExecutionAgentContext;
import com.intellij.ml.llm.matterhorn.ExecutionContext;
import com.intellij.ml.llm.matterhorn.FileWithLine;
import com.intellij.ml.llm.matterhorn.run.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010-\u001a\u00020.2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR$\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00198V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001b\"\u0004\b\u001f\u0010 R(\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010\u001c\u001a\u0004\u0018\u00010!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R \u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u00060"}, d2={"Lcom/intellij/ml/llm/matterhorn/DummyExecutionAgentContext;", "Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;", "project", "Lcom/intellij/openapi/project/Project;", "agentContext", "Lcom/intellij/ml/llm/matterhorn/AgentContext;", "environment", "Lcom/intellij/ml/llm/matterhorn/run/ExecutionEnvironment;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/matterhorn/AgentContext;Lcom/intellij/ml/llm/matterhorn/run/ExecutionEnvironment;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "editsHistory", "", "", "Lcom/intellij/openapi/vcs/changes/Change;", "sessionHistory", "Lcom/intellij/ml/llm/matterhorn/AgentSessionHistory;", "getSessionHistory", "()Lcom/intellij/ml/llm/matterhorn/AgentSessionHistory;", "executionContext", "Lcom/intellij/ml/llm/matterhorn/ExecutionContext;", "getExecutionContext", "()Lcom/intellij/ml/llm/matterhorn/ExecutionContext;", "projectDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProjectDir", "()Lcom/intellij/openapi/vfs/VirtualFile;", "value", "currentDir", "getCurrentDir", "setCurrentDir", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "Lcom/intellij/ml/llm/matterhorn/FileWithLine;", "currentScreenPosition", "getCurrentScreenPosition", "()Lcom/intellij/ml/llm/matterhorn/FileWithLine;", "setCurrentScreenPosition", "(Lcom/intellij/ml/llm/matterhorn/FileWithLine;)V", "executionEnvironment", "getExecutionEnvironment", "()Lcom/intellij/ml/llm/matterhorn/run/ExecutionEnvironment;", "changes", "getChanges", "()Ljava/util/List;", "pushChange", "", "popChange", "ej-core"})
public final class DummyExecutionAgentContext
implements ExecutionAgentContext {
    @NotNull
    private final Project project;
    @NotNull
    private final AgentContext agentContext;
    @Nullable
    private final ExecutionEnvironment environment;
    @NotNull
    private final List<List<Change>> editsHistory;
    @NotNull
    private final AgentSessionHistory sessionHistory;

    public DummyExecutionAgentContext(@NotNull Project project, @NotNull AgentContext agentContext, @Nullable ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)agentContext, (String)"agentContext");
        this.project = project;
        this.agentContext = agentContext;
        this.environment = environment;
        this.editsHistory = new ArrayList();
        this.sessionHistory = AgentSessionHistory.Companion.initialHistoryContext();
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public AgentSessionHistory getSessionHistory() {
        return this.sessionHistory;
    }

    @Override
    @NotNull
    public ExecutionContext getExecutionContext() {
        throw new NotImplementedError("DummyExecutionAgentContext doesn't have ExecutionContext");
    }

    @Override
    @NotNull
    public VirtualFile getProjectDir() {
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.getProject());
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile getCurrentDir() {
        return this.agentContext.getCurrentDir();
    }

    @Override
    public void setCurrentDir(@NotNull VirtualFile value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.agentContext.setCurrentDir(value);
    }

    @Override
    @Nullable
    public FileWithLine getCurrentScreenPosition() {
        return this.agentContext.getCurrentScreenPosition();
    }

    @Override
    public void setCurrentScreenPosition(@Nullable FileWithLine value) {
        this.agentContext.setCurrentScreenPosition(value);
    }

    @Override
    @NotNull
    public ExecutionEnvironment getExecutionEnvironment() {
        if (this.environment != null) {
            return this.environment;
        }
        throw new NotImplementedError("DummyExecutionAgentContext doesn't have ExecutionEnvironment");
    }

    @Override
    @NotNull
    public List<List<Change>> getChanges() {
        return this.editsHistory;
    }

    @Override
    public void pushChange(@NotNull List<? extends Change> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.editsHistory.add(changes);
    }

    @Override
    @NotNull
    public List<Change> popChange() {
        return this.editsHistory.isEmpty() ? CollectionsKt.emptyList() : (List)CollectionsKt.removeLast(this.editsHistory);
    }
}

