/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ.\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0007*\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/matterhorn/helpers/TeamCityLogger;", "", "<init>", "()V", "testStarted", "", "testCase", "", "flow", "testFinished", "durationMs", "", "testFailed", "message", "details", "error", "isTeamCityVersionSet", "", "printMessage", "msg", "toTeamCityFormat", "core"})
@SourceDebugExtension(value={"SMAP\nTeamCityLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamCityLogger.kt\ncom/intellij/ml/llm/matterhorn/helpers/TeamCityLogger\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,68:1\n975#2:69\n1046#2,3:70\n*S KotlinDebug\n*F\n+ 1 TeamCityLogger.kt\ncom/intellij/ml/llm/matterhorn/helpers/TeamCityLogger\n*L\n40#1:69\n40#1:70,3\n*E\n"})
public final class TeamCityLogger {
    @NotNull
    public static final TeamCityLogger INSTANCE = new TeamCityLogger();

    private TeamCityLogger() {
    }

    public final void testStarted(@NotNull String testCase, @NotNull String flow) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        this.printMessage("testStarted name='" + this.toTeamCityFormat(testCase) + "' flowId='" + this.toTeamCityFormat(flow) + "'");
    }

    public final void testFinished(@NotNull String testCase, @NotNull String flow, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        this.printMessage("testFinished name='" + this.toTeamCityFormat(testCase) + "' flowId='" + this.toTeamCityFormat(flow) + "' duration='" + durationMs + "'");
    }

    public final void testFailed(@NotNull String testCase, @NotNull String flow, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        this.printMessage("testFailed name='" + this.toTeamCityFormat(testCase) + "' flowId='" + this.toTeamCityFormat(flow) + "'");
        this.printMessage("testFinished name='" + this.toTeamCityFormat(testCase) + "' flowId='" + this.toTeamCityFormat(flow) + "' duration='" + durationMs + "'");
    }

    public final void testFailed(@NotNull String testCase, @NotNull String flow, @NotNull String message, @NotNull String details, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.printMessage("testFailed name='" + this.toTeamCityFormat(testCase) + "' flowId='" + this.toTeamCityFormat(flow) + "' message='" + this.toTeamCityFormat(message) + "' details='" + this.toTeamCityFormat(details) + "'");
        this.printMessage("testFinished name='" + this.toTeamCityFormat(testCase) + "' flowId='" + this.toTeamCityFormat(flow) + "' duration='" + durationMs + "'");
    }

    public final void error(@NotNull String message, @NotNull String details) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.printMessage("message text='" + this.toTeamCityFormat(message) + "' errorDetails='" + this.toTeamCityFormat(details) + "' status='ERROR'");
    }

    private final boolean isTeamCityVersionSet() {
        return System.getenv("TEAMCITY_VERSION") != null;
    }

    private final void printMessage(String msg) {
        if (this.isTeamCityVersionSet()) {
            System.out.println((Object)("##teamcity[" + msg + "]"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String toTeamCityFormat(String $this$toTeamCityFormat) {
        String string;
        String string2 = $this$toTeamCityFormat;
        if (string2 != null) {
            void $this$mapTo$iv$iv;
            CharSequence $this$map$iv = string2;
            boolean $i$f$map = false;
            CharSequence charSequence = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
                String string3;
                void char_;
                char item$iv$iv;
                char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                switch (char_) {
                    case 39: {
                        string3 = "|'";
                        break;
                    }
                    case 10: {
                        string3 = "|n";
                        break;
                    }
                    case 13: {
                        string3 = "|r";
                        break;
                    }
                    case 124: {
                        string3 = "||";
                        break;
                    }
                    case 91: {
                        string3 = "|[";
                        break;
                    }
                    case 93: {
                        string3 = "|]";
                        break;
                    }
                    default: {
                        string3 = String.valueOf((char)char_);
                    }
                }
                collection.add(string3);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        } else {
            string = null;
        }
        return string;
    }
}

