/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.activation.presentation.vm;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.EffectsKt;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import app.cash.molecule.MoleculeKt;
import app.cash.molecule.RecompositionMode;
import com.intellij.ml.llm.activation.data.model.AipLicense;
import com.intellij.ml.llm.activation.data.model.result.AipLicenseDeniedReason;
import com.intellij.ml.llm.activation.data.model.result.AipLicenseRequestFailure;
import com.intellij.ml.llm.activation.data.model.result.GrazieHttpError;
import com.intellij.ml.llm.activation.data.model.result.GrazieHttpErrorKt;
import com.intellij.ml.llm.activation.platform.AiaPlatformLoggerKt;
import com.intellij.ml.llm.activation.presentation.fus.AiaActivationErrorTelemetryCollector;
import com.intellij.ml.llm.activation.presentation.platformDep.AiaLogPacker;
import com.intellij.ml.llm.activation.presentation.vm.ActivationPendingIntent;
import com.intellij.ml.llm.activation.presentation.vm.ActivationPendingUi;
import com.intellij.ml.llm.activation.presentation.vm.ActivationPendingViewModel;
import com.intellij.ml.llm.activation.presentation.vm.ActivationPendingViewModelKt;
import com.intellij.ml.llm.activation.presentation.vm.AiaPendingActionFailure;
import com.intellij.ml.llm.activation.presentation.vm.AiaPendingErrorMessage;
import com.intellij.ml.llm.activation.presentation.vm.GrazieAuthLicenseRejected;
import com.intellij.ml.llm.activation.presentation.vm.GrazieErrorMessage;
import com.intellij.ml.llm.activation.presentation.vm.GrazieJbaAuthGenericAuthFailure;
import com.intellij.ml.llm.activation.presentation.vm.GrazieQuotaRefillRefreshFailure;
import com.intellij.ml.llm.activation.presentation.vm.GrazieQuotaRefreshFailure;
import com.intellij.ml.llm.activation.presentation.vm.GrazieUrlResolveFailure;
import com.intellij.ml.llm.activation.presentation.vm.LicenseAgreementLoadFailure;
import com.intellij.ml.llm.activation.presentation.vm.LicenseFetchFailure;
import com.intellij.ml.llm.activation.presentation.vm.LicensingErrorMessage;
import com.intellij.ml.llm.activation.presentation.vm.NetworkFailureErrorMessage;
import com.intellij.ml.llm.activation.state.model.AiProJbaActivation;
import com.intellij.ml.llm.activation.state.model.AiaActivationNotReady;
import com.intellij.ml.llm.activation.state.model.AiaActivationPending;
import com.intellij.ml.llm.activation.state.model.AiaActivationProgressing;
import com.intellij.ml.llm.activation.state.model.AiaActivationRoadblocked;
import com.intellij.ml.llm.activation.state.model.AiaActivationStalled;
import com.intellij.ml.llm.activation.state.model.AiaActivationStalledOp;
import com.intellij.ml.llm.activation.state.model.AiaJbActivation;
import com.intellij.ml.llm.activation.state.model.AieRestricted;
import com.intellij.ml.llm.activation.state.model.AipLicenseAgreementLoadPending;
import com.intellij.ml.llm.activation.state.model.AipLicenseChoice;
import com.intellij.ml.llm.activation.state.model.AipLicenseChoiceStep;
import com.intellij.ml.llm.activation.state.model.AipLicenseFetchPending;
import com.intellij.ml.llm.activation.state.model.AipLicenseJourney;
import com.intellij.ml.llm.activation.state.model.AipLicensePending;
import com.intellij.ml.llm.activation.state.model.GrazieCloudUrlPending;
import com.intellij.ml.llm.activation.state.model.GrazieJbaAuthPending;
import com.intellij.ml.llm.activation.state.model.GrazieQuotaPending;
import com.intellij.ml.llm.activation.state.model.GrazieQuotaRefillPending;
import com.intellij.ml.llm.activation.state.model.Journey;
import com.intellij.ml.llm.activation.state.model.Outcome;
import com.intellij.ml.llm.activation.state.model.op.OpHandle;
import com.intellij.ml.llm.activation.state.model.op.OpResult;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0001\u0018\u00002\u00020\u0001:\t23456789:B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u001d\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0003\u00a2\u0006\u0002\u0010\u0019J+\u0010\u001a\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0003\u00a2\u0006\u0002\u0010 J$\u0010!\u001a\u00020\"\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d2\u0006\u0010#\u001a\u00020\u0003H\u0002J\u001c\u0010$\u001a\u00020%\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0002J*\u0010&\u001a\u00020%2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020)\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0*0(2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020%2\u0006\u0010,\u001a\u00020-2\u0006\u0010/\u001a\u00020)H\u0002J\"\u00100\u001a\u00020%2\u0010\u0010'\u001a\f\u0012\u0004\u0012\u000201\u0012\u0002\b\u00030(2\u0006\u0010,\u001a\u00020-H\u0002R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006;\u00b2\u0006\n\u0010\u0018\u001a\u00020\u0006X\u008a\u0084\u0002"}, d2={"Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModel;", "viewModelScope", "Lkotlinx/coroutines/CoroutineScope;", "activationFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/intellij/ml/llm/activation/state/model/AiaJbActivation;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/flow/StateFlow;)V", "intentFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingIntent;", "getIntentFlow", "()Lkotlinx/coroutines/flow/SharedFlow;", "emitIntent", "", "intent", "uiState", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingUi;", "getUiState", "()Lkotlinx/coroutines/flow/StateFlow;", "stalledPresenter", "stalled", "Lcom/intellij/ml/llm/activation/state/model/AiaActivationStalled;", "activation", "(Lcom/intellij/ml/llm/activation/state/model/AiaActivationStalled;Lcom/intellij/ml/llm/activation/state/model/AiaJbActivation;Landroidx/compose/runtime/Composer;I)Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingUi;", "stalledOpPresenter", "Err", "stalledOp", "Lcom/intellij/ml/llm/activation/state/model/AiaActivationStalledOp;", "license", "Lcom/intellij/ml/llm/activation/state/model/AipLicenseChoice;", "(Lcom/intellij/ml/llm/activation/state/model/AiaActivationStalledOp;Lcom/intellij/ml/llm/activation/state/model/AipLicenseChoice;Landroidx/compose/runtime/Composer;I)Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingUi;", "retry", "", "scope", "mapStalledStateToResultState", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$OperationState;", "mapAipLicenseResultsToUi", "result", "Lcom/intellij/ml/llm/activation/state/model/op/OpResult;", "Lcom/intellij/ml/llm/activation/data/model/result/AipLicenseRequestFailure;", "Lkotlinx/collections/immutable/PersistentList;", "Lcom/intellij/ml/llm/activation/data/model/AipLicense;", "action", "Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;", "mapAipFailureToErrorState", "failure", "mapGrazieResultsToUi", "Lcom/intellij/ml/llm/activation/data/model/result/GrazieHttpError;", "OperationState", "CancelledState", "InternalErrorState", "NetworkFailureState", "TimeoutState", "SuccessState", "LicenseAgreementLoadingFailedState", "ErrorState", "AuthenticationRequiredState", "intellij.ml.llm.activation.presentation"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nActivationPendingViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActivationPendingViewModel.kt\ncom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl\n+ 2 Effects.kt\nandroidx/compose/runtime/EffectsKt\n+ 3 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 4 Effects.kt\nandroidx/compose/runtime/EffectsKt$rememberCoroutineScope$1\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,279:1\n599#2:280\n596#2,6:281\n1136#3,3:287\n1139#3,3:291\n1136#3,6:294\n1136#3,6:300\n1136#3,6:306\n1136#3,6:312\n1136#3,6:318\n1136#3,6:324\n1136#3,6:330\n1136#3,6:336\n597#4:290\n1#5:342\n85#6:343\n*S KotlinDebug\n*F\n+ 1 ActivationPendingViewModel.kt\ncom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl\n*L\n127#1:280\n127#1:281,6\n127#1:287,3\n127#1:291,3\n128#1:294,6\n134#1:300,6\n141#1:306,6\n144#1:312,6\n147#1:318,6\n150#1:324,6\n153#1:330,6\n156#1:336,6\n127#1:290\n98#1:343\n*E\n"})
public final class ActivationPendingViewModelImpl
implements ActivationPendingViewModel {
    @NotNull
    private final SharedFlow<ActivationPendingIntent> intentFlow;
    @NotNull
    private final StateFlow<ActivationPendingUi> uiState;
    public static final int $stable = 8;

    public ActivationPendingViewModelImpl(@NotNull CoroutineScope viewModelScope, @NotNull StateFlow<? extends AiaJbActivation> activationFlow) {
        Intrinsics.checkNotNullParameter((Object)viewModelScope, (String)"viewModelScope");
        Intrinsics.checkNotNullParameter(activationFlow, (String)"activationFlow");
        this.intentFlow = (SharedFlow)SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        this.uiState = FlowKt.stateIn((Flow)MoleculeKt.moleculeFlow((RecompositionMode)RecompositionMode.Immediate, (arg_0, arg_1) -> ActivationPendingViewModelImpl.uiState$lambda$0(activationFlow, this, arg_0, arg_1)), (CoroutineScope)viewModelScope, (SharingStarted)SharingStarted.Companion.getLazily(), (Object)ActivationPendingUi.Loading.INSTANCE);
    }

    @Override
    @NotNull
    public SharedFlow<ActivationPendingIntent> getIntentFlow() {
        return this.intentFlow;
    }

    @NotNull
    public Void emitIntent(@NotNull ActivationPendingIntent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public StateFlow<ActivationPendingUi> getUiState() {
        return this.uiState;
    }

    @Composable
    private final ActivationPendingUi stalledPresenter(AiaActivationStalled stalled, AiaJbActivation activation2, Composer $composer, int $changed) {
        ActivationPendingUi activationPendingUi;
        Journey<AipLicensePending, AipLicense> journey;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)1967349256, (int)$changed, (int)-1, (String)"com.intellij.ml.llm.activation.presentation.vm.ActivationPendingViewModelImpl.stalledPresenter (ActivationPendingViewModel.kt:108)");
        }
        AipLicenseChoice license = activation2 instanceof AiProJbaActivation ? ((journey = ((AiProJbaActivation)activation2).getLicenseJourney()) != null && (journey = ((AipLicenseJourney)journey).getLicenseChoiceStep()) != null ? (AipLicenseChoice)Outcome.getOrNull-impl(((AipLicenseChoiceStep)journey).getOutcome-X8CKn68()) : null) : null;
        AiaActivationStalled aiaActivationStalled = stalled;
        if (aiaActivationStalled instanceof AiaActivationNotReady) {
            $composer.startReplaceGroup(837035983);
            $composer.endReplaceGroup();
            activationPendingUi = ActivationPendingUi.Loading.INSTANCE;
        } else if (aiaActivationStalled instanceof AiaActivationStalledOp) {
            $composer.startReplaceGroup(837037484);
            ActivationPendingUi activationPendingUi2 = this.stalledOpPresenter((AiaActivationStalledOp)stalled, license, $composer, 0xE & $changed | 0x380 & $changed);
            $composer.endReplaceGroup();
            activationPendingUi = activationPendingUi2;
        } else if (aiaActivationStalled instanceof AieRestricted.AieFailure) {
            $composer.startReplaceGroup(837039859);
            $composer.endReplaceGroup();
            activationPendingUi = new ActivationPendingUi.IdeProvisionerFailure(((AieRestricted.AieFailure)stalled).getErrorMessage());
        } else {
            $composer.startReplaceGroup(837034564);
            $composer.endReplaceGroup();
            throw new NoWhenBranchMatchedException();
        }
        ActivationPendingUi activationPendingUi3 = activationPendingUi;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        return activationPendingUi3;
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    private final <Err> ActivationPendingUi stalledOpPresenter(AiaActivationStalledOp<? extends Err> stalledOp, AipLicenseChoice license, Composer $composer, int $changed) {
        ActivationPendingUi activationPendingUi;
        Object object;
        void $this$cache$iv;
        Object object2;
        void $this$cache$iv$iv;
        Composer $composer$iv;
        Object object3;
        $composer.startReplaceGroup(-1432193631);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-1432193631, (int)$changed, (int)-1, (String)"com.intellij.ml.llm.activation.presentation.vm.ActivationPendingViewModelImpl.stalledOpPresenter (ActivationPendingViewModel.kt:123)");
        }
        if ((object3 = license) == null || (object3 = ((AipLicenseChoice)object3).getPickedLicense()) == null || (object3 = ((AipLicense)object3).getLicenseId-DZg55yo()) == null) {
            object3 = "";
        }
        Object licenseId = object3;
        OperationState stalledState = this.mapStalledStateToResultState(stalledOp);
        Object object4 = $composer;
        boolean bl = false;
        boolean $i$f$rememberCoroutineScope = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer$iv, (int)773894976, (String)"CC(rememberCoroutineScope)N(getContext)600@27430L68:Effects.kt#9igjgp");
        void composer$iv = $composer$iv;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer$iv, (int)683736516, (String)"CC(remember):Effects.kt#9igjgp");
        void var13_19 = $composer$iv;
        boolean invalid$iv$iv = false;
        boolean $i$f$cache = false;
        Object it$iv$iv = $this$cache$iv$iv.rememberedValue();
        boolean bl2 = false;
        if (it$iv$iv == Composer.Companion.getEmpty()) {
            boolean bl3 = false;
            boolean bl4 = false;
            CoroutineScope value$iv$iv = EffectsKt.createCompositionCoroutineScope((CoroutineContext)((CoroutineContext)EmptyCoroutineContext.INSTANCE), (Composer)composer$iv);
            $this$cache$iv$iv.updateRememberedValue((Object)value$iv$iv);
            object2 = value$iv$iv;
        } else {
            object2 = it$iv$iv;
        }
        CoroutineScope coroutineScope = (CoroutineScope)object2;
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer$iv);
        CoroutineScope coroutineScope2 = coroutineScope;
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer$iv);
        CoroutineScope scope = coroutineScope2;
        $composer$iv = $composer;
        boolean $changed$iv = false;
        boolean $i$f$cache2 = false;
        Object it$iv = $this$cache$iv.rememberedValue();
        boolean bl5 = false;
        if (it$iv == Composer.Companion.getEmpty()) {
            boolean bl6 = false;
            Function0 value$iv = ActivationPendingViewModelImpl::stalledOpPresenter$lambda$0$0;
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object = value$iv;
        } else {
            object = it$iv;
        }
        Function0 collectLogs = (Function0)object;
        OperationState operationState = stalledState;
        if (operationState instanceof SuccessState) {
            $composer.startReplaceGroup(-274932184);
            $composer.endReplaceGroup();
            activationPendingUi = ActivationPendingUi.Loading.INSTANCE;
        } else {
            Composer $this$cache$iv2;
            boolean invalid$iv;
            if (operationState instanceof ErrorState) {
                Object object5;
                $composer.startReplaceGroup(-274876229);
                it$iv = $composer;
                invalid$iv = $composer.changedInstance(stalledOp) | $composer.changedInstance((Object)scope);
                boolean $i$f$cache3 = false;
                Object it$iv2 = $this$cache$iv2.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (invalid$iv || it$iv2 == Composer.Companion.getEmpty()) {
                    boolean bl7 = false;
                    Function0 value$iv = () -> ActivationPendingViewModelImpl.stalledOpPresenter$lambda$1$0(stalledOp, scope);
                    $this$cache$iv2.updateRememberedValue((Object)value$iv);
                    object5 = value$iv;
                } else {
                    object5 = it$iv2;
                }
                Function0 function0 = collectLogs;
                Object object6 = licenseId;
                AiaPendingActionFailure aiaPendingActionFailure = stalledState.getAction();
                AiaPendingErrorMessage aiaPendingErrorMessage = ((ErrorState)stalledState).getErrorMessage();
                Function0 function02 = (Function0)object5;
                ActivationPendingUi.FailureWithRetry failureWithRetry = new ActivationPendingUi.FailureWithRetry((Function0<Unit>)function02, aiaPendingErrorMessage, aiaPendingActionFailure, (String)object6, (Function0<Unit>)function0);
                $composer.endReplaceGroup();
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
                $composer.endReplaceGroup();
                return failureWithRetry;
            }
            if (operationState instanceof CancelledState) {
                Object object7;
                $composer.startReplaceGroup(-1948520500);
                $this$cache$iv2 = $composer;
                invalid$iv = $composer.changedInstance((Object)this) | $composer.changedInstance(stalledOp) | $composer.changedInstance((Object)scope);
                boolean $i$f$cache4 = false;
                Object it$iv3 = $this$cache$iv2.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (invalid$iv || it$iv3 == Composer.Companion.getEmpty()) {
                    boolean bl8 = false;
                    Function0 value$iv = () -> ActivationPendingViewModelImpl.stalledOpPresenter$lambda$2$0(this, stalledOp, scope);
                    $this$cache$iv2.updateRememberedValue((Object)value$iv);
                    object7 = value$iv;
                } else {
                    object7 = it$iv3;
                }
                Function0 function0 = collectLogs;
                Object object8 = licenseId;
                AiaPendingActionFailure aiaPendingActionFailure = stalledState.getAction();
                Function0 function03 = (Function0)object7;
                ActivationPendingUi.Cancelled cancelled = new ActivationPendingUi.Cancelled((Function0<Unit>)function03, aiaPendingActionFailure, (String)object8, (Function0<Unit>)function0);
                $composer.endReplaceGroup();
                activationPendingUi = cancelled;
            } else if (operationState instanceof InternalErrorState) {
                Object object9;
                $composer.startReplaceGroup(-1948516048);
                $this$cache$iv2 = $composer;
                invalid$iv = $composer.changedInstance((Object)this) | $composer.changedInstance(stalledOp) | $composer.changedInstance((Object)scope);
                boolean $i$f$cache5 = false;
                Object it$iv4 = $this$cache$iv2.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (invalid$iv || it$iv4 == Composer.Companion.getEmpty()) {
                    boolean bl9 = false;
                    Function0 value$iv = () -> ActivationPendingViewModelImpl.stalledOpPresenter$lambda$3$0(this, stalledOp, scope);
                    $this$cache$iv2.updateRememberedValue((Object)value$iv);
                    object9 = value$iv;
                } else {
                    object9 = it$iv4;
                }
                Function0 function0 = collectLogs;
                Object object10 = licenseId;
                AiaPendingActionFailure aiaPendingActionFailure = stalledState.getAction();
                Function0 function04 = (Function0)object9;
                ActivationPendingUi.InternalError internalError = new ActivationPendingUi.InternalError((Function0<Unit>)function04, aiaPendingActionFailure, (String)object10, (Function0<Unit>)function0);
                $composer.endReplaceGroup();
                activationPendingUi = internalError;
            } else if (operationState instanceof NetworkFailureState) {
                Object object11;
                $composer.startReplaceGroup(-1948511379);
                $this$cache$iv2 = $composer;
                invalid$iv = $composer.changedInstance((Object)this) | $composer.changedInstance(stalledOp) | $composer.changedInstance((Object)scope);
                boolean $i$f$cache6 = false;
                Object it$iv5 = $this$cache$iv2.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (invalid$iv || it$iv5 == Composer.Companion.getEmpty()) {
                    boolean bl10 = false;
                    Function0 value$iv = () -> ActivationPendingViewModelImpl.stalledOpPresenter$lambda$4$0(this, stalledOp, scope);
                    $this$cache$iv2.updateRememberedValue((Object)value$iv);
                    object11 = value$iv;
                } else {
                    object11 = it$iv5;
                }
                Function0 function0 = collectLogs;
                Object object12 = licenseId;
                AiaPendingActionFailure aiaPendingActionFailure = stalledState.getAction();
                AiaPendingErrorMessage aiaPendingErrorMessage = new NetworkFailureErrorMessage(((NetworkFailureState)stalledState).getErrorMessage().getText());
                Function0 function05 = (Function0)object11;
                ActivationPendingUi.NetworkFailure networkFailure = new ActivationPendingUi.NetworkFailure((Function0<Unit>)function05, aiaPendingErrorMessage, aiaPendingActionFailure, (String)object12, (Function0<Unit>)function0);
                $composer.endReplaceGroup();
                activationPendingUi = networkFailure;
            } else if (operationState instanceof TimeoutState) {
                Object object13;
                $composer.startReplaceGroup(-1948505110);
                $this$cache$iv2 = $composer;
                invalid$iv = $composer.changedInstance((Object)this) | $composer.changedInstance(stalledOp) | $composer.changedInstance((Object)scope);
                boolean $i$f$cache7 = false;
                Object it$iv6 = $this$cache$iv2.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (invalid$iv || it$iv6 == Composer.Companion.getEmpty()) {
                    boolean bl11 = false;
                    Function0 value$iv = () -> ActivationPendingViewModelImpl.stalledOpPresenter$lambda$5$0(this, stalledOp, scope);
                    $this$cache$iv2.updateRememberedValue((Object)value$iv);
                    object13 = value$iv;
                } else {
                    object13 = it$iv6;
                }
                Function0 function0 = collectLogs;
                Object object14 = licenseId;
                AiaPendingActionFailure aiaPendingActionFailure = stalledState.getAction();
                Function0 function06 = (Function0)object13;
                ActivationPendingUi.Timeout timeout = new ActivationPendingUi.Timeout((Function0<Unit>)function06, aiaPendingActionFailure, (String)object14, (Function0<Unit>)function0);
                $composer.endReplaceGroup();
                activationPendingUi = timeout;
            } else if (operationState instanceof LicenseAgreementLoadingFailedState) {
                Object object15;
                $composer.startReplaceGroup(-1948500192);
                $this$cache$iv2 = $composer;
                invalid$iv = $composer.changedInstance((Object)this) | $composer.changedInstance(stalledOp) | $composer.changedInstance((Object)scope);
                boolean $i$f$cache8 = false;
                Object it$iv7 = $this$cache$iv2.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (invalid$iv || it$iv7 == Composer.Companion.getEmpty()) {
                    boolean bl12 = false;
                    Function0 value$iv = () -> ActivationPendingViewModelImpl.stalledOpPresenter$lambda$6$0(this, stalledOp, scope);
                    $this$cache$iv2.updateRememberedValue((Object)value$iv);
                    object15 = value$iv;
                } else {
                    object15 = it$iv7;
                }
                Function0 function0 = collectLogs;
                Object object16 = licenseId;
                AiaPendingActionFailure aiaPendingActionFailure = stalledState.getAction();
                Function0 function07 = (Function0)object15;
                ActivationPendingUi.LicenseAgreementLoadingFailed licenseAgreementLoadingFailed = new ActivationPendingUi.LicenseAgreementLoadingFailed((Function0<Unit>)function07, aiaPendingActionFailure, (String)object16, (Function0<Unit>)function0);
                $composer.endReplaceGroup();
                activationPendingUi = licenseAgreementLoadingFailed;
            } else if (operationState instanceof AuthenticationRequiredState) {
                Object object17;
                $composer.startReplaceGroup(-1948494823);
                $this$cache$iv2 = $composer;
                invalid$iv = $composer.changedInstance((Object)this) | $composer.changedInstance(stalledOp) | $composer.changedInstance((Object)scope);
                boolean $i$f$cache9 = false;
                Object it$iv8 = $this$cache$iv2.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (invalid$iv || it$iv8 == Composer.Companion.getEmpty()) {
                    boolean bl13 = false;
                    Function0 value$iv = () -> ActivationPendingViewModelImpl.stalledOpPresenter$lambda$7$0(this, stalledOp, scope);
                    $this$cache$iv2.updateRememberedValue((Object)value$iv);
                    object17 = value$iv;
                } else {
                    object17 = it$iv8;
                }
                Function0 function0 = collectLogs;
                Object object18 = licenseId;
                AiaPendingActionFailure aiaPendingActionFailure = stalledState.getAction();
                Function0 function08 = (Function0)object17;
                ActivationPendingUi.AuthenticationRequired authenticationRequired = new ActivationPendingUi.AuthenticationRequired((Function0<Unit>)function08, aiaPendingActionFailure, (String)object18, (Function0<Unit>)function0);
                $composer.endReplaceGroup();
                activationPendingUi = authenticationRequired;
            } else {
                $composer.startReplaceGroup(-1948531645);
                $composer.endReplaceGroup();
                throw new NoWhenBranchMatchedException();
            }
        }
        object4 = activationPendingUi;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceGroup();
        return object4;
    }

    private final <Err> void retry(AiaActivationStalledOp<? extends Err> stalledOp, CoroutineScope scope) {
        OpHandle retryHandle = (OpHandle)stalledOp.getRetryNow().invoke();
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(retryHandle, null){
            int label;
            final /* synthetic */ OpHandle<Err> $retryHandle;
            {
                this.$retryHandle = $retryHandle;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$retryHandle.awaitOpResult((Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final <Err> OperationState mapStalledStateToResultState(AiaActivationStalledOp<? extends Err> stalledOp) {
        OperationState operationState;
        AiaActivationStalledOp<? extends Err> aiaActivationStalledOp = stalledOp;
        if (aiaActivationStalledOp instanceof AipLicenseFetchPending.AipLicenseFetchFailure) {
            operationState = this.mapAipLicenseResultsToUi(((AipLicenseFetchPending.AipLicenseFetchFailure)stalledOp).getResult(), new LicenseFetchFailure());
        } else if (aiaActivationStalledOp instanceof GrazieJbaAuthPending.GrazieJbaAuthLicenseRejected) {
            operationState = this.mapGrazieResultsToUi(((GrazieJbaAuthPending.GrazieJbaAuthLicenseRejected)stalledOp).getResult(), new GrazieAuthLicenseRejected());
        } else if (aiaActivationStalledOp instanceof GrazieJbaAuthPending.GrazieJbaAuthGenericAuthFailure) {
            operationState = this.mapGrazieResultsToUi(((GrazieJbaAuthPending.GrazieJbaAuthGenericAuthFailure)stalledOp).getResult(), new GrazieJbaAuthGenericAuthFailure());
        } else if (aiaActivationStalledOp instanceof AipLicenseAgreementLoadPending.AipLicenseAgreementLoadFailure) {
            LicenseAgreementLoadingFailedState licenseAgreementLoadingFailedState;
            LicenseAgreementLoadingFailedState it = licenseAgreementLoadingFailedState = new LicenseAgreementLoadingFailedState(new LicenseAgreementLoadFailure());
            boolean bl = false;
            AiaActivationErrorTelemetryCollector.Companion.getInstance().logLicenseAgreementLoadingFailed();
            operationState = licenseAgreementLoadingFailedState;
        } else if (aiaActivationStalledOp instanceof GrazieCloudUrlPending.GrazieUrlResolveFailure) {
            operationState = this.mapGrazieResultsToUi(((GrazieCloudUrlPending.GrazieUrlResolveFailure)stalledOp).getResult(), new GrazieUrlResolveFailure());
        } else if (aiaActivationStalledOp instanceof GrazieQuotaPending.GrazieQuotaRefreshFailure) {
            operationState = this.mapGrazieResultsToUi(((GrazieQuotaPending.GrazieQuotaRefreshFailure)stalledOp).getResult(), new GrazieQuotaRefreshFailure());
        } else if (aiaActivationStalledOp instanceof GrazieQuotaRefillPending.GrazieQuotaRefillRefreshFailure) {
            operationState = this.mapGrazieResultsToUi(((GrazieQuotaRefillPending.GrazieQuotaRefillRefreshFailure)stalledOp).getResult(), new GrazieQuotaRefillRefreshFailure());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return operationState;
    }

    private final OperationState mapAipLicenseResultsToUi(OpResult<? extends AipLicenseRequestFailure, ? extends PersistentList<AipLicense>> result2, AiaPendingActionFailure action2) {
        OperationState operationState;
        AiaActivationErrorTelemetryCollector errorLogger = AiaActivationErrorTelemetryCollector.Companion.getInstance();
        OpResult<? extends AipLicenseRequestFailure, ? extends PersistentList<AipLicense>> opResult2 = result2;
        if (opResult2 instanceof OpResult.OpTerminated.OpTimeout) {
            TimeoutState timeoutState;
            TimeoutState it = timeoutState = new TimeoutState(action2);
            boolean bl = false;
            AiaPlatformLoggerKt.error(ActivationPendingViewModelKt.access$getLOG$p(), "License request timeout");
            errorLogger.logLicenseTimeout();
            operationState = timeoutState;
        } else if (opResult2 instanceof OpResult.OpCompleted.OpFailed) {
            Object Err = ((OpResult.OpCompleted.OpFailed)result2).getFailure();
            Intrinsics.checkNotNull(Err, (String)"null cannot be cast to non-null type com.intellij.ml.llm.activation.data.model.result.AipLicenseRequestFailure");
            operationState = this.mapAipFailureToErrorState(action2, (AipLicenseRequestFailure)Err);
        } else if (opResult2 instanceof OpResult.OpTerminated.OpCancellation) {
            CancelledState cancelledState;
            CancelledState it = cancelledState = new CancelledState(action2);
            boolean bl = false;
            AiaPlatformLoggerKt.error(ActivationPendingViewModelKt.access$getLOG$p(), "License request cancelled");
            errorLogger.logLicenseCancelled();
            operationState = cancelledState;
        } else if (opResult2 instanceof OpResult.OpTerminated.OpNetworkFailure) {
            NetworkFailureState networkFailureState;
            NetworkFailureState it = networkFailureState = new NetworkFailureState(new AiaPendingErrorMessage(((OpResult.OpTerminated.OpNetworkFailure)result2).getMessage()), action2);
            boolean bl = false;
            AiaPlatformLoggerKt.error(ActivationPendingViewModelKt.access$getLOG$p(), "License request network failure: " + ((OpResult.OpTerminated.OpNetworkFailure)result2).getMessage());
            errorLogger.logLicenseNetworkError();
            operationState = networkFailureState;
        } else if (opResult2 instanceof OpResult.OpTerminated.OpUnhandledException) {
            InternalErrorState internalErrorState;
            InternalErrorState it = internalErrorState = new InternalErrorState(action2);
            boolean bl = false;
            AiaPlatformLoggerKt.error(ActivationPendingViewModelKt.access$getLOG$p(), "License request unhandled exception");
            errorLogger.logLicenseUnhandled();
            operationState = internalErrorState;
        } else if (opResult2 instanceof OpResult.OpCompleted.OpSucceeded) {
            operationState = new SuccessState(action2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return operationState;
    }

    /*
     * WARNING - void declaration
     */
    private final OperationState mapAipFailureToErrorState(AiaPendingActionFailure action2, AipLicenseRequestFailure failure) {
        OperationState operationState;
        block10: {
            AipLicenseRequestFailure aipLicenseRequestFailure;
            AiaActivationErrorTelemetryCollector errorLogger;
            block7: {
                ErrorState errorState;
                Object object;
                String string;
                block9: {
                    block8: {
                        void it;
                        errorLogger = AiaActivationErrorTelemetryCollector.Companion.getInstance();
                        aipLicenseRequestFailure = failure;
                        if (!(aipLicenseRequestFailure instanceof AipLicenseRequestFailure.LicenseDenied)) break block7;
                        string = ((AipLicenseRequestFailure.LicenseDenied)failure).getMessage();
                        object = ((AipLicenseRequestFailure.LicenseDenied)failure).getReason();
                        if (object == null) break block8;
                        AipLicenseDeniedReason aipLicenseDeniedReason = object;
                        String string2 = string;
                        boolean bl = false;
                        String string3 = " reason: " + (AipLicenseDeniedReason)it;
                        string = string2;
                        object = string3;
                        if (string3 != null) break block9;
                    }
                    object = "";
                }
                String string4 = "message: " + string + (String)object;
                AiaPendingActionFailure aiaPendingActionFailure = action2;
                AiaPendingErrorMessage aiaPendingErrorMessage = new LicensingErrorMessage(string4);
                ErrorState it = errorState = new ErrorState(aiaPendingErrorMessage, aiaPendingActionFailure);
                boolean bl = false;
                AiaPlatformLoggerKt.error(ActivationPendingViewModelKt.access$getLOG$p(), "License request denied, reason: " + ((AipLicenseRequestFailure.LicenseDenied)failure).getReason() + " message: " + ((AipLicenseRequestFailure.LicenseDenied)failure).getMessage());
                errorLogger.logLicenseFailureDenied();
                operationState = errorState;
                break block10;
            }
            if (aipLicenseRequestFailure instanceof AipLicenseRequestFailure.ErrorResponse) {
                ErrorState errorState;
                ErrorState it = errorState = new ErrorState(new LicensingErrorMessage(((AipLicenseRequestFailure.ErrorResponse)failure).getErrorMessage()), action2);
                boolean bl = false;
                AiaPlatformLoggerKt.error(ActivationPendingViewModelKt.access$getLOG$p(), "License request error response: " + ((AipLicenseRequestFailure.ErrorResponse)failure).getErrorMessage());
                errorLogger.logLicenseFailureErrorResponse();
                operationState = errorState;
            } else if (aipLicenseRequestFailure instanceof AipLicenseRequestFailure.AuthRequired) {
                AuthenticationRequiredState authenticationRequiredState;
                AuthenticationRequiredState it = authenticationRequiredState = new AuthenticationRequiredState(action2);
                boolean bl = false;
                AiaPlatformLoggerKt.error(ActivationPendingViewModelKt.access$getLOG$p(), "License error: Authentication required");
                errorLogger.logLicenseFailureAuthRequired();
                operationState = authenticationRequiredState;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return operationState;
    }

    private final OperationState mapGrazieResultsToUi(OpResult<? extends GrazieHttpError, ?> result2, AiaPendingActionFailure action2) {
        OperationState operationState;
        AiaActivationErrorTelemetryCollector errorLogger = AiaActivationErrorTelemetryCollector.Companion.getInstance();
        OpResult<? extends GrazieHttpError, ?> opResult2 = result2;
        if (opResult2 instanceof OpResult.OpCompleted.OpFailed) {
            ErrorState errorState;
            Object Err = ((OpResult.OpCompleted.OpFailed)result2).getFailure();
            Intrinsics.checkNotNull(Err, (String)"null cannot be cast to non-null type com.intellij.ml.llm.activation.data.model.result.GrazieHttpError");
            GrazieHttpError httpError = (GrazieHttpError)Err;
            int httpErrorCode = httpError.getCode();
            String string = GrazieHttpErrorKt.getGrazieTraceId(httpError);
            if (string == null) {
                string = "Unknown";
            }
            String grazieTraceId = string;
            ErrorState it = errorState = new ErrorState(new GrazieErrorMessage(httpError + ", id: " + grazieTraceId), action2);
            boolean bl = false;
            AiaPlatformLoggerKt.error(ActivationPendingViewModelKt.access$getLOG$p(), "Failed Grazie request, code: " + httpErrorCode + ", Id: " + grazieTraceId);
            errorLogger.logGrazieHttpFailure(httpErrorCode);
            operationState = errorState;
        } else if (opResult2 instanceof OpResult.OpCompleted.OpSucceeded) {
            operationState = new SuccessState(action2);
        } else if (opResult2 instanceof OpResult.OpTerminated.OpCancellation) {
            CancelledState cancelledState;
            CancelledState it = cancelledState = new CancelledState(action2);
            boolean bl = false;
            AiaPlatformLoggerKt.error(ActivationPendingViewModelKt.access$getLOG$p(), "Grazie request cancelled");
            errorLogger.logGrazieCancelled();
            operationState = cancelledState;
        } else if (opResult2 instanceof OpResult.OpTerminated.OpNetworkFailure) {
            NetworkFailureState networkFailureState;
            NetworkFailureState it = networkFailureState = new NetworkFailureState(new AiaPendingErrorMessage(((OpResult.OpTerminated.OpNetworkFailure)result2).getMessage()), action2);
            boolean bl = false;
            AiaPlatformLoggerKt.error(ActivationPendingViewModelKt.access$getLOG$p(), "Grazie request network failure: " + ((OpResult.OpTerminated.OpNetworkFailure)result2).getMessage());
            errorLogger.logGrazieNetworkError();
            operationState = networkFailureState;
        } else if (opResult2 instanceof OpResult.OpTerminated.OpTimeout) {
            TimeoutState timeoutState;
            TimeoutState it = timeoutState = new TimeoutState(action2);
            boolean bl = false;
            AiaPlatformLoggerKt.error(ActivationPendingViewModelKt.access$getLOG$p(), "Grazie request timeout");
            errorLogger.logGrazieTimeout();
            operationState = timeoutState;
        } else if (opResult2 instanceof OpResult.OpTerminated.OpUnhandledException) {
            InternalErrorState internalErrorState;
            InternalErrorState it = internalErrorState = new InternalErrorState(action2);
            boolean bl = false;
            AiaPlatformLoggerKt.error(ActivationPendingViewModelKt.access$getLOG$p(), "Unhandled exception in Grazie request");
            errorLogger.logGrazieUnhandled();
            operationState = internalErrorState;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return operationState;
    }

    @Composable
    private static final ActivationPendingUi uiState$lambda$0(StateFlow $activationFlow, ActivationPendingViewModelImpl this$0, Composer $composer, int $changed) {
        ActivationPendingUi activationPendingUi;
        State activation$delegate;
        AiaActivationPending activationPending;
        $composer.startReplaceGroup(1096605887);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)1096605887, (int)$changed, (int)-1, (String)"com.intellij.ml.llm.activation.presentation.vm.ActivationPendingViewModelImpl.uiState.<anonymous> (ActivationPendingViewModel.kt:97)");
        }
        if ((activationPending = (AiaActivationPending)Outcome.incompleteOrNull-impl(ActivationPendingViewModelImpl.uiState$lambda$0$0((State<? extends AiaJbActivation>)(activation$delegate = SnapshotStateKt.collectAsState((StateFlow)$activationFlow, null, (Composer)$composer, (int)0, (int)1))).getOutcome-X8CKn68())) == null) {
            $composer.startReplaceGroup(1571274576);
            $composer.endReplaceGroup();
            activationPendingUi = ActivationPendingUi.ReadyConfirmation.INSTANCE;
        } else if (activationPending instanceof AiaActivationProgressing) {
            $composer.startReplaceGroup(1571276326);
            $composer.endReplaceGroup();
            activationPendingUi = ActivationPendingUi.Loading.INSTANCE;
        } else if (activationPending instanceof AiaActivationStalled) {
            $composer.startReplaceGroup(1571277678);
            ActivationPendingUi activationPendingUi2 = this$0.stalledPresenter((AiaActivationStalled)activationPending, ActivationPendingViewModelImpl.uiState$lambda$0$0((State<? extends AiaJbActivation>)activation$delegate), $composer, 0);
            $composer.endReplaceGroup();
            activationPendingUi = activationPendingUi2;
        } else if (activationPending instanceof AiaActivationRoadblocked) {
            $composer.startReplaceGroup(1571280358);
            $composer.endReplaceGroup();
            activationPendingUi = ActivationPendingUi.Loading.INSTANCE;
        } else {
            $composer.startReplaceGroup(1571272148);
            $composer.endReplaceGroup();
            throw new NoWhenBranchMatchedException();
        }
        ActivationPendingUi activationPendingUi3 = activationPendingUi;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceGroup();
        return activationPendingUi3;
    }

    /*
     * WARNING - void declaration
     */
    private static final AiaJbActivation uiState$lambda$0$0(State<? extends AiaJbActivation> $activation$delegate) {
        void $this$getValue$iv;
        State<? extends AiaJbActivation> state2 = $activation$delegate;
        Object var2_2 = null;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (AiaJbActivation)$this$getValue$iv.getValue();
    }

    private static final Unit stalledOpPresenter$lambda$0$0() {
        AiaLogPacker.Companion.getInstance().packLogs();
        return Unit.INSTANCE;
    }

    private static final Unit stalledOpPresenter$lambda$1$0(AiaActivationStalledOp $stalledOp, CoroutineScope $scope) {
        OpHandle retryHandle = (OpHandle)$stalledOp.getRetryNow().invoke();
        BuildersKt.launch$default((CoroutineScope)$scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(retryHandle, null){
            int label;
            final /* synthetic */ OpHandle<Err> $retryHandle;
            {
                this.$retryHandle = $retryHandle;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$retryHandle.awaitOpResult((Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final Unit stalledOpPresenter$lambda$2$0(ActivationPendingViewModelImpl this$0, AiaActivationStalledOp $stalledOp, CoroutineScope $scope) {
        this$0.retry($stalledOp, $scope);
        return Unit.INSTANCE;
    }

    private static final Unit stalledOpPresenter$lambda$3$0(ActivationPendingViewModelImpl this$0, AiaActivationStalledOp $stalledOp, CoroutineScope $scope) {
        this$0.retry($stalledOp, $scope);
        return Unit.INSTANCE;
    }

    private static final Unit stalledOpPresenter$lambda$4$0(ActivationPendingViewModelImpl this$0, AiaActivationStalledOp $stalledOp, CoroutineScope $scope) {
        this$0.retry($stalledOp, $scope);
        return Unit.INSTANCE;
    }

    private static final Unit stalledOpPresenter$lambda$5$0(ActivationPendingViewModelImpl this$0, AiaActivationStalledOp $stalledOp, CoroutineScope $scope) {
        this$0.retry($stalledOp, $scope);
        return Unit.INSTANCE;
    }

    private static final Unit stalledOpPresenter$lambda$6$0(ActivationPendingViewModelImpl this$0, AiaActivationStalledOp $stalledOp, CoroutineScope $scope) {
        this$0.retry($stalledOp, $scope);
        return Unit.INSTANCE;
    }

    private static final Unit stalledOpPresenter$lambda$7$0(ActivationPendingViewModelImpl this$0, AiaActivationStalledOp $stalledOp, CoroutineScope $scope) {
        this$0.retry($stalledOp, $scope);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$AuthenticationRequiredState;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$OperationState;", "action", "Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;", "<init>", "(Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;)V", "intellij.ml.llm.activation.presentation"})
    @StabilityInferred(parameters=1)
    public static final class AuthenticationRequiredState
    extends OperationState {
        public static final int $stable;

        public AuthenticationRequiredState(@NotNull AiaPendingActionFailure action2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            super(action2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$CancelledState;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$OperationState;", "action", "Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;", "<init>", "(Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;)V", "intellij.ml.llm.activation.presentation"})
    @StabilityInferred(parameters=1)
    public static final class CancelledState
    extends OperationState {
        public static final int $stable;

        public CancelledState(@NotNull AiaPendingActionFailure action2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            super(action2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$ErrorState;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$OperationState;", "errorMessage", "Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingErrorMessage;", "action", "Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;", "<init>", "(Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingErrorMessage;Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;)V", "getErrorMessage", "()Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingErrorMessage;", "intellij.ml.llm.activation.presentation"})
    @StabilityInferred(parameters=1)
    public static final class ErrorState
    extends OperationState {
        @NotNull
        private final AiaPendingErrorMessage errorMessage;
        public static final int $stable;

        public ErrorState(@NotNull AiaPendingErrorMessage errorMessage, @NotNull AiaPendingActionFailure action2) {
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            super(action2, null);
            this.errorMessage = errorMessage;
        }

        @NotNull
        public final AiaPendingErrorMessage getErrorMessage() {
            return this.errorMessage;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$InternalErrorState;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$OperationState;", "action", "Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;", "<init>", "(Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;)V", "intellij.ml.llm.activation.presentation"})
    @StabilityInferred(parameters=1)
    public static final class InternalErrorState
    extends OperationState {
        public static final int $stable;

        public InternalErrorState(@NotNull AiaPendingActionFailure action2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            super(action2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$LicenseAgreementLoadingFailedState;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$OperationState;", "action", "Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;", "<init>", "(Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;)V", "intellij.ml.llm.activation.presentation"})
    @StabilityInferred(parameters=1)
    public static final class LicenseAgreementLoadingFailedState
    extends OperationState {
        public static final int $stable;

        public LicenseAgreementLoadingFailedState(@NotNull AiaPendingActionFailure action2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            super(action2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$NetworkFailureState;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$OperationState;", "errorMessage", "Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingErrorMessage;", "action", "Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;", "<init>", "(Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingErrorMessage;Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;)V", "getErrorMessage", "()Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingErrorMessage;", "intellij.ml.llm.activation.presentation"})
    @StabilityInferred(parameters=1)
    public static final class NetworkFailureState
    extends OperationState {
        @NotNull
        private final AiaPendingErrorMessage errorMessage;
        public static final int $stable;

        public NetworkFailureState(@NotNull AiaPendingErrorMessage errorMessage, @NotNull AiaPendingActionFailure action2) {
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            super(action2, null);
            this.errorMessage = errorMessage;
        }

        @NotNull
        public final AiaPendingErrorMessage getErrorMessage() {
            return this.errorMessage;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\b\b\t\n\u000b\f\r\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$OperationState;", "", "action", "Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;", "<init>", "(Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;)V", "getAction", "()Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$AuthenticationRequiredState;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$CancelledState;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$ErrorState;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$InternalErrorState;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$LicenseAgreementLoadingFailedState;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$NetworkFailureState;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$SuccessState;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$TimeoutState;", "intellij.ml.llm.activation.presentation"})
    @StabilityInferred(parameters=1)
    public static abstract sealed class OperationState
    permits AuthenticationRequiredState, CancelledState, ErrorState, InternalErrorState, LicenseAgreementLoadingFailedState, NetworkFailureState, SuccessState, TimeoutState {
        @NotNull
        private final AiaPendingActionFailure action;
        public static final int $stable;

        private OperationState(AiaPendingActionFailure action2) {
            this.action = action2;
        }

        @NotNull
        public final AiaPendingActionFailure getAction() {
            return this.action;
        }

        public /* synthetic */ OperationState(AiaPendingActionFailure action2, DefaultConstructorMarker $constructor_marker) {
            this(action2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$SuccessState;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$OperationState;", "action", "Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;", "<init>", "(Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;)V", "intellij.ml.llm.activation.presentation"})
    @StabilityInferred(parameters=1)
    public static final class SuccessState
    extends OperationState {
        public static final int $stable;

        public SuccessState(@NotNull AiaPendingActionFailure action2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            super(action2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$TimeoutState;", "Lcom/intellij/ml/llm/activation/presentation/vm/ActivationPendingViewModelImpl$OperationState;", "action", "Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;", "<init>", "(Lcom/intellij/ml/llm/activation/presentation/vm/AiaPendingActionFailure;)V", "intellij.ml.llm.activation.presentation"})
    @StabilityInferred(parameters=1)
    public static final class TimeoutState
    extends OperationState {
        public static final int $stable;

        public TimeoutState(@NotNull AiaPendingActionFailure action2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            super(action2, null);
        }
    }
}

