/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.client;

import com.agentclientprotocol.model.ContentBlock;
import com.agentclientprotocol.model.PermissionOption;
import com.agentclientprotocol.model.PlanEntry;
import com.agentclientprotocol.model.PlanEntryStatus;
import com.agentclientprotocol.model.SessionUpdate;
import com.agentclientprotocol.model.ToolCallContent;
import com.agentclientprotocol.model.ToolCallLocation;
import com.agentclientprotocol.model.ToolCallStatus;
import com.agentclientprotocol.model.ToolKind;
import com.intellij.ml.llm.agents.A2UXEvent;
import com.intellij.ml.llm.agents.acp.client.AcpEvent;
import com.intellij.ml.llm.agents.acp.client.AcpToA2UXConverterKt;
import com.intellij.ml.llm.agents.acp.client.ChunkBuffer;
import com.intellij.ml.llm.agents.acp.client.InputRequestWrapper;
import com.intellij.ml.llm.agents.acp.client.ToolCallWrapper;
import com.intellij.ml.llm.agents.acp.process.AcpPathConverter;
import com.intellij.ml.llm.agents.acp.support.FileUtilKt;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.a2ux.api.AgentEvent;
import org.jetbrains.a2ux.api.AgentFailureEvent;
import org.jetbrains.a2ux.api.AgentPlanUpdatedEvent;
import org.jetbrains.a2ux.api.ChoiceInputRequest;
import org.jetbrains.a2ux.api.ChoiceInputResponse;
import org.jetbrains.a2ux.api.ChoiceOption;
import org.jetbrains.a2ux.api.File;
import org.jetbrains.a2ux.api.FileChange;
import org.jetbrains.a2ux.api.FileChangesBlockUpdatedEvent;
import org.jetbrains.a2ux.api.FileContent;
import org.jetbrains.a2ux.api.InputRequest;
import org.jetbrains.a2ux.api.InputResponse;
import org.jetbrains.a2ux.api.ItemStatus;
import org.jetbrains.a2ux.api.McpBlockUpdatedEvent;
import org.jetbrains.a2ux.api.PlanItem;
import org.jetbrains.a2ux.api.ResultBlockUpdatedEvent;
import org.jetbrains.a2ux.api.StepStatus;
import org.jetbrains.a2ux.api.TerminalBlockUpdatedEvent;
import org.jetbrains.a2ux.api.TextFileContent;
import org.jetbrains.a2ux.api.ToolBlockUpdatedEvent;
import org.jetbrains.a2ux.api.ToolType;
import org.jetbrains.a2ux.api.ViewFilesBlockUpdatedEvent;
import org.jetbrains.a2ux.extensions.A2uxTaskState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u001dH\u0002J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u001eH\u0002J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u001fH\u0002J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020 H\u0002J\f\u0010\u001c\u001a\u00020!*\u00020\"H\u0002J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\rH\u0002J\u000e\u0010#\u001a\u0004\u0018\u00010$*\u00020\rH\u0002J\u000e\u0010%\u001a\u0004\u0018\u00010\f*\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006&"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/AcpToA2UXConverter;", "", "project", "Lcom/intellij/openapi/project/Project;", "pathConverter", "Lcom/intellij/ml/llm/agents/acp/process/AcpPathConverter;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/agents/acp/process/AcpPathConverter;)V", "chunkBuffer", "Lcom/intellij/ml/llm/agents/acp/client/ChunkBuffer;", "toolCallsMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/ml/llm/agents/acp/client/ToolCallWrapper;", "value", "", "isFinished", "()Z", "process", "", "Lcom/intellij/ml/llm/agents/A2UXEvent;", "event", "Lcom/intellij/ml/llm/agents/acp/client/AcpEvent;", "processUserResponse", "", "userResponse", "Lorg/jetbrains/a2ux/api/InputResponse;", "withEventsFromBuffer", "convert", "Lcom/intellij/ml/llm/agents/acp/client/AcpEvent$SessionRequestPermission;", "Lcom/agentclientprotocol/model/SessionUpdate$AvailableCommandsUpdate;", "Lcom/agentclientprotocol/model/SessionUpdate$CurrentModeUpdate;", "Lcom/agentclientprotocol/model/SessionUpdate$PlanUpdate;", "Lorg/jetbrains/a2ux/api/ItemStatus;", "Lcom/agentclientprotocol/model/PlanEntryStatus;", "toToolType", "Lorg/jetbrains/a2ux/api/ToolType;", "extractText", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpToA2UXConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpToA2UXConverter.kt\ncom/intellij/ml/llm/agents/acp/client/AcpToA2UXConverter\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,268:1\n72#2,2:269\n72#2,2:272\n72#2,2:277\n1#3:271\n1#3:274\n1#3:279\n1#3:284\n295#4,2:275\n1563#4:280\n1634#4,3:281\n1563#4:285\n1634#4,3:286\n1563#4:289\n1634#4,3:290\n1563#4:293\n1634#4,3:294\n1761#4,3:297\n808#4,11:300\n1563#4:311\n1634#4,3:312\n1761#4,3:315\n808#4,11:318\n1563#4:329\n1634#4,3:330\n*S KotlinDebug\n*F\n+ 1 AcpToA2UXConverter.kt\ncom/intellij/ml/llm/agents/acp/client/AcpToA2UXConverter\n*L\n66#1:269,2\n71#1:272,2\n89#1:277,2\n66#1:271\n71#1:274\n89#1:279\n82#1:275,2\n100#1:280\n100#1:281,3\n123#1:285\n123#1:286,3\n127#1:289\n127#1:290,3\n131#1:293\n131#1:294,3\n140#1:297,3\n142#1:300,11\n142#1:311\n142#1:312,3\n159#1:315,3\n215#1:318,11\n215#1:329\n215#1:330,3\n*E\n"})
public final class AcpToA2UXConverter {
    @NotNull
    private final Project project;
    @NotNull
    private final AcpPathConverter pathConverter;
    @NotNull
    private final ChunkBuffer chunkBuffer;
    @NotNull
    private final ConcurrentHashMap<String, ToolCallWrapper> toolCallsMap;
    private boolean isFinished;

    public AcpToA2UXConverter(@NotNull Project project2, @NotNull AcpPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        this.project = project2;
        this.pathConverter = pathConverter;
        this.chunkBuffer = new ChunkBuffer();
        this.toolCallsMap = new ConcurrentHashMap();
    }

    public final boolean isFinished() {
        return this.isFinished;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<A2UXEvent> process(@NotNull AcpEvent event2) {
        List<A2UXEvent> list;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (this.isFinished) {
            throw new IllegalStateException("Already finished");
        }
        AcpEvent acpEvent = event2;
        if (acpEvent instanceof AcpEvent.SessionConnectionFailed) {
            this.isFinished = true;
            String string = ((AcpEvent.SessionConnectionFailed)event2).getMessage();
            if (string == null) {
                string = "Session connection failed";
            }
            return this.withEventsFromBuffer(CollectionsKt.listOf((Object)new A2UXEvent((AgentEvent)new AgentFailureEvent(string), A2uxTaskState.FAILED)));
        }
        if (acpEvent instanceof AcpEvent.SessionPromptFinished) {
            this.isFinished = true;
            return this.withEventsFromBuffer(CollectionsKt.listOf((Object)new A2UXEvent((AgentEvent)new ResultBlockUpdatedEvent(null, null, null, "", CollectionsKt.emptyList(), 7, null), A2uxTaskState.COMPLETED)));
        }
        if (acpEvent instanceof AcpEvent.CustomAgentEvent) {
            return this.withEventsFromBuffer(CollectionsKt.listOf((Object)new A2UXEvent(((AcpEvent.CustomAgentEvent)event2).getAgentEvent(), A2uxTaskState.IN_PROGRESS)));
        }
        if (acpEvent instanceof AcpEvent.SessionRequestPermission) {
            return this.withEventsFromBuffer(this.convert((AcpEvent.SessionRequestPermission)event2));
        }
        if (!(acpEvent instanceof AcpEvent.AcpSessionUpdate)) {
            throw new NoWhenBranchMatchedException();
        }
        SessionUpdate sessionUpdate = ((AcpEvent.AcpSessionUpdate)event2).getSessionUpdate();
        acpEvent = sessionUpdate;
        if (acpEvent instanceof SessionUpdate.AgentMessageChunk || acpEvent instanceof SessionUpdate.AgentThoughtChunk || acpEvent instanceof SessionUpdate.UserMessageChunk) {
            list = this.chunkBuffer.processChunkableUpdate(sessionUpdate);
        } else if (acpEvent instanceof SessionUpdate.AvailableCommandsUpdate) {
            list = this.withEventsFromBuffer(this.convert((SessionUpdate.AvailableCommandsUpdate)sessionUpdate));
        } else if (acpEvent instanceof SessionUpdate.CurrentModeUpdate) {
            list = this.withEventsFromBuffer(this.convert((SessionUpdate.CurrentModeUpdate)sessionUpdate));
        } else if (acpEvent instanceof SessionUpdate.PlanUpdate) {
            list = this.withEventsFromBuffer(this.convert((SessionUpdate.PlanUpdate)sessionUpdate));
        } else if (acpEvent instanceof SessionUpdate.ToolCall) {
            void $this$getOrPut$iv;
            ConcurrentMap concurrentMap = this.toolCallsMap;
            String key$iv = ((SessionUpdate.ToolCall)sessionUpdate).getToolCallId-DimCYko();
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl = false;
                ToolCallWrapper default$iv = new ToolCallWrapper(((SessionUpdate.ToolCall)sessionUpdate).getToolCallId-DimCYko(), null);
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            ToolCallWrapper wrapper = (ToolCallWrapper)object;
            wrapper.updateFrom((SessionUpdate.ToolCall)sessionUpdate);
            Intrinsics.checkNotNull((Object)wrapper);
            list = this.withEventsFromBuffer(this.convert(wrapper));
        } else if (acpEvent instanceof SessionUpdate.ToolCallUpdate) {
            ConcurrentMap $this$getOrPut$iv = this.toolCallsMap;
            String key$iv = ((SessionUpdate.ToolCallUpdate)sessionUpdate).getToolCallId-DimCYko();
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl = false;
                ToolCallWrapper default$iv = new ToolCallWrapper(((SessionUpdate.ToolCallUpdate)sessionUpdate).getToolCallId-DimCYko(), null);
                boolean bl3 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            ToolCallWrapper wrapper = (ToolCallWrapper)object;
            wrapper.updateFrom((SessionUpdate.ToolCallUpdate)sessionUpdate);
            Intrinsics.checkNotNull((Object)wrapper);
            list = this.withEventsFromBuffer(this.convert(wrapper));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    public final void processUserResponse(@NotNull InputResponse userResponse) {
        Object v2;
        ToolCallWrapper toolCall;
        block5: {
            Intrinsics.checkNotNullParameter((Object)userResponse, (String)"userResponse");
            if (!(userResponse instanceof ChoiceInputResponse)) {
                return;
            }
            ToolCallWrapper toolCallWrapper = this.toolCallsMap.get(((ChoiceInputResponse)userResponse).getRequestId());
            if (toolCallWrapper == null) {
                return;
            }
            toolCall = toolCallWrapper;
            InputRequestWrapper inputRequestWrapper = toolCall.getInputRequest();
            if (inputRequestWrapper == null) {
                return;
            }
            InputRequestWrapper inputRequest = inputRequestWrapper;
            Iterable $this$firstOrNull$iv = inputRequest.getOptions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PermissionOption it = (PermissionOption)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOptionId-w2So5B0(), (Object)((ChoiceInputResponse)userResponse).getOptionId())) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        PermissionOption permissionOption = v2;
        if (permissionOption == null) {
            return;
        }
        PermissionOption option = permissionOption;
        toolCall.inputRequestAnswered(option);
    }

    private final List<A2UXEvent> withEventsFromBuffer(List<A2UXEvent> $this$withEventsFromBuffer) {
        return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)this.chunkBuffer.flush()), (Iterable)$this$withEventsFromBuffer);
    }

    /*
     * WARNING - void declaration
     */
    private final List<A2UXEvent> convert(AcpEvent.SessionRequestPermission $this$convert) {
        void $this$getOrPut$iv;
        ConcurrentMap concurrentMap = this.toolCallsMap;
        String key$iv = $this$convert.getToolCall().getToolCallId-DimCYko();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            ToolCallWrapper default$iv = new ToolCallWrapper($this$convert.getToolCall().getToolCallId-DimCYko(), null);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        ToolCallWrapper context2 = (ToolCallWrapper)object;
        context2.updateFrom($this$convert.getToolCall());
        context2.updateFrom($this$convert);
        Intrinsics.checkNotNull((Object)context2);
        return this.convert(context2);
    }

    private final List<A2UXEvent> convert(SessionUpdate.AvailableCommandsUpdate $this$convert) {
        return CollectionsKt.emptyList();
    }

    private final List<A2UXEvent> convert(SessionUpdate.CurrentModeUpdate $this$convert) {
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final List<A2UXEvent> convert(SessionUpdate.PlanUpdate $this$convert) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$convert.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PlanEntry planEntry = (PlanEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PlanItem(this.convert(it.getStatus()), it.getContent()));
        }
        List items2 = (List)destination$iv$iv;
        return CollectionsKt.listOf((Object)new A2UXEvent((AgentEvent)new AgentPlanUpdatedEvent(items2), A2uxTaskState.IN_PROGRESS));
    }

    private final ItemStatus convert(PlanEntryStatus $this$convert) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$convert.ordinal()]) {
            case 1 -> ItemStatus.PENDING;
            case 2 -> ItemStatus.IN_PROGRESS;
            case 3 -> ItemStatus.DONE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List<A2UXEvent> convert(ToolCallWrapper $this$convert) {
        Object object;
        CharSequence charSequence;
        ChoiceInputRequest inputRequest;
        Object object2;
        String markdownText;
        A2uxTaskState taskState;
        block41: {
            block45: {
                Object object3;
                Object object4;
                block44: {
                    boolean bl;
                    block39: {
                        ToolCallContent it;
                        boolean $i$f$any;
                        Iterable $this$any$iv;
                        block43: {
                            void $this$mapTo$iv$iv;
                            String $this$map$iv;
                            void $this$filterIsInstanceTo$iv$iv;
                            String it2;
                            Object object5;
                            block42: {
                                boolean bl2;
                                block38: {
                                    block40: {
                                        List filePaths;
                                        Iterable $this$mapTo$iv$iv2;
                                        boolean $i$f$mapTo;
                                        Collection destination$iv$iv;
                                        boolean $i$f$map;
                                        Iterable $this$map$iv2;
                                        Collection destination$iv$iv2;
                                        Object request2;
                                        ToolCallStatus toolCallStatus = $this$convert.getStatus();
                                        taskState = switch (toolCallStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$1[toolCallStatus.ordinal()]) {
                                            case 1, 2 -> A2uxTaskState.IN_PROGRESS;
                                            case 3, 4 -> null;
                                            case -1 -> A2uxTaskState.IN_PROGRESS;
                                            default -> throw new NoWhenBranchMatchedException();
                                        };
                                        markdownText = this.extractText($this$convert);
                                        object2 = $this$convert.getInputRequest();
                                        InputRequestWrapper it3 = object2;
                                        boolean bl3 = false;
                                        Object object6 = $this$convert.getStatus() != ToolCallStatus.COMPLETED ? object2 : null;
                                        if (object6 != null) {
                                            void $this$mapTo$iv$iv3;
                                            void $this$map$iv3;
                                            request2 = object6;
                                            boolean bl4 = false;
                                            object4 = ((InputRequestWrapper)request2).getOptions();
                                            object3 = $this$convert.getToolCallId-DimCYko();
                                            boolean $i$f$map2 = false;
                                            void var14_27 = $this$map$iv3;
                                            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                                            boolean $i$f$mapTo2 = false;
                                            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                                                void it4;
                                                PermissionOption permissionOption = (PermissionOption)item$iv$iv;
                                                object5 = destination$iv$iv2;
                                                boolean bl5 = false;
                                                object5.add(new ChoiceOption(it4.getOptionId-w2So5B0(), it4.getName()));
                                            }
                                            List list = (List)destination$iv$iv2;
                                            Object object7 = object3;
                                            v3 = new ChoiceInputRequest((String)object7, list);
                                        } else {
                                            v3 = inputRequest = null;
                                        }
                                        if ($this$convert.getKind() != ToolKind.READ && $this$convert.getKind() != ToolKind.SEARCH) break block40;
                                        request2 = $this$convert.getLocations();
                                        Iterator it5 = request2;
                                        boolean bl6 = false;
                                        Object object8 = !((Collection)((Object)it5)).isEmpty() ? request2 : null;
                                        if (object8 != null) {
                                            $this$map$iv2 = (Iterable)object8;
                                            $i$f$map = false;
                                            object3 = $this$map$iv2;
                                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                                            $i$f$mapTo = false;
                                            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                                destination$iv$iv2 = (ToolCallLocation)item$iv$iv;
                                                Collection collection = destination$iv$iv;
                                                boolean bl7 = false;
                                                collection.add(it2.getPath());
                                            }
                                            v5 = (List)destination$iv$iv;
                                        } else {
                                            v5 = filePaths = CollectionsKt.listOfNotNull((Object)$this$convert.getFilePath());
                                        }
                                        if (!((Collection)filePaths).isEmpty()) {
                                            object2 = $this$convert.getToolCallId-DimCYko();
                                            $this$map$iv2 = filePaths;
                                            $i$f$map = false;
                                            $this$mapTo$iv$iv2 = $this$map$iv2;
                                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                                            $i$f$mapTo = false;
                                            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                                void agentPath;
                                                it2 = (String)item$iv$iv;
                                                Collection collection = destination$iv$iv;
                                                boolean bl8 = false;
                                                Path localPath = this.pathConverter.fromAgentPath((String)agentPath);
                                                collection.add(new File(FileUtilKt.relativizePath(this.project, localPath)));
                                            }
                                            request2 = (List)destination$iv$iv;
                                            DefaultConstructorMarker defaultConstructorMarker = null;
                                            int n = 2;
                                            A2uxTaskState a2uxTaskState = null;
                                            AgentEvent agentEvent = (AgentEvent)new ViewFilesBlockUpdatedEvent((String)object2, null, null, (InputRequest)inputRequest, null, (List)request2, markdownText, 22, null);
                                            return CollectionsKt.listOf((Object)new A2UXEvent(agentEvent, a2uxTaskState, n, defaultConstructorMarker));
                                        }
                                        break block41;
                                    }
                                    if ($this$convert.getKind() == ToolKind.EDIT) break block42;
                                    $this$any$iv = $this$convert.getContent();
                                    $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        bl2 = false;
                                    } else {
                                        for (Object element$iv : $this$any$iv) {
                                            it = (ToolCallContent)element$iv;
                                            boolean bl9 = false;
                                            if (!(it instanceof ToolCallContent.Diff)) continue;
                                            bl2 = true;
                                            break block38;
                                        }
                                        bl2 = false;
                                    }
                                }
                                if (!bl2) break block43;
                            }
                            Iterable $this$filterIsInstance$iv = $this$convert.getContent();
                            boolean $i$f$filterIsInstance = false;
                            Iterable element$iv = $this$filterIsInstance$iv;
                            Collection destination$iv$iv = new ArrayList();
                            boolean $i$f$filterIsInstanceTo = false;
                            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                if (!(element$iv$iv instanceof ToolCallContent.Diff)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filterIsInstance$iv = (List)destination$iv$iv;
                            boolean $i$f$map = false;
                            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                String relativePath;
                                TextFileContent textFileContent;
                                void diff2;
                                ToolCallContent.Diff $i$f$map2 = (ToolCallContent.Diff)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl10 = false;
                                if (diff2.getOldText() != null) {
                                    boolean bl11 = false;
                                    textFileContent = new TextFileContent(it2);
                                } else {
                                    textFileContent = null;
                                }
                                TextFileContent beforeContent = textFileContent;
                                TextFileContent afterContent = new TextFileContent(diff2.getNewText());
                                Path localPath = this.pathConverter.fromAgentPath(diff2.getPath());
                                String string = relativePath = FileUtilKt.relativizePath(this.project, localPath);
                                object5 = string;
                                FileContent fileContent = (FileContent)afterContent;
                                FileContent fileContent2 = (FileContent)beforeContent;
                                boolean bl12 = false;
                                boolean bl13 = beforeContent != null;
                                String string2 = relativePath;
                                String string3 = bl13 ? string : null;
                                FileContent fileContent3 = fileContent;
                                FileContent fileContent4 = fileContent2;
                                collection.add(new FileChange(fileContent4, fileContent3, string3, string2));
                            }
                            List changes2 = (List)destination$iv$iv;
                            $this$map$iv = $this$convert.getToolCallId-DimCYko();
                            StepStatus stepStatus = AcpToA2UXConverterKt.access$getToolStatus($this$convert);
                            return CollectionsKt.listOf((Object)new A2UXEvent((AgentEvent)new FileChangesBlockUpdatedEvent($this$map$iv, null, null, (InputRequest)inputRequest, stepStatus, changes2, markdownText, 6, null), taskState));
                        }
                        if ($this$convert.getKind() == ToolKind.EXECUTE) break block44;
                        $this$any$iv = $this$convert.getContent();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (ToolCallContent)element$iv;
                                boolean bl14 = false;
                                if (!(it instanceof ToolCallContent.Terminal)) continue;
                                bl = true;
                                break block39;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block45;
                }
                charSequence = $this$convert.getToolCallId-DimCYko();
                String string = $this$convert.getCommand();
                if (string == null) {
                    string = $this$convert.getTitle();
                }
                String string4 = string;
                object = AcpToA2UXConverterKt.access$getToolStatus($this$convert);
                String string5 = $this$convert.getOutput();
                Object it = object3 = AcpToA2UXConverterKt.takeIfNotOutput(markdownText);
                boolean bl = false;
                object4 = $this$convert.getStatus() != ToolCallStatus.COMPLETED ? object3 : null;
                A2uxTaskState a2uxTaskState = taskState;
                AgentEvent agentEvent = (AgentEvent)new TerminalBlockUpdatedEvent((String)charSequence, null, null, (InputRequest)inputRequest, null, null, (StepStatus)object, string4, string5, (String)object4, 54, null);
                return CollectionsKt.listOf((Object)new A2UXEvent(agentEvent, a2uxTaskState));
            }
            String string = $this$convert.getTitle();
            boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"mcp__", (boolean)false, (int)2, null) : false;
            if (bl) {
                charSequence = $this$convert.getToolCallId-DimCYko();
                String string6 = $this$convert.getTitle();
                if (string6 == null) {
                    string6 = "";
                }
                String string7 = string6;
                object = AcpToA2UXConverterKt.access$getToolStatus($this$convert);
                return CollectionsKt.listOf((Object)new A2UXEvent((AgentEvent)new McpBlockUpdatedEvent((String)charSequence, null, null, (InputRequest)inputRequest, string7, null, (StepStatus)object, markdownText, 38, null), null, 2, null));
            }
        }
        if (!((charSequence = (CharSequence)$this$convert.getTitle()) == null || charSequence.length() == 0)) {
            charSequence = $this$convert.getToolCallId-DimCYko();
            String string = $this$convert.getTitle();
            if (string == null) {
                string = "";
            }
            object2 = string;
            object = this.toToolType($this$convert);
            return CollectionsKt.listOf((Object)new A2UXEvent((AgentEvent)new ToolBlockUpdatedEvent((String)charSequence, null, null, (InputRequest)inputRequest, (String)object2, null, null, markdownText, (ToolType)object, 102, null), taskState));
        }
        return CollectionsKt.emptyList();
    }

    private final ToolType toToolType(ToolCallWrapper $this$toToolType) {
        ToolKind toolKind = $this$toToolType.getKind();
        return switch (toolKind == null ? -1 : WhenMappings.$EnumSwitchMapping$2[toolKind.ordinal()]) {
            case 1 -> ToolType.Search;
            case 2 -> ToolType.Read;
            case 3 -> ToolType.Edit;
            case 4 -> ToolType.Edit;
            case 5 -> ToolType.Edit;
            case 6 -> ToolType.Run;
            case 7 -> ToolType.Plan;
            case 8 -> ToolType.Download;
            case 9 -> null;
            case 10 -> null;
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final String extractText(ToolCallWrapper $this$extractText) {
        String string;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$extractText.getContent();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ToolCallContent.Content)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ToolCallContent.Content content2 = (ToolCallContent.Content)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getContent());
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ContentBlock.Text)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String it = string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, AcpToA2UXConverter::extractText$lambda$1, (int)30, null);
        boolean bl = false;
        return !StringsKt.isBlank((CharSequence)it) ? string : null;
    }

    private static final CharSequence extractText$lambda$1(ContentBlock.Text it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[PlanEntryStatus.values().length];
            try {
                nArray[PlanEntryStatus.PENDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlanEntryStatus.IN_PROGRESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlanEntryStatus.COMPLETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ToolCallStatus.values().length];
            try {
                nArray[ToolCallStatus.PENDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolCallStatus.IN_PROGRESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolCallStatus.COMPLETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolCallStatus.FAILED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ToolKind.values().length];
            try {
                nArray[ToolKind.SEARCH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolKind.READ.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolKind.EDIT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolKind.DELETE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolKind.MOVE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolKind.EXECUTE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolKind.THINK.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolKind.FETCH.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolKind.SWITCH_MODE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolKind.OTHER.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

