/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.diagnostic;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.IdeaLogRecordFormatter;
import com.intellij.openapi.diagnostic.JulLogger;
import com.intellij.openapi.diagnostic.RollingFileHandler;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/agents/acp/diagnostic/AcpLoggerFactory;", "", "<init>", "()V", "TRANSPORT_LOGGER_NAME", "", "TRANSPORT_LOG_FILE", "ACP_LOG_FILE", "ACP_LOGS_DIR", "ACP_PACKAGE", "ACP_LIBRARY_PACKAGE", "transportLogger", "Ljava/util/logging/Logger;", "getTransportLogger", "getTransportLogPath", "Ljava/nio/file/Path;", "getAcpLogsDirectory", "intellij.ml.llm.agents.acp"})
public final class AcpLoggerFactory {
    @NotNull
    public static final AcpLoggerFactory INSTANCE = new AcpLoggerFactory();
    @NotNull
    private static final String TRANSPORT_LOGGER_NAME = "AcpTransport";
    @NotNull
    private static final String TRANSPORT_LOG_FILE = "acp-transport.log";
    @NotNull
    private static final String ACP_LOG_FILE = "acp.log";
    @NotNull
    private static final String ACP_LOGS_DIR = "acp";
    @NotNull
    private static final String ACP_PACKAGE = "#com.intellij.ml.llm.agents.acp";
    @NotNull
    private static final String ACP_LIBRARY_PACKAGE = "com.agentclientprotocol";
    @NotNull
    private static final Logger transportLogger;

    private AcpLoggerFactory() {
    }

    @NotNull
    public final Logger getTransportLogger() {
        return transportLogger;
    }

    @NotNull
    public final Path getTransportLogPath() {
        Path path = PathManager.getLogDir().resolve(ACP_LOGS_DIR).resolve(TRANSPORT_LOG_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getAcpLogsDirectory() {
        Path path = PathManager.getLogDir().resolve(ACP_LOGS_DIR);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    static {
        Path acpLogDir = PathManager.getLogDir().resolve(ACP_LOGS_DIR);
        Files.createDirectories(acpLogDir, new FileAttribute[0]);
        Path path = acpLogDir.resolve(ACP_LOG_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        RollingFileHandler acpLogHandler = new RollingFileHandler(path, JulLogger.LOG_FILE_SIZE_LIMIT, JulLogger.LOG_FILE_COUNT, true, null, 16, null);
        acpLogHandler.setLevel(Level.FINER);
        acpLogHandler.setFormatter((Formatter)new IdeaLogRecordFormatter());
        Logger acpPackageLogger = Logger.getLogger(ACP_PACKAGE);
        acpPackageLogger.setLevel(Level.FINER);
        acpPackageLogger.addHandler((Handler)acpLogHandler);
        Logger acpLibraryLogger = Logger.getLogger(ACP_LIBRARY_PACKAGE);
        acpLibraryLogger.setLevel(Level.FINER);
        acpLibraryLogger.addHandler((Handler)acpLogHandler);
        Logger logger = Logger.getLogger(TRANSPORT_LOGGER_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        transportLogger = logger;
        transportLogger.setLevel(Level.FINEST);
        transportLogger.setUseParentHandlers(false);
        Path logPath = acpLogDir.resolve(TRANSPORT_LOG_FILE);
        Intrinsics.checkNotNull((Object)logPath);
        RollingFileHandler handler2 = new RollingFileHandler(logPath, JulLogger.LOG_FILE_SIZE_LIMIT, JulLogger.LOG_FILE_COUNT, true, null, 16, null);
        handler2.setLevel(Level.FINEST);
        handler2.setFormatter((Formatter)new IdeaLogRecordFormatter());
        transportLogger.addHandler((Handler)handler2);
    }
}

