/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.process;

import com.agentclientprotocol.protocol.Protocol;
import com.agentclientprotocol.protocol.ProtocolOptions;
import com.agentclientprotocol.transport.Transport;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.execution.wsl.WslIjentManager;
import com.intellij.ml.llm.agents.acp.AcpTransportUtil;
import com.intellij.ml.llm.agents.acp.config.AcpConfigurationLoader;
import com.intellij.ml.llm.agents.acp.config.AgentServerConfig;
import com.intellij.ml.llm.agents.acp.config.ExecutionEnvironment;
import com.intellij.ml.llm.agents.acp.config.ExecutionEnvironmentType;
import com.intellij.ml.llm.agents.acp.process.AcpPathConverter;
import com.intellij.ml.llm.agents.acp.process.EelAcpProcessHandler;
import com.intellij.ml.llm.agents.acp.process.EelAcpProcessHandlerKt;
import com.intellij.ml.llm.agents.acp.process.EelAwarePathConverter;
import com.intellij.ml.llm.agents.acp.process.LocalAcpServerProcessHandler;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelExecApi;
import com.intellij.platform.eel.EelExecApiKt;
import com.intellij.platform.eel.EelProcess;
import com.intellij.platform.eel.ReadResult;
import com.intellij.platform.eel.channels.EelReceiveChannel;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.ide.impl.wsl.WslEelDescriptor;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 12\u00020\u0001:\u00011BR\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\r\u00a2\u0006\u0004\b\u0012\u0010\u0013J\b\u0010&\u001a\u00020\u0011H\u0002J\u001c\u0010'\u001a\u00020\u00112\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00110\rH\u0002J\u0016\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*H\u0082@\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u000bH\u0002J\b\u0010.\u001a\u00020\u0011H\u0016J\b\u0010/\u001a\u00020\u0011H\u0002J\b\u00100\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010%\u00a8\u00062"}, d2={"Lcom/intellij/ml/llm/agents/acp/process/EelAcpProcessHandler;", "Lcom/intellij/ml/llm/agents/acp/process/LocalAcpServerProcessHandler;", "eelProcess", "Lcom/intellij/platform/eel/EelProcess;", "projectDir", "Ljava/nio/file/Path;", "pathConverter", "Lcom/intellij/ml/llm/agents/acp/process/AcpPathConverter;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "agentName", "", "handleError", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "error", "", "<init>", "(Lcom/intellij/platform/eel/EelProcess;Ljava/nio/file/Path;Lcom/intellij/ml/llm/agents/acp/process/AcpPathConverter;Lkotlinx/coroutines/CoroutineScope;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getProjectDir", "()Ljava/nio/file/Path;", "getPathConverter", "()Lcom/intellij/ml/llm/agents/acp/process/AcpPathConverter;", "processScope", "terminated", "Ljava/util/concurrent/atomic/AtomicBoolean;", "stdErrBuffer", "Ljava/lang/StringBuffer;", "transport", "Lcom/agentclientprotocol/transport/Transport;", "protocol", "Lcom/agentclientprotocol/protocol/Protocol;", "getProtocol", "()Lcom/agentclientprotocol/protocol/Protocol;", "isRunning", "", "()Z", "initialize", "monitorProcessTermination", "readStderr", "stderr", "Lcom/intellij/platform/eel/channels/EelReceiveChannel;", "(Lcom/intellij/platform/eel/channels/EelReceiveChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "appendStdErr", "line", "stopServer", "killProcess", "cleanup", "Companion", "intellij.ml.llm.agents.acp"})
public final class EelAcpProcessHandler
implements LocalAcpServerProcessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EelProcess eelProcess;
    @NotNull
    private final Path projectDir;
    @NotNull
    private final AcpPathConverter pathConverter;
    @NotNull
    private final String agentName;
    @NotNull
    private final CoroutineScope processScope;
    @NotNull
    private final AtomicBoolean terminated;
    @NotNull
    private final StringBuffer stdErrBuffer;
    @NotNull
    private final Transport transport;
    @NotNull
    private final Protocol protocol;
    private static final int STD_ERR_BUFFER_SIZE = 10000;

    public EelAcpProcessHandler(@NotNull EelProcess eelProcess, @NotNull Path projectDir, @NotNull AcpPathConverter pathConverter, @NotNull CoroutineScope cs, @NotNull String agentName, @NotNull Function1<? super String, Unit> handleError2) {
        Intrinsics.checkNotNullParameter((Object)eelProcess, (String)"eelProcess");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        Intrinsics.checkNotNullParameter(handleError2, (String)"handleError");
        this.eelProcess = eelProcess;
        this.projectDir = projectDir;
        this.pathConverter = pathConverter;
        this.agentName = agentName;
        this.processScope = CoroutineScopeKt.childScope$default((CoroutineScope)cs, (String)("EelAcpProcessHandler-" + this.agentName), null, (boolean)false, (int)6, null);
        this.terminated = new AtomicBoolean(false);
        this.stdErrBuffer = new StringBuffer();
        this.transport = AcpTransportUtil.INSTANCE.createEelStdioTransport(this.processScope, this.eelProcess);
        this.protocol = new Protocol(this.processScope, this.transport, new ProtocolOptions(DurationKt.toDuration((int)60, (DurationUnit)DurationUnit.SECONDS), 0L, null, 6, null));
        this.initialize();
        this.monitorProcessTermination(handleError2);
    }

    @Override
    @NotNull
    public Path getProjectDir() {
        return this.projectDir;
    }

    @Override
    @NotNull
    public AcpPathConverter getPathConverter() {
        return this.pathConverter;
    }

    @Override
    @NotNull
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public boolean isRunning() {
        return !this.terminated.get() && !this.eelProcess.getExitCode().isCompleted();
    }

    private final void initialize() {
        this.transport.onError(arg_0 -> EelAcpProcessHandler.initialize$lambda$0(this, arg_0));
        this.getProtocol().start();
    }

    private final void monitorProcessTermination(Function1<? super String, Unit> handleError2) {
        BuildersKt.launch$default((CoroutineScope)this.processScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ EelAcpProcessHandler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = EelAcpProcessHandler.access$readStderr(this.this$0, EelAcpProcessHandler.access$getEelProcess$p(this.this$0).getStderr(), (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object2;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (CancellationException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            EelAcpProcessHandlerKt.access$getLogger$p().error("[" + EelAcpProcessHandler.access$getAgentName$p(this.this$0) + "] Error monitoring stderr", (Throwable)e);
                            EelAcpProcessHandler.access$killProcess(this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        BuildersKt.launch$default((CoroutineScope)this.processScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, handleError2, null){
            int label;
            final /* synthetic */ EelAcpProcessHandler this$0;
            final /* synthetic */ Function1<String, Unit> $handleError;
            {
                this.this$0 = $receiver;
                this.$handleError = $handleError;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = EelAcpProcessHandler.access$getEelProcess$p(this.this$0).getExitCode().await((Continuation)this);
                        ** if (v0 != var7_2) goto lbl11
lbl10:
                        // 1 sources

                        return var7_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            exitCode = ((Number)v0).intValue();
                            EelAcpProcessHandler.access$getTerminated$p(this.this$0).set(true);
                            if (exitCode != 0) {
                                it = var4_5 = EelAcpProcessHandler.access$getStdErrBuffer$p(this.this$0).toString();
                                $i$a$-takeIf-EelAcpProcessHandler$monitorProcessTermination$2$error$1 = false;
                                Intrinsics.checkNotNull((Object)it);
                                v1 = ((CharSequence)it).length() > 0 != false ? var4_5 : null;
                                if (v1 != null) {
                                    it = v1;
                                    $i$a$-let-EelAcpProcessHandler$monitorProcessTermination$2$error$2 = false;
                                    v2 = " Process output:\n" + it;
                                } else {
                                    v2 = v3 = null;
                                }
                                if (v2 == null) {
                                    v3 = "";
                                }
                                error = v3;
                                this.$handleError.invoke((Object)("Process terminated with exit code: " + exitCode + "." + error));
                                EelAcpProcessHandlerKt.access$getLogger$p().warn("[" + EelAcpProcessHandler.access$getAgentName$p(this.this$0) + "] Process terminated with exit code " + exitCode);
                            } else {
                                EelAcpProcessHandlerKt.access$getLogger$p().info("[" + EelAcpProcessHandler.access$getAgentName$p(this.this$0) + "] Process terminated successfully (exit code 0)");
                            }
                        }
                        catch (Throwable var2_4) {
                            throw var2_4;
                        }
                        finally {
                            EelAcpProcessHandler.access$cleanup(this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object readStderr(EelReceiveChannel stderr, Continuation<? super Unit> $completion) {
        if (!($completion instanceof readStderr.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ EelAcpProcessHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EelAcpProcessHandler.access$readStderr(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                buffer = ByteBuffer.allocate(8192);
lbl13:
                // 2 sources

                while (true) {
                    Intrinsics.checkNotNull((Object)buffer);
                    $continuation.L$0 = stderr;
                    $continuation.L$1 = buffer;
                    $continuation.label = 1;
                    v0 = stderr.receive(buffer, (Continuation)$continuation);
                    if (v0 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl27
                    break;
                }
            }
            case 1: {
                buffer = (ByteBuffer)$continuation.L$1;
                stderr = (EelReceiveChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                if (v0 != ReadResult.EOF) {
                    buffer.flip();
                    if (buffer.hasRemaining()) {
                        Intrinsics.checkNotNullExpressionValue((Object)Charsets.UTF_8.decode(buffer).toString(), (String)"toString(...)");
                        this.appendStdErr(line);
                        EelAcpProcessHandlerKt.access$getLogger$p().warn("[" + this.agentName + "] stderr: " + line);
                    }
                    buffer.clear();
                    ** continue;
                }
                EelAcpProcessHandlerKt.access$getLogger$p().info("[" + this.agentName + "] Stderr stream closed");
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void appendStdErr(String line) {
        if (this.stdErrBuffer.length() >= 10000) {
            this.stdErrBuffer.delete(0, 5000);
        }
        ((Appendable)this.stdErrBuffer).append(line).append('\n');
    }

    @Override
    public void stopServer() {
        EelAcpProcessHandlerKt.access$getLogger$p().info("[" + this.agentName + "] Stopping server");
        if (this.terminated.compareAndSet(false, true)) {
            BuildersKt.launch$default((CoroutineScope)this.processScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                int I$0;
                int label;
                final /* synthetic */ EelAcpProcessHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Exception decompiling
                 */
                public final Object invokeSuspend(Object $result) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CASE], 6[SWITCH]], but top level block is 3[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.dump(StructuredIf.java:61)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                     *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final void killProcess() {
        if (this.terminated.compareAndSet(false, true)) {
            EelAcpProcessHandlerKt.access$getLogger$p().warn("[" + this.agentName + "] Killing process due to error");
            BuildersKt.launch$default((CoroutineScope)this.processScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ EelAcpProcessHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = EelAcpProcessHandler.access$getEelProcess$p(this.this$0).kill((Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            Object object2;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                object2 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Exception e) {
                                EelAcpProcessHandlerKt.access$getLogger$p().error("[" + EelAcpProcessHandler.access$getAgentName$p(this.this$0) + "] Error killing process", (Throwable)e);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final void cleanup() {
        EelAcpProcessHandlerKt.access$getLogger$p().info("[" + this.agentName + "] Cleaning up process resources");
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.processScope, null, (int)1, null);
    }

    private static final Unit initialize$lambda$0(EelAcpProcessHandler this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EelAcpProcessHandlerKt.access$getLogger$p().error("[" + this$0.agentName + "] Transport error", it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$readStderr(EelAcpProcessHandler $this, EelReceiveChannel stderr, Continuation $completion) {
        return $this.readStderr(stderr, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ EelProcess access$getEelProcess$p(EelAcpProcessHandler $this) {
        return $this.eelProcess;
    }

    public static final /* synthetic */ String access$getAgentName$p(EelAcpProcessHandler $this) {
        return $this.agentName;
    }

    public static final /* synthetic */ void access$killProcess(EelAcpProcessHandler $this) {
        $this.killProcess();
    }

    public static final /* synthetic */ AtomicBoolean access$getTerminated$p(EelAcpProcessHandler $this) {
        return $this.terminated;
    }

    public static final /* synthetic */ StringBuffer access$getStdErrBuffer$p(EelAcpProcessHandler $this) {
        return $this.stdErrBuffer;
    }

    public static final /* synthetic */ void access$cleanup(EelAcpProcessHandler $this) {
        $this.cleanup();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0082@\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0082@\u00a2\u0006\u0002\u0010\u000eJQ\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b0\u0017H\u0086@\u00a2\u0006\u0002\u0010\u001cJ*\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\rH\u0082@\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/agents/acp/process/EelAcpProcessHandler$Companion;", "", "<init>", "()V", "STD_ERR_BUFFER_SIZE", "", "resolveEelInstance", "Lcom/intellij/platform/eel/EelApi;", "config", "Lcom/intellij/ml/llm/agents/acp/config/AgentServerConfig;", "(Lcom/intellij/ml/llm/agents/acp/config/AgentServerConfig;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getWslEel", "distributionName", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startProcess", "Lcom/intellij/ml/llm/agents/acp/process/EelAcpProcessHandler;", "agentName", "projectDir", "Ljava/nio/file/Path;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "handleError", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "error", "", "(Ljava/lang/String;Lcom/intellij/ml/llm/agents/acp/config/AgentServerConfig;Ljava/nio/file/Path;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadEnv", "", "exec", "Lcom/intellij/platform/eel/EelExecApi;", "(Lcom/intellij/platform/eel/EelExecApi;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.agents.acp"})
    @SourceDebugExtension(value={"SMAP\nEelAcpProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelAcpProcessHandler.kt\ncom/intellij/ml/llm/agents/acp/process/EelAcpProcessHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,351:1\n295#2,2:352\n1563#2:354\n1634#2,3:355\n1#3:358\n216#4,2:359\n*S KotlinDebug\n*F\n+ 1 EelAcpProcessHandler.kt\ncom/intellij/ml/llm/agents/acp/process/EelAcpProcessHandler$Companion\n*L\n245#1:352,2\n278#1:354\n278#1:355,3\n306#1:359,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Object resolveEelInstance(AgentServerConfig config, Continuation<? super EelApi> $completion) {
            ExecutionEnvironment execEnv = config.getExecutionEnvironment();
            if (execEnv == null) {
                EelAcpProcessHandlerKt.access$getLogger$p().info("No execution environment specified, using local Eel");
                return EelProviderUtil.getLocalEel();
            }
            switch (WhenMappings.$EnumSwitchMapping$0[execEnv.getType().ordinal()]) {
                case 1: {
                    String distributionName = execEnv.getDistribution();
                    List list = WslDistributionManager.getInstance().getInstalledDistributions();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInstalledDistributions(...)");
                    List distributions = list;
                    EelAcpProcessHandlerKt.access$getLogger$p().info("Execution environment type: WSL, available distributions: " + CollectionsKt.joinToString$default((Iterable)distributions, null, null, null, (int)0, null, Companion::resolveEelInstance$lambda$0, (int)31, null));
                    if (distributionName != null) {
                        EelAcpProcessHandlerKt.access$getLogger$p().info("Using WSL execution for distribution: " + distributionName);
                        return this.getWslEel(distributionName, $completion);
                    }
                    EelAcpProcessHandlerKt.access$getLogger$p().info("Using WSL execution with default distribution");
                    WSLDistribution wSLDistribution = (WSLDistribution)CollectionsKt.firstOrNull((List)distributions);
                    if (wSLDistribution == null) {
                        throw new IllegalStateException("No WSL distributions found");
                    }
                    WSLDistribution defaultDistribution = wSLDistribution;
                    String string = defaultDistribution.getMsId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-msId>(...)");
                    return this.getWslEel(string, $completion);
                }
                case 2: {
                    EelAcpProcessHandlerKt.access$getLogger$p().info("Using local execution environment");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return (EelApi)EelProviderUtil.getLocalEel();
        }

        /*
         * Unable to fully structure code
         */
        private final Object getWslEel(String distributionName, Continuation<? super EelApi> $completion) {
            if (!($completion instanceof getWslEel.1)) ** GOTO lbl-1000
            var12_3 = $completion;
            if ((var12_3.label & -2147483648) != 0) {
                var12_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return com.intellij.ml.llm.agents.acp.process.EelAcpProcessHandler$Companion.access$getWslEel(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = WslDistributionManager.getInstance().getInstalledDistributions();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstalledDistributions(...)");
                    var5_6 = v0;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        it = (WSLDistribution)element$iv;
                        $i$a$-firstOrNull-EelAcpProcessHandler$Companion$getWslEel$distribution$1 = false;
                        if (!Intrinsics.areEqual((Object)it.getMsId(), (Object)distributionName)) continue;
                        v1 = element$iv;
                        ** GOTO lbl24
                    }
                    v1 = null;
lbl24:
                    // 2 sources

                    v2 = v1;
                    if (v2 == null) {
                        throw new IllegalArgumentException("WSL distribution not found: " + distributionName);
                    }
                    distribution = v2;
                    descriptor = new WslEelDescriptor(distribution);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)distributionName);
                    $continuation.L$1 = distribution;
                    $continuation.L$2 = descriptor;
                    $continuation.label = 1;
                    v3 = WslIjentManager.Companion.instanceAsync((Continuation)$continuation);
                    if (v3 == var13_5) {
                        return var13_5;
                    }
                    ** GOTO lbl43
                }
                case 1: {
                    descriptor = (WslEelDescriptor)$continuation.L$2;
                    distribution = (WSLDistribution)$continuation.L$1;
                    distributionName = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl43:
                    // 2 sources

                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)distributionName);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)distribution);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)descriptor);
                    $continuation.label = 2;
                    v4 = ((WslIjentManager)v3).getIjentApi((EelDescriptor)descriptor, distribution, null, false, (Continuation)$continuation);
                    if (v4 == var13_5) {
                        return var13_5;
                    }
                    ** GOTO lbl57
                }
                case 2: {
                    descriptor = (WslEelDescriptor)$continuation.L$2;
                    distribution = (WSLDistribution)$continuation.L$1;
                    distributionName = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl57:
                    // 2 sources

                    return v4;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Nullable
        public final Object startProcess(@NotNull String agentName, @NotNull AgentServerConfig config, @NotNull Path projectDir, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super String, Unit> handleError, @NotNull Continuation<? super EelAcpProcessHandler> $completion) {
            if (!($completion instanceof startProcess.1)) ** GOTO lbl-1000
            var27_7 = $completion;
            if ((var27_7.label & -2147483648) != 0) {
                var27_7.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    Object L$9;
                    Object L$10;
                    Object L$11;
                    Object L$12;
                    Object L$13;
                    Object L$14;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.startProcess(null, null, null, null, null, (Continuation<? super EelAcpProcessHandler>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var28_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    expandedCommand = AcpConfigurationLoader.INSTANCE.expandPath(config.getCommand());
                    $this$map$iv = config.getArgs();
                    $i$f$map = false;
                    var11_16 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var16_27 = (String)item$iv$iv;
                        var25_31 = destination$iv$iv;
                        $i$a$-map-EelAcpProcessHandler$Companion$startProcess$expandedArgs$1 = false;
                        var25_31.add(AcpConfigurationLoader.INSTANCE.expandPath((String)it /* !! */ ));
                    }
                    expandedArgs = (List)destination$iv$iv;
                    EelAcpProcessHandlerKt.access$getLogger$p().info("[" + agentName + "] Starting ACP agent with Eel");
                    EelAcpProcessHandlerKt.access$getLogger$p().info("[" + agentName + "]   Command: " + expandedCommand);
                    EelAcpProcessHandlerKt.access$getLogger$p().info("[" + agentName + "]   Args: " + expandedArgs);
                    EelAcpProcessHandlerKt.access$getLogger$p().info("[" + agentName + "]   Working dir: " + projectDir);
                    $continuation.L$0 = agentName;
                    $continuation.L$1 = config;
                    $continuation.L$2 = projectDir;
                    $continuation.L$3 = coroutineScope;
                    $continuation.L$4 = handleError;
                    $continuation.L$5 = expandedCommand;
                    $continuation.L$6 = expandedArgs;
                    $continuation.label = 1;
                    v0 = this.resolveEelInstance(config, (Continuation<? super EelApi>)$continuation);
                    if (v0 == var28_9) {
                        return var28_9;
                    }
                    ** GOTO lbl52
                }
                case 1: {
                    expandedArgs = (List)$continuation.L$6;
                    expandedCommand = (String)$continuation.L$5;
                    handleError = (Function1)$continuation.L$4;
                    coroutineScope = (CoroutineScope)$continuation.L$3;
                    projectDir = (Path)$continuation.L$2;
                    config = (AgentServerConfig)$continuation.L$1;
                    agentName = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl52:
                    // 2 sources

                    eel = (EelApi)v0;
                    pathConverter = new EelAwarePathConverter(eel);
                    eelDescriptor = eel.getDescriptor();
                    if (!(eelDescriptor instanceof WslEelDescriptor) || EelProviderUtil.getEelDescriptor((Path)projectDir) != LocalEelDescriptor.INSTANCE) ** GOTO lbl67
                    v1 /* !! */  = ((WslEelDescriptor)eelDescriptor).getDistribution().getWslPath(projectDir);
                    if (v1 /* !! */  == null) ** GOTO lbl64
                    it /* !! */  = v1 /* !! */ ;
                    $i$a$-let-EelAcpProcessHandler$Companion$startProcess$workingDir$1 = false;
                    v2 = EelPath.Companion.parse((String)it /* !! */ , eelDescriptor);
                    v1 /* !! */  = v2;
                    if (v2 != null) ** GOTO lbl68
lbl64:
                    // 2 sources

                    v1 /* !! */  = EelNioBridgeServiceKt.asEelPath((Path)projectDir);
                    ** GOTO lbl68
lbl67:
                    // 1 sources

                    v1 /* !! */  = EelNioBridgeServiceKt.asEelPath((Path)projectDir);
lbl68:
                    // 3 sources

                    workingDir = v1 /* !! */ ;
                    exec = eel.getExec();
                    $continuation.L$0 = agentName;
                    $continuation.L$1 = config;
                    $continuation.L$2 = projectDir;
                    $continuation.L$3 = coroutineScope;
                    $continuation.L$4 = handleError;
                    $continuation.L$5 = expandedCommand;
                    $continuation.L$6 = expandedArgs;
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)eel);
                    $continuation.L$8 = pathConverter;
                    $continuation.L$9 = eelDescriptor;
                    $continuation.L$10 = workingDir;
                    $continuation.L$11 = exec;
                    $continuation.label = 2;
                    v3 = EelExecApiKt.where((EelExecApi)exec, (String)expandedCommand, (Continuation)$continuation);
                    if (v3 == var28_9) {
                        return var28_9;
                    }
                    ** GOTO lbl102
                }
                case 2: {
                    exec = (EelExecApi)$continuation.L$11;
                    workingDir = (EelPath)$continuation.L$10;
                    eelDescriptor = (EelDescriptor)$continuation.L$9;
                    pathConverter = (EelAwarePathConverter)$continuation.L$8;
                    eel = (EelApi)$continuation.L$7;
                    expandedArgs = (List)$continuation.L$6;
                    expandedCommand = (String)$continuation.L$5;
                    handleError = (Function1)$continuation.L$4;
                    coroutineScope = (CoroutineScope)$continuation.L$3;
                    projectDir = (Path)$continuation.L$2;
                    config = (AgentServerConfig)$continuation.L$1;
                    agentName = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl102:
                    // 2 sources

                    locatedProcess = (EelPath)v3;
                    EelAcpProcessHandlerKt.access$getLogger$p().info("[" + agentName + "] Located process: " + locatedProcess);
                    EelAcpProcessHandlerKt.access$getLogger$p().info("Current PATH: " + PathEnvironmentVariableUtil.getPathVariableValue());
                    v4 = locatedProcess;
                    if (v4 == null) {
                        v4 = EelPath.Companion.parse(expandedCommand, eelDescriptor);
                    }
                    where = v4;
                    $continuation.L$0 = agentName;
                    $continuation.L$1 = config;
                    $continuation.L$2 = projectDir;
                    $continuation.L$3 = coroutineScope;
                    $continuation.L$4 = handleError;
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)expandedCommand);
                    $continuation.L$6 = expandedArgs;
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)eel);
                    $continuation.L$8 = pathConverter;
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)eelDescriptor);
                    $continuation.L$10 = workingDir;
                    $continuation.L$11 = exec;
                    $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)locatedProcess);
                    $continuation.L$13 = where;
                    $continuation.label = 3;
                    v5 = this.loadEnv(exec, agentName, (Continuation<? super Map<String, String>>)$continuation);
                    if (v5 == var28_9) {
                        return var28_9;
                    }
                    ** GOTO lbl145
                }
                case 3: {
                    where = (EelPath)$continuation.L$13;
                    locatedProcess = (EelPath)$continuation.L$12;
                    exec = (EelExecApi)$continuation.L$11;
                    workingDir = (EelPath)$continuation.L$10;
                    eelDescriptor = (EelDescriptor)$continuation.L$9;
                    pathConverter = (EelAwarePathConverter)$continuation.L$8;
                    eel = (EelApi)$continuation.L$7;
                    expandedArgs = (List)$continuation.L$6;
                    expandedCommand = (String)$continuation.L$5;
                    handleError = (Function1)$continuation.L$4;
                    coroutineScope = (CoroutineScope)$continuation.L$3;
                    projectDir = (Path)$continuation.L$2;
                    config = (AgentServerConfig)$continuation.L$1;
                    agentName = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl145:
                    // 2 sources

                    env = MapsKt.toMutableMap((Map)((Map)v5));
                    EelAcpProcessHandlerKt.access$getLogger$p().info("Available env variables: " + CollectionsKt.joinToString$default((Iterable)env.keySet(), null, null, null, (int)0, null, null, (int)63, null));
                    $this$forEach$iv = config.getEnv();
                    $i$f$forEach = false;
                    var19_35 = $this$forEach$iv.entrySet().iterator();
                    while (var19_35.hasNext()) {
                        var21_37 = element$iv = var19_35.next();
                        $i$a$-forEach-EelAcpProcessHandler$Companion$startProcess$2 = false;
                        key = var21_37.getKey();
                        value = var21_37.getValue();
                        env.put(key, value);
                    }
                    $continuation.L$0 = agentName;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)config);
                    $continuation.L$2 = projectDir;
                    $continuation.L$3 = coroutineScope;
                    $continuation.L$4 = handleError;
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)expandedCommand);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)expandedArgs);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)eel);
                    $continuation.L$8 = pathConverter;
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)eelDescriptor);
                    $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)workingDir);
                    $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)exec);
                    $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)locatedProcess);
                    $continuation.L$13 = SpillingKt.nullOutSpilledVariable((Object)where);
                    $continuation.L$14 = SpillingKt.nullOutSpilledVariable((Object)env);
                    $continuation.label = 4;
                    v6 = EelExecApiKt.spawnProcess((EelExecApi)exec, (EelPath)where, (String[])new String[0]).args(expandedArgs).env(env).workingDirectory(workingDir).eelIt((Continuation)$continuation);
                    if (v6 == var28_9) {
                        return var28_9;
                    }
                    ** GOTO lbl197
                }
                case 4: {
                    env = (Map)$continuation.L$14;
                    where = (EelPath)$continuation.L$13;
                    locatedProcess = (EelPath)$continuation.L$12;
                    exec = (EelExecApi)$continuation.L$11;
                    workingDir = (EelPath)$continuation.L$10;
                    eelDescriptor = (EelDescriptor)$continuation.L$9;
                    pathConverter = (EelAwarePathConverter)$continuation.L$8;
                    eel = (EelApi)$continuation.L$7;
                    expandedArgs = (List)$continuation.L$6;
                    expandedCommand = (String)$continuation.L$5;
                    handleError = (Function1)$continuation.L$4;
                    coroutineScope = (CoroutineScope)$continuation.L$3;
                    projectDir = (Path)$continuation.L$2;
                    config = (AgentServerConfig)$continuation.L$1;
                    agentName = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl197:
                    // 2 sources

                    eelProcess = (EelProcess)v6;
                    EelAcpProcessHandlerKt.access$getLogger$p().info("[" + agentName + "] Process started with PID: " + eelProcess.getPid());
                    return new EelAcpProcessHandler(eelProcess, projectDir, pathConverter, coroutineScope, agentName, (Function1<? super String, Unit>)handleError);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Exception decompiling
         */
        private final Object loadEnv(EelExecApi exec, String agentName, Continuation<? super Map<String, String>> $completion) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[SWITCH], 14[CASE]], but top level block is 6[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static final CharSequence resolveEelInstance$lambda$0(WSLDistribution it) {
            String string = it.getMsId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-msId>(...)");
            return string;
        }

        public static final /* synthetic */ Object access$resolveEelInstance(Companion $this, AgentServerConfig config, Continuation $completion) {
            return $this.resolveEelInstance(config, (Continuation<? super EelApi>)$completion);
        }

        public static final /* synthetic */ Object access$getWslEel(Companion $this, String distributionName, Continuation $completion) {
            return $this.getWslEel(distributionName, (Continuation<? super EelApi>)$completion);
        }

        public static final /* synthetic */ Object access$loadEnv(Companion $this, EelExecApi exec2, String agentName, Continuation $completion) {
            return $this.loadEnv(exec2, agentName, (Continuation<? super Map<String, String>>)$completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ExecutionEnvironmentType.values().length];
                try {
                    nArray[ExecutionEnvironmentType.WSL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExecutionEnvironmentType.LOCAL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

