/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.process;

import com.intellij.ml.llm.agents.acp.process.AcpPathConverter;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.ide.impl.wsl.WslEelDescriptor;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/agents/acp/process/EelAwarePathConverter;", "Lcom/intellij/ml/llm/agents/acp/process/AcpPathConverter;", "eel", "Lcom/intellij/platform/eel/EelApi;", "<init>", "(Lcom/intellij/platform/eel/EelApi;)V", "toAgentPath", "", "path", "Ljava/nio/file/Path;", "fromAgentPath", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nEelAwarePathConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelAwarePathConverter.kt\ncom/intellij/ml/llm/agents/acp/process/EelAwarePathConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1#2:42\n*E\n"})
public final class EelAwarePathConverter
implements AcpPathConverter {
    @NotNull
    private final EelApi eel;

    public EelAwarePathConverter(@NotNull EelApi eel) {
        Intrinsics.checkNotNullParameter((Object)eel, (String)"eel");
        this.eel = eel;
    }

    @Override
    @NotNull
    public String toAgentPath(@NotNull Path path) {
        Object object;
        block4: {
            block2: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    EelDescriptor eelDescriptor = this.eel.getDescriptor();
                    if (!(eelDescriptor instanceof WslEelDescriptor) || EelProviderUtil.getEelDescriptor((Path)path) != LocalEelDescriptor.INSTANCE) break block2;
                    object = ((WslEelDescriptor)eelDescriptor).getDistribution().getWslPath(path);
                    if (object == null) break block3;
                    Object it = object;
                    boolean bl = false;
                    EelPath eelPath = EelPath.Companion.parse((String)it, eelDescriptor);
                    object = eelPath;
                    if (eelPath != null) break block4;
                }
                object = EelNioBridgeServiceKt.asEelPath((Path)path);
                break block4;
            }
            object = EelNioBridgeServiceKt.asEelPath((Path)path);
        }
        EelPath agentPath = object;
        return agentPath.toString();
    }

    @Override
    @NotNull
    public Path fromAgentPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path simplePath = path2;
        if (!simplePath.isAbsolute()) {
            return simplePath;
        }
        EelDescriptor descriptor2 = this.eel.getDescriptor();
        if (!(descriptor2 instanceof WslEelDescriptor)) {
            Path path3 = Paths.get(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            return path3;
        }
        String string = ((WslEelDescriptor)descriptor2).getDistribution().getWindowsPath(path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWindowsPath(...)");
        Path path4 = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
        return path4;
    }
}

