/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.registry;

import com.intellij.ml.llm.agents.ChatAgent;
import com.intellij.ml.llm.agents.acp.config.AcpConfiguration;
import com.intellij.ml.llm.agents.acp.config.AgentServerConfig;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentConfigurationListener;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentRegistry;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentRegistryKt;
import com.intellij.ml.llm.agents.acp.registry.AgentRegistration;
import com.intellij.ml.llm.agents.acp.registry.DynamicAcpChatAgent;
import com.intellij.ml.llm.agents.acp.registry.RegistryStatistics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0001J$\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0080@\u00a2\u0006\u0004\b\u0013\u0010\u0014J2\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00182\b\u0010\u0010\u001a\u0004\u0018\u00010\u0018H\u0082@\u00a2\u0006\u0002\u0010\u0019J \u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\b\u0010\u001d\u001a\u00020\fH\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0010\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentRegistry;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "registeredAgents", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/ml/llm/agents/acp/registry/AgentRegistration;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentConfigurationListener;", "addListener", "", "listener", "parentDisposable", "reloadAgents", "newConfig", "Lcom/intellij/ml/llm/agents/acp/config/AcpConfiguration;", "oldConfig", "reloadAgents$intellij_ml_llm_agents_acp", "(Lcom/intellij/ml/llm/agents/acp/config/AcpConfiguration;Lcom/intellij/ml/llm/agents/acp/config/AcpConfiguration;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "notifyListeners", "agentId", "agentName", "Lcom/intellij/ml/llm/agents/acp/config/AgentServerConfig;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ml/llm/agents/acp/config/AgentServerConfig;Lcom/intellij/ml/llm/agents/acp/config/AgentServerConfig;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "registerAgent", "config", "unregisterAgent", "unregisterAllAgents", "getStatistics", "Lcom/intellij/ml/llm/agents/acp/registry/RegistryStatistics;", "sanitizeAgentId", "name", "registerChatAgentDynamically", "agent", "Lcom/intellij/ml/llm/agents/ChatAgent;", "dispose", "Companion", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpAgentRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpAgentRegistry.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpAgentRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n1869#2,2:220\n1869#2,2:222\n*S KotlinDebug\n*F\n+ 1 AcpAgentRegistry.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpAgentRegistry\n*L\n70#1:220,2\n152#1:222,2\n*E\n"})
public final class AcpAgentRegistry
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, AgentRegistration> registeredAgents = new ConcurrentHashMap();
    @NotNull
    private final EventDispatcher<AcpAgentConfigurationListener> dispatcher;

    public AcpAgentRegistry() {
        EventDispatcher eventDispatcher = EventDispatcher.create(AcpAgentConfigurationListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.dispatcher = eventDispatcher;
    }

    public final void addListener(@NotNull AcpAgentConfigurationListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.dispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object reloadAgents$intellij_ml_llm_agents_acp(@Nullable AcpConfiguration newConfig, @Nullable AcpConfiguration oldConfig, @NotNull Continuation<? super Unit> $completion) {
        block13: {
            block15: {
                block14: {
                    if (!($completion instanceof reloadAgents.1)) ** GOTO lbl-1000
                    var17_4 = $completion;
                    if ((var17_4.label & -2147483648) != 0) {
                        var17_4.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, $completion){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            Object L$3;
                            Object L$4;
                            Object L$5;
                            Object L$6;
                            Object L$7;
                            Object L$8;
                            Object L$9;
                            Object L$10;
                            Object L$11;
                            int I$0;
                            int I$1;
                            /* synthetic */ Object result;
                            final /* synthetic */ AcpAgentRegistry this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return this.this$0.reloadAgents$intellij_ml_llm_agents_acp(null, null, (Continuation<? super Unit>)((Continuation)this));
                            }
                        };
                    }
                    $result = $continuation.result;
                    var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block0 : switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            AcpAgentRegistryKt.access$getLogger$p().info("Reloading dynamic ACP agents");
                            v0 = oldConfig;
                            if (v0 == null || (v0 = v0.getAgentServers()) == null) {
                                v0 = oldAgentConfigs = MapsKt.emptyMap();
                            }
                            if ((v1 = newConfig) == null || (v1 = v1.getAgentServers()) == null) {
                                v1 = MapsKt.emptyMap();
                            }
                            newAgentConfigs = v1;
                            allAgentNames = CollectionsKt.toSet((Iterable)SetsKt.plus(oldAgentConfigs.keySet(), (Iterable)newAgentConfigs.keySet()));
                            $this$forEach$iv = allAgentNames;
                            $i$f$forEach = 0;
                            var9_12 = $this$forEach$iv.iterator();
lbl23:
                            // 8 sources

                            while (var9_12.hasNext()) {
                                element$iv = var9_12.next();
                                agentName = (String)element$iv;
                                $i$a$-forEach-AcpAgentRegistry$reloadAgents$2 = 0;
                                agentId = this.sanitizeAgentId(agentName);
                                oldServerConfig = (AgentServerConfig)oldAgentConfigs.get(agentName);
                                newServerConfig = (AgentServerConfig)newAgentConfigs.get(agentName);
                                if (oldServerConfig != null || newServerConfig == null) break block0;
                                AcpAgentRegistryKt.access$getLogger$p().info("Agent '" + agentName + "' added");
                                this.registerAgent(agentId, agentName, newServerConfig);
                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)newConfig);
                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)oldConfig);
                                $continuation.L$2 = oldAgentConfigs;
                                $continuation.L$3 = newAgentConfigs;
                                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)allAgentNames);
                                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                                $continuation.L$6 = var9_12;
                                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)agentName);
                                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)agentId);
                                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)oldServerConfig);
                                $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)newServerConfig);
                                $continuation.I$0 = $i$f$forEach;
                                $continuation.I$1 = $i$a$-forEach-AcpAgentRegistry$reloadAgents$2;
                                $continuation.label = 1;
                                v2 = this.notifyListeners(agentId, agentName, null, newServerConfig, (Continuation<? super Unit>)$continuation);
                                if (v2 != var18_6) continue;
                                return var18_6;
                            }
                            break block13;
                        }
                        case 1: {
                            $i$a$-forEach-AcpAgentRegistry$reloadAgents$2 = $continuation.I$1;
                            $i$f$forEach = $continuation.I$0;
                            newServerConfig = (AgentServerConfig)$continuation.L$11;
                            oldServerConfig = (AgentServerConfig)$continuation.L$10;
                            agentId = (String)$continuation.L$9;
                            agentName = (String)$continuation.L$8;
                            element$iv = $continuation.L$7;
                            var9_12 = (Iterator<T>)$continuation.L$6;
                            $this$forEach$iv = (Iterable)$continuation.L$5;
                            allAgentNames = (Set)$continuation.L$4;
                            newAgentConfigs = (Map)$continuation.L$3;
                            oldAgentConfigs = (Map)$continuation.L$2;
                            oldConfig = (AcpConfiguration)$continuation.L$1;
                            newConfig = (AcpConfiguration)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            ** GOTO lbl23
                        }
                    }
                    if (oldServerConfig == null || newServerConfig != null) break block14;
                    AcpAgentRegistryKt.access$getLogger$p().info("Agent '" + agentName + "' removed");
                    this.unregisterAgent(agentId);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)newConfig);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)oldConfig);
                    $continuation.L$2 = oldAgentConfigs;
                    $continuation.L$3 = newAgentConfigs;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)allAgentNames);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                    $continuation.L$6 = var9_12;
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)agentName);
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)agentId);
                    $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)oldServerConfig);
                    $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)newServerConfig);
                    $continuation.I$0 = $i$f$forEach;
                    $continuation.I$1 = $i$a$-forEach-AcpAgentRegistry$reloadAgents$2;
                    $continuation.label = 2;
                    v3 = this.notifyListeners(agentId, agentName, oldServerConfig, null, (Continuation<? super Unit>)$continuation);
                    if (v3 == var18_6) {
                        return var18_6;
                    }
                    ** GOTO lbl23
                    {
                        case 2: {
                            $i$a$-forEach-AcpAgentRegistry$reloadAgents$2 = $continuation.I$1;
                            $i$f$forEach = $continuation.I$0;
                            newServerConfig = (AgentServerConfig)$continuation.L$11;
                            oldServerConfig = (AgentServerConfig)$continuation.L$10;
                            agentId = (String)$continuation.L$9;
                            agentName = (String)$continuation.L$8;
                            element$iv = $continuation.L$7;
                            var9_12 = (Iterator)$continuation.L$6;
                            $this$forEach$iv = (Iterable)$continuation.L$5;
                            allAgentNames = (Set)$continuation.L$4;
                            newAgentConfigs = (Map)$continuation.L$3;
                            oldAgentConfigs = (Map)$continuation.L$2;
                            oldConfig = (AcpConfiguration)$continuation.L$1;
                            newConfig = (AcpConfiguration)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
                            ** GOTO lbl23
                        }
                    }
                }
                if (oldServerConfig == null || newServerConfig == null || Intrinsics.areEqual((Object)oldServerConfig, (Object)newServerConfig)) break block15;
                AcpAgentRegistryKt.access$getLogger$p().info("Agent '" + agentName + "' configuration changed");
                this.unregisterAgent(agentId);
                this.registerAgent(agentId, agentName, newServerConfig);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)newConfig);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)oldConfig);
                $continuation.L$2 = oldAgentConfigs;
                $continuation.L$3 = newAgentConfigs;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)allAgentNames);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                $continuation.L$6 = var9_12;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)agentName);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)agentId);
                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)oldServerConfig);
                $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)newServerConfig);
                $continuation.I$0 = $i$f$forEach;
                $continuation.I$1 = $i$a$-forEach-AcpAgentRegistry$reloadAgents$2;
                $continuation.label = 3;
                v4 = this.notifyListeners(agentId, agentName, oldServerConfig, newServerConfig, (Continuation<? super Unit>)$continuation);
                if (v4 == var18_6) {
                    return var18_6;
                }
                ** GOTO lbl23
                {
                    case 3: {
                        $i$a$-forEach-AcpAgentRegistry$reloadAgents$2 = $continuation.I$1;
                        $i$f$forEach = $continuation.I$0;
                        newServerConfig = (AgentServerConfig)$continuation.L$11;
                        oldServerConfig = (AgentServerConfig)$continuation.L$10;
                        agentId = (String)$continuation.L$9;
                        agentName = (String)$continuation.L$8;
                        element$iv = $continuation.L$7;
                        var9_12 = (Iterator)$continuation.L$6;
                        $this$forEach$iv = (Iterable)$continuation.L$5;
                        allAgentNames = (Set)$continuation.L$4;
                        newAgentConfigs = (Map)$continuation.L$3;
                        oldAgentConfigs = (Map)$continuation.L$2;
                        oldConfig = (AcpConfiguration)$continuation.L$1;
                        newConfig = (AcpConfiguration)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                        ** GOTO lbl23
                    }
                }
            }
            AcpAgentRegistryKt.access$getLogger$p().debug("Agent '" + agentName + "' unchanged");
            ** GOTO lbl23
        }
        AcpAgentRegistryKt.access$getLogger$p().info("Dynamic ACP agents reloaded: " + this.registeredAgents.size() + " active");
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object notifyListeners(String agentId, String agentName, AgentServerConfig oldConfig, AgentServerConfig newConfig, Continuation<? super Unit> $completion) {
        AcpAgentRegistryKt.access$getLogger$p().debug("Notifying listeners: agent=" + agentName + ", oldConfig=" + (oldConfig != null) + ", newConfig=" + (newConfig != null));
        Object object = ((AcpAgentConfigurationListener)this.dispatcher.getMulticaster()).agentConfigurationChanged(agentId, agentName, oldConfig, newConfig, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void registerAgent(String agentId, String agentName, AgentServerConfig config) {
        AcpAgentRegistryKt.access$getLogger$p().info("Registering dynamic agent: " + agentName + " (id: " + agentId + ")");
        DynamicAcpChatAgent agent2 = new DynamicAcpChatAgent(agentId, agentName, config);
        Disposable disposable = this.registerChatAgentDynamically(agent2);
        ((Map)this.registeredAgents).put(agentId, new AgentRegistration(agent2, disposable));
        AcpAgentRegistryKt.access$getLogger$p().info("Successfully registered agent: " + agentName);
    }

    private final void unregisterAgent(String agentId) {
        block0: {
            AgentRegistration agentRegistration = this.registeredAgents.remove(agentId);
            if (agentRegistration == null) break block0;
            AgentRegistration registration = agentRegistration;
            boolean bl = false;
            AcpAgentRegistryKt.access$getLogger$p().info("Unregistering agent: " + registration.getAgent().getName());
            Disposer.dispose((Disposable)registration.getDisposable());
        }
    }

    private final void unregisterAllAgents() {
        AcpAgentRegistryKt.access$getLogger$p().info("Unregistering all dynamic ACP agents (" + this.registeredAgents.size() + ")");
        Collection<AgentRegistration> collection = this.registeredAgents.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AgentRegistration registration = (AgentRegistration)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)registration.getDisposable());
        }
        this.registeredAgents.clear();
    }

    @NotNull
    public final RegistryStatistics getStatistics() {
        int n = this.registeredAgents.size();
        Set set = this.registeredAgents.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return new RegistryStatistics(n, CollectionsKt.toList((Iterable)set));
    }

    private final String sanitizeAgentId(String name) {
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        Object object = string;
        Regex regex = new Regex("[^a-z0-9]+");
        String string2 = "-";
        String string3 = regex.replace((CharSequence)object, string2);
        object = new char[1];
        object[0] = 45;
        return "acp." + StringsKt.trim((String)string3, (char[])object);
    }

    private final Disposable registerChatAgentDynamically(ChatAgent agent2) {
        Application app = ApplicationManager.getApplication();
        ExtensionsArea extensionsArea = app.getExtensionArea();
        Intrinsics.checkNotNullExpressionValue((Object)extensionsArea, (String)"getExtensionArea(...)");
        ExtensionsArea area = extensionsArea;
        ExtensionPoint ep = area.getExtensionPoint(ChatAgent.Companion.getEP_NAME());
        Disposable disposable = Disposer.newDisposable((String)("acp-agent:" + agent2.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable registration = disposable;
        ep.registerExtension((Object)agent2, registration);
        AcpAgentRegistryKt.access$getLogger$p().info("Registered ChatAgent dynamically: " + agent2.getId());
        return registration;
    }

    public void dispose() {
        this.unregisterAllAgents();
    }

    public static final /* synthetic */ Object access$notifyListeners(AcpAgentRegistry $this, String agentId, String agentName, AgentServerConfig oldConfig, AgentServerConfig newConfig, Continuation $completion) {
        return $this.notifyListeners(agentId, agentName, oldConfig, newConfig, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentRegistry$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentRegistry;", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AcpAgentRegistry getInstance() {
            Object object = ApplicationManager.getApplication().getService(AcpAgentRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (AcpAgentRegistry)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

