/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration;

import com.intellij.ml.llm.codeGeneration.AICodeGenerationControllerUtils;
import com.intellij.ml.llm.codeGeneration.AICodeGenerationPromptController;
import com.intellij.ml.llm.core.chat.messages.CompletableMessage;
import com.intellij.ml.llm.core.chat.parts.MessagePart;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.ChatSourceAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.Topic;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\bg\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u001e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0018\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/codeGeneration/AICodeGenerationProgressListener;", "", "interactionStarted", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "generationStarted", "generationTextArrived", "codeBlocks", "", "Lcom/intellij/ml/llm/core/chat/parts/MessagePart;", "generationFinished", "generationStopped", "addMessage", "chat", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "newMessage", "Lcom/intellij/ml/llm/core/chat/messages/CompletableMessage;", "onSubmit", "sourceAction", "Lcom/intellij/ml/llm/core/chat/session/ChatSourceAction;", "regenerate", "", "Companion", "intellij.ml.llm.codeGeneration"})
@ApiStatus.Experimental
public interface AICodeGenerationProgressListener {
    @NotNull
    public static final Companion Companion = com.intellij.ml.llm.codeGeneration.AICodeGenerationProgressListener$Companion.$$INSTANCE;

    default public void interactionStarted(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
    }

    default public void generationStarted(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
    }

    default public void generationTextArrived(@NotNull Editor editor2, @NotNull List<? extends MessagePart> codeBlocks) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(codeBlocks, (String)"codeBlocks");
    }

    default public void generationFinished(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
    }

    default public void generationStopped(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
    }

    default public void addMessage(@NotNull ChatSession chat, @NotNull CompletableMessage newMessage) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)newMessage, (String)"newMessage");
    }

    default public void onSubmit(@NotNull Editor editor2, @NotNull ChatSourceAction sourceAction, boolean regenerate) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)sourceAction, (String)"sourceAction");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007R)\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/codeGeneration/AICodeGenerationProgressListener$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/ml/llm/codeGeneration/AICodeGenerationProgressListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getTOPIC", "()Lcom/intellij/util/messages/Topic;", "submit", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "sourceAction", "Lcom/intellij/ml/llm/core/chat/session/ChatSourceAction;", "regenerate", "", "intellij.ml.llm.codeGeneration"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @Topic.ProjectLevel
        @NotNull
        private static final Topic<AICodeGenerationProgressListener> TOPIC;

        private Companion() {
        }

        @NotNull
        public final Topic<AICodeGenerationProgressListener> getTOPIC() {
            return TOPIC;
        }

        @RequiresEdt
        public final void submit(@NotNull Editor editor2, @NotNull ChatSourceAction sourceAction, boolean regenerate) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)sourceAction, (String)"sourceAction");
            ThreadingAssertions.assertEventDispatchThread();
            AICodeGenerationPromptController aICodeGenerationPromptController = AICodeGenerationControllerUtils.INSTANCE.getActivePrompt(editor2);
            if (aICodeGenerationPromptController == null) {
                return;
            }
            AICodeGenerationPromptController controller2 = aICodeGenerationPromptController;
            Project project2 = editor2.getProject();
            Intrinsics.checkNotNull((Object)project2);
            AICodeGenerationProgressListener listener2 = (AICodeGenerationProgressListener)project2.getMessageBus().syncPublisher(TOPIC);
            if (!regenerate) {
                controller2.updatePrompt();
            }
            if (!controller2.getAndSetGeneratingMode()) {
                controller2.showDiffControl();
                listener2.onSubmit(editor2, sourceAction, regenerate);
            }
        }

        public static /* synthetic */ void submit$default(Companion companion, Editor editor2, ChatSourceAction chatSourceAction, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            companion.submit(editor2, chatSourceAction, bl);
        }

        static {
            $$INSTANCE = new Companion();
            Topic topic = Topic.create((String)"Code generation progress listener", AICodeGenerationProgressListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
            TOPIC = topic;
        }
    }
}

