/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.lightAgent.steps.events.logging.file;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.codeGeneration.lightAgent.steps.events.logging.file.LogDirectoryManagerKt;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/logging/file/LogDirectoryManager;", "", "logDir", "Ljava/nio/file/Path;", "retention", "Ljava/time/Duration;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Ljava/nio/file/Path;Ljava/time/Duration;Lkotlinx/coroutines/CoroutineScope;)V", "initializeDirectory", "", "scheduleCleanup", "Lkotlinx/coroutines/Job;", "cleanupOldFiles", "deleteFile", "file", "intellij.ml.llm.codeGeneration"})
@StabilityInferred(parameters=0)
public final class LogDirectoryManager {
    @NotNull
    private final Path logDir;
    @NotNull
    private final Duration retention;
    @NotNull
    private final CoroutineScope scope;
    public static final int $stable = 8;

    public LogDirectoryManager(@NotNull Path logDir, @NotNull Duration retention, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)logDir, (String)"logDir");
        Intrinsics.checkNotNullParameter((Object)retention, (String)"retention");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.logDir = logDir;
        this.retention = retention;
        this.scope = scope;
    }

    public final void initializeDirectory() {
        try {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(this.logDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Files.createDirectories(this.logDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            LogDirectoryManagerKt.access$getLOG$p().warn("Failed to create Light Agent session dump directory: " + this.logDir, (Throwable)e);
        }
    }

    @NotNull
    public final Job scheduleCleanup() {
        return BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)new CoroutineName("LightAgentSessionDumpCleanup")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ LogDirectoryManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            LogDirectoryManager.access$cleanupOldFiles(this.this$0);
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = DelayKt.delay((long)Duration.ofHours(1L).toMillis(), (Continuation)((Continuation)this));
                            if (v0 != var3_3) continue;
                            return var3_3;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanupOldFiles() {
        try {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(this.logDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return;
            }
            Closeable closeable = Files.newDirectoryStream(this.logDir);
            Throwable throwable = null;
            try {
                DirectoryStream stream = (DirectoryStream)closeable;
                boolean bl = false;
                Iterator iterator = stream.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Instant lastModified;
                    Instant instant;
                    Path file2 = (Path)iterator2.next();
                    if (!Files.isRegularFile(file2, new LinkOption[0])) continue;
                    try {
                        Intrinsics.checkNotNull((Object)file2);
                        LinkOption[] linkOptionArray2 = new LinkOption[]{};
                        FileTime fileTime = Files.getLastModifiedTime(file2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
                        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                        instant = fileTime.toInstant();
                    }
                    catch (Exception exception) {
                        instant = null;
                    }
                    if (instant == null || Duration.between(lastModified, Instant.now()).compareTo(this.retention) <= 0) continue;
                    Intrinsics.checkNotNull((Object)file2);
                    this.deleteFile(file2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            LogDirectoryManagerKt.access$getLOG$p().warn("Failed to sweep Light Agent dump directory " + this.logDir, (Throwable)e);
        }
    }

    private final void deleteFile(Path file2) {
        try {
            Files.deleteIfExists(file2);
        }
        catch (IOException e) {
            LogDirectoryManagerKt.access$getLOG$p().warn("Failed to delete old Light Agent dump file " + PathsKt.getName((Path)file2), (Throwable)e);
        }
    }

    public static final /* synthetic */ void access$cleanupOldFiles(LogDirectoryManager $this) {
        $this.cleanupOldFiles();
    }
}

