/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.logging;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.codeGeneration.AICodeGenerationFeatures;
import com.intellij.ml.llm.codeGeneration.CodeGenerationRequestState;
import com.intellij.ml.llm.codeGeneration.logging.AICodeGenerationDumpsLogger;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.ChatSessionKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\n0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\n0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0086@\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\bH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/codeGeneration/logging/AICodeGenerationDumpsLogger;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "logDir", "Ljava/nio/file/Path;", "PREFIX", "", "formatDate", "kotlin.jvm.PlatformType", "dateTime", "Ljava/time/ZonedDateTime;", "formatDateAndTime", "logInteraction", "", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "state", "Lcom/intellij/ml/llm/codeGeneration/CodeGenerationRequestState;", "(Lcom/intellij/ml/llm/core/chat/session/ChatSession;Lcom/intellij/ml/llm/codeGeneration/CodeGenerationRequestState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cleanUpOldFiles", "currentDir", "intellij.ml.llm.codeGeneration"})
@StabilityInferred(parameters=0)
public final class AICodeGenerationDumpsLogger {
    @NotNull
    public static final AICodeGenerationDumpsLogger INSTANCE = new AICodeGenerationDumpsLogger();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Path logDir;
    @NotNull
    private static final String PREFIX = "code_generation_dumps_";
    public static final int $stable;

    private AICodeGenerationDumpsLogger() {
    }

    private final String formatDate(ZonedDateTime dateTime) {
        return DateTimeFormatter.ofPattern("yyyyMMdd").format(dateTime);
    }

    private final String formatDateAndTime(ZonedDateTime dateTime) {
        return DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss").format(dateTime);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object logInteraction(@NotNull ChatSession chatSession, @Nullable CodeGenerationRequestState state, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof logInteraction.1)) ** GOTO lbl-1000
        var10_4 = $completion;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AICodeGenerationDumpsLogger this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.logInteraction(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!AICodeGenerationFeatures.INSTANCE.shouldDumpChatInteraction()) ** GOTO lbl42
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)chatSession);
                $continuation.L$1 = state;
                $continuation.label = 1;
                v0 = ChatSessionKt.stringify$default((ChatSession)chatSession, (boolean)false, (Continuation)$continuation, (int)1, null);
                if (v0 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                state = (CodeGenerationRequestState)$continuation.L$1;
                chatSession = (ChatSession)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                content = (String)v0;
                now = ZonedDateTime.now();
                Intrinsics.checkNotNull((Object)now);
                currentDir = AICodeGenerationDumpsLogger.logDir.resolve("code_generation_dumps_" + this.formatDate(now));
                Intrinsics.checkNotNull((Object)currentDir);
                this.cleanUpOldFiles(currentDir);
                v1 = state;
                file = currentDir.resolve("code_generation_dumps_" + this.formatDateAndTime(now) + "_" + (v1 != null ? v1.name() : null) + ".txt");
                try {
                    Files.createDirectories(file.getParent(), new FileAttribute[0]);
                    Files.writeString(file, (CharSequence)content, new OpenOption[0]);
                }
                catch (IOException e) {
                    AICodeGenerationDumpsLogger.LOG.info("Failed to write code generation dump file", (Throwable)e);
                }
lbl42:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void cleanUpOldFiles(Path currentDir) {
        try {
            Files.find(logDir, 1, (arg_0, arg_1) -> AICodeGenerationDumpsLogger.cleanUpOldFiles$lambda$0(currentDir, arg_0, arg_1), new FileVisitOption[0]).forEach(arg_0 -> AICodeGenerationDumpsLogger.cleanUpOldFiles$lambda$2(AICodeGenerationDumpsLogger::cleanUpOldFiles$lambda$1, arg_0));
        }
        catch (IOException e) {
            LOG.info("Failed to clean up old code generation dump files", (Throwable)e);
        }
    }

    private static final boolean cleanUpOldFiles$lambda$0(Path $currentDir, Path path, BasicFileAttributes basicFileAttributes) {
        return StringsKt.startsWith$default((String)((Object)path.getFileName()).toString(), (String)PREFIX, (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)path, (Object)$currentDir);
    }

    private static final Unit cleanUpOldFiles$lambda$1(Path dir) {
        Intrinsics.checkNotNull((Object)dir);
        PathsKt.deleteRecursively((Path)dir);
        return Unit.INSTANCE;
    }

    private static final void cleanUpOldFiles$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Path path = PathManager.getLogDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getLogDir(...)");
        logDir = path;
        $stable = 8;
    }
}

