/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.multifile.context;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.diff.editor.DiffViewerVirtualFile;
import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.codeGeneration.multifile.context.CodeGenerationChangeEntitySource;
import com.intellij.ml.llm.codeGeneration.multifile.context.ExternalChangeChatAttachment;
import com.intellij.ml.llm.codeGeneration.multifile.core.change.ChangeUtilsKt;
import com.intellij.ml.llm.codeGeneration.multifile.core.change.CumulativeLlmDiffChange;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ProjectFileContextEntity;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010#\u001a\u00020\u000eH\u0016J\u000e\u0010$\u001a\u00020%H\u0096@\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000f\u001a\r\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\b\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R!\u0010\u0015\u001a\u000f\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010\u00a2\u0006\u0002\b\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0019\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u001c\u0010 \u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0014R\u0014\u0010+\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001dR\u0014\u0010-\u001a\u00020.X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u00061"}, d2={"Lcom/intellij/ml/llm/codeGeneration/multifile/context/ExternalChangeContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ProjectFileContextEntity;", "project", "Lcom/intellij/openapi/project/Project;", "change", "Lcom/intellij/ml/llm/codeGeneration/multifile/core/change/CumulativeLlmDiffChange;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/codeGeneration/multifile/core/change/CumulativeLlmDiffChange;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getChange", "()Lcom/intellij/ml/llm/codeGeneration/multifile/core/change/CumulativeLlmDiffChange;", "changeVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "name", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "hint", "getHint", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "tooltipText", "getTooltipText", "()Ljava/lang/String;", "popupPresentationText", "getPopupPresentationText", "icon", "Ljavax/swing/Icon;", "getIcon", "virtualFile", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "id", "getId", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "intellij.ml.llm.codeGeneration"})
@StabilityInferred(parameters=0)
public final class ExternalChangeContextAttachment
extends ContextAttachmentBase
implements ProjectFileContextEntity {
    @NotNull
    private final Project project;
    @NotNull
    private final CumulativeLlmDiffChange change;
    @NotNull
    private final VirtualFile changeVirtualFile;
    @NotNull
    private final ContextEntitySource attachedBy;
    public static final int $stable = 8;

    public ExternalChangeContextAttachment(@NotNull Project project2, @NotNull CumulativeLlmDiffChange change) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        this.project = project2;
        this.change = change;
        this.changeVirtualFile = this.change.getDiffVirtualFile();
        this.attachedBy = (ContextEntitySource)((Object)CodeGenerationChangeEntitySource.INSTANCE);
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final CumulativeLlmDiffChange getChange() {
        return this.change;
    }

    @NotNull
    public ObservableProperty<String> getName() {
        return (ObservableProperty)new AtomicProperty((Object)this.changeVirtualFile.getName());
    }

    @Nullable
    public ObservableProperty<String> getHint() {
        return null;
    }

    @NotNull
    public PSString getText() {
        return ExtensionsKtKt.privacySafe(this.changeVirtualFile, this.getProject()).readText();
    }

    @NotNull
    public String getTooltipText() {
        return (String)this.getName().get();
    }

    @NotNull
    public String getPopupPresentationText() {
        return (String)this.getName().get();
    }

    @Nullable
    public ObservableProperty<Icon> getIcon() {
        Icon icon2 = this.virtualFile().getFileType().getIcon();
        if (icon2 == null) {
            Icon icon3 = AllIcons.FileTypes.Unknown;
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Unknown");
        }
        return (ObservableProperty)new AtomicProperty((Object)icon2);
    }

    @NotNull
    public VirtualFile virtualFile() {
        return this.change.getVirtualFile();
    }

    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        PSString attachmentName = SharedExtensionsKtKt.getPrivacySafe((FilePath)this.change.getFilePath()).getName();
        return new ExternalChangeChatAttachment(this.getProject(), attachmentName, this.getText(), this.change);
    }

    public void performAction(boolean isInMessage) {
        DiffViewerVirtualFile file2 = ChangeUtilsKt.createDiffFile(this.getProject(), this.change, false, false);
        FileEditorManager.getInstance((Project)this.getProject()).openTextEditor(new OpenFileDescriptor(this.getProject(), (VirtualFile)file2), true);
    }

    @NotNull
    public String getId() {
        String string = this.virtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.attachedBy;
    }
}

