/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context.actions;

import com.intellij.ml.llm.context.actions.PostProcessorNode;
import com.intellij.ml.llm.context.actions.PostProcessorsBucketNode;
import com.intellij.ml.llm.context.actions.RetrieverNode;
import com.intellij.ml.llm.context.actions.RetrieversBucketNode;
import com.intellij.ml.llm.context.actions.SessionNode;
import com.intellij.ml.llm.context.actions.TransformerNode;
import com.intellij.ml.llm.context.actions.TransformersBucketNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/context/actions/SessionCellRenderer;", "Lcom/intellij/ui/CheckboxTree$CheckboxTreeCellRenderer;", "<init>", "()V", "customizeRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.ml.llm.context"})
final class SessionCellRenderer
extends CheckboxTree.CheckboxTreeCellRenderer {
    public void customizeRenderer(@NotNull JTree tree, @NotNull Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
        Object object = value2;
        if (object instanceof SessionNode) {
            String string = StringUtil.shortenTextWithEllipsis((String)(((SessionNode)value2).getSession().getName() + " (" + ((SessionNode)value2).getSession() + ")"), (int)100, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
            String bucketName = string;
            textRenderer.append(bucketName, SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
        } else if (object instanceof RetrieversBucketNode) {
            textRenderer.append("Retrievers", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        } else if (object instanceof TransformersBucketNode) {
            textRenderer.append("Transformers", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        } else if (object instanceof PostProcessorsBucketNode) {
            textRenderer.append("Post-Processors", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        } else if (object instanceof RetrieverNode) {
            textRenderer.append(((RetrieverNode)((Object)value2)).getRetriever().getId(), SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
        } else if (object instanceof TransformerNode) {
            textRenderer.append(((TransformerNode)((Object)value2)).getTransformer().getId(), SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
        } else if (object instanceof PostProcessorNode) {
            textRenderer.append(((PostProcessorNode)((Object)value2)).getPostProcessor().getId(), SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
        } else {
            throw new UnsupportedOperationException("Unsupported value: " + value2);
        }
    }
}

