/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context.airules;

import com.intellij.ide.actions.RedoAction;
import com.intellij.ide.actions.UndoAction;
import com.intellij.ml.llm.context.airules.AiRuleEditor;
import com.intellij.ml.llm.context.airules.AiRulesLLMBundle;
import com.intellij.ml.llm.context.airules.AiRulesService;
import com.intellij.ml.llm.context.airules.metadata.AiRuleMetadataField;
import com.intellij.ml.llm.context.airules.metadata.AiRuleMetadataModel;
import com.intellij.ml.llm.context.airules.metadata.AiRuleMetadataPanel;
import com.intellij.ml.llm.context.airules.metadata.AiRuleType;
import com.intellij.ml.llm.core.chat.services.AIAssistantServiceScope;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0006H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u001fH\u0016J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00101\u001a\u00020\u001fH\u0002J\u001c\u00102\u001a\u00020\u001f2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020$04H\u0002J\b\u00106\u001a\u00020'H\u0002J\b\u00107\u001a\u00020\u001fH\u0002J\b\u00108\u001a\u00020\u001fH\u0002J\b\u00109\u001a\u00020\u001fH\u0002J\b\u0010:\u001a\u00020\u001fH\u0002J\u0014\u0010;\u001a\u00020$*\u00020$2\u0006\u0010<\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/ml/llm/context/airules/AiRuleEditor;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "mainPanel", "Ljavax/swing/JPanel;", "document", "Lcom/intellij/openapi/editor/Document;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "metadataModel", "Lcom/intellij/ml/llm/context/airules/metadata/AiRuleMetadataModel;", "metadataPanel", "Lcom/intellij/ml/llm/context/airules/metadata/AiRuleMetadataPanel;", "contentOffset", "", "metadataLock", "Lcom/intellij/openapi/editor/RangeMarker;", "foldRegion", "Lcom/intellij/openapi/editor/FoldRegion;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "metadataUpdateFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getName", "", "getFile", "isModified", "", "isValid", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "dispose", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "setupMetadata", "updateMetadataModel", "map", "", "Lcom/intellij/ml/llm/context/airules/metadata/AiRuleMetadataField;", "triggerMetadataUpdate", "updateMetadata", "setupListeners", "changeType", "ensureMetadataIsImmutable", "substringSafe", "from", "intellij.ml.llm.context.airules"})
@SourceDebugExtension(value={"SMAP\nAiRuleEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiRuleEditor.kt\ncom/intellij/ml/llm/context/airules/AiRuleEditor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,191:1\n19#2:192\n19#2:196\n1#3:193\n216#4,2:194\n*S KotlinDebug\n*F\n+ 1 AiRuleEditor.kt\ncom/intellij/ml/llm/context/airules/AiRuleEditor\n*L\n58#1:192\n172#1:196\n112#1:194,2\n*E\n"})
public final class AiRuleEditor
extends UserDataHolderBase
implements FileEditor {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private final Document document;
    @NotNull
    private final PsiFile psiFile;
    @NotNull
    private final Editor editor;
    @NotNull
    private final AiRuleMetadataModel metadataModel;
    @NotNull
    private final AiRuleMetadataPanel metadataPanel;
    private int contentOffset;
    @Nullable
    private RangeMarker metadataLock;
    @Nullable
    private FoldRegion foldRegion;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final MutableSharedFlow<Unit> metadataUpdateFlow;

    /*
     * WARNING - void declaration
     */
    public AiRuleEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        void $this$metadataModel_u24lambda_u240;
        void $this$editor_u24lambda_u240;
        Object object;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.project = project2;
        this.file = file2;
        this.mainPanel = new JPanel(new BorderLayout());
        Document document2 = FileDocumentManager.getInstance().getDocument(this.file);
        if (document2 == null) {
            throw new IllegalStateException("Cannot get Document for file: " + this.file.getName());
        }
        this.document = document2;
        PsiFile psiFile = VirtualFileUtil.findPsiFile((VirtualFile)this.file, (Project)this.project);
        if (psiFile == null) {
            throw new IllegalStateException("Cannot find PsiFile for file: " + this.file.getName());
        }
        this.psiFile = psiFile;
        Editor editor2 = object = EditorFactory.getInstance().createEditor(this.document, this.project, (FileType)MarkdownFileType.INSTANCE, false);
        AiRuleEditor aiRuleEditor = this;
        boolean bl = false;
        $this$editor_u24lambda_u240.getSettings().setLineNumbersShown(false);
        void $this$asSafely$iv = $this$editor_u24lambda_u240;
        boolean $i$f$asSafely = false;
        Object v2 = $this$asSafely$iv;
        if (!(v2 instanceof EditorEx)) {
            v2 = null;
        }
        EditorEx editorEx = v2;
        if (editorEx != null) {
            editorEx.setContextMenuGroupId("EditorPopupMenu");
        }
        Editor editor3 = object;
        Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"apply(...)");
        aiRuleEditor.editor = editor3;
        AiRuleMetadataModel aiRuleMetadataModel = new AiRuleMetadataModel();
        object = aiRuleMetadataModel;
        aiRuleEditor = this;
        boolean bl2 = false;
        $this$metadataModel_u24lambda_u240.setOnMetadataChangedListener((Function0<Unit>)((Function0)() -> AiRuleEditor.metadataModel$lambda$0$0(this)));
        aiRuleEditor.metadataModel = aiRuleMetadataModel;
        this.coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)AIAssistantServiceScope.Companion.getScope(this.project), (String)"AiRuleEditorScope", null, (boolean)false, (int)6, null);
        this.metadataUpdateFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, null, (int)5, null);
        this.setupMetadata();
        this.setupListeners();
        this.metadataPanel = new AiRuleMetadataPanel(this.project, this.metadataModel);
        this.mainPanel.add((Component)this.metadataPanel, "North");
        this.mainPanel.add((Component)this.editor.getComponent(), "Center");
        this.updateMetadata();
    }

    @NotNull
    public JComponent getComponent() {
        return this.mainPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.editor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @NotNull
    public String getName() {
        return AiRulesLLMBundle.message("label.airules.editor.name", new Object[0]);
    }

    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void setState(@NotNull FileEditorState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.editor);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    private final void setupMetadata() {
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)FlowKt.debounce((Flow)((Flow)this.metadataUpdateFlow), (long)300L), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AiRuleEditor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        AiRuleEditor.access$updateMetadata(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.coroutineScope);
        AiRulesService aiRulesService = AiRulesService.Companion.getInstance(this.project);
        String string = this.document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Triple<String, String, Integer> triple = aiRulesService.splitMetadataFromContent(string);
        String metadata = (String)triple.component1();
        int metadataSize = ((Number)triple.component3()).intValue();
        Map<AiRuleMetadataField, String> metadataFields = AiRulesService.Companion.getInstance(this.project).parseMetadata(metadata);
        this.updateMetadataModel(metadataFields);
        this.contentOffset = metadataSize;
        this.ensureMetadataIsImmutable();
    }

    private final void updateMetadataModel(Map<AiRuleMetadataField, String> map2) {
        Map<AiRuleMetadataField, String> $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<AiRuleMetadataField, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<AiRuleMetadataField, String> element$iv;
            Map.Entry<AiRuleMetadataField, String> entry = element$iv = iterator.next();
            boolean bl = false;
            AiRuleMetadataField field = entry.getKey();
            String value2 = entry.getValue();
            this.metadataModel.updateField(field, value2, false);
        }
    }

    private final boolean triggerMetadataUpdate() {
        return this.metadataUpdateFlow.tryEmit((Object)Unit.INSTANCE);
    }

    private final void updateMetadata() {
        String metadataText = this.metadataModel.toMetadataText() + "\n";
        String string = this.document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String newContent = metadataText + this.substringSafe(string, this.contentOffset);
        this.contentOffset = metadataText.length();
        if (!Intrinsics.areEqual((Object)this.document.getText(), (Object)newContent)) {
            ApplicationManager.getApplication().invokeLater(() -> AiRuleEditor.updateMetadata$lambda$0(this, newContent));
        }
    }

    private final void setupListeners() {
        EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(this.document, AiRuleEditor::setupListeners$lambda$0);
        this.editor.getSelectionModel().addSelectionListener(new SelectionListener(this){
            final /* synthetic */ AiRuleEditor this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int safeStart = Math.max(e.getNewRange().getStartOffset(), AiRuleEditor.access$getContentOffset$p(this.this$0));
                AiRuleEditor.access$getEditor$p(this.this$0).getSelectionModel().setSelection(safeStart, e.getNewRange().getEndOffset());
            }
        }, (Disposable)this);
        this.editor.getCaretModel().addCaretListener(new CaretListener(this){
            final /* synthetic */ AiRuleEditor this$0;
            {
                this.this$0 = $receiver;
            }

            public void caretPositionChanged(CaretEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                int safePosition = Math.max(AiRuleEditor.access$getEditor$p(this.this$0).logicalPositionToOffset(event2.getNewPosition()), AiRuleEditor.access$getContentOffset$p(this.this$0));
                AiRuleEditor.access$getEditor$p(this.this$0).getCaretModel().moveToOffset(safePosition);
            }

            public void caretAdded(CaretEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                if (event2.getCaret().getOffset() < AiRuleEditor.access$getContentOffset$p(this.this$0)) {
                    AiRuleEditor.access$getEditor$p(this.this$0).getCaretModel().removeCaret(event2.getCaret());
                }
            }
        }, (Disposable)this);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = AnActionListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new AnActionListener(this){
            final /* synthetic */ AiRuleEditor this$0;
            {
                this.this$0 = $receiver;
            }

            public void afterActionPerformed(AnAction action2, AnActionEvent event2, AnActionResult result2) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                if (!Intrinsics.areEqual((Object)event2.getDataContext().getData(CommonDataKeys.VIRTUAL_FILE), (Object)AiRuleEditor.access$getFile$p(this.this$0))) {
                    return;
                }
                if (!(action2 instanceof UndoAction) && !(action2 instanceof RedoAction)) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> setupListeners.4.afterActionPerformed$lambda$0(this.this$0));
            }

            private static final void afterActionPerformed$lambda$0(AiRuleEditor this$0) {
                AiRuleEditor.access$setupMetadata(this$0);
                AiRuleEditor.access$changeType(this$0);
            }
        });
    }

    private final void changeType() {
        AiRuleType aiRuleType = AiRulesService.Companion.getInstance(this.project).getCurrentType(this.metadataModel);
        if (aiRuleType == null) {
            aiRuleType = AiRuleType.ALWAYS;
        }
        AiRuleType selectedType = aiRuleType;
        this.metadataPanel.changeType(selectedType);
    }

    private final void ensureMetadataIsImmutable() {
        block2: {
            FoldingModelEx foldingModel;
            RangeMarker rangeMarker = this.metadataLock;
            if (rangeMarker != null) {
                rangeMarker.dispose();
            }
            Document $this$asSafely$iv = this.document;
            boolean $i$f$asSafely = false;
            Document document2 = $this$asSafely$iv;
            if (!(document2 instanceof DocumentEx)) {
                document2 = null;
            }
            DocumentEx documentEx = (DocumentEx)document2;
            this.metadataLock = documentEx != null ? documentEx.createGuardedBlock(0, this.contentOffset) : null;
            FoldingModel foldingModel2 = this.editor.getFoldingModel();
            FoldingModelEx foldingModelEx = foldingModel = foldingModel2 instanceof FoldingModelEx ? (FoldingModelEx)foldingModel2 : null;
            if (foldingModelEx == null) break block2;
            foldingModelEx.runBatchFoldingOperation(() -> AiRuleEditor.ensureMetadataIsImmutable$lambda$0(this, foldingModel));
        }
    }

    private final String substringSafe(String $this$substringSafe, int from) {
        String string;
        try {
            String string2 = $this$substringSafe.substring(from);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            string = $this$substringSafe;
        }
        return string;
    }

    private static final Unit metadataModel$lambda$0$0(AiRuleEditor this$0) {
        this$0.triggerMetadataUpdate();
        return Unit.INSTANCE;
    }

    private static final void updateMetadata$lambda$0(AiRuleEditor this$0, String $newContent) {
        PsiFile[] psiFileArray = new PsiFile[]{this$0.psiFile};
        WriteCommandAction.runWriteCommandAction((Project)this$0.project, (String)"", null, () -> AiRuleEditor.updateMetadata$lambda$0$0(this$0, $newContent), (PsiFile[])psiFileArray);
        this$0.ensureMetadataIsImmutable();
    }

    private static final void updateMetadata$lambda$0$0(AiRuleEditor this$0, String $newContent) {
        this$0.document.setText((CharSequence)$newContent);
    }

    private static final void setupListeners$lambda$0(ReadOnlyFragmentModificationException it) {
    }

    private static final void ensureMetadataIsImmutable$lambda$0(AiRuleEditor this$0, FoldingModelEx $foldingModel) {
        block3: {
            FoldRegion foldRegion = this$0.foldRegion;
            if (foldRegion != null) {
                foldRegion.dispose();
            }
            FoldRegion foldRegion2 = this$0.foldRegion = $foldingModel.createFoldRegion(0, this$0.contentOffset, "", null, true);
            if (foldRegion2 != null) {
                foldRegion2.setExpanded(false);
            }
            FoldRegion foldRegion3 = this$0.foldRegion;
            if (foldRegion3 != null) {
                foldRegion3.shouldNeverExpand();
            }
            FoldRegion foldRegion4 = this$0.foldRegion;
            if (foldRegion4 == null) break block3;
            foldRegion4.setGutterMarkEnabledForSingleLine(false);
        }
    }

    public static final /* synthetic */ void access$updateMetadata(AiRuleEditor $this) {
        $this.updateMetadata();
    }

    public static final /* synthetic */ int access$getContentOffset$p(AiRuleEditor $this) {
        return $this.contentOffset;
    }

    public static final /* synthetic */ Editor access$getEditor$p(AiRuleEditor $this) {
        return $this.editor;
    }

    public static final /* synthetic */ VirtualFile access$getFile$p(AiRuleEditor $this) {
        return $this.file;
    }

    public static final /* synthetic */ void access$setupMetadata(AiRuleEditor $this) {
        $this.setupMetadata();
    }

    public static final /* synthetic */ void access$changeType(AiRuleEditor $this) {
        $this.changeType();
    }
}

