/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context.airules.metadata;

import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ml.llm.context.airules.AiRulesService;
import com.intellij.ml.llm.context.airules.metadata.AiRuleMetadataField;
import com.intellij.ml.llm.context.airules.metadata.AiRuleMetadataModel;
import com.intellij.ml.llm.context.airules.metadata.AiRuleType;
import com.intellij.ml.llm.context.airules.metadata.AiRuleTypeComboboxProvider;
import com.intellij.ml.llm.context.airules.statistics.AIAssistantAiRulesEventLogger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.EmptySpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/context/airules/metadata/AiRuleTypeComboboxProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "selectedType", "Lcom/intellij/ml/llm/context/airules/metadata/AiRuleType;", "metadataModel", "Lcom/intellij/ml/llm/context/airules/metadata/AiRuleMetadataModel;", "onTypeChanged", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/context/airules/metadata/AiRuleType;Lcom/intellij/ml/llm/context/airules/metadata/AiRuleMetadataModel;Lkotlin/jvm/functions/Function1;)V", "comboboxPopupWidth", "", "comboboxPopupInsets", "getCombobox", "Lcom/intellij/openapi/ui/ComboBox;", "createTypeItemPane", "Ljavax/swing/JComponent;", "type", "isSelected", "", "configListRendererFlexibleHeight", "selectablePanel", "Lcom/intellij/ui/popup/list/SelectablePanel;", "calculateDescriptionWidth", "intellij.ml.llm.context.airules"})
@SourceDebugExtension(value={"SMAP\nAiRuleTypeComboboxProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiRuleTypeComboboxProvider.kt\ncom/intellij/ml/llm/context/airules/metadata/AiRuleTypeComboboxProvider\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,163:1\n37#2,2:164\n*S KotlinDebug\n*F\n+ 1 AiRuleTypeComboboxProvider.kt\ncom/intellij/ml/llm/context/airules/metadata/AiRuleTypeComboboxProvider\n*L\n34#1:164,2\n*E\n"})
public final class AiRuleTypeComboboxProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final AiRuleType selectedType;
    @NotNull
    private final AiRuleMetadataModel metadataModel;
    @NotNull
    private final Function1<AiRuleType, Unit> onTypeChanged;
    private final int comboboxPopupWidth;
    private final int comboboxPopupInsets;

    public AiRuleTypeComboboxProvider(@NotNull Project project2, @NotNull AiRuleType selectedType, @NotNull AiRuleMetadataModel metadataModel, @NotNull Function1<? super AiRuleType, Unit> onTypeChanged) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)selectedType), (String)"selectedType");
        Intrinsics.checkNotNullParameter((Object)metadataModel, (String)"metadataModel");
        Intrinsics.checkNotNullParameter(onTypeChanged, (String)"onTypeChanged");
        this.project = project2;
        this.selectedType = selectedType;
        this.metadataModel = metadataModel;
        this.onTypeChanged = onTypeChanged;
        this.comboboxPopupWidth = 250;
        this.comboboxPopupInsets = 8;
    }

    @NotNull
    public final ComboBox<AiRuleType> getCombobox() {
        Collection $this$toTypedArray$iv = AiRulesService.Companion.getInstance(this.project).getEnabledRuleTypes();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object object = thisCollection$iv.toArray(new AiRuleType[0]);
        Object $this$getCombobox_u24lambda_u240 = object = new ComboBox<AiRuleType>(this, object){
            final /* synthetic */ AiRuleTypeComboboxProvider this$0;
            {
                this.this$0 = $receiver;
                super((Object[])$super_call_param$1);
            }

            public int getMinimumPopupWidth() {
                return AiRuleTypeComboboxProvider.access$getComboboxPopupWidth$p(this.this$0);
            }

            public boolean isSwingPopup() {
                return false;
            }

            public ListCellRenderer<? super AiRuleType> getRenderer() {
                return new ListCellRenderer<AiRuleType>(this.this$0){
                    final /* synthetic */ AiRuleTypeComboboxProvider this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public Component getListCellRendererComponent(JList<? extends AiRuleType> list, AiRuleType value2, int index, boolean isSelected, boolean cellHasFocus) {
                        Intrinsics.checkNotNullParameter(list, (String)"list");
                        if (index == -1) {
                            JLabel jLabel;
                            Object object = value2;
                            if (object == null || (object = object.getDisplayName()) == null) {
                                object = "";
                            }
                            JLabel $this$getListCellRendererComponent_u24lambda_u240 = jLabel = new JLabel((String)object);
                            boolean bl = false;
                            $this$getListCellRendererComponent_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)2, (int)4));
                            return jLabel;
                        }
                        AiRuleType aiRuleType = value2;
                        if (aiRuleType == null) {
                            aiRuleType = AiRuleTypeComboboxProvider.access$getSelectedType$p(this.this$0);
                        }
                        JComponent component2 = AiRuleTypeComboboxProvider.access$createTypeItemPane(this.this$0, aiRuleType, isSelected);
                        if (isSelected) {
                            component2.setBackground(UIUtil.getListBackground());
                            component2.setOpaque(true);
                        }
                        return component2;
                    }
                };
            }
        };
        boolean bl = false;
        $this$getCombobox_u24lambda_u240.setSelectedItem((Object)this.selectedType);
        Ref.ObjectRef initialSelection = new Ref.ObjectRef();
        SwingUtilities.invokeLater(() -> AiRuleTypeComboboxProvider.getCombobox$lambda$0$0((Object)$this$getCombobox_u24lambda_u240, this));
        $this$getCombobox_u24lambda_u240.addPopupMenuListener(new PopupMenuListener((Ref.ObjectRef<AiRuleType>)initialSelection, (Object)$this$getCombobox_u24lambda_u240, this){
            final /* synthetic */ Ref.ObjectRef<AiRuleType> $initialSelection;
            final /* synthetic */ getCombobox.1 $this_apply;
            final /* synthetic */ AiRuleTypeComboboxProvider this$0;
            {
                this.$initialSelection = $initialSelection;
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object object = this.$this_apply.getSelectedItem();
                this.$initialSelection.element = object instanceof AiRuleType ? (AiRuleType)((Object)object) : null;
                SwingUtilities.invokeLater(() -> getCombobox.2.2.popupMenuWillBecomeVisible$lambda$0(this.$this_apply, this.this$0));
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                AiRuleType newSelection;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object object = this.$this_apply.getSelectedItem();
                AiRuleType aiRuleType = newSelection = object instanceof AiRuleType ? (AiRuleType)((Object)object) : null;
                if (newSelection != null && newSelection != this.$initialSelection.element) {
                    AiRuleMetadataModel.updateField$default(AiRuleTypeComboboxProvider.access$getMetadataModel$p(this.this$0), AiRuleMetadataField.TYPE, newSelection.getFieldName(), false, 4, null);
                    AIAssistantAiRulesEventLogger.logAiRuleTypeSwitched(AiRuleTypeComboboxProvider.access$getProject$p(this.this$0), (AiRuleType)((Object)this.$initialSelection.element), newSelection);
                    AiRuleTypeComboboxProvider.access$getOnTypeChanged$p(this.this$0).invoke((Object)((Object)newSelection));
                }
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$this_apply.setSelectedItem(this.$initialSelection.element);
            }

            private static final void popupMenuWillBecomeVisible$lambda$0(getCombobox.1 $this_apply, AiRuleTypeComboboxProvider this$0) {
                Accessible accessible = $this_apply.getAccessibleContext().getAccessibleChild(0);
                JPopupMenu jPopupMenu = accessible instanceof JPopupMenu ? (JPopupMenu)accessible : null;
                if (jPopupMenu == null) {
                    return;
                }
                JPopupMenu popup2 = jPopupMenu;
                Border border = popup2.getBorder();
                if (border == null) {
                    border = BorderFactory.createEmptyBorder();
                }
                popup2.setBorder(BorderFactory.createCompoundBorder(border, (Border)JBUI.Borders.empty((int)AiRuleTypeComboboxProvider.access$getComboboxPopupInsets$p(this$0), (int)0)));
            }
        });
        return (ComboBox)object;
    }

    private final JComponent createTypeItemPane(AiRuleType type2, boolean isSelected) {
        DialogPanel dialogPanel;
        DialogPanel $this$createTypeItemPane_u24lambda_u241 = dialogPanel = BuilderKt.panel(arg_0 -> AiRuleTypeComboboxProvider.createTypeItemPane$lambda$0(type2, isSelected, this, arg_0));
        boolean bl = false;
        $this$createTypeItemPane_u24lambda_u241.setBorder((Border)JBUI.Borders.empty((int)8, (int)0));
        $this$createTypeItemPane_u24lambda_u241.setOpaque(false);
        DialogPanel content2 = dialogPanel;
        SelectablePanel result2 = SelectablePanel.Companion.wrap((Component)content2, JBUI.CurrentTheme.Popup.BACKGROUND);
        this.configListRendererFlexibleHeight(result2);
        if (isSelected) {
            result2.setSelectionColor(ListPluginComponent.SELECTION_COLOR);
        }
        NonOpaquePanel res2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        res2.setBorder((Border)JBUI.Borders.empty());
        res2.add((Component)result2, (Object)"Center");
        return (JComponent)res2;
    }

    public final void configListRendererFlexibleHeight(@NotNull SelectablePanel selectablePanel) {
        Intrinsics.checkNotNullParameter((Object)selectablePanel, (String)"selectablePanel");
        Insets insets = JBUI.CurrentTheme.Popup.Selection.innerInsets();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"innerInsets(...)");
        Insets innerInsets = insets;
        selectablePanel.setBorder((Border)JBUI.Borders.empty((int)innerInsets.top, (int)innerInsets.left, (int)innerInsets.bottom, (int)innerInsets.right));
        selectablePanel.setSelectionArc(JBUI.CurrentTheme.Popup.Selection.ARC.get());
        JBInsets jBInsets = JBUI.emptyInsets();
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"emptyInsets(...)");
        selectablePanel.setSelectionInsets((Insets)jBInsets);
    }

    private final int calculateDescriptionWidth() {
        Insets insets = JBUI.CurrentTheme.Popup.Selection.innerInsets();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"innerInsets(...)");
        Insets innerInsets = insets;
        int leftRightInset = JBUI.CurrentTheme.Popup.Selection.LEFT_RIGHT_INSET.get();
        int borderSize = innerInsets.left + leftRightInset;
        return this.comboboxPopupWidth - (leftRightInset + borderSize) * 2;
    }

    private static final void getCombobox$lambda$0$0(getCombobox.1 $this_apply, AiRuleTypeComboboxProvider this$0) {
        Accessible accessible = $this_apply.getAccessibleContext().getAccessibleChild(0);
        JPopupMenu jPopupMenu = accessible instanceof JPopupMenu ? (JPopupMenu)accessible : null;
        if (jPopupMenu == null) {
            return;
        }
        JPopupMenu popup2 = jPopupMenu;
        Dimension size2 = popup2.getPreferredSize();
        popup2.setPreferredSize(new Dimension(size2.width, size2.height + this$0.comboboxPopupInsets * 2));
        popup2.revalidate();
        popup2.repaint();
    }

    private static final String createTypeItemPane$getTypeDescription(AiRuleTypeComboboxProvider this$0, AiRuleType $type) {
        return "<html><div style='width:" + this$0.calculateDescriptionWidth() + "'>" + $type.getDescription() + "</div></html>";
    }

    private static final Unit createTypeItemPane$lambda$0(AiRuleType $type, boolean $isSelected, AiRuleTypeComboboxProvider this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.customizeSpacingConfiguration((SpacingConfiguration)new EmptySpacingConfiguration(), arg_0 -> AiRuleTypeComboboxProvider.createTypeItemPane$lambda$0$0($type, $isSelected, this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createTypeItemPane$lambda$0$0(AiRuleType $type, boolean $isSelected, AiRuleTypeComboboxProvider this$0, Panel $this$customizeSpacingConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, arg_0 -> AiRuleTypeComboboxProvider.createTypeItemPane$lambda$0$0$0($type, $isSelected, this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createTypeItemPane$lambda$0$0$0(AiRuleType $type, boolean $isSelected, AiRuleTypeComboboxProvider this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.panel(arg_0 -> AiRuleTypeComboboxProvider.createTypeItemPane$lambda$0$0$0$0($type, $isSelected, this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createTypeItemPane$lambda$0$0$0$0(AiRuleType $type, boolean $isSelected, AiRuleTypeComboboxProvider this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiRuleTypeComboboxProvider.createTypeItemPane$lambda$0$0$0$0$0($type, $isSelected, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiRuleTypeComboboxProvider.createTypeItemPane$lambda$0$0$0$0$1(this$0, $type, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createTypeItemPane$lambda$0$0$0$0$0(AiRuleType $type, boolean $isSelected, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label($type.getDisplayName()).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)4, (int)0, (int)11, null)).accessibleName($type.getDisplayName()).applyToComponent(arg_0 -> AiRuleTypeComboboxProvider.createTypeItemPane$lambda$0$0$0$0$0$0($isSelected, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createTypeItemPane$lambda$0$0$0$0$0$0(boolean $isSelected, JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setForeground($isSelected ? NamedColorUtil.getListSelectionForeground((boolean)true) : UIUtil.getListForeground());
        return Unit.INSTANCE;
    }

    private static final Unit createTypeItemPane$lambda$0$0$0$0$1(AiRuleTypeComboboxProvider this$0, AiRuleType $type, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(AiRuleTypeComboboxProvider.createTypeItemPane$getTypeDescription(this$0, $type)).applyToComponent(AiRuleTypeComboboxProvider::createTypeItemPane$lambda$0$0$0$0$1$0).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createTypeItemPane$lambda$0$0$0$0$1$0(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setFont((Font)JBFont.smallOrNewUiMedium());
        $this$applyToComponent.setForeground(UIUtil.getLabelInfoForeground());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ int access$getComboboxPopupWidth$p(AiRuleTypeComboboxProvider $this) {
        return $this.comboboxPopupWidth;
    }

    public static final /* synthetic */ JComponent access$createTypeItemPane(AiRuleTypeComboboxProvider $this, AiRuleType type2, boolean isSelected) {
        return $this.createTypeItemPane(type2, isSelected);
    }

    public static final /* synthetic */ AiRuleType access$getSelectedType$p(AiRuleTypeComboboxProvider $this) {
        return $this.selectedType;
    }

    public static final /* synthetic */ AiRuleMetadataModel access$getMetadataModel$p(AiRuleTypeComboboxProvider $this) {
        return $this.metadataModel;
    }

    public static final /* synthetic */ Project access$getProject$p(AiRuleTypeComboboxProvider $this) {
        return $this.project;
    }

    public static final /* synthetic */ Function1 access$getOnTypeChanged$p(AiRuleTypeComboboxProvider $this) {
        return $this.onTypeChanged;
    }

    public static final /* synthetic */ int access$getComboboxPopupInsets$p(AiRuleTypeComboboxProvider $this) {
        return $this.comboboxPopupInsets;
    }
}

