/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.httpClient.ktor;

import com.intellij.ml.llm.activation.util.SensitiveKt;
import com.intellij.ml.llm.core.httpClient.AiaHttpClientCallEvent;
import com.intellij.ml.llm.core.httpClient.AiaHttpClientCallLogSink;
import com.intellij.ml.llm.core.httpClient.AiaHttpClientConfig;
import com.intellij.ml.llm.core.httpClient.AiaHttpClientConfigManager;
import com.intellij.ml.llm.core.httpClient.AiaHttpClientTimeouts;
import com.intellij.ml.llm.core.httpClient.ktor.KtorHttpClientLogger;
import com.intellij.util.net.HttpConfigurable;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientConfig;
import io.ktor.client.HttpClientKt;
import io.ktor.client.engine.HttpClientEngineFactory;
import io.ktor.client.engine.java.Java;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.HttpTimeoutConfig;
import io.ktor.client.plugins.HttpTimeoutKt;
import io.ktor.client.plugins.api.ClientPlugin;
import io.ktor.client.plugins.api.ClientPluginBuilder;
import io.ktor.client.plugins.api.CreatePluginUtilsKt;
import io.ktor.client.plugins.api.OnRequestContext;
import io.ktor.client.plugins.logging.LogLevel;
import io.ktor.client.plugins.logging.Logger;
import io.ktor.client.plugins.logging.LoggingConfig;
import io.ktor.client.plugins.logging.LoggingKt;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.http.HttpHeaders;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\u00020\t2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\u0007R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/core/httpClient/ktor/AiaKtorHttpClientUtil;", "", "<init>", "()V", "httpClient", "Lio/ktor/client/HttpClient;", "config", "Lcom/intellij/ml/llm/core/httpClient/AiaHttpClientConfig;", "configure", "", "Lio/ktor/client/HttpClientConfig;", "aiaConfig", "ProxyAuthenticationPlugin", "Lio/ktor/client/plugins/api/ClientPlugin;", "intellij.ml.llm.core.httpClient"})
public final class AiaKtorHttpClientUtil {
    @NotNull
    public static final AiaKtorHttpClientUtil INSTANCE = new AiaKtorHttpClientUtil();
    @NotNull
    private static final ClientPlugin<Unit> ProxyAuthenticationPlugin = CreatePluginUtilsKt.createClientPlugin((String)"ProxyAuthenticationPlugin", AiaKtorHttpClientUtil::ProxyAuthenticationPlugin$lambda$0);

    private AiaKtorHttpClientUtil() {
    }

    @NotNull
    public final HttpClient httpClient(@NotNull AiaHttpClientConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return HttpClientKt.HttpClient((HttpClientEngineFactory)((HttpClientEngineFactory)Java.INSTANCE), arg_0 -> AiaKtorHttpClientUtil.httpClient$lambda$0(config, arg_0));
    }

    public static /* synthetic */ HttpClient httpClient$default(AiaKtorHttpClientUtil aiaKtorHttpClientUtil, AiaHttpClientConfig aiaHttpClientConfig, int n, Object object) {
        if ((n & 1) != 0) {
            aiaHttpClientConfig = AiaHttpClientConfigManager.defaultConfig$default(AiaHttpClientConfigManager.INSTANCE, null, 1, null);
        }
        return aiaKtorHttpClientUtil.httpClient(aiaHttpClientConfig);
    }

    public final void configure(@NotNull HttpClientConfig<?> config, @NotNull AiaHttpClientConfig aiaConfig) {
        block1: {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)aiaConfig, (String)"aiaConfig");
            AiaHttpClientTimeouts aiaHttpClientTimeouts = aiaConfig.getTimeouts();
            if (aiaHttpClientTimeouts != null) {
                AiaHttpClientTimeouts timeouts = aiaHttpClientTimeouts;
                boolean bl = false;
                config.install((HttpClientPlugin)HttpTimeoutKt.getHttpTimeout(), arg_0 -> AiaKtorHttpClientUtil.configure$lambda$0$0(timeouts, arg_0));
            }
            AiaHttpClientCallLogSink aiaHttpClientCallLogSink = aiaConfig.getLogSink();
            if (aiaHttpClientCallLogSink == null) break block1;
            AiaHttpClientCallLogSink logSink = aiaHttpClientCallLogSink;
            boolean bl = false;
            config.install((HttpClientPlugin)LoggingKt.getLogging(), arg_0 -> AiaKtorHttpClientUtil.configure$lambda$1$0(logSink, aiaConfig, arg_0));
        }
    }

    private static final Unit httpClient$lambda$0(AiaHttpClientConfig $config, HttpClientConfig $this$HttpClient) {
        Intrinsics.checkNotNullParameter((Object)$this$HttpClient, (String)"$this$HttpClient");
        INSTANCE.configure($this$HttpClient, $config);
        HttpClientConfig.install$default((HttpClientConfig)$this$HttpClient, (HttpClientPlugin)((HttpClientPlugin)ProxyAuthenticationPlugin), null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit configure$lambda$0$0(AiaHttpClientTimeouts $timeouts, HttpTimeoutConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        $this$install.setRequestTimeoutMillis(Long.valueOf(Duration.getInWholeMilliseconds-impl((long)$timeouts.getRequest-UwyO8pc())));
        $this$install.setConnectTimeoutMillis(Long.valueOf(Duration.getInWholeMilliseconds-impl((long)$timeouts.getConnect-UwyO8pc())));
        $this$install.setSocketTimeoutMillis(Long.valueOf(Duration.getInWholeMilliseconds-impl((long)$timeouts.getSocket-UwyO8pc())));
        return Unit.INSTANCE;
    }

    private static final Unit configure$lambda$1$0(AiaHttpClientCallLogSink $logSink, AiaHttpClientConfig $aiaConfig, LoggingConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        $this$install.setLogger((Logger)new KtorHttpClientLogger((Function1<? super AiaHttpClientCallEvent, Unit>)((Function1)arg_0 -> AiaKtorHttpClientUtil.configure$lambda$1$0$0($logSink, arg_0))));
        $this$install.setLevel(LogLevel.ALL);
        LoggingConfig.sanitizeHeader$default((LoggingConfig)$this$install, null, AiaKtorHttpClientUtil::configure$lambda$1$0$1, (int)1, null);
        $this$install.filter(arg_0 -> AiaKtorHttpClientUtil.configure$lambda$1$0$2($logSink, $aiaConfig, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit configure$lambda$1$0$0(AiaHttpClientCallLogSink $logSink, AiaHttpClientCallEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        $logSink.log(event2);
        return Unit.INSTANCE;
    }

    private static final boolean configure$lambda$1$0$1(String header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        return SensitiveKt.isSensitiveHttpHeader(header);
    }

    private static final boolean configure$lambda$1$0$2(AiaHttpClientCallLogSink $logSink, AiaHttpClientConfig $aiaConfig, HttpRequestBuilder request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return $logSink.isLogEnabled() && (Boolean)$aiaConfig.getLogUrlPredicate().invoke((Object)request2.getUrl().buildString()) != false;
    }

    private static final Unit ProxyAuthenticationPlugin$lambda$0(ClientPluginBuilder $this$createClientPlugin) {
        Intrinsics.checkNotNullParameter((Object)$this$createClientPlugin, (String)"$this$createClientPlugin");
        $this$createClientPlugin.onRequest((Function4)new Function4<OnRequestContext, HttpRequestBuilder, Object, Continuation<? super Unit>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                HttpRequestBuilder httpRequestBuilder = (HttpRequestBuilder)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        HttpConfigurable platformHttpConfig = HttpConfigurable.getInstance();
                        if (platformHttpConfig.USE_HTTP_PROXY && platformHttpConfig.PROXY_AUTHENTICATION) {
                            void request2;
                            String proxyLogin = platformHttpConfig.getProxyLogin();
                            String proxyPassword = platformHttpConfig.getPlainProxyPassword();
                            Base64.Encoder encoder = Base64.getEncoder();
                            String string = proxyLogin + ":" + proxyPassword;
                            byte[] byArray = string.getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                            String token = encoder.encodeToString(byArray);
                            request2.getHeaders().append(HttpHeaders.INSTANCE.getProxyAuthorization(), "Basic " + token);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(OnRequestContext p1, HttpRequestBuilder p2, Object p3, Continuation<? super Unit> p4) {
                var var5_5 = new /* invalid duplicate definition of identical inner class */;
                var5_5.L$0 = p2;
                return var5_5.invokeSuspend(Unit.INSTANCE);
            }
        });
        return Unit.INSTANCE;
    }
}

