/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight;

import com.intellij.ml.llm.daemon.insight.InsightEventListener;
import com.intellij.ml.llm.daemon.insight.InsightEventReporter;
import com.intellij.ml.llm.daemon.insight.diagnostics.InsightComplexityRangesView;
import com.intellij.ml.llm.daemon.insight.handler.InsightModel;
import com.intellij.ml.llm.daemon.insight.logs.FUSListener;
import com.intellij.ml.llm.daemon.insight.logs.LLMCListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\u000b\"\n\b\u0000\u0010\f\u0018\u0001*\u00020\r*\u0002H\fH\u0086\b\u00a2\u0006\u0002\u0010\u000e\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0011H\u0000\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/ml/llm/daemon/insight/InsightEventListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addInsightEventsListener", "", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "thisInsightLogger", "Lcom/intellij/ml/llm/daemon/insight/InsightEventReporter;", "T", "", "(Ljava/lang/Object;)Lcom/intellij/ml/llm/daemon/insight/InsightEventReporter;", "toTextMessage", "", "Lcom/intellij/ml/llm/daemon/insight/InsightEventListener$Event;", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightEventDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightEventDispatcher.kt\ncom/intellij/ml/llm/daemon/insight/InsightEventDispatcherKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,175:1\n13#2:176\n*S KotlinDebug\n*F\n+ 1 InsightEventDispatcher.kt\ncom/intellij/ml/llm/daemon/insight/InsightEventDispatcherKt\n*L\n29#1:176\n*E\n"})
public final class InsightEventDispatcherKt {
    @NotNull
    private static final EventDispatcher<InsightEventListener> dispatcher;

    public static final void addInsightEventsListener(@NotNull InsightEventListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        dispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public static final /* synthetic */ <T> InsightEventReporter thisInsightLogger(T $this$thisInsightLogger) {
        Intrinsics.checkNotNullParameter($this$thisInsightLogger, (String)"<this>");
        boolean $i$f$thisInsightLogger = false;
        boolean $i$f$logger = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Logger logger = Logger.getInstance(Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return new InsightEventReporter(logger);
    }

    @Nullable
    public static final String toTextMessage(@NotNull InsightEventListener.Event $this$toTextMessage) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toTextMessage, (String)"<this>");
        InsightEventListener.Event event2 = $this$toTextMessage;
        if (event2 instanceof InsightEventListener.ProviderCalled) {
            object = "Provider called";
        } else if (event2 instanceof InsightEventListener.FullyCoveredByCache) {
            object = "Fully cached insights: " + ((InsightEventListener.FullyCoveredByCache)$this$toTextMessage).getInsights().size();
        } else if (event2 instanceof InsightEventListener.PartialCache) {
            object = "Cached insights: " + ((InsightEventListener.PartialCache)$this$toTextMessage).getCachedInsights().size() + ", unmatched start lines: " + ((InsightEventListener.PartialCache)$this$toTextMessage).getUnmatchedStartLines().size();
        } else if (event2 instanceof InsightEventListener.WhereClientExecuted) {
            object = "Where client called for " + ((InsightEventListener.WhereClientExecuted)$this$toTextMessage).getRemainingRanges().size() + " " + StringUtil.pluralize((String)"range", (int)((InsightEventListener.WhereClientExecuted)$this$toTextMessage).getRemainingRanges().size()) + " (" + Duration.getInWholeMilliseconds-impl((long)((InsightEventListener.WhereClientExecuted)$this$toTextMessage).getTime-UwyO8pc()) + "ms)";
        } else if (event2 instanceof InsightEventListener.ClientExecuted) {
            object = "Generated " + StringUtil.pluralize((String)"insight", (int)((InsightEventListener.ClientExecuted)$this$toTextMessage).getNewInsights().size()) + ": " + ((InsightEventListener.ClientExecuted)$this$toTextMessage).getNewInsights().size();
        } else if (event2 instanceof InsightEventListener.PostProcessingResults) {
            Object object2;
            if (!((InsightEventListener.PostProcessingResults)$this$toTextMessage).getStats().isEmpty()) {
                String content2 = CollectionsKt.joinToString$default((Iterable)((InsightEventListener.PostProcessingResults)$this$toTextMessage).getStats().entrySet(), (CharSequence)", ", null, null, (int)0, null, InsightEventDispatcherKt::toTextMessage$lambda$0, (int)30, null);
                object2 = " (Filtered/Modified: " + content2 + ")";
            } else {
                object2 = " (Filtered/Modified: none)";
            }
            String details = object2;
            object = "Post-processing: (inputCount=" + ((InsightEventListener.PostProcessingResults)$this$toTextMessage).getInputCount() + ") -> (outputCount=" + ((InsightEventListener.PostProcessingResults)$this$toTextMessage).getOutputCount() + ") " + StringUtil.pluralize((String)"insight", (int)((InsightEventListener.PostProcessingResults)$this$toTextMessage).getInputCount()) + " in " + Duration.toString-impl((long)((InsightEventListener.PostProcessingResults)$this$toTextMessage).getDurationMs-UwyO8pc()) + details;
        } else if (event2 instanceof InsightEventListener.PostProcessingFinished) {
            object = "Post-processing finished for " + ((InsightEventListener.PostProcessingFinished)$this$toTextMessage).getInsights().size() + " " + StringUtil.pluralize((String)"insight", (int)((InsightEventListener.PostProcessingFinished)$this$toTextMessage).getInsights().size());
        } else if (event2 instanceof InsightEventListener.RequestFinished) {
            object = "Request finished";
        } else if (event2 instanceof InsightEventListener.HeuristicRangesContextCollected) {
            object = "Context collected for range size: " + ((InsightEventListener.HeuristicRangesContextCollected)$this$toTextMessage).getRangeSize() + ", text range: " + ((InsightEventListener.HeuristicRangesContextCollected)$this$toTextMessage).getTextRange().getStartOffset() + "-" + ((InsightEventListener.HeuristicRangesContextCollected)$this$toTextMessage).getTextRange().getEndOffset();
        } else if (event2 instanceof InsightEventListener.WhatClientContextCollected) {
            object = "Context collected for " + ((InsightEventListener.WhatClientContextCollected)$this$toTextMessage).getItems() + " " + StringUtil.pluralize((String)"item", (int)((InsightEventListener.WhatClientContextCollected)$this$toTextMessage).getItems()) + ", text range: " + ((InsightEventListener.WhatClientContextCollected)$this$toTextMessage).getRange().getStartOffset() + "-" + ((InsightEventListener.WhatClientContextCollected)$this$toTextMessage).getRange().getEndOffset();
        } else if (event2 instanceof InsightEventListener.WhereClientContextCollected) {
            object = "Context collected for text range: " + ((InsightEventListener.WhereClientContextCollected)$this$toTextMessage).getRange().getStartOffset() + "-" + ((InsightEventListener.WhereClientContextCollected)$this$toTextMessage).getRange().getEndOffset();
        } else if (event2 instanceof InsightEventListener.HeuristicResponseReceived) {
            object = "Heuristic LLM response received in " + Duration.toString-impl((long)((InsightEventListener.HeuristicResponseReceived)$this$toTextMessage).getDurationMs-UwyO8pc());
        } else if (event2 instanceof InsightEventListener.HeuristicResponseParsed) {
            object = "Parsed " + ((InsightEventListener.HeuristicResponseParsed)$this$toTextMessage).getCount() + " heuristic " + StringUtil.pluralize((String)"insight", (int)((InsightEventListener.HeuristicResponseParsed)$this$toTextMessage).getCount()) + " in " + Duration.toString-impl((long)((InsightEventListener.HeuristicResponseParsed)$this$toTextMessage).getDurationMs-UwyO8pc()) + ". " + StringUtil.pluralize((String)"Result", (int)((InsightEventListener.HeuristicResponseParsed)$this$toTextMessage).getCount()) + ": \n" + CollectionsKt.joinToString$default((Iterable)((InsightEventListener.HeuristicResponseParsed)$this$toTextMessage).getExamples(), (CharSequence)"\n", null, null, (int)0, null, InsightEventDispatcherKt::toTextMessage$lambda$1, (int)30, null);
        } else if (event2 instanceof InsightEventListener.WhatClientResponseReceived) {
            object = "WhatClient response received in " + Duration.toString-impl((long)((InsightEventListener.WhatClientResponseReceived)$this$toTextMessage).getDurationMs-UwyO8pc());
        } else if (event2 instanceof InsightEventListener.WhatClientResponseParsed) {
            object = "Parsed Insight: '" + ((InsightEventListener.WhatClientResponseParsed)$this$toTextMessage).getComment() + "' (Type: " + ((InsightEventListener.WhatClientResponseParsed)$this$toTextMessage).getType() + "), reasoning: " + ((InsightEventListener.WhatClientResponseParsed)$this$toTextMessage).getReasoning() + " (" + Duration.toString-impl((long)((InsightEventListener.WhatClientResponseParsed)$this$toTextMessage).getDurationMs-UwyO8pc()) + ")";
        } else if (event2 instanceof InsightEventListener.WhereClientResponseReceived) {
            object = "WhereClient response received in " + Duration.toString-impl((long)((InsightEventListener.WhereClientResponseReceived)$this$toTextMessage).getDurationMs-UwyO8pc());
        } else if (event2 instanceof InsightEventListener.WhereClientResponseParsed) {
            object = "Parsed " + ((InsightEventListener.WhereClientResponseParsed)$this$toTextMessage).getRanges() + " 'Where' " + StringUtil.pluralize((String)"range", (int)((InsightEventListener.WhereClientResponseParsed)$this$toTextMessage).getRanges()) + " in " + Duration.toString-impl((long)((InsightEventListener.WhereClientResponseParsed)$this$toTextMessage).getDurationMs-UwyO8pc());
        } else if (event2 instanceof InsightEventListener.HeuristicLogBlocksGenerated) {
            object = "Finished generating log blocks with heuristic, took " + Duration.toString-impl((long)((InsightEventListener.HeuristicLogBlocksGenerated)$this$toTextMessage).getDurationMs-UwyO8pc());
        } else if (event2 instanceof InsightEventListener.InsightsAndLogBlocksGenerated) {
            object = "Finished generating insights and log blocks, took " + Duration.toString-impl((long)((InsightEventListener.InsightsAndLogBlocksGenerated)$this$toTextMessage).getDurationMs-UwyO8pc());
        } else if (event2 instanceof InsightEventListener.InterestingSymbolsFound) {
            object = "Found " + ((InsightEventListener.InterestingSymbolsFound)$this$toTextMessage).getCount() + " interesting context " + StringUtil.pluralize((String)"symbol", (int)((InsightEventListener.InterestingSymbolsFound)$this$toTextMessage).getCount()) + " in " + Duration.toString-impl((long)((InsightEventListener.InterestingSymbolsFound)$this$toTextMessage).getDurationMs-UwyO8pc());
        } else if (event2 instanceof InsightEventListener.VisibleInlaysUpdated) {
            String sign;
            List list;
            List $this$toTextMessage_u24lambda_u242 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            if (((InsightEventListener.VisibleInlaysUpdated)$this$toTextMessage).getInsightsChanged() != 0) {
                sign = ((InsightEventListener.VisibleInlaysUpdated)$this$toTextMessage).getInsightsChanged() > 0 ? "+" : "";
                $this$toTextMessage_u24lambda_u242.add(StringUtil.pluralize((String)"Insight", (int)((InsightEventListener.VisibleInlaysUpdated)$this$toTextMessage).getActiveInsights()) + ": " + ((InsightEventListener.VisibleInlaysUpdated)$this$toTextMessage).getActiveInsights() + " (" + sign + ((InsightEventListener.VisibleInlaysUpdated)$this$toTextMessage).getInsightsChanged() + ")");
            }
            if (((InsightEventListener.VisibleInlaysUpdated)$this$toTextMessage).getPlaceholdersChanged() != 0) {
                sign = ((InsightEventListener.VisibleInlaysUpdated)$this$toTextMessage).getPlaceholdersChanged() > 0 ? "+" : "";
                $this$toTextMessage_u24lambda_u242.add(StringUtil.pluralize((String)"Placeholder", (int)((InsightEventListener.VisibleInlaysUpdated)$this$toTextMessage).getPlaceholders()) + ": " + ((InsightEventListener.VisibleInlaysUpdated)$this$toTextMessage).getPlaceholders() + " (" + sign + ((InsightEventListener.VisibleInlaysUpdated)$this$toTextMessage).getPlaceholdersChanged() + ")");
            }
            List parts = CollectionsKt.build((List)list);
            object = "Visible inlays updated in " + Duration.toString-impl((long)((InsightEventListener.VisibleInlaysUpdated)$this$toTextMessage).getDurationMs-UwyO8pc()) + ". " + (!((Collection)parts).isEmpty() ? "Active " : "") + CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        } else {
            object = event2 instanceof InsightEventListener.InsightRendered ? "Rendered Insight (insightId=" + ((InsightEventListener.InsightRendered)$this$toTextMessage).getInsight().getId() + ") at line " + ((InsightEventListener.InsightRendered)$this$toTextMessage).getInsight().getRange().getStartLine() : (event2 instanceof InsightEventListener.ComplexityForElementCalculated ? "Complexity for element calculated (range=" + ((InsightEventListener.ComplexityForElementCalculated)$this$toTextMessage).getRange() + ", complexity=" + ((InsightEventListener.ComplexityForElementCalculated)$this$toTextMessage).getComplexity() + ")" : (event2 instanceof InsightEventListener.AutoProcessingFinished ? "Auto-processing entire editor took " + Duration.toString-impl((long)((InsightEventListener.AutoProcessingFinished)$this$toTextMessage).getDurationMs-UwyO8pc()) : (event2 instanceof InsightEventListener.Rated ? "Rated " + ((InsightEventListener.Rated)$this$toTextMessage).getRating() + " (insightId=" + ((InsightEventListener.Rated)$this$toTextMessage).getInsight().getId() + ")" : (event2 instanceof InsightEventListener.Copied ? "Copied (insightId=" + ((InsightEventListener.Copied)$this$toTextMessage).getInsight().getId() + ")" : (event2 instanceof InsightEventListener.Hidden ? "Hidden (insightId=" + ((InsightEventListener.Hidden)$this$toTextMessage).getInsight().getId() + ")" : (event2 instanceof InsightEventListener.InsertedAsComment ? "Inserted as " + ((InsightEventListener.InsertedAsComment)$this$toTextMessage).getCommentType() + " (insightId=" + ((InsightEventListener.InsertedAsComment)$this$toTextMessage).getInsight().getId() + ")" : (event2 instanceof InsightEventListener.HoverFinished ? "Hover on (insightId=" + ((InsightEventListener.HoverFinished)$this$toTextMessage).getInsight().getId() + ")" : (event2 instanceof InsightEventListener.FrequencyAdjusted ? "Adjusted frequency to " + ((InsightEventListener.FrequencyAdjusted)$this$toTextMessage).getFrequency() : null))))))));
        }
        return object;
    }

    private static final CharSequence toTextMessage$lambda$0(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue() + " " + it.getKey();
    }

    private static final CharSequence toTextMessage$lambda$1(InsightModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "Text: '" + ((Object)StringsKt.trim((CharSequence)it.getText())).toString() + "', range: " + it.getRange().getStartLine() + "-" + it.getRange().getEndLine();
    }

    public static final /* synthetic */ EventDispatcher access$getDispatcher$p() {
        return dispatcher;
    }

    static {
        EventDispatcher eventDispatcher;
        EventDispatcher $this$dispatcher_u24lambda_u240 = eventDispatcher = EventDispatcher.create(InsightEventListener.class);
        boolean bl = false;
        $this$dispatcher_u24lambda_u240.addListener((EventListener)new FUSListener());
        $this$dispatcher_u24lambda_u240.addListener((EventListener)new LLMCListener());
        $this$dispatcher_u24lambda_u240.addListener((EventListener)new InsightComplexityRangesView.Listener());
        EventDispatcher eventDispatcher2 = eventDispatcher;
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"apply(...)");
        dispatcher = eventDispatcher2;
    }
}

