/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.diagnostics.logs;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ml.llm.daemon.insight.InsightEventDispatcherKt;
import com.intellij.ml.llm.daemon.insight.InsightEventListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.JBColor;
import com.intellij.util.text.DateFormatUtil;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/daemon/insight/diagnostics/logs/InsightLogEntryDecorator;", "", "<init>", "()V", "COLOR_LLM", "Lcom/intellij/ui/JBColor;", "COLOR_GENERATION", "COLOR_INTERACTION", "COLOR_PROCESSING", "COLOR_DEFAULT", "kotlin.jvm.PlatformType", "decorate", "", "event", "Lcom/intellij/ml/llm/daemon/insight/InsightEventListener$Event;", "console", "Lcom/intellij/execution/ui/ConsoleView;", "getContentTypeForColor", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "color", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightLogEntryDecorator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightLogEntryDecorator.kt\ncom/intellij/ml/llm/daemon/insight/diagnostics/logs/InsightLogEntryDecorator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class InsightLogEntryDecorator {
    @NotNull
    public static final InsightLogEntryDecorator INSTANCE = new InsightLogEntryDecorator();
    @NotNull
    private static final JBColor COLOR_LLM = new JBColor(11630060, 11630060);
    @NotNull
    private static final JBColor COLOR_GENERATION = new JBColor(4894291, 4894291);
    @NotNull
    private static final JBColor COLOR_INTERACTION = new JBColor(0xA8A8A8, 0xA8A8A8);
    @NotNull
    private static final JBColor COLOR_PROCESSING = new JBColor(14064465, 14064465);
    private static final JBColor COLOR_DEFAULT = JBColor.WHITE;

    private InsightLogEntryDecorator() {
    }

    public final void decorate(@NotNull InsightEventListener.Event event2, @NotNull ConsoleView console) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        String string = InsightEventDispatcherKt.toTextMessage(event2);
        if (string == null) {
            return;
        }
        String eventMessage = string;
        String eventName = event2.getClass().getSimpleName();
        String string2 = DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatTimeWithSeconds(...)");
        String timestamp = string2;
        InsightEventListener.Event event3 = event2;
        JBColor tagColor = event3 instanceof InsightEventListener.LlmEvent ? COLOR_LLM : (event3 instanceof InsightEventListener.GenerationEvent ? COLOR_GENERATION : (event3 instanceof InsightEventListener.InteractionEvent ? COLOR_INTERACTION : (event3 instanceof InsightEventListener.ProcessingEvent ? COLOR_PROCESSING : COLOR_DEFAULT)));
        Intrinsics.checkNotNull((Object)tagColor);
        ConsoleViewContentType tagContentType = this.getContentTypeForColor(tagColor);
        console.print("[" + timestamp + " ", ConsoleViewContentType.LOG_DEBUG_OUTPUT);
        console.print(eventName, tagContentType);
        console.print("] ", ConsoleViewContentType.LOG_DEBUG_OUTPUT);
        console.print(eventMessage, ConsoleViewContentType.NORMAL_OUTPUT);
        console.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
    }

    private final ConsoleViewContentType getContentTypeForColor(JBColor color) {
        TextAttributes textAttributes;
        TextAttributes $this$getContentTypeForColor_u24lambda_u240 = textAttributes = new TextAttributes();
        boolean bl = false;
        $this$getContentTypeForColor_u24lambda_u240.setForegroundColor((Color)color);
        TextAttributes attributes = textAttributes;
        return new ConsoleViewContentType("INSIGHT_TAG_" + color.getRGB(), attributes);
    }
}

