/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.handler.listeners;

import com.intellij.ml.llm.daemon.insight.ui.InsightRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/listeners/InsightMouseMotionListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "<init>", "()V", "mouseMoved", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "intellij.ml.llm.daemon"})
public final class InsightMouseMotionListener
implements EditorMouseMotionListener {
    public void mouseMoved(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.isConsumed()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)e.getArea(), (Object)EditorMouseEventArea.EDITING_AREA)) {
            return;
        }
        Editor editor2 = e.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        InsightRenderer insightRenderer = InsightRenderer.Companion.getOrNull(editor2);
        if (insightRenderer == null) {
            return;
        }
        InsightRenderer renderer2 = insightRenderer;
        Point point = e.getMouseEvent().getPoint();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
        renderer2.processHover(point);
    }
}

