/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.handler.listeners;

import com.intellij.ml.llm.daemon.insight.handler.InsightsHandler;
import com.intellij.ml.llm.daemon.insight.handler.request.InsightEvent;
import com.intellij.ml.llm.daemon.insight.handler.request.InsightViewport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/listeners/InsightVisibleAreaListener;", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "previousViewport", "Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightViewport;", "visibleAreaChanged", "", "e", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "changedNoticeable", "", "viewport", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightVisibleAreaListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightVisibleAreaListener.kt\ncom/intellij/ml/llm/daemon/insight/handler/listeners/InsightVisibleAreaListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,46:1\n13#2:47\n*S KotlinDebug\n*F\n+ 1 InsightVisibleAreaListener.kt\ncom/intellij/ml/llm/daemon/insight/handler/listeners/InsightVisibleAreaListener\n*L\n12#1:47\n*E\n"})
public final class InsightVisibleAreaListener
implements VisibleAreaListener {
    @NotNull
    private final Logger log;
    @Nullable
    private InsightViewport previousViewport;

    public InsightVisibleAreaListener() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(InsightVisibleAreaListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
    }

    public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ApplicationManager.getApplication().runReadAction(() -> InsightVisibleAreaListener.visibleAreaChanged$lambda$0(e, this));
    }

    private final boolean changedNoticeable(InsightViewport viewport) {
        if (this.previousViewport == null) {
            return true;
        }
        int n = viewport.getFirstLine() + 1;
        InsightViewport insightViewport = this.previousViewport;
        Intrinsics.checkNotNull((Object)insightViewport);
        if (n < insightViewport.getFirstLine()) {
            return true;
        }
        int n2 = viewport.getLastLine() - 1;
        InsightViewport insightViewport2 = this.previousViewport;
        Intrinsics.checkNotNull((Object)insightViewport2);
        return n2 > insightViewport2.getLastLine();
    }

    private static final void visibleAreaChanged$lambda$0(VisibleAreaEvent $e, InsightVisibleAreaListener this$0) {
        Project project2 = $e.getEditor().getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        if ($e.getEditor().isDisposed() || project3.isDisposed()) {
            return;
        }
        Editor editor2 = $e.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        InsightViewport insightViewport = InsightViewport.Companion.create(editor2);
        if (insightViewport == null) {
            return;
        }
        InsightViewport viewport = insightViewport;
        if (viewport.getFirstLine() == viewport.getLastLine()) {
            return;
        }
        if (this$0.changedNoticeable(viewport)) {
            this$0.log.debug("VisibleAreaChanged noticeable");
            InsightsHandler insightsHandler = InsightsHandler.Companion.getInstance(project3);
            Editor editor3 = $e.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
            InsightEvent insightEvent = InsightEvent.Companion.create(editor3);
            if (insightEvent == null) {
                return;
            }
            insightsHandler.execute(insightEvent);
            this$0.previousViewport = viewport;
        }
    }
}

